/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;
import proper.xml.Attribute;
import proper.xml.Document;
import proper.xml.Element;
import proper.xml.Path;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class XMLInstances {
    public static final String TYPE_DATE = "date";
    public static final String TYPE_NOMINAL = "nominal";
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_STRING = "string";
    public static final String DOCTYPE = "<!DOCTYPE relation [\n   <!ELEMENT relation (attributes, instances)>\n   <!ATTLIST relation name CDATA #REQUIRED>\n   <!ATTLIST relation timestamp CDATA #IMPLIED>\n   <!ELEMENT attributes (attribute+)>\n   <!ELEMENT attribute (value*)>\n   <!ATTLIST attribute name CDATA #REQUIRED>\n   <!ATTLIST attribute type (date | nominal | numeric | string) #REQUIRED>\n   <!ATTLIST attribute class (yes | no) \"no\">\n   <!ELEMENT instances (instance*)>\n   <!ELEMENT instance (value+)>\n   <!ELEMENT value (#PCDATA)>\n]>\n";
    public static final String PI = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final String DATE_FORMAT = "yyyy-mm-dd";
    public static final String TAG_RELATION = "relation";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_INSTANCES = "instances";
    public static final String TAG_INSTANCE = "instance";
    public static final String TAG_VALUE = "value";
    private Instances instances = null;
    private String doctype = "<!DOCTYPE relation [\n   <!ELEMENT relation (attributes, instances)>\n   <!ATTLIST relation name CDATA #REQUIRED>\n   <!ATTLIST relation timestamp CDATA #IMPLIED>\n   <!ELEMENT attributes (attribute+)>\n   <!ELEMENT attribute (value*)>\n   <!ATTLIST attribute name CDATA #REQUIRED>\n   <!ATTLIST attribute type (date | nominal | numeric | string) #REQUIRED>\n   <!ATTLIST attribute class (yes | no) \"no\">\n   <!ELEMENT instances (instance*)>\n   <!ELEMENT instance (value+)>\n   <!ELEMENT value (#PCDATA)>\n]>\n";
    private String pi = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private String dateFormat = "yyyy-mm-dd";

    public XMLInstances() {
    }

    public XMLInstances(Instances instances) {
        this();
        this.setInstances(instances);
    }

    public void setInstances(Instances instances) {
        this.instances = instances;
    }

    public Instances getInstances() {
        return this.instances;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setPI(String pi) {
        this.pi = pi;
    }

    public String getPI() {
        return this.pi;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public static int stringToType(String typeStr) {
        int result = typeStr.equalsIgnoreCase(TYPE_DATE) ? 3 : (typeStr.equalsIgnoreCase(TYPE_NOMINAL) ? 1 : (typeStr.equalsIgnoreCase(TYPE_NUMERIC) ? 0 : (typeStr.equalsIgnoreCase(TYPE_STRING) ? 2 : 2)));
        return result;
    }

    public static String typeToString(int type) {
        String result = type == 3 ? TYPE_DATE : (type == 1 ? TYPE_NOMINAL : (type == 0 ? TYPE_NUMERIC : (type == 2 ? TYPE_STRING : TYPE_STRING)));
        return result;
    }

    public Document process(Instances instances) {
        int n;
        Element subnode;
        Document result = new Document();
        Element root = new Element(result.getRoot(), TAG_RELATION);
        int classIndex = instances.classIndex();
        if (classIndex == -1) {
            classIndex = instances.numAttributes() - 1;
        }
        root.addAttribute(new Attribute("name", instances.relationName()));
        Element node = new Element(root, TAG_ATTRIBUTES);
        int i = 0;
        while (i < instances.numAttributes()) {
            weka.core.Attribute attr = instances.attribute(i);
            subnode = new Element(node, TAG_ATTRIBUTE);
            subnode.addAttribute(new Attribute("name", instances.attribute(i).name()));
            subnode.addAttribute(new Attribute("type", XMLInstances.typeToString(attr.type())));
            if (i == classIndex) {
                subnode.addAttribute(new Attribute("class", "yes"));
            }
            if (attr.type() == 1) {
                n = 0;
                while (n < attr.numValues()) {
                    subnode.add(new Element(TAG_VALUE, attr.value(n)));
                    ++n;
                }
            }
            ++i;
        }
        node = new Element(root, TAG_INSTANCES);
        i = 0;
        while (i < instances.numInstances()) {
            subnode = new Element(node, TAG_INSTANCE);
            n = 0;
            while (n < instances.numAttributes()) {
                Instance inst = instances.instance(i);
                String value = inst.isMissing(n) ? "?" : (inst.attribute(n).isDate() || inst.attribute(n).isNominal() || inst.attribute(n).isString() ? inst.stringValue(n) : (inst.attribute(n).isNumeric() ? Double.toString(inst.value(n)) : ""));
                subnode.add(new Element(TAG_VALUE, value));
                ++n;
            }
            ++i;
        }
        return result;
    }

    public Instances process(Document doc) {
        int n;
        Vector subnodes;
        Element node;
        Path path = new Path();
        weka.core.Attribute cls = null;
        weka.core.Attribute att = null;
        FastVector atts = new FastVector();
        Vector nodes = path.get(doc.getRoot(), "//attribute");
        int i = 0;
        while (i < nodes.size()) {
            node = (Element)nodes.get(i);
            String name = node.getAttribute("name").getValue();
            String type = node.getAttribute("type").getValue();
            switch (XMLInstances.stringToType(type)) {
                case 3: {
                    att = new weka.core.Attribute(name, this.getDateFormat());
                    break;
                }
                case 1: 
                case 2: {
                    subnodes = path.get(node, ".//value");
                    FastVector values = new FastVector();
                    n = 0;
                    while (n < subnodes.size()) {
                        values.addElement((Object)((Element)subnodes.get(n)).getContent());
                        ++n;
                    }
                    att = new weka.core.Attribute(name, values);
                    break;
                }
                case 0: {
                    att = new weka.core.Attribute(name);
                }
            }
            if (node.getAttribute("class") != null && node.getAttribute("class").getValue().equals("yes")) {
                cls = att;
            } else {
                atts.addElement((Object)att);
            }
            ++i;
        }
        atts.addElement(cls);
        nodes = path.get(doc.getRoot(), "/relation");
        node = (Element)nodes.get(0);
        Instances result = new Instances(node.getAttribute("name").getValue(), atts, path.get(doc.getRoot(), "//instance").size());
        result.setClassIndex(cls.index());
        nodes = path.get(doc.getRoot(), "//instance");
        i = 0;
        while (i < nodes.size()) {
            node = (Element)nodes.get(i);
            subnodes = path.get(node, ".//value");
            double[] doubleValues = new double[atts.size()];
            n = 0;
            while (n < atts.size()) {
                node = (Element)subnodes.get(n);
                att = (weka.core.Attribute)atts.elementAt(n);
                String value = node.getContent();
                if (value.equals("?")) {
                    doubleValues[n] = Instance.missingValue();
                } else {
                    switch (att.type()) {
                        case 0: {
                            doubleValues[n] = Double.parseDouble(value);
                            break;
                        }
                        case 1: 
                        case 2: {
                            doubleValues[n] = att.indexOfValue(value);
                            if (doubleValues[n] != -1.0) break;
                            doubleValues[n] = Instance.missingValue();
                            break;
                        }
                        case 3: {
                            try {
                                doubleValues[n] = att.parseDate(value);
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                doubleValues[n] = Instance.missingValue();
                            }
                        }
                    }
                }
                ++n;
            }
            result.add(new Instance(1.0, doubleValues));
            ++i;
        }
        return result;
    }

    public boolean write(String filename) {
        Document doc = this.process(this.getInstances());
        doc.setPI(this.getPI());
        doc.setDoctype(this.getDoctype());
        return doc.write(filename);
    }

    public static boolean write(String filename, Instances instances) {
        return new XMLInstances(instances).write(filename);
    }

    public boolean read(String filename) {
        Document doc = new Document();
        boolean result = doc.read(filename);
        if (result) {
            this.instances = this.process(doc);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("\n" + XMLInstances.class.getName() + " <xml | arff> <filename>\n");
            System.exit(1);
        }
        XMLInstances xinst = new XMLInstances();
        Instances inst = null;
        if (args[0].equals("xml")) {
            if (!xinst.read(args[1])) throw new Exception("Error reading '" + args[1] + "'");
            inst = xinst.getInstances();
        } else if (args[0].equals("arff")) {
            inst = new Instances((Reader)new FileReader(args[1]));
        }
        System.out.println(inst);
        if (inst == null) return;
        XMLInstances.write(String.valueOf(args[1]) + ".xml", inst);
    }
}

