#!/bin/bash

# This script starts the client
# -h the help
#
# $Revision: 1.3 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -H <hostname> -P <port> -p <port> -o <output> [-h]"
   echo "       -J <Java-home> -A <ANT-home>"
   echo 
   echo "starts the JobClient - the default parameters are listed below."
   echo 
   echo " -h   this help"
   echo " -p   the port on which the client should listen (optional)"
   echo "      default: $PORT"
   echo " -H   the hostname/IP of the server to connect to (optional)"
   echo "      default: $SERVER"
   echo " -P   the port on which the server listens (optional)"
   echo "      default: $SERVER_PORT"
   echo " -o   the directory where to store the logfiles"
   echo "      default: $OUTPUT"
   echo " -v   classname(s) (comma separated list) for which to switch verbose"
   echo "      mode on (optional)"
   echo "      default: $VERBOSE"
   echo " -A   the location of ANT (above 'bin')"
   echo "      default: $ANT_HOME"
   echo " -J   the location of Java (above 'bin')"
   echo "      default: $JAVA_HOME"
   echo
}

# variables
ANT=$ANT_HOME/bin/ant
ROOT=`expr "$0" : '\(.*\)/'`
XMLDIR="$ROOT/../xml"
SERVER="localhost"
SERVER_PORT="31415"
PORT="31416"
OUTPUT="$ROOT/../tmp"

# interprete parameters
while getopts ":hH:P:p:v:o:A:J:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      H) SERVER=$OPTARG
         ;;
      P) SERVER_PORT=$OPTARG
         ;;
      p) PORT=$OPTARG
         ;;
      o) OUTPUT=$OPTARG
         ;;
      v) VERBOSE=$OPTARG
         ;;
      A) ANT_HOME=$OPTARG
         ;;
      J) JAVA_HOME=$OPTARG
         ;;
      *) usage
         exit 1
         ;;
   esac
done

export JAVA_HOME
export ANT_HOME

# start server
COMMAND="$ANT -f $XMLDIR/remote.xml client -Dclient.port=$PORT -Dserver.hostname=$SERVER -Dserver.port=$SERVER_PORT -Dclient.output=$OUTPUT -Dverbose=$VERBOSE"

if [ ! "$VERBOSE" = "" ]
then
   echo $COMMAND
fi

$COMMAND
