#!/bin/bash

# This script saves information about the client into a text file
# -h the help
#
# $Revision: 1.1.1.1 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -o <filename> [-h]"
   echo 
   echo "Retrieves information about the client and stores it in a text file"
   echo 
   echo " -h   this help"
   echo " -o   the file where to store the info"
   echo "      default: $OUTPUT"
   echo
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
OUTPUT="$ROOT/../tmp/info_client.txt"
OUTPUT_CSV=$OUTPUT".csv"

# interprete parameters
while getopts ":ho:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      o) OUTPUT=$OPTARG
         OUTPUT_CSV=$OPTARG".csv"
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# get some informations
CPU=`cat /proc/cpuinfo | grep "model name" | sed s/.*":"//g | sed s/^" "*//g`
MEMORY=`cat /proc/meminfo | grep "MemTotal" | sed s/.*":"//g | sed s/^" "*//g`
PROCESSES=`ps -e | grep java | grep -v grep | wc -l | sed s/^" "*//g`
TMP=`ps -ef | grep java | grep -v grep | cut -f1 -d" " | sort -u`
USERS=`echo $TMP | sed s/" "/,/g`

# text file
echo $HOSTNAME >> $OUTPUT
echo " - CPU: $CPU" >> $OUTPUT
echo " - Memory: $MEMORY" >> $OUTPUT
echo " - # of Java processes: $PROCESSES" >> $OUTPUT
echo " - Java Process user(s): $USERS" >> $OUTPUT 
echo >> $OUTPUT

# CSV file
if [ ! -f $OUTPUT_CSV ]
then
   echo "Hostname;CPU;Memory;Java Processes;Java Users" >> $OUTPUT_CSV
fi
echo "$HOSTNAME;$CPU;$MEMORY;$PROCESSES;$USERS" >> $OUTPUT_CSV

