/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.io.File;
import java.sql.Date;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import proper.database.Column;
import proper.database.Dropper;
import proper.database.Table;
import proper.engine.DatabaseEngine;
import proper.imp.CSVParser;
import proper.imp.Data;
import proper.imp.Indexer;
import proper.imp.Namer;
import proper.imp.Parser;
import proper.imp.PostProcessor;
import proper.imp.Predicate;
import proper.imp.PrologParser;
import proper.imp.Traverser;
import proper.util.ID;
import proper.util.ProperVector;

public class Importer
extends DatabaseEngine {
    public static final String KEY_TABLE = "_keys";
    private boolean containsID;
    private boolean addPosClass;
    private boolean addNegClass;
    private ID id = new ID();
    private boolean useKeys;
    private Hashtable keys = new Hashtable();
    private Indexer indexer = null;
    private Namer namer = null;
    private boolean foreignKeys;

    public Importer() {
        this.setParameter("database", "relaggs");
        this.setParameter("add_pos_class", "no");
        this.setParameter("add_neg_class", "no");
        this.setParameter("reduce_lists", "no");
        this.setParameter("list_positions", "no");
        this.setParameter("asymmetric", "");
        this.setParameter("id_index", "");
    }

    private Vector parse(String filename, boolean addClassLabel, boolean onlyForSingles, String classLabel) throws Exception {
        Parser p;
        this.println("Parsing " + filename + "...");
        if (this.valueEquals("parser", "csv")) {
            Parser c = p = new CSVParser();
            ((CSVParser)c).setPredicateName(new File(filename).getName().replaceAll("\\..*", ""));
            ((CSVParser)c).setHasIdentifiers(!this.exists("no_identifiers"));
            ((CSVParser)c).setQualifier(this.getStringParameter("qualifier"));
            ((CSVParser)c).setSeparator(this.getStringParameter("separator"));
        } else {
            p = new PrologParser();
        }
        this.addListener(p);
        p.clear();
        p.setVerbose(this.getVerboseLevel() >= 1);
        p.setAddClassLabel(addClassLabel);
        p.setClassLabel(classLabel);
        p.setOnlyForSingles(onlyForSingles);
        p.setID(this.id);
        p.parse(filename);
        Vector result = p.getPredicates();
        return result;
    }

    private void drop() throws Exception {
        Dropper dropper = new Dropper(this.conn);
        dropper.dropAll();
    }

    private void createIndex(String name, String table) {
        String sql = "CREATE INDEX " + table + name + " ON " + table + "(" + name + ")";
        boolean result = this.exec.update(sql);
        if (this.getVerbose()) {
            this.println(String.valueOf(sql) + " = " + result);
        }
        if (!result) {
            this.println(this.exec.getLastException());
        }
    }

    private String addColumn(String statement, String column) {
        if (!statement.endsWith("(")) {
            statement = String.valueOf(statement) + ", ";
        }
        statement = String.valueOf(statement) + column;
        return statement;
    }

    private String fixName(String name) {
        String result = name.replaceAll("-", "_");
        return result;
    }

    private void create(Traverser t, String name) throws Exception {
        this.println("Creating table for " + name + "...");
        boolean listpos = this.getStringParameter("list_positions").equals("yes");
        Data d = t.findFirst(name);
        Vector types = t.findAllArgTypes(name);
        String sql = "CREATE TABLE " + this.namer.getTable(d) + "_" + " (";
        sql = this.addColumn(sql, String.valueOf(this.namer.getPrimaryKey(d)) + " INT NOT NULL");
        if (d.getParent() != null) {
            sql = this.addColumn(sql, String.valueOf(this.namer.getParentPrimaryKey(d)) + " INT NOT NULL");
        }
        int n = 0;
        while (n < types.size()) {
            if (!(types.get(n) instanceof Data)) {
                String column = this.namer.getColumnName(d, n);
                boolean idIndex = this.indexer.isIndex(d, n);
                String type = "";
                if (types.get(n) instanceof String) {
                    int len = t.getMaxLength(name, n);
                    if (len < 1) {
                        len = 1;
                    }
                    if (len > 255) {
                        len = 255;
                    }
                    type = "VARCHAR(" + len + ")";
                } else if (types.get(n) instanceof Integer) {
                    type = "INT";
                } else if (types.get(n) instanceof Long) {
                    type = "INT";
                } else if (types.get(n) instanceof Double) {
                    type = "DOUBLE PRECISION";
                } else if (types.get(n) instanceof java.util.Date) {
                    type = "DATE";
                } else if (types.get(n) instanceof Data) {
                    type = "INT";
                } else {
                    this.println(String.valueOf(d.get(n).getClass().getName()) + " is not supported!");
                }
                if (this.useKeys && idIndex) {
                    type = "INT";
                }
                if (!type.equals("")) {
                    sql = this.addColumn(sql, String.valueOf(column) + " " + type);
                }
                if (this.containsID && idIndex) {
                    sql = String.valueOf(sql) + " NOT NULL";
                }
            }
            ++n;
        }
        if (listpos && !t.isPredicate(name)) {
            sql = this.addColumn(sql, String.valueOf(this.namer.getTable(d)) + "_order INT NOT NULL");
        }
        if (t.isPredicate(name)) {
            sql = this.addColumn(sql, "PRIMARY KEY (" + this.namer.getPrimaryKey(d) + ")");
        }
        sql = String.valueOf(sql) + ")";
        if (this.getVerbose()) {
            this.println(sql);
        }
        if (!this.exec.update(sql)) {
            this.println("ERROR: " + sql);
            this.println(this.exec.getLastException());
            throw new Exception("Error: cannot create table '" + name + "'");
        }
        if (!t.isPredicate(name)) {
            this.createIndex(this.namer.getPrimaryKey(d), String.valueOf(this.namer.getTable(d)) + "_");
        } else {
            Vector ids = this.namer.createIdNames(d);
            int i = 0;
            while (i < ids.size()) {
                this.createIndex(ids.get(i).toString(), String.valueOf(this.namer.getTable(d)) + "_");
                ++i;
            }
        }
        if (d.getParent() != null) {
            this.createIndex(this.namer.getParentPrimaryKey(d), String.valueOf(this.namer.getTable(d)) + "_");
        }
    }

    private void addForeignKey(Traverser t, String name) throws Exception {
        Data d = t.findFirst(name);
        if (d.getParent() != null) {
            String sql = Table.createForeignKeyStatement(new Table(String.valueOf(this.namer.getTable(d)) + "_"), new Column(this.namer.getParentPrimaryKey(d)), new Table(String.valueOf(this.namer.getTable(d.getParent())) + "_"), new Column(this.namer.getParentPrimaryKey(d)));
            if (this.getVerbose()) {
                this.println(sql);
            }
            if (!this.exec.update(sql)) {
                this.println("ERROR: " + sql);
                this.println(this.exec.getLastException());
                throw new Exception("Error: cannot add foreign key to '" + name + "'");
            }
        }
    }

    private String startInsert(String table) {
        return "INSERT INTO " + table + "_" + " VALUES (";
    }

    private String initInsert(String sql, Data d) {
        sql = this.addColumn(sql, new Integer(d.getID()).toString());
        if (d.getParent() != null) {
            sql = this.addColumn(sql, new Integer(d.getParent().getID()).toString());
        }
        return sql;
    }

    private String endInsert(String sql) {
        return String.valueOf(sql) + ")";
    }

    private String getValue(Object o) {
        String result = "";
        if (o instanceof String) {
            result = Data.isNull(o.toString()) ? "NULL" : "'" + o + "'";
        } else if (o instanceof Integer) {
            result = o.toString();
        } else if (o instanceof Double) {
            result = o.toString();
        } else if (o instanceof java.util.Date) {
            result = "'" + new SimpleDateFormat("yyyy-MM-dd").format((java.util.Date)o) + "'";
        } else if (o instanceof Date) {
            result = "'" + o.toString() + "'";
        } else if (o instanceof Data) {
            result = Integer.toString(((Data)o).getID());
        } else {
            this.println(String.valueOf(o.getClass().getName()) + " is not supported!");
        }
        return result;
    }

    private void fill(Traverser t, String name) throws Exception {
        this.println("Retrieving all predicates/lists (" + name + ")...");
        boolean listpos = this.getStringParameter("list_positions").equals("yes");
        Vector datas = t.findAll(name);
        String nameFixed = this.fixName(name);
        boolean isPredicate = t.isPredicate(name);
        Vector types = t.findAllArgTypes(name);
        int n = 0;
        while (n < datas.size()) {
            int m;
            String sql;
            Data d = (Data)datas.get(n);
            if (isPredicate) {
                sql = this.startInsert(nameFixed);
                sql = this.initInsert(sql, d);
                m = 0;
                while (m < d.size()) {
                    String value;
                    if (!(types.get(m) instanceof Data) && !(value = this.getValue(d.get(m))).equals("")) {
                        sql = this.addColumn(sql, value);
                    }
                    ++m;
                }
                sql = this.endInsert(sql);
                if (this.getVerboseLevel() >= 2) {
                    this.println(sql);
                }
                if (!this.exec.update(sql)) {
                    this.println("ERROR: " + sql + "\n" + this.exec.getLastException());
                }
            } else {
                m = 0;
                while (m < d.size()) {
                    sql = this.startInsert(nameFixed);
                    sql = this.initInsert(sql, d);
                    if (!(d.get(m) instanceof Data)) {
                        sql = this.addColumn(sql, this.getValue(d.get(m)));
                    }
                    if (listpos) {
                        sql = this.addColumn(sql, Integer.toString(m));
                    }
                    sql = this.endInsert(sql);
                    if (this.getVerboseLevel() >= 2) {
                        this.println(sql);
                    }
                    if (!this.exec.update(sql)) {
                        this.println("ERROR: " + sql + "\n" + this.exec.getLastException());
                    }
                    ++m;
                }
            }
            if ((n + 1) % 1000 == 0 || n + 1 == datas.size()) {
                this.println(String.valueOf(n + 1) + "/" + datas.size());
            }
            ++n;
        }
    }

    private void removeNullIndexes(Traverser t) {
        this.indexer.setTraverser(t);
        this.indexer.removeNullIndexes();
    }

    private boolean store(Vector predicates) throws Exception {
        String name;
        this.println("\nStoring data:");
        Traverser t = new Traverser(predicates);
        this.addListener(t);
        if (this.exists("shuffle")) {
            t.shuffleIDs();
        }
        this.println("Determining predicate/list names... ");
        Vector names = t.getPredicates();
        names.addAll(t.getLists());
        this.println(String.valueOf(names.size()) + " predicates/lists found!");
        this.indexer.setTraverser(t);
        this.indexer.setIndexes(this.getStringParameter("id_index"));
        this.namer = new Namer(t, this.indexer);
        this.namer.setContainsID(this.containsID);
        this.removeNullIndexes(t);
        this.println();
        PostProcessor p = new PostProcessor(t, this.indexer);
        p.setUseReducing(this.getStringParameter("reduce_lists").equals("yes"));
        p.setForeignKeys(this.getStringParameter("foreign_keys"));
        p.setAsymmetric(this.getStringParameter("asymmetric"));
        t = p.process();
        names = t.getAll();
        int i = 0;
        while (i < names.size()) {
            name = (String)names.get(i);
            this.println("\nProcessing " + name + ":");
            this.create(t, name);
            this.fill(t, name);
            System.gc();
            ++i;
        }
        if (this.foreignKeys) {
            this.print("\nAdding foreign keys");
            i = 0;
            while (i < names.size()) {
                this.print(".");
                name = (String)names.get(i);
                this.addForeignKey(t, name);
                ++i;
            }
            this.println();
        }
        this.println("\nStoring done!");
        return true;
    }

    private boolean supplementBackground(Vector predicates) throws Exception {
        boolean result = true;
        if (predicates.size() == 0) {
            return result;
        }
        int i = 0;
        while (i < predicates.size()) {
            String name = (String)predicates.get(i);
            this.println("\nAdding negative classes for " + name + "...");
            String sql = "SELECT MAX(" + name + "_id) FROM " + name + "_";
            ResultSet rs = this.exec.select(sql);
            if (rs == null) {
                this.println("ERROR: " + sql + "\n" + this.exec.getLastException());
            } else {
                rs.first();
                int primKey = rs.getInt(1);
                rs.close();
                Enumeration enm = this.keys.keys();
                while (enm.hasMoreElements()) {
                    ++primKey;
                    String key = (String)enm.nextElement();
                    Integer id = (Integer)this.keys.get(key);
                    sql = "SELECT COUNT(id) FROM " + name + "_ WHERE id = " + id;
                    rs = this.exec.select(sql);
                    if (rs == null) {
                        this.println("Couldn't add negativ classes for " + name);
                        this.println("Cause: " + this.exec.getLastException());
                        break;
                    }
                    rs.first();
                    boolean exists = rs.getInt(1) != 0;
                    rs.close();
                    if (exists) continue;
                    sql = "INSERT INTO " + name + "_" + " VALUES(" + primKey + ", " + id + ", " + "'" + "neg" + "'" + ")";
                    if (this.getVerboseLevel() >= 2) {
                        this.println(sql);
                    }
                    if (this.exec.update(sql)) continue;
                    this.println("ERROR: " + sql + "\n" + this.exec.getLastException());
                }
            }
            ++i;
        }
        return result;
    }

    private String addFile(String files, String file) {
        if (!file.equals("")) {
            if (!files.equals("")) {
                files = String.valueOf(files) + ",";
            }
            files = String.valueOf(files) + file;
        }
        return files;
    }

    private boolean doImport() throws Exception {
        boolean result = false;
        this.useKeys = false;
        ProperVector bkPredicates = new ProperVector();
        this.drop();
        this.indexer = new Indexer();
        this.indexer.setIndexes(this.getStringParameter("id_index"));
        this.addListener(this.indexer);
        ProperVector preds = new ProperVector();
        int i = 0;
        while (i < 6) {
            boolean addClassLabel = false;
            String classLabel = "";
            boolean isBackground = false;
            String tmp = "";
            switch (i) {
                case 0: {
                    if (this.addPosClass) {
                        addClassLabel = true;
                        classLabel = "pos";
                    }
                    isBackground = true;
                    tmp = this.addFile("", this.getStringParameter("background"));
                    break;
                }
                case 1: {
                    tmp = this.addFile("", this.getStringParameter("rel_database"));
                    break;
                }
                case 2: {
                    addClassLabel = true;
                    tmp = this.addFile("", this.getStringParameter("pos_neg"));
                    break;
                }
                case 3: {
                    addClassLabel = true;
                    classLabel = "pos";
                    tmp = this.addFile("", this.getStringParameter("positive"));
                    break;
                }
                case 4: {
                    addClassLabel = true;
                    classLabel = "neg";
                    tmp = this.addFile("", this.getStringParameter("negative"));
                    break;
                }
                case 5: {
                    addClassLabel = true;
                    classLabel = "?";
                    tmp = this.addFile("", this.getStringParameter("unclassified"));
                }
            }
            Stack<String> files = new Stack<String>();
            StringTokenizer tok = new StringTokenizer(tmp, ",");
            while (tok.hasMoreTokens()) {
                files.push(tok.nextToken());
            }
            while (!files.empty()) {
                Vector predicates = this.parse((String)files.pop(), addClassLabel, isBackground, classLabel);
                result = predicates != null && predicates.size() > 0;
                preds.addAll(predicates);
                Traverser t = new Traverser(predicates);
                this.addListener(t);
                this.indexer.setTraverser(t);
                this.indexer.setAddClassLabel(addClassLabel, isBackground);
                if (isBackground) {
                    Vector names = t.getPredicates();
                    int n = 0;
                    while (n < names.size()) {
                        String name = (String)names.get(n);
                        Predicate p = t.findFirstPredicate(name);
                        if (p.getClassLabelAdded()) {
                            bkPredicates.add(name);
                        }
                        ++n;
                    }
                }
                if (!result) break;
            }
            ++i;
        }
        if (result) {
            result = this.store(preds);
        }
        if (this.addNegClass) {
            result = this.supplementBackground(bkPredicates);
        }
        return result;
    }

    @Override
    public boolean execute() {
        boolean result;
        super.execute();
        this.containsID = !this.getStringParameter("id_index").equals("");
        this.addNegClass = this.valueEquals("add_neg_class", "yes");
        this.addPosClass = this.valueEquals("add_pos_class", "yes") || this.addNegClass;
        this.foreignKeys = this.exists("use_foreign_keys");
        try {
            result = this.doImport();
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        return result;
    }
}

