/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.frame;

import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.CommandLineFrame;

public class ChildFrame
extends CommandLineFrame {
    private ApplicationFrame parent;

    public ChildFrame(ApplicationFrame parent) {
        this(parent, "");
    }

    public ChildFrame(ApplicationFrame parent, String title) {
        this(parent, title, 800, 600);
    }

    public ChildFrame(ApplicationFrame parent, String title, int width, int height) {
        this(parent, title, width, height, -1, -1);
    }

    public ChildFrame(ApplicationFrame parent, String title, int width, int height, int left, int top) {
        super(title);
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.left = left;
        this.top = top;
        this.resizeFrame();
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        if (this.getParentFrame() != null) {
            this.getParentFrame().addWindow(this);
        }
    }

    public static ChildFrame createInstance(String classname, ApplicationFrame parent) {
        ChildFrame result;
        try {
            Class<?> properDefinition = Class.forName(classname);
            Class[] properArgsClass = new Class[]{ApplicationFrame.class};
            Object[] properArgs = new Object[]{parent};
            Constructor<?> properConstructor = properDefinition.getConstructor(properArgsClass);
            result = (ChildFrame)properConstructor.newInstance(properArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public ChildFrame createInstance(String classname) {
        return ChildFrame.createInstance(classname, this.getParentFrame());
    }

    public void setParentFrame(ApplicationFrame parent) {
        this.parent = parent;
    }

    public ApplicationFrame getParentFrame() {
        return this.parent;
    }

    protected void setFrameTitle() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().addWindow(this);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        if (this.getParentFrame() != null) {
            this.getParentFrame().removeWindow(this);
        }
    }

    public static void main(String[] args) throws Exception {
        ChildFrame frame = new ChildFrame(null, "Frame-Test");
        frame.run(args);
    }
}

