/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import util.Couple;
import util.Mutable;

public class Mean
extends AggregateFunction<Couple<Mutable<Double>, Mutable<Long>>> {
    public Mean() {
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Numeric();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "mean";
        this.resApplied = new Value(0.0);
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        Double res = 0.0;
        ArrayList<Double> sortedElements = new ArrayList<Double>();
        for (Value val : s) {
            sortedElements.add(val.getNumericValue());
        }
        Collections.sort(sortedElements);
        for (Double v : sortedElements) {
            res = res + v;
        }
        res = res / (double)s.size();
        return new Value(res);
    }

    @Override
    public Supplier<Couple<Mutable<Double>, Mutable<Long>>> supplier() {
        return () -> new Couple<Mutable<Double>, Mutable<Long>>(new Mutable<Double>(0.0), new Mutable<Long>(0L));
    }

    @Override
    public BiConsumer<Couple<Mutable<Double>, Mutable<Long>>, Value> accumulator() {
        return (accum, val) -> {
            ((Mutable)accum.getLeft()).set((Double)((Mutable)accum.getLeft()).get() + val.getNumericValue());
            ((Mutable)accum.getRight()).set((Long)((Mutable)accum.getRight()).get() + 1L);
        };
    }

    @Override
    public BinaryOperator<Couple<Mutable<Double>, Mutable<Long>>> combiner() {
        return (a, b) -> {
            ((Mutable)a.getLeft()).set((Double)((Mutable)a.getLeft()).get() + (Double)((Mutable)b.getLeft()).get());
            ((Mutable)a.getRight()).set((Long)((Mutable)a.getRight()).get() + (Long)((Mutable)b.getRight()).get());
            return a;
        };
    }

    @Override
    public Function<Couple<Mutable<Double>, Mutable<Long>>, Value> finisher() {
        return a -> {
            if ((Long)((Mutable)a.getRight()).get() > 0L) {
                return new Value((Double)((Mutable)a.getLeft()).get() / ((Long)((Mutable)a.getRight()).get()).doubleValue());
            }
            return new Value(null);
        };
    }
}

