/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import util.Mutable;

public class Sum
extends AggregateFunction<Mutable<OptionalDouble>> {
    public Sum() {
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Numeric();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "sum";
        this.resApplied = new Value(0.0);
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        Double res = 0.0;
        ArrayList<Double> sortedElements = new ArrayList<Double>();
        for (Value val : s) {
            sortedElements.add(val.getNumericValue());
        }
        Collections.sort(sortedElements);
        for (Double v : sortedElements) {
            res = res + v;
        }
        return new Value(res);
    }

    @Override
    public Supplier<Mutable<OptionalDouble>> supplier() {
        return () -> new Mutable<OptionalDouble>(OptionalDouble.empty());
    }

    @Override
    public BiConsumer<Mutable<OptionalDouble>, Value> accumulator() {
        return (accum, val) -> {
            if (!((OptionalDouble)accum.get()).isPresent()) {
                accum.set(OptionalDouble.of(0.0));
            }
            accum.set(OptionalDouble.of(((OptionalDouble)accum.get()).getAsDouble() + val.getNumericValue()));
        };
    }

    @Override
    public BinaryOperator<Mutable<OptionalDouble>> combiner() {
        return (a, b) -> {
            if (!((OptionalDouble)a.get()).isPresent() && !((OptionalDouble)b.get()).isPresent()) {
                a.set(OptionalDouble.empty());
            } else {
                a.set(OptionalDouble.of(((OptionalDouble)a.get()).orElse(0.0) + ((OptionalDouble)b.get()).orElse(0.0)));
            }
            return a;
        };
    }

    @Override
    public Function<Mutable<OptionalDouble>, Value> finisher() {
        return a -> {
            if (((OptionalDouble)a.get()).isPresent()) {
                return new Value(((OptionalDouble)a.get()).getAsDouble());
            }
            return new Value(null);
        };
    }
}

