/*
 * Decompiled with CFR 0.152.
 */
package data.feature;

import data.Type;
import data.aggregate.AggregateFunction;
import data.aggregate.selection.PipeSelectionFilters;
import data.aggregate.selection.SelectionWithFilters;
import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.Feature;
import data.feature.SimpleFeature;
import data.feature.SingleValueFeature;
import data.instance.Instances;
import data.parameter.AffineShift;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import model.inference.hc.AggregateBase;
import org.jdom2.Content;
import org.jdom2.Element;

public class AggregateFeature
extends Feature
implements SingleValueFeature {
    protected PipeSelectionFilters objectSelection;
    protected SingleValueFeature feature;
    protected AggregateFunction<?> aggregateFunction;
    protected String aggregateFunctionName;
    private NumericShiftFunction shift;
    public static double complexityBase = Math.log(5.0);

    public AggregateFeature(AggregateFunction<?> af) {
        this.aggregateFunction = af;
        this.aggregateFunctionName = af.getName();
        this.objectSelection = new PipeSelectionFilters();
        this.shift = new AffineShift();
    }

    public AggregateFeature() {
        this.objectSelection = new PipeSelectionFilters();
        this.shift = new AffineShift();
    }

    public AggregateFeature(AggregateBase ab, ArrayList<Value> ids, Catalog cat, boolean fillCond) {
        this.aggregateFunction = ab.getFunction();
        this.aggregateFunctionName = this.aggregateFunction.getName();
        this.feature = ab.getFeature();
        this.objectSelection = new PipeSelectionFilters();
        SelectionWithFilters swf = new SelectionWithFilters();
        swf.setSelection(ab.getLink());
        this.shift = new AffineShift();
        if (fillCond) {
            swf.initializeFilters(ids, cat);
        }
        this.objectSelection.addToObjectSelection(swf);
    }

    public AggregateFeature(AggregateBase ab, ArrayList<Value> ids, Catalog cat, boolean fillCond, ArrayList<SimpleFeature> sfs, Random rt) {
        this.aggregateFunction = ab.getFunction();
        this.aggregateFunctionName = this.aggregateFunction.getName();
        this.feature = ab.getFeature();
        this.objectSelection = new PipeSelectionFilters();
        SelectionWithFilters swf = new SelectionWithFilters();
        swf.setSelection(ab.getLink());
        this.shift = new AffineShift();
        if (fillCond) {
            swf.initializeFilters(ids, cat, sfs, rt);
        }
        this.objectSelection.addToObjectSelection(swf);
    }

    public AggregateFeature(Element featElem, Catalog cat) {
        this();
        Element process = featElem.getChild("process");
        this.setFunction(AggregateFunction.fromXML(process.getChild("function"), cat));
        this.setFeature(Feature.fromXML(process.getChild("feature"), cat));
        this.setObjectSelection(new PipeSelectionFilters(featElem.getChild("selection"), cat));
        if (this.aggregateFunction.getKindOut() == 1) {
            this.shift = NumericShiftFunction.fromXML(featElem.getChild("shift"));
        }
    }

    @Override
    public Value result(Value in, Catalog cat) {
        AggregateBase ab = new AggregateBase(this.aggregateFunction, this.objectSelection.getLastSelection().getSelection(), this.feature);
        cat.setUsingAggregate(ab, new HashSet<SimpleFeature>(this.objectSelection.getLastSelection().getFilters().stream().map(ff -> (SimpleFeature)ff.getFeature()).collect(Collectors.toSet())));
        Value res2 = null;
        if (this.aggregateFunction.isNeedsFeature()) {
            if (this.feature instanceof AggregateFeature && ((AggregateFeature)this.feature).isSensitive()) {
                AggregateFeature aggFeature = (AggregateFeature)this.feature;
                FilterFeature protect = aggFeature.protection();
                res2 = (Value)this.objectSelection.select(in, cat).filter(protect.filter(cat)).map(v -> this.feature.result((Value)v, cat)).collect(this.aggregateFunction);
            } else {
                res2 = (Value)this.objectSelection.select(in, cat).map(v -> this.feature.result((Value)v, cat)).collect(this.aggregateFunction);
            }
        } else {
            res2 = (Value)this.objectSelection.select(in, cat).collect(this.aggregateFunction);
        }
        if (res2.getNumericValue() != null && this.aggregateFunction.getKindOut() == 1) {
            res2 = this.shift.apply(res2);
        }
        cat.setUsingAggregate(null, null);
        return res2;
    }

    public Value resultSimple(Value in, Catalog cat) {
        AggregateBase ab = new AggregateBase(this.aggregateFunction, this.objectSelection.getLastSelection().getSelection(), this.feature);
        cat.setUsingAggregate(ab, new HashSet<SimpleFeature>(this.objectSelection.getLastSelection().getFilters().stream().map(ff -> (SimpleFeature)ff.getFeature()).collect(Collectors.toSet())));
        Value res2 = null;
        if (this.aggregateFunction.isNeedsFeature()) {
            if (this.feature instanceof AggregateFeature && ((AggregateFeature)this.feature).isSensitive()) {
                AggregateFeature aggFeature = (AggregateFeature)this.feature;
                FilterFeature protect = aggFeature.protection();
                res2 = (Value)this.objectSelection.select(in, cat).filter(protect.filter(cat)).map(v -> this.feature.result((Value)v, cat)).collect(this.aggregateFunction);
            } else {
                res2 = (Value)this.objectSelection.select(in, cat).map(v -> this.feature.result((Value)v, cat)).collect(this.aggregateFunction);
            }
        } else {
            res2 = (Value)this.objectSelection.select(in, cat).collect(this.aggregateFunction);
        }
        if (res2.getNumericValue() != null && this.aggregateFunction.getKindOut() == 1) {
            res2 = this.shift.apply(res2);
        }
        cat.setUsingAggregate(null, null);
        return res2;
    }

    public void setFeature(SingleValueFeature f) {
        this.feature = f;
    }

    public SingleValueFeature getFeature() {
        return this.feature;
    }

    public AggregateFunction<?> getAggregateFunction() {
        return this.aggregateFunction;
    }

    public PipeSelectionFilters getObjectSelection() {
        return this.objectSelection;
    }

    public void addToObjectSelection(SelectionWithFilters b) {
        this.objectSelection.addToObjectSelection(b);
    }

    @Override
    public AggregateFeature clone() {
        AggregateFeature res = new AggregateFeature(this.aggregateFunction);
        if (this.feature == null) {
            res.setFeature(null);
        } else {
            res.setFeature(this.feature.clone());
        }
        res.setObjectSelection(this.objectSelection.clone());
        return res;
    }

    public void setObjectSelection(PipeSelectionFilters psf) {
        this.objectSelection = psf;
    }

    @Override
    public Type getTypeOutput() {
        return this.feature.getTypeOutput();
    }

    @Override
    public double complexity() {
        return 1.0 + Math.log1p(this.objectSelection.complexity()) / complexityBase + (this.feature == null ? 0.0 : Math.log(this.feature.complexity()) / complexityBase);
    }

    @Override
    public boolean equals(Feature f) {
        if (f instanceof AggregateFeature) {
            AggregateFeature af = (AggregateFeature)f;
            boolean result = true;
            if (af.getFeature() == null ^ this.feature == null) {
                result = false;
            }
            return result && this.aggregateFunction.equals(af.getAggregateFunction()) && this.objectSelection.equals(af.getObjectSelection());
        }
        return f == this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.aggregateFunction.toString()) + "(" + (this.aggregateFunction.isNeedsFeature() ? String.valueOf(this.feature.toString()) + ", " : "") + this.objectSelection.toString() + ")";
    }

    public SelectionWithFilters getLastSelection() {
        return this.objectSelection.getLastSelection();
    }

    public void addToLastSelection(FilterFeature filter) {
        this.objectSelection.addToLastSelection(filter);
    }

    public void removeLastFilterFromLastSelection() {
        this.objectSelection.removeLastFilterFromLastSelection();
    }

    public void removeLastSelection() {
        this.objectSelection.removeLastSelection();
    }

    @Override
    public boolean equals(SingleValueFeature f) {
        if (f instanceof AggregateFeature) {
            return this.equals((Feature)((Object)f));
        }
        return f == this;
    }

    @Override
    public boolean isSensitive() {
        return this.aggregateFunction.isSensitive();
    }

    public FilterFeature protection() {
        FilterFeature res = this.aggregateFunction.baseProtection(this.objectSelection);
        return res;
    }

    public void reinitialize(AggregateFeature agg) {
        this.setObjectSelection(agg.getObjectSelection());
        this.setFeature(agg.getFeature());
    }

    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> res = new HashMap<NumericShiftFunction, double[]>();
        res.putAll(this.objectSelection.getShifts(vals, cat));
        if (this.feature instanceof AggregateFeature) {
            res.putAll(((AggregateFeature)this.feature).getShifts(new ArrayList<Value>(vals.stream().flatMap(v -> this.objectSelection.select((Value)v, cat)).collect(Collectors.toList())), cat));
        }
        return res;
    }

    @Override
    public HashSet<NumericShiftFunction> getShifts() {
        HashSet<NumericShiftFunction> res = new HashSet<NumericShiftFunction>();
        res.add(this.shift);
        res.addAll(this.objectSelection.getShifts());
        return res;
    }

    public void addCondition(Catalog cat, SimpleFeature simpleFeature, ArrayList<Value> values, Random rt) {
        this.objectSelection.getSelections().get(0).addCondition(simpleFeature, values, rt);
    }

    public void removeCondition(SimpleFeature sf) {
        this.objectSelection.getSelections().get(0).removeCondition(sf);
    }

    public void applyMove(Catalog cat, ArrayList<Value> ids, SimpleFeature sf, Value val) {
        this.objectSelection.applyMove(cat, ids, sf, val);
    }

    public void reInitializeCondition(ArrayList<Value> ids, Catalog cat, ArrayList<SimpleFeature> allFeatures, Random rt) {
        this.objectSelection.getSelections().get(0).getFilters().clear();
        this.objectSelection.getSelections().get(0).initializeFilters(ids, cat, allFeatures, rt);
    }

    public ArrayList<AggregateFeature> neighbors(TreeSet<Value> possibleValues, SimpleFeature sf, int absDepth) {
        ArrayList<SelectionWithFilters> swfsNeighbors = this.objectSelection.getSelections().get(0).neighbors(possibleValues, sf, absDepth);
        ArrayList<AggregateFeature> res = new ArrayList<AggregateFeature>();
        for (SelectionWithFilters swf : swfsNeighbors) {
            AggregateFeature toAdd = this.clone();
            toAdd.getObjectSelection().removeLastSelection();
            toAdd.getObjectSelection().addToObjectSelection(swf);
            res.add(toAdd);
        }
        return res;
    }

    public AggregateFeature getNeighbor(TreeSet<Value> possibleValues, SimpleFeature sf, Random rt) {
        SelectionWithFilters swf = this.objectSelection.getSelections().get(0).randomNeighbor(possibleValues, sf, rt);
        AggregateFeature res = this.clone();
        res.getObjectSelection().removeLastSelection();
        res.getObjectSelection().addToObjectSelection(swf);
        return res;
    }

    public AggregateFeature randomNeighbor(Instances insts, Catalog cat, Random rt) {
        return null;
    }

    public void setFunction(AggregateFunction<?> function) {
        this.aggregateFunction = function;
        this.aggregateFunctionName = function.getName();
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("aggregate");
        Element aggProcEl = new Element("process");
        Element funcEl = new Element("function");
        funcEl.setAttribute("name", this.aggregateFunctionName);
        aggProcEl.addContent((Content)funcEl);
        if (this.feature != null) {
            Element featEl = new Element("feature");
            featEl.addContent((Content)this.feature.toXMLElement());
            aggProcEl.addContent((Content)featEl);
        }
        el.addContent((Content)aggProcEl);
        el.addContent((Content)this.objectSelection.toXMLElement());
        Element shiftEl = new Element("shift");
        shiftEl.addContent((Content)this.shift.toXMLElement());
        el.addContent((Content)shiftEl);
        return el;
    }

    @Override
    public double[] range(ArrayList<Value> ids, Catalog cat) {
        if (this.aggregateFunction.getKindOut() == 1 && !ids.isEmpty()) {
            double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            boolean modif = false;
            for (Value id : ids) {
                Value dval = this.result(id, cat);
                if (dval.getStringValue() == null) continue;
                double val = dval.getNumericValue();
                if (val < range[0]) {
                    range[0] = val;
                    modif = true;
                }
                if (!(val > range[1])) continue;
                range[1] = val;
                modif = true;
            }
            if (modif && range[0] != range[1]) {
                return range;
            }
        }
        return null;
    }

    public double[] rangeSimple(ArrayList<Value> ids, Catalog cat) {
        if (this.aggregateFunction.getKindOut() == 1 && !ids.isEmpty()) {
            double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            boolean modif = false;
            for (Value id : ids) {
                Value dval = this.result(id, cat);
                if (dval.getStringValue() == null) continue;
                double val = dval.getNumericValue();
                if (val < range[0]) {
                    range[0] = val;
                    modif = true;
                }
                if (!(val > range[1])) continue;
                range[1] = val;
                modif = true;
            }
            if (modif && range[0] != range[1]) {
                return range;
            }
        }
        return null;
    }

    @Override
    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        if (this.aggregateFunction.isNeedsFeature() && this.feature instanceof AggregateFeature) {
            this.feature.initShifts(vals, cat);
        }
        this.objectSelection.initShifts(vals, cat);
        double[] range = this.range(vals, cat);
        if (range == null) {
            range = this.rangeSimple(vals, cat);
        }
        this.shift.setFeature(this);
        this.shift.setParamsOrig(range);
    }

    @Override
    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        if (this.aggregateFunction.isNeedsFeature() && this.feature instanceof AggregateFeature) {
            this.feature.deployShifts(vals, cat);
        }
        this.objectSelection.deployShifts(vals, cat);
        double[] range = this.range(vals, cat);
        if (range == null) {
            range = this.rangeSimple(vals, cat);
        }
        this.shift.setParamsDeploy(range);
    }

    @Override
    public NumericShiftFunction getShift() {
        return this.shift;
    }
}

