/*
 * Decompiled with CFR 0.152.
 */
package measures.regression;

import data.instance.Instance;
import data.instance.Instances;
import measures.regression.MeasureBase;

public class Variance
extends MeasureBase {
    public Variance() {
        this.min = 0.0;
        this.max = Double.MAX_VALUE;
    }

    @Override
    public double scoreForOnePartition(Instances ex) {
        double res = 0.0;
        if (ex.size() > 1) {
            double n = ex.size();
            double sumSquares = 0.0;
            double sum = 0.0;
            for (Instance inst : ex) {
                Double val = inst.getLabel().getNumericValue();
                sumSquares += val * val;
                sum += val.doubleValue();
            }
            res = (sumSquares /= n) - (sum /= n) * sum;
        }
        return res < 0.0 ? 0.0 : res;
    }
}

