/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.Application;
import proper.engine.Engine;
import proper.engine.MilkClassifier;
import proper.engine.WekaClassifier;

public class Classifier
extends Application {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("input", "the name of an ARFF-File to build the classifier on", true, "<name>", false);
        this.addDefinition("unknown", "the name of an ARFF-File with instances of unknown classes", true, "<name>", false);
        this.addDefinition("output", "the name of the ARFF-File to store the prediction in", true, "<name>", false);
        this.addDefinition("classifier", "the WEKA-/MILK-Classifier's classname", true, "<classname>", false);
        this.addDefinition("additional", "additional parameters for the classifier", true, "<args>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Trains a classifier and classifies with it given instances.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        Engine engine = this.cl.getValue("classifier").startsWith("milk.") ? new MilkClassifier() : new WekaClassifier();
        this.addListener(engine);
        if (!engine.getVerbose()) {
            engine.setVerbose(this.getVerbose());
        }
        engine.setParameter("classifier", this.cl.getValue("classifier"));
        engine.setParameter("additional", this.cl.getValue("additional"));
        engine.setParameter("input", this.cl.getValue("input"));
        engine.setParameter("unknown", this.cl.getValue("unknown"));
        engine.setParameter("output", this.cl.getValue("output"));
        return engine.execute();
    }

    public static void main(String[] args) throws Exception {
        Classifier app = new Classifier();
        app.run(args);
    }
}

