/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Vector;
import proper.database.ColumnLister;
import proper.engine.DatabaseEngine;
import proper.engine.Instancer;

public class BagArffer
extends DatabaseEngine {
    private Instancer inst = new Instancer();
    private String bagColumn;

    public BagArffer() {
        this.addListener(this.inst);
        this.setParameter("database", "musk1");
        this.setParameter("table", "musk_clean1_");
        this.setParameter("bag", "id");
        this.setParameter("field", "musk_clean1168");
        this.setParameter("exclude_fields", "");
        this.setParameter("output", "tmp/output.arff");
        this.setParameter("type", "classified");
        this.setParameter("order", "yes");
        this.setParameter("orderby", "");
        this.setParameter("percentage", "0");
        this.setParameter("ignore_empty_nominal", "no");
        this.bagColumn = "";
    }

    private String getBagColumn() {
        if (this.bagColumn.equals("")) {
            this.bagColumn = this.getStringParameter("bag");
        }
        if (this.bagColumn.equals("")) {
            ColumnLister col = new ColumnLister(this.conn);
            col.setTable(this.getStringParameter("table"));
            col.setOnlyIndexes(true);
            Vector indexes = col.getList();
            if (indexes.size() == 1) {
                this.bagColumn = indexes.get(0).toString();
            } else {
                int i = 0;
                while (i < indexes.size()) {
                    String name = indexes.get(i).toString();
                    if (!name.endsWith("_id")) {
                        this.bagColumn = name;
                        break;
                    }
                    ++i;
                }
            }
            if (this.getVerbose()) {
                this.println("Bag determined: " + this.bagColumn);
            }
        }
        return this.bagColumn;
    }

    private String createFieldList() throws Exception {
        ColumnLister col = new ColumnLister(this.conn);
        col.setTable(this.getStringParameter("table"));
        col.setSort(this.valueEquals("order", "yes"));
        String excludes = String.valueOf(this.getBagColumn()) + "," + this.getStringParameter("field");
        if (!this.valueEquals("exclude_fields", "")) {
            excludes = String.valueOf(excludes) + "," + this.getStringParameter("exclude_fields");
        }
        col.setExcludes(excludes);
        Vector fields = col.getList();
        this.conn.disconnect();
        String result = this.getBagColumn();
        int i = 0;
        while (i < fields.size()) {
            result = String.valueOf(result) + "," + fields.get(i).toString();
            ++i;
        }
        result = String.valueOf(result) + "," + this.getStringParameter("field");
        return result;
    }

    @Override
    public boolean execute() {
        boolean result = super.execute();
        String fields = "";
        if (result) {
            boolean bl = result = !this.getBagColumn().equals("");
            if (result) {
                this.println("Using Bag: " + this.getBagColumn());
            } else {
                this.println("Couldn't determine Bag!");
            }
        }
        if (result) {
            try {
                fields = this.createFieldList();
            }
            catch (Exception e) {
                this.println(e);
                fields = "";
                result = false;
            }
            if (this.getVerbose()) {
                this.println("Fields: " + fields);
            }
        }
        if (result) {
            if (!this.inst.getVerbose()) {
                this.inst.setVerbose(this.getVerbose());
            }
            this.inst.setParameter("driver", this.getParameter("driver"));
            this.inst.setParameter("url", this.getParameter("url"));
            this.inst.setParameter("database", this.getParameter("database"));
            this.inst.setParameter("table", this.getParameter("table"));
            this.inst.setParameter("user", this.getParameter("user"));
            this.inst.setParameter("password", this.getParameter("password"));
            this.inst.setParameter("field_list", fields);
            this.inst.setParameter("nominal_list", this.getBagColumn());
            this.inst.setParameter("field", this.getParameter("field"));
            this.inst.setParameter("bag", this.getBagColumn());
            this.inst.setParameter("exclude_fields", this.getParameter("exclude_fields"));
            this.inst.setParameter("output", this.getParameter("output"));
            this.inst.setParameter("sql_limit", this.getParameter("sql_limit"));
            this.inst.setParameter("type", this.getParameter("type"));
            this.inst.setParameter("order", this.getParameter("order"));
            this.inst.setParameter("orderby", this.getBagColumn());
            this.inst.setParameter("no_nulls", this.getBagColumn());
            this.inst.setParameter("percentage", this.getParameter("percentage"));
            if (this.exists("filter")) {
                this.inst.setParameter("filter", this.getParameter("filter"));
            }
            if (this.exists("filter_additional")) {
                this.inst.setParameter("filter_additional", this.getParameter("filter_additional"));
            }
            if (this.exists("missing_binary_to_zero")) {
                this.inst.setParameter("missing_binary_to_zero", this.getParameter("missing_binary_to_zero"));
            }
            if (this.exists("ignore_empty_nominal")) {
                this.inst.setParameter("ignore_empty_nominal", this.getParameter("ignore_empty_nominal"));
            }
            result = this.inst.execute();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.inst.toString();
    }
}

