/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.io.SimpleFileFilter;
import proper.gui.core.list.List;
import proper.gui.core.text.JTextAreaPrintStream;
import proper.gui.experiment.ExperimentExecutor;
import proper.gui.experiment.ExperimentOptions;
import proper.io.Ant;
import proper.io.TextFile;
import proper.util.Excluder;
import proper.util.ProperVector;
import proper.util.Strings;

public class ExperimentFrame
extends ChildFrame
implements ItemListener {
    protected static final String ACTION_START = "start";
    protected static final String ACTION_STOP = "stop";
    protected static final String ACTION_CLEAR = "clear";
    protected static final String ACTION_SAVE = "save";
    protected static final String ACTION_OPTIONS = "options";
    protected static final String ACTION_RELOAD = "reload";
    protected JTabbedPane tabbedPane;
    protected JComboBox comboSteps;
    protected JButton buttonStart;
    protected JButton buttonStop;
    protected JButton buttonExit;
    protected JButton buttonClear;
    protected JButton buttonSave;
    protected JButton buttonOptions;
    protected JButton buttonReload;
    protected JLabel labelSteps;
    protected List listDatasets;
    protected JTextArea areaOutput;
    protected JScrollPane paneDatasets;
    protected JScrollPane paneOutput;
    protected JPanel panelDatasets;
    protected JPanel panelOutput;
    protected JTextAreaPrintStream streamOutput;
    protected FileChooser fileChooser;
    protected Vector filenames;
    protected Ant ant;
    protected ExperimentExecutor exec;
    protected boolean noChange;
    protected Hashtable files;

    public ExperimentFrame(ApplicationFrame parent, String title) {
        super(parent, title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.filenames = new ProperVector();
        this.ant = null;
        this.exec = null;
        this.noChange = false;
        this.files = new Hashtable();
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.labelSteps = new JLabel("Step");
        this.comboSteps = new JComboBox();
        this.comboSteps.addItemListener(this);
        this.buttonOptions = new JButton("Options", ImageLoader.getImageIcon("properties.gif"));
        this.buttonOptions.setActionCommand(ACTION_OPTIONS);
        this.buttonOptions.addActionListener(this);
        this.buttonOptions.setMnemonic('p');
        this.buttonReload = new JButton("Reload", ImageLoader.getImageIcon("undo.gif"));
        this.buttonReload.setActionCommand(ACTION_RELOAD);
        this.buttonReload.addActionListener(this);
        this.buttonReload.setMnemonic('R');
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.labelSteps);
        panel.add(this.comboSteps);
        panel.add(this.buttonOptions);
        panel.add(this.buttonReload);
        this.getContentPane().add((Component)panel, "North");
        this.panelDatasets = new JPanel(new BorderLayout());
        this.panelOutput = new JPanel(new BorderLayout());
        this.listDatasets = new List();
        this.listDatasets.setPopupMenuEnabled(true);
        this.listDatasets.addMouseListener(this);
        this.listDatasets.setFont(Font.decode(this.getCustomFont()));
        this.areaOutput = new JTextArea();
        this.areaOutput.setFont(Font.decode(this.getCustomFont()));
        this.areaOutput.setLineWrap(true);
        this.paneDatasets = new JScrollPane(this.listDatasets);
        this.paneOutput = new JScrollPane(this.areaOutput);
        this.panelDatasets.add((Component)this.paneDatasets, "Center");
        this.panelOutput.add((Component)this.paneOutput, "Center");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Datasets", ImageLoader.getImageIcon("objects.gif"), this.panelDatasets);
        this.tabbedPane.addTab("Output", ImageLoader.getImageIcon("list.gif"), this.panelOutput);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.buttonStart = new JButton("Start", ImageLoader.getImageIcon("run.gif"));
        this.buttonStart.setActionCommand(ACTION_START);
        this.buttonStart.addActionListener(this);
        this.buttonStart.setMnemonic('S');
        this.buttonExit = new JButton("Exit", ImageLoader.getImageIcon("delete.gif"));
        this.buttonExit.setActionCommand("exit");
        this.buttonExit.addActionListener(this);
        this.buttonExit.setMnemonic('E');
        this.labelStatus.setHorizontalAlignment(0);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buttonStart, "West");
        panel.add((Component)this.labelStatus, "Center");
        panel.add((Component)this.buttonExit, "East");
        this.getContentPane().add((Component)panel, "South");
        this.buttonClear = new JButton("Clear", ImageLoader.getImageIcon("new.gif"));
        this.buttonClear.setActionCommand(ACTION_CLEAR);
        this.buttonClear.addActionListener(this);
        this.buttonClear.setMnemonic('C');
        this.buttonStop = new JButton("Stop", ImageLoader.getImageIcon("stop2.gif"));
        this.buttonStop.setActionCommand(ACTION_STOP);
        this.buttonStop.addActionListener(this);
        this.buttonStop.setMnemonic('t');
        this.buttonSave = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonSave.setActionCommand(ACTION_SAVE);
        this.buttonSave.addActionListener(this);
        this.buttonSave.setMnemonic('a');
        panel = new JPanel(new GridLayout(3, 1));
        panel.add(this.buttonClear);
        panel.add(this.buttonStop);
        panel.add(this.buttonSave);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelOutput.add((Component)panel2, "East");
        this.streamOutput = new JTextAreaPrintStream(this.areaOutput);
        this.setOutput(this.streamOutput);
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setFileFilter(new SimpleFileFilter("xml", "XML-Files"));
    }

    private String createComboBoxItem(String filename) {
        String result = "";
        if (filename.length() > 0) {
            result = filename.replaceAll(".*/", "").substring(0, 1).toUpperCase();
            if (filename.length() > 1) {
                result = String.valueOf(result) + filename.replaceAll(".*/", "").substring(1);
            }
            result = result.replaceAll("\\.xml$", "");
            result = result.replaceAll("-mi$", "").replaceAll("-remi$", "");
        }
        return result;
    }

    @Override
    protected boolean afterCreate() {
        this.noChange = true;
        this.filenames = Strings.fromCommalistVector(this.cl.getValue("filename"));
        this.comboSteps.removeAllItems();
        int i = 0;
        while (i < this.filenames.size()) {
            this.comboSteps.addItem(this.createComboBoxItem(this.filenames.get(i).toString()));
            ++i;
        }
        this.noChange = false;
        this.comboSteps.setSelectedIndex(-1);
        this.comboSteps.setSelectedIndex(0);
        return true;
    }

    @Override
    protected void setFrameTitle() {
        if (this.getSelectedAnt() != null && this.getSelectedAnt().getFilename() != null) {
            this.setTitle(String.valueOf(this.frameTitle) + " - " + this.getSelectedAnt().getFilename());
        } else {
            this.setTitle(this.frameTitle);
        }
        super.setFrameTitle();
    }

    @Override
    protected void setEnabledState(boolean enabled) {
        this.comboSteps.setEnabled(enabled);
        this.buttonOptions.setEnabled(enabled);
        this.buttonReload.setEnabled(enabled);
        this.listDatasets.setEnabled(enabled);
        this.buttonStart.setEnabled(enabled);
        this.buttonExit.setEnabled(enabled);
        this.buttonSave.setEnabled(enabled);
        this.repaint();
    }

    private void close() {
        this.windowClosing(null);
    }

    private void start() {
        this.tabbedPane.setSelectedIndex(1);
        this.exec = new ExperimentExecutor(this);
        this.exec.start();
    }

    private void stop() {
        if (this.exec != null) {
            this.exec.stopRunning();
        }
    }

    private void save() {
        int retVal = this.fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        ProperVector lines = new ProperVector();
        lines.add(String.valueOf(this.areaOutput.getText()) + "\n");
        TextFile.save(this.fileChooser.getSelectedFile().getAbsolutePath(), lines);
    }

    private void clear() {
        this.areaOutput.setText("");
    }

    private void showOptions() {
        if (this.getSelectedAnt() == null) {
            return;
        }
        ExperimentOptions options = new ExperimentOptions((ProperFrame)this, this.getSelectedAnt());
        options.show();
    }

    private void reload() {
        int index = this.comboSteps.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.ant = new Ant(this.filenames.get(index).toString());
        this.files.put(this.comboSteps.getItemAt(index), this.ant);
        this.displayAnt();
    }

    private Ant getSelectedAnt() {
        Ant result = null;
        int index = this.comboSteps.getSelectedIndex();
        if (index > -1) {
            if (!this.files.containsKey(this.comboSteps.getItemAt(index))) {
                String filename = this.filenames.get(index).toString();
                result = new Ant(filename);
                this.files.put(this.comboSteps.getItemAt(index), result);
            }
            result = (Ant)this.files.get(this.comboSteps.getItemAt(index));
        }
        return result;
    }

    private void displayAnt() {
        this.ant = this.getSelectedAnt();
        if (this.ant != null) {
            ProperVector experiments = new ProperVector();
            Vector targets = this.ant.getTargets(new Excluder("all,init,clean"));
            int i = 0;
            while (i < targets.size()) {
                Vector tasks = this.ant.getJavaTasks((String)targets.get(i));
                if (tasks != null && tasks.size() != 0) {
                    experiments.add(targets.get(i));
                }
                ++i;
            }
            this.listDatasets.setListData(experiments);
            this.setFrameTitle();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("exit")) {
            this.close();
        } else if (action.equals(ACTION_START)) {
            this.start();
        } else if (action.equals(ACTION_STOP)) {
            this.stop();
        } else if (action.equals(ACTION_SAVE)) {
            this.save();
        } else if (action.equals(ACTION_CLEAR)) {
            this.clear();
        } else if (action.equals(ACTION_OPTIONS)) {
            this.showOptions();
        } else if (action.equals(ACTION_RELOAD)) {
            this.reload();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.listDatasets && e.getButton() == 1 && e.getClickCount() == 2 && this.listDatasets.getSelectedIndex() > -1) {
            e.consume();
            this.start();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.noChange) {
            return;
        }
        if (e.getSource() == this.comboSteps) {
            this.displayAnt();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("bla");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -filename <name>");
        System.out.println("  the name of the ANT file to extract the experiments from");
    }

    public static void main(String[] args) throws Exception {
        ExperimentFrame frame = new ExperimentFrame(null, "Test");
        frame.run(args);
    }
}

