#!/bin/bash

# This script stops JobClients via "killall java" and ssh agent.
# For ssh-agent see: http://mah.everybody.org/docs/ssh
#
# -h  displays the help
#
#
# $Revision: 1.2 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -H <host-file> [-h]"
   echo 
   echo "stops the JobClients via 'kill' and ssh-agent"
   echo "for ssh-agent see: http://mah.everybody.org/docs/ssh"
   echo
   echo " -h   this help"
   echo " -H   the name of the file containing the hostnames for the clients"
   echo "      default: $HOSTS"
   echo
}

# counts the lines of the hosts file and returns the result in TMP
function count_hosts()
{
   TMP=`cat $HOSTS | grep -v "^$\|^#" | wc -l | sed s/" "*//g`
}

# returns the specified line (in LINE) from the hosts file in TMP
function get_line()
{
   TMP=`cat $HOSTS | grep -v "^$\|^#" | head -n $LINE | tail -n 1`
}

# returns the hosts from the specified line (in LINE) from the hosts file in TMP
function get_host()
{
   get_line
   TMP=`echo $TMP | cut -f1 -d";"`
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
HOSTS="$ROOT/../tmp/clients"

# interprete parameters
while getopts ":hH:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      H) HOSTS=$OPTARG
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# stop the clients
count_hosts;COUNT=$TMP

for ((i = 1; i <= $COUNT; i++))
do
   # get host
   LINE=$i;get_host;HOST=$TMP
   
   # was it a comment?
   HOST=`echo $HOST | sed s/#.*//g`
   if [ "$HOST" = "" ]
   then
      continue
   fi
   
   # ssh
   echo $HOST
   #ssh $HOST "bash --login -ic \"kill `ps -fC java --cols 2000 | grep JobClient | cut -f2 -d\" \" & > /dev/null`\"" &
   ssh $HOST "bash --login -ic \"killall -s 9 java\"" &
done

