/*
 * Decompiled with CFR 0.152.
 */
package model.tree;

import data.catalog.Catalog;
import data.feature.SimpleFeature;
import data.instance.Instances;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import model.ModelOptions;
import model.inference.GuidedInference;
import model.inference.hc.AggregateBase;
import model.tree.DecisionTree;
import org.jdom2.Element;

public class RunnableDecisionTree
extends DecisionTree
implements Runnable {
    protected Instances train;
    protected Catalog catalog;
    protected Semaphore semaphore;
    protected CountDownLatch countdown;
    protected int index;

    public RunnableDecisionTree(ModelOptions opt, Catalog cat, Instances instsTrain, Random r, Semaphore sema, CountDownLatch cdl, int n) {
        super(opt, r);
        this.catalog = cat;
        this.train = instsTrain;
        this.semaphore = sema;
        this.countdown = cdl;
        this.index = n;
    }

    public RunnableDecisionTree(ModelOptions opt, Element el, Catalog cat) {
        super(opt, el, cat);
    }

    public RunnableDecisionTree(ModelOptions optsIndiv, Catalog cat, Instances train2, Random gr, Semaphore sem, CountDownLatch cdl, ArrayList<SimpleFeature> sfToUse, ArrayList<AggregateBase> aggsToUse, int n) {
        this(optsIndiv, cat, train2, gr, sem, cdl, n);
        this.inference = new GuidedInference(this.opts, gr, sfToUse, aggsToUse);
    }

    @Override
    public void run() {
        try {
            this.semaphore.acquire();
            this.build(this.train, this.catalog);
            this.semaphore.release();
            this.countdown.countDown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int getIndex() {
        return this.index;
    }
}

