/*
 * Decompiled with CFR 0.152.
 */
package util;

import data.feature.AggregateFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import model.NodeSplit;
import util.Couple;

public class AggregatesRanking
extends TreeMap<Double, ArrayList<Couple<AggregateFeature, NodeSplit>>>
implements Cloneable {
    private static final long serialVersionUID = 3334480469676555428L;
    private double threshold;
    private int beamSize;
    private boolean strict;

    public AggregatesRanking(double t, int b, boolean s) {
        this.threshold = t;
        this.beamSize = b;
        this.strict = s;
    }

    public AggregatesRanking(AggregatesRanking ar, double t, int b, boolean s) {
        super(ar);
        this.threshold = t;
        this.beamSize = b;
        this.strict = s;
    }

    public void insertInto(Couple<AggregateFeature, NodeSplit> toInsert) {
        boolean stop = !this.strict && toInsert.getRight().getScore() < this.threshold || this.strict && toInsert.getRight().getScore() <= this.threshold;
        boolean mustAdd = !stop;
        block0: for (Double sc : this.descendingKeySet()) {
            ArrayList list = new ArrayList((Collection)this.get(sc));
            if (stop) break;
            if (sc > toInsert.getRight().getScore()) {
                for (Couple coup : list) {
                    if (stop) continue block0;
                    if (!((AggregateFeature)coup.getLeft()).equals(toInsert.getLeft())) continue;
                    stop = true;
                    mustAdd = false;
                }
                continue;
            }
            if (sc < toInsert.getRight().getScore()) {
                for (Couple coup : list) {
                    if (stop) continue block0;
                    if (!((AggregateFeature)coup.getLeft()).equals(toInsert.getLeft())) continue;
                    ((ArrayList)this.get(sc)).remove(coup);
                    stop = true;
                }
                continue;
            }
            for (Couple coup : list) {
                if (stop) continue block0;
                if (!((AggregateFeature)coup.getLeft()).equals(toInsert.getLeft())) continue;
                stop = true;
                mustAdd = false;
            }
        }
        TreeSet keys = new TreeSet(this.keySet());
        for (Double sc : keys) {
            if (!((ArrayList)this.get(sc)).isEmpty()) continue;
            this.remove(sc);
        }
        if (mustAdd) {
            if (!this.containsKey(toInsert.getRight().getScore())) {
                this.put(toInsert.getRight().getScore(), new ArrayList());
            }
            ((ArrayList)this.get(toInsert.getRight().getScore())).add(toInsert);
        }
    }

    public void merge(TreeMap<Double, ArrayList<Couple<AggregateFeature, NodeSplit>>> bestAggregates2) {
        for (Double sc : bestAggregates2.descendingKeySet()) {
            for (Couple<AggregateFeature, NodeSplit> coup : bestAggregates2.get(sc)) {
                this.insertInto(coup);
            }
        }
    }

    public void pruneBeam() {
        int count = 0;
        AggregatesRanking bestAggregates2 = this.clone();
        for (Double score : bestAggregates2.descendingKeySet()) {
            if (count >= this.beamSize) {
                this.remove(score);
                continue;
            }
            int sizeBin = ((ArrayList)this.get(score)).size();
            if (count + sizeBin > this.beamSize) {
                Random r = new Random();
                int i = 0;
                while (i < count + sizeBin - this.beamSize) {
                    int toRemove = r.nextInt(((ArrayList)this.get(score)).size());
                    ((ArrayList)this.get(score)).remove(toRemove);
                    ++i;
                }
            }
            count += sizeBin;
        }
    }

    @Override
    public AggregatesRanking clone() {
        AggregatesRanking res = new AggregatesRanking(this, this.threshold, this.beamSize, this.strict);
        return res;
    }

    public void mergeUpper(AggregatesRanking bestAggregatesNextLevel) {
        for (Double sc : bestAggregatesNextLevel.descendingKeySet()) {
            for (Couple coup : (ArrayList)bestAggregatesNextLevel.get(sc)) {
                Couple<AggregateFeature, NodeSplit> newCoup = new Couple<AggregateFeature, NodeSplit>((AggregateFeature)((NodeSplit)coup.getRight()).getSplitCondition().getFeature(), (NodeSplit)coup.getRight());
                this.insertInto(newCoup);
            }
        }
    }
}

