/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.Application;
import proper.engine.Engine;
import proper.engine.Milk;
import proper.engine.Weka;

public class Tester
extends Application {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("classifier", "the WEKA-/MILK-Classifier's classname", true, "<classname>", false);
        this.addDefinition("additional", "additional parameters for the classifier.", true, "<add. parameters>", true);
        this.addDefinition("train", "the filename of the ARFF-file to train the classifier with", true, "<filename>", false);
        this.addDefinition("test", "the filename of the ARFF-file to test the trained classifier against", true, "<filename>", false);
    }

    @Override
    public void printDescription() {
        System.out.println("Tests a previously generated classifier, which can be a WEKA- or MILK");
        System.out.println("classifier.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        Engine engine = this.cl.getValue("classifier").startsWith("weka") ? new Weka() : new Milk();
        this.addListener(engine);
        if (!engine.getVerbose()) {
            engine.setVerbose(this.getVerbose());
        }
        String params = this.fixAdditionalArg(this.cl.getValue("additional"));
        params = String.valueOf(params) + " -T \"" + this.cl.getValue("test") + "\"";
        engine.setParameter("classifier", this.cl.getValue("classifier"));
        engine.setParameter("additional", params);
        engine.setParameter("type", "output");
        engine.setParameter("train", this.cl.getValue("train"));
        return engine.execute();
    }

    public static void main(String[] args) throws Exception {
        Tester app = new Tester();
        app.run(args);
    }
}

