/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import proper.database.Connector;
import proper.database.DatabaseLister;
import proper.gui.core.dialog.DataBaseConnectDialog;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.panel.ProperPanel;

public class DataBaseChooserPanel
extends ProperPanel
implements ActionListener {
    private ProperDialog parent;
    private Connector conn;
    private static String[][] types = new String[][]{{"PostgreSQL", "MySQL", "Oracle"}, {"org.postgresql.Driver", "org.gjt.mm.mysql.Driver", "oracle.jdbc.OracleDriver"}, {"5432", "3306", "1531"}, {"true", "false", "false"}};
    private JPanel jp_typeinfos;
    private JPanel jp_serverinfos;
    private JPanel jp_basesinfos;
    private JLabel jl_type;
    private JLabel jl_host;
    private JLabel jl_login;
    private JLabel jl_pass;
    private JLabel jl_defaultbase;
    private JLabel jl_bases;
    private JTextField jtf_host;
    private JTextField jtf_port;
    private JTextField jtf_login;
    private JPasswordField jtf_pass;
    private JTextField jtf_defaultbase;
    private JComboBox jcb_drivers;
    private JComboBox jcb_bases;
    private JButton jb_connect;

    public DataBaseChooserPanel(ProperDialog parent, Connector conn) {
        this.conn = conn;
        this.parent = parent;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jp_default = new JPanel(new FlowLayout(3));
        JPanel jp_host = new JPanel(new FlowLayout(3));
        JPanel jp_login = new JPanel(new FlowLayout(3));
        JPanel jp_pass = new JPanel(new FlowLayout(3));
        TitledBorder t1 = new TitledBorder("Database types");
        TitledBorder t2 = new TitledBorder("Server Informations");
        TitledBorder t3 = new TitledBorder("Select a database");
        this.jp_typeinfos = new JPanel(new FlowLayout(3));
        this.jp_typeinfos.setBorder(t1);
        this.jp_serverinfos = new JPanel(new GridLayout(4, 1));
        this.jp_serverinfos.setBorder(t2);
        this.jp_basesinfos = new JPanel(new FlowLayout(3));
        this.jp_basesinfos.setBorder(t3);
        this.jl_type = new JLabel("Database type : ");
        this.jl_host = new JLabel("Host : ");
        this.jl_login = new JLabel("Login : ");
        this.jl_pass = new JLabel("Password : ");
        this.jl_defaultbase = new JLabel("Default Database : ");
        this.jl_bases = new JLabel("Databases : ");
        this.jtf_host = new JTextField("", 20);
        this.jtf_port = new JTextField("", 4);
        this.jtf_login = new JTextField("", 10);
        this.jtf_pass = new JPasswordField("", 10);
        this.jtf_defaultbase = new JTextField("", 10);
        this.jcb_drivers = new JComboBox<String>(types[0]);
        this.jcb_drivers.setEditable(false);
        this.jcb_drivers.addActionListener(this);
        this.jcb_bases = new JComboBox();
        this.jcb_bases.insertItemAt("Choose...", 0);
        this.jcb_bases.setEditable(false);
        this.jcb_bases.addActionListener(this);
        this.jb_connect = new JButton("Connect", ImageLoader.getImageIcon("network.gif"));
        this.jb_connect.addActionListener(this);
        this.jp_typeinfos.add(this.jl_type);
        this.jp_typeinfos.add(this.jcb_drivers);
        jp_host.add(this.jl_host);
        jp_host.add(this.jtf_host);
        jp_host.add(this.jtf_port);
        jp_login.add(this.jl_login);
        jp_login.add(this.jtf_login);
        jp_pass.add(this.jl_pass);
        jp_pass.add(this.jtf_pass);
        jp_default.add(this.jl_defaultbase);
        jp_default.add(this.jtf_defaultbase);
        jp_default.add(this.jb_connect);
        this.jp_serverinfos.add(jp_host);
        this.jp_serverinfos.add(jp_login);
        this.jp_serverinfos.add(jp_pass);
        this.jp_serverinfos.add(jp_default);
        this.jp_basesinfos.add(this.jl_bases);
        this.jp_basesinfos.add(this.jcb_bases);
        this.add((Component)this.jp_typeinfos, "North");
        this.add((Component)this.jp_serverinfos, "Center");
        this.add((Component)this.jp_basesinfos, "South");
        this.changeType();
        this.verifyConnection();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb_connect) {
            this.newConnection();
        } else if (e.getSource() == this.jcb_drivers) {
            this.changeType();
        } else if (e.getSource() == this.jcb_bases) {
            this.changeDatabase();
        }
    }

    public void newConnection() {
        boolean connected;
        String driver = types[1][this.jcb_drivers.getSelectedIndex()];
        String url = "jdbc:" + types[0][this.jcb_drivers.getSelectedIndex()].toLowerCase() + "://" + this.jtf_host.getText().toLowerCase() + ":" + this.jtf_port.getText() + "/";
        String user = this.jtf_login.getText();
        String password = new String(this.jtf_pass.getPassword());
        String base = "";
        if (this.jtf_defaultbase.isEnabled()) {
            base = String.valueOf(base) + this.jtf_defaultbase.getText();
        }
        if (!(connected = this.conn.connect(driver, url, base, user, password))) {
            this.jcb_bases.setSelectedIndex(0);
            JOptionPane.showMessageDialog(this, "Server connection failed !", "Error", 0);
        } else {
            this.jcb_bases.setSelectedIndex(0);
            this.listedBases();
        }
        this.verifyConnection();
    }

    public void listedBases() {
        this.jcb_bases.removeAllItems();
        this.jcb_bases.addItem("Choose...");
        try {
            DatabaseLister lister = new DatabaseLister(this.conn);
            Vector list = lister.getList();
            int i = 0;
            while (i < list.size()) {
                this.jcb_bases.addItem(list.get(i).toString());
                ++i;
            }
            this.jcb_bases.setSelectedIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void verifyConnection() {
        this.jp_basesinfos.setVisible(false);
        this.jp_serverinfos.setVisible(true);
        this.jp_typeinfos.setVisible(true);
        try {
            if (this.conn.isConnected()) {
                this.jp_basesinfos.setVisible(true);
                this.jp_serverinfos.setVisible(false);
                this.jp_typeinfos.setVisible(false);
                this.jtf_pass.setText(this.conn.getPassword());
                this.listedBases();
            }
        }
        catch (Exception e) {
            System.out.println("No connection yet !");
            e.printStackTrace();
        }
        this.parent.pack();
    }

    public void changeDatabase() {
        if (this.jcb_bases.getSelectedIndex() > 0) {
            ((DataBaseConnectDialog)this.parent).changeOkButtonStatus(true);
            this.conn.setDatabase(this.jcb_bases.getSelectedItem().toString());
            this.conn.setTable("");
            this.conn.setColumn("");
            boolean connected = this.conn.connect();
            if (!connected) {
                this.jcb_bases.setSelectedIndex(0);
                JOptionPane.showMessageDialog(this, "Database connection failed !", "Error", 0);
            }
        } else {
            ((DataBaseConnectDialog)this.parent).changeOkButtonStatus(false);
        }
    }

    public void changeType() {
        String needDefaultBase = types[3][this.jcb_drivers.getSelectedIndex()];
        String defaultPort = types[2][this.jcb_drivers.getSelectedIndex()];
        if (needDefaultBase.equals("true")) {
            this.jtf_defaultbase.setEnabled(true);
        } else {
            this.jtf_defaultbase.setEnabled(false);
        }
        this.jtf_port.setText(defaultPort);
        this.jtf_login.setText("");
        this.jtf_pass.setText("");
    }
}

