/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.net.InetSocketAddress;
import proper.app.Application;
import proper.net.Data;
import proper.remote.messages.DataMessage;
import proper.remote.messages.Message;

public class JobAdder
extends Application {
    private Data sender = new Data();

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("server", "the server to retrieve jobs from", true, "<hostname/IP>", false);
        this.addDefinition("server_port", "the port to bind to, default is 31415", true, "<int>", true);
        this.addDefinition("jobs", "the file containing the jobs to send to the JobServer", true, "<filename>", false);
    }

    @Override
    public void printDescription() {
        System.out.println("A little helper for adding Jobs to an already running JobServer.");
        System.out.println();
    }

    public String getServerHostName() {
        return this.cl.getValue("server");
    }

    public int getServerPort() {
        if (this.cl.exists("server_port")) {
            return Integer.parseInt(this.cl.getValue("server_port"));
        }
        return 31415;
    }

    private boolean sendToJobServer(Message msg) {
        boolean result;
        try {
            InetSocketAddress addr = new InetSocketAddress(this.getServerHostName(), this.getServerPort());
            this.sender.send(addr, msg.toString());
            result = true;
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        return result;
    }

    @Override
    protected boolean process() throws Exception {
        DataMessage msg = new DataMessage();
        msg.setType("add_jobs");
        msg.setLines(this.cl.getValue("jobs"));
        boolean result = this.sendToJobServer(msg);
        if (result) {
            this.println("Jobs from '" + this.cl.getValue("jobs") + "' sent to " + this.getServerHostName() + ":" + this.getServerPort() + ".");
        } else {
            this.println("Couldn't send Jobs from '" + this.cl.getValue("jobs") + "' to " + this.getServerHostName() + ":" + this.getServerPort() + "!");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        JobAdder app = new JobAdder();
        app.run(args);
    }
}

