/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.io.FileReader;
import java.io.Reader;
import java.util.HashSet;
import proper.app.Application;
import proper.database.Connector;
import proper.database.Writer;
import proper.util.Excluder;
import proper.util.Includer;
import proper.util.MilkHelper;
import proper.util.WekaHelper;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.Filter;

public class ArffFilter
extends Application {
    private Includer includer;

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("input", "the ARFF file to filter through the criteria", true, "<filename>", false);
        this.addDefinition("output", "the name of the generated output - must be different from 'input' name", true, "<filename>", false);
        this.addDefinition("names", "comma separated list of patterns for names, e.g. '*bla*' deletes all\nattributes that contain the string 'bla'.", true, "<pattern-list>", false);
        this.addDefinition("multi_instance", "with this flag the first attribute, which resembles the bag ID, is exempted", false, "", true);
        this.addDefinition("filter", "the complete name of a WEKA filter", true, "<name>", true);
        this.addDefinition("filter_additiona", "additional parameters for the filter", true, "<args>", true);
        this.addDefinition("missing_binary_to_zero", "if nominal attributes were postprocessed with the NominalToBinary-Filter\nthen the missing values can be set to '0' with this option.", false, "", true);
    }

    @Override
    public void checkCommandLine() {
        super.checkCommandLine();
        if (this.cl.getValue("input").equals(this.cl.getValue("output"))) {
            this.parameterError();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Filters ARFF files, by deleting attributes based on patterns matching the");
        System.out.println("name of an attribute. Can also include WEKA filters.");
        System.out.println();
    }

    private Instances applyFilter(Instances instances) throws Exception {
        Filter filter;
        String filterName = this.cl.getValue("filter");
        String filterOptions = this.cl.getValue("filter_additional");
        if (filterName.startsWith("weka.")) {
            filter = WekaHelper.getFilterInstance(filterName);
            WekaHelper.setOptions((Object)filter, filterOptions);
        } else {
            filter = MilkHelper.getFilterInstance(filterName);
            MilkHelper.setOptions((Object)filter, filterOptions);
        }
        filter.setInputFormat(instances);
        instances = Filter.useFilter((Instances)instances, (Filter)filter);
        return instances;
    }

    private void initProcessBinaryAttributes(Instances instances) {
        String tmp = "";
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNominal()) {
                if (!tmp.equals("")) {
                    tmp = String.valueOf(tmp) + ",";
                }
                tmp = String.valueOf(tmp) + instances.attribute(i).name() + "*";
            }
            ++i;
        }
        if (this.getVerbose()) {
            this.println("Nominal attributes: " + tmp);
        }
        this.includer = new Includer(tmp, true);
    }

    private int getDistinctCount(Instances instances, int attIndex) {
        HashSet<Double> count = new HashSet<Double>();
        int i = 0;
        while (i < instances.numInstances()) {
            if (!instances.instance(i).isMissing(attIndex)) {
                count.add(new Double(instances.instance(i).value(attIndex)));
            }
            ++i;
        }
        if (this.getVerbose()) {
            this.println(count);
        }
        return count.size();
    }

    private Instances processBinaryAttributes(Instances instances) {
        boolean count = false;
        int i = 0;
        while (i < instances.numAttributes()) {
            Attribute att = instances.attribute(i);
            if (att.isNumeric() && this.includer.contains(att.name())) {
                if (this.getVerbose()) {
                    this.println("replace missing in binarized Attribute '" + att.name() + "'");
                }
                if (this.getVerbose()) {
                    this.print(att.name());
                }
                int n = 0;
                while (n < instances.numInstances()) {
                    if (instances.instance(n).isMissing(i)) {
                        instances.instance(n).setValue(i, 0.0);
                    }
                    ++n;
                }
            }
            if (i == 0) {
                this.println("Processing binary attributes...");
            } else if (i % 100 == 0) {
                this.println(String.valueOf(i) + "/" + instances.numAttributes());
            }
            ++i;
        }
        return instances;
    }

    @Override
    protected boolean process() throws Exception {
        boolean result = false;
        Instances instances = new Instances((Reader)new FileReader(this.cl.getValue("input")));
        if (instances.classIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
        }
        Excluder excluder = new Excluder(this.cl.getValue("names"));
        int start = 0;
        if (this.cl.exists("multi_instance")) {
            ++start;
        }
        int i = start;
        while (i < instances.numAttributes()) {
            if (instances.classIndex() == i) {
                ++i;
                continue;
            }
            if (excluder.contains(instances.attribute(i).name())) {
                instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
        if (this.cl.hasValue("filter")) {
            if (this.cl.exists("missing_binary_to_zero")) {
                this.initProcessBinaryAttributes(instances);
            }
            instances = this.applyFilter(instances);
            if (this.cl.exists("missing_binary_to_zero")) {
                instances = this.processBinaryAttributes(instances);
            }
        }
        Writer writer = new Writer(new Connector());
        writer.setFilename(this.cl.getValue("output"));
        writer.write(instances);
        result = true;
        return result;
    }

    public static void main(String[] args) throws Exception {
        ArffFilter app = new ArffFilter();
        app.run(args);
    }
}

