/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate.selection;

import data.aggregate.selection.SelectionWithFilters;
import data.aggregate.selection.Selector;
import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.SimpleFeature;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom2.Content;
import org.jdom2.Element;

public class PipeSelectionFilters
implements Selector {
    ArrayList<SelectionWithFilters> bricks = new ArrayList();

    public PipeSelectionFilters() {
    }

    public PipeSelectionFilters(Element psfEl, Catalog cat) {
        this();
        ArrayList selections = new ArrayList(psfEl.getChildren("selector"));
        Collections.sort(selections, new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                Integer pos1 = new Integer(e1.getAttributeValue("pos"));
                Integer pos2 = new Integer(e2.getAttributeValue("pos"));
                return pos1.compareTo(pos2);
            }
        });
        for (Element swfEl : selections) {
            this.bricks.add(new SelectionWithFilters(swfEl, cat));
        }
    }

    @Override
    public double complexity() {
        int res = 0;
        for (SelectionWithFilters swf : this.bricks) {
            res = (int)((double)res + swf.complexity());
        }
        return res;
    }

    @Override
    public Stream<Value> select(Value val, Catalog cat) {
        Stream<Value> res = Stream.of(val);
        for (SelectionWithFilters swf : this.bricks) {
            res = res.flatMap(o -> swf.select((Value)o, cat));
        }
        return res;
    }

    public Stream<Value> selectAll(Value val, Catalog cat) {
        Stream<Value> res = Stream.of(val);
        for (SelectionWithFilters swf : this.bricks) {
            res = res.flatMap(o -> swf.selectAll((Value)o, cat));
        }
        return res;
    }

    public SelectionWithFilters getLastSelection() {
        return this.bricks.get(this.bricks.size() - 1);
    }

    public PipeSelectionFilters clone() {
        PipeSelectionFilters res = new PipeSelectionFilters();
        for (SelectionWithFilters swf : this.bricks) {
            res.addToObjectSelection(swf.clone());
        }
        return res;
    }

    public void addToObjectSelection(SelectionWithFilters swf) {
        this.bricks.add(swf);
    }

    public void addToLastSelection(FilterFeature filter) {
        this.bricks.get(this.bricks.size() - 1).addFilter(filter);
    }

    public String toString() {
        String res = new String();
        int i = 0;
        while (i < this.bricks.size()) {
            String resTemp = String.valueOf(this.bricks.get(i).getSelection().toString()) + "(";
            if (!res.isEmpty()) {
                resTemp = String.valueOf(resTemp) + res + ", ";
            }
            int j = 0;
            while (j < this.bricks.get(i).getFilters().size()) {
                resTemp = String.valueOf(resTemp) + ((FilterFeature)this.bricks.get(i).getFilters().get(j)).toString();
                if (j < this.bricks.get(i).getFilters().size() - 1) {
                    resTemp = String.valueOf(resTemp) + ", ";
                }
                ++j;
            }
            res = resTemp = String.valueOf(resTemp) + ")";
            ++i;
        }
        return res;
    }

    public void removeLastFilterFromLastSelection() {
        this.bricks.get(this.bricks.size() - 1).removeLastFilter();
    }

    public void removeLastSelection() {
        this.bricks.remove(this.bricks.size() - 1);
    }

    public ArrayList<SelectionWithFilters> getSelections() {
        return this.bricks;
    }

    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> res = new HashMap<NumericShiftFunction, double[]>();
        ArrayList<Value> toUse = new ArrayList<Value>(vals);
        for (SelectionWithFilters swf : this.bricks) {
            ArrayList<Value> toUse1 = new ArrayList<Value>(toUse.stream().flatMap(o -> swf.getSelection().getLinkedElements((Value)o, cat).stream()).collect(Collectors.toList()));
            res.putAll(swf.getShifts(toUse1, cat));
            toUse = new ArrayList(toUse.stream().flatMap(o -> swf.select((Value)o, cat)).collect(Collectors.toList()));
        }
        return res;
    }

    public void applyMove(Catalog cat, ArrayList<Value> ids, SimpleFeature sf, Value val) {
        this.bricks.get(0).applyMove(cat, ids, sf, val);
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("selection");
        int i = 0;
        while (i < this.bricks.size()) {
            Element selEl = this.bricks.get(i).toXMLElement();
            selEl.setAttribute("pos", String.valueOf(i));
            el.addContent((Content)selEl);
            ++i;
        }
        return el;
    }

    public HashSet<NumericShiftFunction> getShifts() {
        HashSet<NumericShiftFunction> res = new HashSet<NumericShiftFunction>();
        for (SelectionWithFilters swf : this.bricks) {
            res.addAll(swf.getShifts());
        }
        return res;
    }

    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        ArrayList<Value> toUse = new ArrayList<Value>(vals);
        for (SelectionWithFilters swf : this.bricks) {
            toUse = new ArrayList(toUse.stream().flatMap(o -> swf.getSelection().getLinkedElements((Value)o, cat).stream()).collect(Collectors.toList()));
            swf.initShifts(toUse, cat);
        }
    }

    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        ArrayList<Value> toUse = new ArrayList<Value>(vals);
        for (SelectionWithFilters swf : this.bricks) {
            toUse = new ArrayList(toUse.stream().flatMap(o -> swf.getSelection().getLinkedElements((Value)o, cat).stream()).collect(Collectors.toList()));
            swf.deployShifts(toUse, cat);
        }
    }
}

