/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.ComplexObject;
import data.catalog.Catalog;
import data.condition.Conjunction;
import data.condition.FilterInterval;
import data.condition.FilterNominalFeature;
import data.condition.FilterNumericFeature;
import data.condition.FilterSet;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jdom2.Element;

public interface Condition
extends ComplexObject {
    public Predicate<Value> filter(Catalog var1);

    public Condition cloneCondition();

    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> var1, Catalog var2);

    public Element toXMLElement();

    public static Condition fromXML(Element condEl, Catalog cat) {
        String type = condEl.getAttributeValue("type");
        if (type.equals("numeric")) {
            return new FilterNumericFeature(condEl, cat);
        }
        if (type.equals("nominal")) {
            return new FilterNominalFeature(condEl, cat);
        }
        if (type.equals("interval")) {
            return new FilterInterval(condEl, cat);
        }
        if (type.equals("set")) {
            return new FilterSet(condEl, cat);
        }
        if (type.equals("conjunction")) {
            return new Conjunction(condEl, cat);
        }
        return null;
    }

    public void initShifts(ArrayList<Value> var1, Catalog var2);

    public void deployShifts(ArrayList<Value> var1, Catalog var2);

    public HashSet<NumericShiftFunction> getShifts();
}

