#!/bin/bash

# this scripts changes the database access parameters in the ant files
#
# $Revision: 1.1 $
# FracPete

# prints the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -D <DSN> -u <user> -p <password> -b [-h]"
   echo 
   echo "changes the database, user and password for ODBC databases in the ANT files"
   echo 
   echo " -h   this help"
   echo " -D   the filename of the ODBC database"
   echo "      default: $DATABASE"
   echo " -u   the user with which to connect to the DB"
   echo "      default: $USER"
   echo " -p   the password of the user"
   echo "      default: $PASSWORD"
   echo " -b   backup the files"
   echo 
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
XMLDIR="$ROOT/../xml"
DATABASE=demo
USER=peter
PASSWORD=peter
BACKUP=no
SCRIPT="$ROOT/change_property.sh"

# interprete parameters
while getopts ":hbD:u:p:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      D) DATABASE=$OPTARG
         ;;
      u) USER=$OPTARG
         ;;
      p) PASSWORD=$OPTARG
         ;;
      b) BACKUP=yes
         ;;
      *) usage
         exit 1
         ;;
   esac
done

if [ "$BACKUP" = "yes" ]
then
   BAK="-b"
else
   BAK=""
fi

# change the files
for i in "$ROOT/../*.xml $XMLDIR"
do
   # skip dirs
   if [ -d "$i" ]
   then
     continue
   fi

   $SCRIPT -p "driver"   -v "sun.jdbc.odbc.JdbcOdbcDriver" -d "$i" $BAK
   $SCRIPT -p "url"      -v "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=$DATABASE;DriverID=22;READONLY=false"               -d "$i" $BAK
   $SCRIPT -p "user"     -v "$USER"                        -d "$i" $BAK
   $SCRIPT -p "password" -v "$PASSWORD"                    -d "$i" $BAK
done

