/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import milk.classifiers.MIClassifier;
import milk.classifiers.MIEvaluation;
import milk.core.Exemplars;
import proper.engine.Engine;
import proper.util.MilkHelper;
import proper.util.Strings;
import weka.core.Instances;

public class Milk
extends Engine {
    public Milk() {
        this.setParameter("classifier", "milk.classifiers.MIWrapper");
        this.setParameter("additional", "=W weka.classifieres.trees.J48");
        this.setParameter("type", "output");
        this.setParameter("train", "tmp/output.arff");
        this.setParameter("instances", "");
        this.setParameter("folds", "10");
    }

    @Override
    public boolean execute() {
        super.execute();
        try {
            boolean useArff = this.valueEquals("type", "output");
            MIClassifier c = MilkHelper.getClassifierInstance(this.getStringParameter("classifier"));
            String add = "-x " + this.getStringParameter("folds") + " ";
            add = useArff ? String.valueOf(add) + "-t " + this.getStringParameter("train") + " " : "";
            add = String.valueOf(add) + this.getStringParameter("additional");
            String[] args = Strings.breakUp(add.trim(), " ", "\"");
            if (useArff) {
                this.println(MIEvaluation.evaluateModel((MIClassifier)c, (String[])args));
            } else {
                Instances instances = (Instances)this.getParameter("instances");
                MilkHelper.setOptions((Object)c, args);
                c.buildClassifier(new Exemplars(instances));
                this.println(c);
            }
            return true;
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
    }
}

