r"""
Copyright &copy; 2023 NetApp Inc.
All rights reserved.

This file has been automatically generated based on the ONTAP REST API documentation.

The suspects DELETE API clears all the suspect files for a volume from the list of potential suspects. <br/>"""

import asyncio
from datetime import datetime
import inspect
from typing import Callable, Iterable, List, Optional, Union

try:
    RECLINE_INSTALLED = False
    import recline
    from recline.arg_types.choices import Choices
    from recline.commands import ReclineCommandError
    from netapp_ontap.resource_table import ResourceTable
    RECLINE_INSTALLED = True
except ImportError:
    pass

from marshmallow import fields, EXCLUDE  # type: ignore

import netapp_ontap
from netapp_ontap.resource import Resource, ResourceSchema, ResourceSchemaMeta, ImpreciseDateTime, Size
from netapp_ontap import NetAppResponse, HostConnection
from netapp_ontap.validations import enum_validation, len_validation, integer_validation
from netapp_ontap.error import NetAppRestError


__all__ = ["AntiRansomwareSuspect", "AntiRansomwareSuspectSchema"]
__pdoc__ = {
    "AntiRansomwareSuspectSchema.resource": False,
    "AntiRansomwareSuspectSchema.opts": False,
    "AntiRansomwareSuspect.anti_ransomware_suspect_show": False,
    "AntiRansomwareSuspect.anti_ransomware_suspect_create": False,
    "AntiRansomwareSuspect.anti_ransomware_suspect_modify": False,
    "AntiRansomwareSuspect.anti_ransomware_suspect_delete": False,
}


class AntiRansomwareSuspectSchema(ResourceSchema, metaclass=ResourceSchemaMeta):
    """The fields of the AntiRansomwareSuspect object"""

    links = fields.Nested("netapp_ontap.models.self_link.SelfLinkSchema", data_key="_links", unknown=EXCLUDE)
    r""" The links field of the anti_ransomware_suspect."""

    file = fields.Nested("netapp_ontap.models.anti_ransomware_suspect_file.AntiRansomwareSuspectFileSchema", data_key="file", unknown=EXCLUDE)
    r""" The file field of the anti_ransomware_suspect."""

    is_false_positive = fields.Boolean(
        data_key="is_false_positive",
    )
    r""" Specifies whether the suspected ransomware activity is a false positive or not. This parameter is only used when making a DELETE call."""

    volume = fields.Nested("netapp_ontap.resources.volume.VolumeSchema", data_key="volume", unknown=EXCLUDE)
    r""" The volume field of the anti_ransomware_suspect."""

    @property
    def resource(self):
        return AntiRansomwareSuspect

    gettable_fields = [
        "links",
        "file",
        "is_false_positive",
        "volume.links",
        "volume.name",
        "volume.uuid",
    ]
    """links,file,is_false_positive,volume.links,volume.name,volume.uuid,"""

    patchable_fields = [
    ]
    """"""

    postable_fields = [
    ]
    """"""

def _get_field_list(field: str) -> Callable[[], List]:
    def getter():
        return [getattr(r, field) for r in AntiRansomwareSuspect.get_collection(fields=field)]
    return getter

async def _wait_for_job(response: NetAppResponse) -> None:
    """Examine the given response. If it is a job, asynchronously wait for it to
    complete. While polling, prints the current status message of the job.
    """

    if not response.is_job:
        return
    from netapp_ontap.resources import Job
    job = Job(**response.http_response.json()["job"])
    while True:
        job.get(fields="state,message")
        if hasattr(job, "message"):
            print("[%s]: %s" % (job.state, job.message))
        if job.state == "failure":
            raise NetAppRestError("AntiRansomwareSuspect modify job failed")
        if job.state == "success":
            break
        await asyncio.sleep(1)

class AntiRansomwareSuspect(Resource):
    r""" File suspected to be potentially attacked by ransomware. """

    _schema = AntiRansomwareSuspectSchema
    _path = "/api/security/anti-ransomware/suspects"
    _keys = ["volume.uuid"]

    @classmethod
    def get_collection(
        cls,
        *args,
        connection: HostConnection = None,
        max_records: int = None,
        **kwargs
    ) -> Iterable["Resource"]:
        r"""Retrieves information on the suspects generated by the anti-ransomware analytics.
### Related ONTAP commands
* `security anti-ransomware volume attack generate-report`

### Learn more
* [`DOC /security/anti-ransomware/suspects`](#docs-security-security_anti-ransomware_suspects)"""
        return super()._get_collection(*args, connection=connection, max_records=max_records, **kwargs)

    get_collection.__func__.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._get_collection.__doc__)

    if RECLINE_INSTALLED:
        @recline.command(name="anti ransomware suspect show")
        def anti_ransomware_suspect_show(
            fields: List[Choices.define(["is_false_positive", "*"])]=None,
        ) -> ResourceTable:
            """Fetch a list of AntiRansomwareSuspect resources

            Args:
                is_false_positive: Specifies whether the suspected ransomware activity is a false positive or not. This parameter is only used when making a DELETE call.
            """

            kwargs = {}
            if is_false_positive is not None:
                kwargs["is_false_positive"] = is_false_positive
            if fields is not None:
                fields = ",".join(fields)
                kwargs["fields"] = fields

            return AntiRansomwareSuspect.get_collection(
                **kwargs
            )

    @classmethod
    def count_collection(
        cls,
        *args,
        connection: HostConnection = None,
        **kwargs
    ) -> int:
        """Returns a count of all AntiRansomwareSuspect resources that match the provided query"""
        return super()._count_collection(*args, connection=connection, **kwargs)

    count_collection.__func__.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._count_collection.__doc__)



    @classmethod
    def delete_collection(
        cls,
        *args,
        records: Iterable["AntiRansomwareSuspect"] = None,
        body: Union[Resource, dict] = None,
        poll: bool = True,
        poll_interval: Optional[int] = None,
        poll_timeout: Optional[int] = None,
        connection: HostConnection = None,
        **kwargs
    ) -> NetAppResponse:
        r"""Clears either all the suspect files of a volume or suspect files of a volume based on file format or suspect time provided.
### Related ONTAP commands
* `security anti-ransomware volume attack clear-suspect`

### Learn more
* [`DOC /security/anti-ransomware/suspects/{volume.uuid}`](#docs-security-security_anti-ransomware_suspects_{volume.uuid})"""
        return super()._delete_collection(
            *args, body=body, records=records, poll=poll, poll_interval=poll_interval,
            poll_timeout=poll_timeout, connection=connection, **kwargs
        )

    delete_collection.__func__.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._delete_collection.__doc__)

    @classmethod
    def find(cls, *args, connection: HostConnection = None, **kwargs) -> Resource:
        r"""Retrieves information on the suspects generated by the anti-ransomware analytics.
### Related ONTAP commands
* `security anti-ransomware volume attack generate-report`

### Learn more
* [`DOC /security/anti-ransomware/suspects`](#docs-security-security_anti-ransomware_suspects)"""
        return super()._find(*args, connection=connection, **kwargs)

    find.__func__.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._find.__doc__)




    def delete(
        self,
        body: Union[Resource, dict] = None,
        poll: bool = True,
        poll_interval: Optional[int] = None,
        poll_timeout: Optional[int] = None,
        **kwargs
    ) -> NetAppResponse:
        r"""Clears either all the suspect files of a volume or suspect files of a volume based on file format or suspect time provided.
### Related ONTAP commands
* `security anti-ransomware volume attack clear-suspect`

### Learn more
* [`DOC /security/anti-ransomware/suspects/{volume.uuid}`](#docs-security-security_anti-ransomware_suspects_{volume.uuid})"""
        return super()._delete(
            body=body, poll=poll, poll_interval=poll_interval,
            poll_timeout=poll_timeout, **kwargs
        )

    delete.__doc__ += "\n\n---\n" + inspect.cleandoc(Resource._delete.__doc__)

    if RECLINE_INSTALLED:
        @recline.command(name="anti ransomware suspect delete")
        async def anti_ransomware_suspect_delete(
        ) -> None:
            """Delete an instance of a AntiRansomwareSuspect resource

            Args:
                is_false_positive: Specifies whether the suspected ransomware activity is a false positive or not. This parameter is only used when making a DELETE call.
            """

            kwargs = {}
            if is_false_positive is not None:
                kwargs["is_false_positive"] = is_false_positive

            if hasattr(AntiRansomwareSuspect, "find"):
                resource = AntiRansomwareSuspect.find(
                    **kwargs
                )
            else:
                resource = AntiRansomwareSuspect()
            try:
                response = resource.delete(poll=False)
                await _wait_for_job(response)
            except NetAppRestError as err:
                raise ReclineCommandError("Unable to delete AntiRansomwareSuspect: %s" % err)


