/*
 * Decompiled with CFR 0.152.
 */
package corenlp.rdrsegmenter;

import corenlp.rdrsegmenter.FWObject;
import corenlp.rdrsegmenter.WordTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static Map<String, String> NORMALIZER = new HashMap<String, String>();

    public static FWObject getCondition(String strCondition) {
        FWObject condition = new FWObject(false);
        for (String rule : strCondition.split(" and ")) {
            rule = rule.trim();
            String key = rule.substring(rule.indexOf(".") + 1, rule.indexOf(" "));
            String value = Utils.getConcreteValue(rule);
            if (key.equals("prevWord2")) {
                condition.getContext()[4] = value;
                continue;
            }
            if (key.equals("prevTag2")) {
                condition.getContext()[5] = value;
                continue;
            }
            if (key.equals("prevWord1")) {
                condition.getContext()[2] = value;
                continue;
            }
            if (key.equals("prevTag1")) {
                condition.getContext()[3] = value;
                continue;
            }
            if (key.equals("word")) {
                condition.getContext()[1] = value;
                continue;
            }
            if (key.equals("tag")) {
                condition.getContext()[0] = value;
                continue;
            }
            if (key.equals("nextWord1")) {
                condition.getContext()[6] = value;
                continue;
            }
            if (key.equals("nextTag1")) {
                condition.getContext()[7] = value;
                continue;
            }
            if (key.equals("nextWord2")) {
                condition.getContext()[8] = value;
                continue;
            }
            if (!key.equals("nextTag2")) continue;
            condition.getContext()[9] = value;
        }
        return condition;
    }

    public static FWObject getObject(List<WordTag> wordTags, int size, int index) {
        FWObject object = new FWObject(true);
        if (index > 1) {
            object.getContext()[4] = wordTags.get((int)(index - 2)).word;
            object.getContext()[5] = wordTags.get((int)(index - 2)).tag;
        }
        if (index > 0) {
            object.getContext()[2] = wordTags.get((int)(index - 1)).word;
            object.getContext()[3] = wordTags.get((int)(index - 1)).tag;
        }
        String currentWord = wordTags.get((int)index).word;
        String currentTag = wordTags.get((int)index).tag;
        object.getContext()[1] = currentWord;
        object.getContext()[0] = currentTag;
        if (index < size - 1) {
            object.getContext()[6] = wordTags.get((int)(index + 1)).word;
            object.getContext()[7] = wordTags.get((int)(index + 1)).tag;
        }
        if (index < size - 2) {
            object.getContext()[8] = wordTags.get((int)(index + 2)).word;
            object.getContext()[9] = wordTags.get((int)(index + 2)).tag;
        }
        return object;
    }

    public static String getConcreteValue(String str) {
        if (str.contains("\"\"")) {
            if (str.contains("Word")) {
                return "<W>";
            }
            return "<T>";
        }
        String conclusion = str.substring(str.indexOf("\"") + 1, str.length() - 1);
        return conclusion;
    }

    static {
        NORMALIZER.put("\u00f2a", "o\u00e0");
        NORMALIZER.put("\u00f3a", "o\u00e1");
        NORMALIZER.put("\u1ecfa", "o\u1ea3");
        NORMALIZER.put("\u00f5a", "o\u00e3");
        NORMALIZER.put("\u1ecda", "o\u1ea1");
        NORMALIZER.put("\u00f2e", "o\u00e8");
        NORMALIZER.put("\u00f3e", "o\u00e9");
        NORMALIZER.put("\u1ecfe", "o\u1ebb");
        NORMALIZER.put("\u00f5e", "o\u1ebd");
        NORMALIZER.put("\u1ecde", "o\u1eb9");
        NORMALIZER.put("\u00f9y", "u\u1ef3");
        NORMALIZER.put("\u00fay", "u\u00fd");
        NORMALIZER.put("\u1ee7y", "u\u1ef7");
        NORMALIZER.put("\u0169y", "u\u1ef9");
        NORMALIZER.put("\u1ee5y", "u\u1ef5");
        NORMALIZER.put("\u1ee6y", "U\u1ef7");
    }
}

