# redis-orm

## **Python Redis ORM, turns redis to a fully functional in-memory database, inspired by Django ORM**

For one project, I needed to work with redis, but redis-py provides a minimum level of work with redis. I didn't find any Django-like ORM for redis, so I wrote this library, then there will be a port to Django.

### Working with this library, you are expected:

- Fully works in 2021
- Django-like architecture
- Easy adaptation to your needs
- Adequate informational messages and error messages
- Built-in RedisModel class
- 6 built-in types of fields:
    - RedisField - base class for nesting
    - RedisString - string
    - RedisNumber - int or float
    - RedisId - instances IDs
    - RedisDatetime - for work with date and time, via python datetime
    - RedisForeignKey - for links to other redis models
- All fields supports:
    - Automatically serialization and deserialization
    - TTL (Time To Live)
    - Default values
    - Providing functions to default values
    - Allow null values setting
    - Choices
- Extras:
    - Ignore deserialization errors setting - do not raise errors, while deserealizing data
    - Save consistency setting - show structure-first data


# Installation
`pip install python-redis-orm`

[Here is PyPi](https://pypi.org/project/python-redis-orm/)


# Usage
