"""Redux-like state management for Python."""

from .basic_types import (
    AutorunDecorator,
    AutorunOptions,
    AutorunReturnType,
    BaseAction,
    BaseCombineReducerState,
    BaseEvent,
    CombineReducerAction,
    CombineReducerInitAction,
    CombineReducerRegisterAction,
    CombineReducerUnregisterAction,
    CompleteReducerResult,
    Dispatch,
    DispatchParameters,
    EventSubscriber,
    FinishAction,
    FinishEvent,
    InitAction,
    InitializationActionError,
    ReducerResult,
    ReducerType,
    Scheduler,
    StoreOptions,
    ViewDecorator,
    ViewOptions,
    ViewReturnType,
    is_complete_reducer_result,
    is_state_reducer_result,
)
from .combine_reducers import combine_reducers
from .main import Store

__all__ = (
    'AutorunDecorator',
    'AutorunOptions',
    'AutorunReturnType',
    'BaseAction',
    'BaseCombineReducerState',
    'BaseEvent',
    'CombineReducerAction',
    'CombineReducerInitAction',
    'CombineReducerRegisterAction',
    'CombineReducerUnregisterAction',
    'CompleteReducerResult',
    'Dispatch',
    'DispatchParameters',
    'EventSubscriber',
    'FinishAction',
    'FinishEvent',
    'InitAction',
    'InitializationActionError',
    'ReducerResult',
    'ReducerType',
    'Scheduler',
    'Store',
    'StoreOptions',
    'ViewDecorator',
    'ViewOptions',
    'ViewReturnType',
    'combine_reducers',
    'is_complete_reducer_result',
    'is_state_reducer_result',
)
