/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;

@RunWith(value=Parameterized.class)
public class PythonRestClientCodegenTest {
    private final String filePath;
    private final String yamlName;

    @Parameterized.Parameters(name="{index} : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"test/resources/petStore", "petstore"}, {"test/resources/codeWithInheritance", "openapi"}, {"test/resources/enumPathParam", "openapi"}, {"test/resources/simpleCode", "openapi"}, {"test/resources/apiKey", "openapi"}, {"test/resources/arrayOfReferencedEnum", "openapi"}, {"test/resources/multipleOneOfWithDiscriminator", "openapi"}, {"test/resources/nullableRef", "openapi"}, {"test/resources/oneOfWithDiscriminator", "openapi"}, {"test/resources/orderedTags", "openapi"}, {"test/resources/xRestrict", "openapi"}, {"test/resources/productApi", "product"});
    }

    public PythonRestClientCodegenTest(String filePath, String yamlName) {
        this.filePath = filePath;
        this.yamlName = yamlName;
    }

    @Test
    public void generateCodegen() throws IOException {
        File tempDirectory = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        Path outputPath = Files.createDirectory(tempDirectory.toPath().resolve("myModule"), new FileAttribute[0]);
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("hideGenerationTimestamp", true);
        Path inputPath = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath().getParent().getParent().toAbsolutePath();
        boolean setupTestResults = false;
        if (setupTestResults) {
            outputPath = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath().getParent().resolve("src/" + this.filePath);
        }
        CodegenConfigurator configurator = new CodegenConfigurator().setGeneratorName("python-rest-client-codegen").setPackageName("gen.client").setApiPackage("controllers").setAdditionalProperties(properties).setInputSpec(inputPath.toString() + "/" + this.filePath + "/" + this.yamlName + ".yaml").setOutputDir(outputPath.toString().replace("\\", "/"));
        DefaultGenerator generator = new DefaultGenerator();
        ClientOptInput clientOptInput = configurator.toClientOptInput();
        generator.setGenerateMetadata(Boolean.valueOf(false));
        generator.opts(clientOptInput).generate();
        Path expectedContent = Paths.get("src/" + this.filePath, new String[0]);
        Files.createDirectories(expectedContent, new FileAttribute[0]);
        Assert.assertTrue((String)("Generated code and expected one are not similar. Look : " + outputPath.toString()), (boolean)DirectoryUtils.isEqual(expectedContent, outputPath, true));
    }
}

