# coding: utf-8

"""
    LCDP REST API

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime, timezone
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Notification(BaseModel):
    """
    Notification
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Notification type")
    readable_name: Optional[StrictStr] = Field(default=None, description="Human readable name", alias="readableName")
    subject: Optional[StrictStr] = None
    content: Optional[StrictStr] = None
    notification_sendings: Optional[List[NotificationSending]] = Field(default=None, alias="notificationSendings")
    __properties: ClassVar[List[str]] = ["name", "readableName", "subject", "content", "notificationSendings"]

    @field_validator('name')
    def name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ORDER_CREATED_SELLER', 'ORDER_CREATED_BUYER', 'ORDER_ACCEPTED', 'ORDER_SENT_BUYER', 'ORDER_RECEIVED', 'ORDER_ARCHIVED_BUYER', 'ORDER_VALIDATED_SELLER', 'ORDER_VALIDATED_BUYER', 'ORDER_CANCELED_BUYER', 'AD_ARCHIVED', 'AD_ARCHIVED_BY_ADMIN', 'AD_VALIDATED', 'AD_EXPIRED', 'AD_MANIFESTATION_INTERET', 'AD_SOLD_OUT', 'AD_PRICE_UPDATE_REFUSED', 'AD_PRICE_UPDATE_ACCEPTED', 'AD_WISHLIST_LINE', 'ORDER_ACCEPTATION_DELAY', 'ORDER_SENDING_DELAY', 'CLIENT_SUBSCRIPTION_STEP_4_VALIDATED', 'CLIENT_SUBSCRIPTION_VALIDATED', 'CLIENT_TEST_ACCOUNT_EXPIRED', 'CLIENT_KYC_LIMITED', 'CLIENT_CREDIT_CARD_EXPIRATION', 'CLIENT_FIRST_SALE', 'CLIENT_FIRST_BUY', 'CLIENT_FIRST_AD', 'DAILY_MAIL', 'AD_DAILY_MAIL', 'ORDER_DAILY_MAIL', 'ORDER_TWICE_DAILY_MAIL', 'CLIENT_HAS_A_REQUEST', 'DOCUMENT_EXPIRE', 'GLOBAL_COMMISSION_INVOICE', 'PHARMAIDE_FIRST_SUBSCRIPTION', 'PHARMAIDE_TEST_TEST_EXPIRATION', 'PHARMAIDE_SB_TEST_EXPIRATION']):
            raise ValueError("must be one of enum values ('ORDER_CREATED_SELLER', 'ORDER_CREATED_BUYER', 'ORDER_ACCEPTED', 'ORDER_SENT_BUYER', 'ORDER_RECEIVED', 'ORDER_ARCHIVED_BUYER', 'ORDER_VALIDATED_SELLER', 'ORDER_VALIDATED_BUYER', 'ORDER_CANCELED_BUYER', 'AD_ARCHIVED', 'AD_ARCHIVED_BY_ADMIN', 'AD_VALIDATED', 'AD_EXPIRED', 'AD_MANIFESTATION_INTERET', 'AD_SOLD_OUT', 'AD_PRICE_UPDATE_REFUSED', 'AD_PRICE_UPDATE_ACCEPTED', 'AD_WISHLIST_LINE', 'ORDER_ACCEPTATION_DELAY', 'ORDER_SENDING_DELAY', 'CLIENT_SUBSCRIPTION_STEP_4_VALIDATED', 'CLIENT_SUBSCRIPTION_VALIDATED', 'CLIENT_TEST_ACCOUNT_EXPIRED', 'CLIENT_KYC_LIMITED', 'CLIENT_CREDIT_CARD_EXPIRATION', 'CLIENT_FIRST_SALE', 'CLIENT_FIRST_BUY', 'CLIENT_FIRST_AD', 'DAILY_MAIL', 'AD_DAILY_MAIL', 'ORDER_DAILY_MAIL', 'ORDER_TWICE_DAILY_MAIL', 'CLIENT_HAS_A_REQUEST', 'DOCUMENT_EXPIRE', 'GLOBAL_COMMISSION_INVOICE', 'PHARMAIDE_FIRST_SUBSCRIPTION', 'PHARMAIDE_TEST_TEST_EXPIRATION', 'PHARMAIDE_SB_TEST_EXPIRATION')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        json_encoders={
            datetime: lambda dt: dt.isoformat(timespec='milliseconds')
        }
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Notification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in notification_sendings (list)
        _items = []
        if self.notification_sendings:
            for _item_notification_sendings in self.notification_sendings:
                if _item_notification_sendings:
                    _items.append(_item_notification_sendings.to_dict())
            _dict['notificationSendings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Notification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "readableName": obj.get("readableName"),
            "subject": obj.get("subject"),
            "content": obj.get("content"),
            "notificationSendings": [NotificationSending.from_dict(_item) for _item in obj["notificationSendings"]] if obj.get("notificationSendings") is not None else None
        })
        return _obj

from gen.client.models.notification_sending import NotificationSending
# TODO: Rewrite to not use raise_errors
Notification.model_rebuild(raise_errors=False)

