# coding: utf-8

"""
    LCDP REST API

    This is the REST API of RFx (Request For X)

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import os
from gen.client.configuration import Configuration

class ConfigurationBuilder:
    """NOTE: This class is auto generated by OpenAPI Generator
        Do not edit the class manually.

        :param base_path: Base path of the client
        :param host: Host of the client
        :param service_name: Client service name
        :param is_secured:

        :Example:
        """

    def __init__(self,
                 service_name="service",
                 base_path="api/v1",
                 host="localhost",
                 is_secured=False,
                 access_token=None,
                 **kwargs):
        """Constructor
        """
        self.base_path = base_path
        """Server app base path
        """
        self.host = host
        """Server host
        """
        self.service_name = service_name
        """Upstream env var name
        """
        self.is_secured = is_secured
        """ Is host url http or https
        """
        self.access_token = access_token
        """access token for OAuth/Bearer
        """

        self.kwargs = kwargs

    def build_configuration_from_upstream(self):
        """Build an api configuration from path
        :return: build configuration
        """
        configuration = Configuration(**self.kwargs)
        configuration.host = self.get_host_from_upstream_and_path()
        configuration.access_token = self.access_token
        return configuration

    def get_host_from_upstream_and_path(self):
        """ Get api url from docker env upstream and path.
        :return: apr url
        """

        port = self.get_port_from_upstream()

        port_in_url = "" if not port else ":{}".format(port)

        protocol = "https" if self.is_secured else "http"

        host_url = "{}://{}{}/{}".format(protocol, self.host, port_in_url, self.base_path)

        return host_url

    def get_port_from_upstream(self):
        """ Get port from docker upstream
        :return: port from docker upstream, none if not found
        """

        port = ""

        upstreams_var = os.getenv("SERVICE_UPSTREAMS")
        if upstreams_var:
            upstreams = upstreams_var.split(";")
            for upstream in upstreams:
                if self.service_name in upstream:
                    port = upstream.split(":")[-1]

        return port