# coding: utf-8

"""
    title

    This is the REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from gen.client.models.mode_b import ModeB
from gen.client.models.mode_c import ModeC
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ANYIDENTIFIEDMODE_ONE_OF_SCHEMAS = ["ModeB", "ModeC"]

class AnyIdentifiedMode(BaseModel):
    """
    AnyIdentifiedMode
    """
    # data type: ModeC
    oneof_schema_1_validator: Optional[ModeC] = None
    # data type: ModeB
    oneof_schema_2_validator: Optional[ModeB] = None
    actual_instance: Optional[Union[ModeB, ModeC]] = None
    one_of_schemas: Set[str] = { "ModeB", "ModeC" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AnyIdentifiedMode.model_construct()
        error_messages = []
        match = 0
        # validate data type: ModeC
        if not isinstance(v, ModeC):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ModeC`")
        else:
            match += 1
        # validate data type: ModeB
        if not isinstance(v, ModeB):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ModeB`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AnyIdentifiedMode with oneOf schemas: ModeB, ModeC. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AnyIdentifiedMode with oneOf schemas: ModeB, ModeC. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("distributionType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `distributionType` in the input.")

        # check if data type is `ModeC`
        if _data_type == "A":
            instance.actual_instance = ModeC.from_json(json_str)
            return instance

        # check if data type is `ModeB`
        if _data_type == "B":
            instance.actual_instance = ModeB.from_json(json_str)
            return instance

        # check if data type is `ModeB`
        if _data_type == "ModeB":
            instance.actual_instance = ModeB.from_json(json_str)
            return instance

        # check if data type is `ModeC`
        if _data_type == "ModeC":
            instance.actual_instance = ModeC.from_json(json_str)
            return instance

        # deserialize data into ModeC
        try:
            instance.actual_instance = ModeC.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ModeB
        try:
            instance.actual_instance = ModeB.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AnyIdentifiedMode with oneOf schemas: ModeB, ModeC. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AnyIdentifiedMode with oneOf schemas: ModeB, ModeC. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ModeB, ModeC]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


