# coding: utf-8

"""
    lcdp-monolith-service

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime, timezone
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ImageVersions(BaseModel):
    """
    ImageVersions
    """ # noqa: E501
    xsmall: Optional[StrictStr] = Field(default=None, description="URI to S3 file (width 100px, height computed with original image aspect ratio)")
    small: Optional[StrictStr] = Field(default=None, description="URI to S3 file (width 350px, height computed with original image aspect ratio)")
    medium: Optional[StrictStr] = Field(default=None, description="URI to S3 file (width 1024px, height computed with original image aspect ratio)")
    large: Optional[StrictStr] = Field(default=None, description="URI to S3 file (width 1920px, height computed with original image aspect ratio)")
    xlarge: Optional[StrictStr] = Field(default=None, description="URI to S3 file (width 3840px, height computed with original image aspect ratio)")
    original: Optional[StrictStr] = Field(default=None, description="URI to S3 file (Original size)")
    __properties: ClassVar[List[str]] = ["xsmall", "small", "medium", "large", "xlarge", "original"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        json_encoders={
            datetime: lambda dt: dt.isoformat(timespec='milliseconds')
        }
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageVersions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageVersions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "xsmall": obj.get("xsmall"),
            "small": obj.get("small"),
            "medium": obj.get("medium"),
            "large": obj.get("large"),
            "xlarge": obj.get("xlarge"),
            "original": obj.get("original")
        })
        return _obj


