# coding: utf-8

"""
    lcdp-monolith-service

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from gen.client.models.paginated_products import PaginatedProducts
from gen.client.models.product import Product
from gen.client.models.product_status import ProductStatus

from gen.client.api_client import ApiClient, RequestSerialized
from gen.client.api_response import ApiResponse
from gen.client.rest import RESTResponseType


class SearchProductApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_product(
        self,
        product_id: Annotated[StrictInt, Field(description="The id of the product concerned by the request")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Product:
        """Retrieve a product with ID


        :param product_id: The id of the product concerned by the request (required)
        :type product_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_product_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Product",
            '400': "RestError",
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_product_with_http_info(
        self,
        product_id: Annotated[StrictInt, Field(description="The id of the product concerned by the request")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Product]:
        """Retrieve a product with ID


        :param product_id: The id of the product concerned by the request (required)
        :type product_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_product_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Product",
            '400': "RestError",
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_product_without_preload_content(
        self,
        product_id: Annotated[StrictInt, Field(description="The id of the product concerned by the request")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a product with ID


        :param product_id: The id of the product concerned by the request (required)
        :type product_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_product_serialize(
            product_id=product_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Product",
            '400': "RestError",
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_product_serialize(
        self,
        product_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if product_id is not None:
            _path_params['productId'] = product_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/products/{productId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_products(
        self,
        q: Annotated[Optional[StrictStr], Field(description="Any field in the product contains 'q'")] = None,
        vidal_package_eq: Annotated[Optional[StrictInt], Field(description="Vidal package equal this one")] = None,
        st_eq: Annotated[Optional[List[ProductStatus]], Field(description="Filter on status to include in the search (can be given multiple time which result in a OR condition)")] = None,
        pt_eq: Annotated[Optional[StrictStr], Field(description="Product type to search on")] = None,
        spt_eq: Annotated[Optional[StrictStr], Field(description="Secondary product type to search on")] = None,
        lab_eq: Annotated[Optional[List[StrictInt]], Field(description="Laboratory to search on (can be given multiple time which result in a OR condition)")] = None,
        s_waiting_sale_offer_count_gte: Annotated[Optional[StrictInt], Field(description="Waiting sale offers count greater than or equal")] = None,
        order_by: Annotated[Optional[StrictStr], Field(description="Sort by")] = None,
        p: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Page number to search for (start at 0)")] = None,
        pp: Annotated[Optional[Annotated[int, Field(le=50, strict=True, ge=1)]], Field(description="Number of user per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedProducts:
        """Search for products with his name or status


        :param q: Any field in the product contains 'q'
        :type q: str
        :param vidal_package_eq: Vidal package equal this one
        :type vidal_package_eq: int
        :param st_eq: Filter on status to include in the search (can be given multiple time which result in a OR condition)
        :type st_eq: List[ProductStatus]
        :param pt_eq: Product type to search on
        :type pt_eq: str
        :param spt_eq: Secondary product type to search on
        :type spt_eq: str
        :param lab_eq: Laboratory to search on (can be given multiple time which result in a OR condition)
        :type lab_eq: List[int]
        :param s_waiting_sale_offer_count_gte: Waiting sale offers count greater than or equal
        :type s_waiting_sale_offer_count_gte: int
        :param order_by: Sort by
        :type order_by: str
        :param p: Page number to search for (start at 0)
        :type p: int
        :param pp: Number of user per page
        :type pp: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_products_serialize(
            q=q,
            vidal_package_eq=vidal_package_eq,
            st_eq=st_eq,
            pt_eq=pt_eq,
            spt_eq=spt_eq,
            lab_eq=lab_eq,
            s_waiting_sale_offer_count_gte=s_waiting_sale_offer_count_gte,
            order_by=order_by,
            p=p,
            pp=pp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProducts",
            '403': None,
            '4XX': "RestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_products_with_http_info(
        self,
        q: Annotated[Optional[StrictStr], Field(description="Any field in the product contains 'q'")] = None,
        vidal_package_eq: Annotated[Optional[StrictInt], Field(description="Vidal package equal this one")] = None,
        st_eq: Annotated[Optional[List[ProductStatus]], Field(description="Filter on status to include in the search (can be given multiple time which result in a OR condition)")] = None,
        pt_eq: Annotated[Optional[StrictStr], Field(description="Product type to search on")] = None,
        spt_eq: Annotated[Optional[StrictStr], Field(description="Secondary product type to search on")] = None,
        lab_eq: Annotated[Optional[List[StrictInt]], Field(description="Laboratory to search on (can be given multiple time which result in a OR condition)")] = None,
        s_waiting_sale_offer_count_gte: Annotated[Optional[StrictInt], Field(description="Waiting sale offers count greater than or equal")] = None,
        order_by: Annotated[Optional[StrictStr], Field(description="Sort by")] = None,
        p: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Page number to search for (start at 0)")] = None,
        pp: Annotated[Optional[Annotated[int, Field(le=50, strict=True, ge=1)]], Field(description="Number of user per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedProducts]:
        """Search for products with his name or status


        :param q: Any field in the product contains 'q'
        :type q: str
        :param vidal_package_eq: Vidal package equal this one
        :type vidal_package_eq: int
        :param st_eq: Filter on status to include in the search (can be given multiple time which result in a OR condition)
        :type st_eq: List[ProductStatus]
        :param pt_eq: Product type to search on
        :type pt_eq: str
        :param spt_eq: Secondary product type to search on
        :type spt_eq: str
        :param lab_eq: Laboratory to search on (can be given multiple time which result in a OR condition)
        :type lab_eq: List[int]
        :param s_waiting_sale_offer_count_gte: Waiting sale offers count greater than or equal
        :type s_waiting_sale_offer_count_gte: int
        :param order_by: Sort by
        :type order_by: str
        :param p: Page number to search for (start at 0)
        :type p: int
        :param pp: Number of user per page
        :type pp: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_products_serialize(
            q=q,
            vidal_package_eq=vidal_package_eq,
            st_eq=st_eq,
            pt_eq=pt_eq,
            spt_eq=spt_eq,
            lab_eq=lab_eq,
            s_waiting_sale_offer_count_gte=s_waiting_sale_offer_count_gte,
            order_by=order_by,
            p=p,
            pp=pp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProducts",
            '403': None,
            '4XX': "RestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_products_without_preload_content(
        self,
        q: Annotated[Optional[StrictStr], Field(description="Any field in the product contains 'q'")] = None,
        vidal_package_eq: Annotated[Optional[StrictInt], Field(description="Vidal package equal this one")] = None,
        st_eq: Annotated[Optional[List[ProductStatus]], Field(description="Filter on status to include in the search (can be given multiple time which result in a OR condition)")] = None,
        pt_eq: Annotated[Optional[StrictStr], Field(description="Product type to search on")] = None,
        spt_eq: Annotated[Optional[StrictStr], Field(description="Secondary product type to search on")] = None,
        lab_eq: Annotated[Optional[List[StrictInt]], Field(description="Laboratory to search on (can be given multiple time which result in a OR condition)")] = None,
        s_waiting_sale_offer_count_gte: Annotated[Optional[StrictInt], Field(description="Waiting sale offers count greater than or equal")] = None,
        order_by: Annotated[Optional[StrictStr], Field(description="Sort by")] = None,
        p: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Page number to search for (start at 0)")] = None,
        pp: Annotated[Optional[Annotated[int, Field(le=50, strict=True, ge=1)]], Field(description="Number of user per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search for products with his name or status


        :param q: Any field in the product contains 'q'
        :type q: str
        :param vidal_package_eq: Vidal package equal this one
        :type vidal_package_eq: int
        :param st_eq: Filter on status to include in the search (can be given multiple time which result in a OR condition)
        :type st_eq: List[ProductStatus]
        :param pt_eq: Product type to search on
        :type pt_eq: str
        :param spt_eq: Secondary product type to search on
        :type spt_eq: str
        :param lab_eq: Laboratory to search on (can be given multiple time which result in a OR condition)
        :type lab_eq: List[int]
        :param s_waiting_sale_offer_count_gte: Waiting sale offers count greater than or equal
        :type s_waiting_sale_offer_count_gte: int
        :param order_by: Sort by
        :type order_by: str
        :param p: Page number to search for (start at 0)
        :type p: int
        :param pp: Number of user per page
        :type pp: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_products_serialize(
            q=q,
            vidal_package_eq=vidal_package_eq,
            st_eq=st_eq,
            pt_eq=pt_eq,
            spt_eq=spt_eq,
            lab_eq=lab_eq,
            s_waiting_sale_offer_count_gte=s_waiting_sale_offer_count_gte,
            order_by=order_by,
            p=p,
            pp=pp,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProducts",
            '403': None,
            '4XX': "RestError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_products_serialize(
        self,
        q,
        vidal_package_eq,
        st_eq,
        pt_eq,
        spt_eq,
        lab_eq,
        s_waiting_sale_offer_count_gte,
        order_by,
        p,
        pp,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'st[eq]': 'multi',
            'lab[eq]': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if q is not None:
            
            _query_params.append(('q', q))
            
        if vidal_package_eq is not None:
            
            _query_params.append(('vidalPackage[eq]', vidal_package_eq))
            
        if st_eq is not None:
            
            _query_params.append(('st[eq]', st_eq))
            
        if pt_eq is not None:
            
            _query_params.append(('pt[eq]', pt_eq))
            
        if spt_eq is not None:
            
            _query_params.append(('spt[eq]', spt_eq))
            
        if lab_eq is not None:
            
            _query_params.append(('lab[eq]', lab_eq))
            
        if s_waiting_sale_offer_count_gte is not None:
            
            _query_params.append(('sWaitingSaleOfferCount[gte]', s_waiting_sale_offer_count_gte))
            
        if order_by is not None:
            
            _query_params.append(('orderBy', order_by))
            
        if p is not None:
            
            _query_params.append(('p', p))
            
        if pp is not None:
            
            _query_params.append(('pp', pp))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/products',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def test_free_access(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Test generation without bearer


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._test_free_access_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def test_free_access_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Test generation without bearer


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._test_free_access_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def test_free_access_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Test generation without bearer


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._test_free_access_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _test_free_access_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/products/testFreeAccess',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


