/*
 * Decompiled with CFR 0.152.
 */
package fr.lcdp.codegen;

import java.io.File;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PythonClientCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonRestClientCodegen
extends PythonClientCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PythonRestClientCodegen.class);
    public static final String API_DOC_PATH = "apiDocPath";
    public static final String MODEL_DOC_PATH = "modelDocPath";

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "python-rest-client-codegen";
    }

    public String getHelp() {
        return "Generates a python-lcdp-client.";
    }

    public void preProcessOpts() {
        this.additionalProperties.put("generateSourceCodeOnly", "true");
        if (!this.additionalProperties.containsKey(API_DOC_PATH)) {
            this.additionalProperties.put(API_DOC_PATH, "/docs");
        }
        this.apiDocPath = this.additionalProperties.get(API_DOC_PATH).toString();
        if (!this.additionalProperties.containsKey(MODEL_DOC_PATH)) {
            this.additionalProperties.put(MODEL_DOC_PATH, "/docs");
        }
        this.modelDocPath = this.additionalProperties.get(MODEL_DOC_PATH).toString();
    }

    public void processOpts() {
        this.preProcessOpts();
        this.setUseOneOfDiscriminatorLookup(true);
        super.processOpts();
        this.removeSupportingFile("gitlab-ci.mustache");
        this.removeSupportingFile("README_onlypackage.mustache");
        this.supportingFiles.add(new SupportingFile("lcdp/configuration_builder.mustache", this.packagePath(), "configuration_builder.py"));
        this.supportingFiles.add(new SupportingFile("lcdp/api_client_utils.mustache", this.packagePath(), "api_client_utils.py"));
        String apiPath = this.apiPackage.replace('.', File.separatorChar);
        this.removeSupportingFile("__init__api.mustache");
        this.supportingFiles.add(new SupportingFile("lcdp/__init__api.mustache", apiPath, "__init__.py"));
        this.removeSupportingFile("__init__package.mustache");
        this.supportingFiles.add(new SupportingFile("lcdp/__init__package.mustache", this.packagePath(), "__init__.py"));
        this.modelTemplateFiles.remove("model.mustache");
        this.modelTemplateFiles.put("lcdp/model.mustache", ".py");
        this.removeSupportingFile("api_client.mustache");
        this.supportingFiles.add(new SupportingFile("lcdp/api_client.mustache", this.packagePath(), "api_client.py"));
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.put("lcdp/api.mustache", ".py");
    }

    private void removeSupportingFile(String templateName) {
        this.supportingFiles.removeIf(supportingFile -> supportingFile.getTemplateFile().equals(templateName));
    }
}

