/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class DirectoryUtils {
    public static boolean isEqual(Path directory, Path compareDirectory, boolean checkFileContent) throws IOException {
        boolean check = DirectoryUtils.isEverythingInCompareDirectory(directory, compareDirectory, checkFileContent);
        boolean checkOppositeFileContent = false;
        boolean checkOpposite = check && DirectoryUtils.isEverythingInCompareDirectory(compareDirectory, directory, checkOppositeFileContent);
        return check && checkOpposite;
    }

    private static boolean isEverythingInCompareDirectory(Path directory, Path compareDirectory, boolean checkFileContent) throws IOException {
        if (directory != null && compareDirectory != null) {
            File directoryFile = directory.toFile();
            File compareFile = compareDirectory.toFile();
            File[] directoryFiles = directoryFile.listFiles();
            File[] compareFiles = compareFile.listFiles();
            if (directoryFiles != null && compareFiles != null) {
                if (directoryFiles.length == compareFiles.length) {
                    return DirectoryUtils.compareDirectoryContents(directory, compareDirectory, checkFileContent);
                }
                return false;
            }
            return DirectoryUtils.checkForNulls(directoryFiles, compareFiles);
        }
        return DirectoryUtils.checkForNulls(directory, compareDirectory);
    }

    private static boolean checkForNulls(Object directory, Object compareDirectory) {
        return directory == null && compareDirectory == null;
    }

    private static boolean compareDirectoryContents(Path directory, Path compareDirectory, boolean checkFileContent) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path directoryFilePath : directoryStream) {
                Path compareFilePath = compareDirectory.resolve(directoryFilePath.getFileName());
                if (compareFilePath != null) {
                    File directoryFile = directoryFilePath.toFile();
                    if (directoryFile.isFile()) {
                        if (!checkFileContent || FileUtils.contentEquals((File)compareFilePath.toFile(), (File)directoryFile)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean result = DirectoryUtils.isEverythingInCompareDirectory(directoryFilePath, compareFilePath, checkFileContent);
                    if (result) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

