from __future__ import annotations

from enum import Enum
from typing import Any


class RoborockDockType(str, Enum):
    NO_DOCK = "No dock"
    AUTO_EMPTY = "Roborock auto-empty dock"  # Dust collection
    EMPTY_WASH_FILL_DOCK = "Roborock empty wash fill dock"
    AUTO_EMPTY_PURE = "Roborock auto-empty pure dock"
    UNKNOWN = "Unknown Dock - please submit an issue"


class RoborockDockDustCollectionType(str, Enum):
    SMART = "smart"
    LIGHT = "light"
    BALANCED = "balanced"
    MAX = "max"


class RoborockDockWashingModeType(str, Enum):
    LIGHT = "light"
    BALANCED = "balanced"
    DEEP = "deep"


STATE_CODE_TO_STATUS: dict[int | Any, str | Any] = {
    1: "starting",
    2: "charger_disconnected",
    3: "idle",
    4: "remote_control_active",
    5: "cleaning",
    6: "returning_home",
    7: "manual_mode",
    8: "charging",
    9: "charging_problem",
    10: "paused",
    11: "spot_cleaning",
    12: "error",
    13: "shutting_down",
    14: "updating",
    15: "docking",
    16: "going_to_target",
    17: "zoned_cleaning",
    18: "segment_cleaning",
    22: "emptying_the_bin",  # on s7+, see #1189
    23: "washing_the_mop",  # on a46, #1435
    26: "going_to_wash_the_mop",  # on a46, #1435
    100: "charging_complete",
    101: "device_offline",
}

ERROR_CODE_TO_TEXT = {
    0: "None",
    1: "LiDAR turret or laser blocked. Check for obstruction and retry.",
    2: "Bumper stuck. Clean it and lightly tap to release it.",
    3: "Wheels suspended. Move robot and restart.",
    4: "Cliff sensor error. Clean cliff sensors, move robot away from drops and restart.",
    5: "Main brush jammed. Clean main brush and bearings.",
    6: "Side brush jammed. Remove and clean side brush.",
    7: "Wheels jammed. Move the robot and restart.",
    8: "Robot trapped. Clear obstacles surrounding robot.",
    9: "No dustbin. Install dustbin and filter.",
    12: "Low battery. Recharge and retry.",
    13: "Charging error. Clean charging contacts and retry.",
    14: "Battery error.",
    15: "Wall sensor dirty. Clean wall sensor.",
    16: "Robot tilted. Move to level ground and restart.",
    17: "Side brush error. Reset robot.",
    18: "Fan error. Reset robot.",
    21: "Vertical bumper pressed. Move robot and retry.",
    22: "Dock locator error. Clean and retry.",
    23: "Could not return to dock. Clean dock location beacon and retry.",
    24: "No-go zone or invisible wall detected. Move the robot.",
    27: "VibraRise system jammed. Check for obstructions.",
    28: "Robot on carpet. Move robot to floor and retry.",
    29: "Filter blocked or wet. Clean, dry, and retry.",
    30: "No-go zone or Invisible Wall detected. Move robot from this area.",
    31: "Cannot cross carpet. Move robot across carpet and restart.",
    32: "Internal error. Reset the robot.",
}

FAN_SPEED_CODES = {
    105: "off",
    101: "silent",
    102: "balanced",
    103: "turbo",
    104: "max",
    108: "max_plus",
    106: "custom",
}

MOP_MODE_CODES = {
    300: "standard",
    301: "deep",
    303: "deep_plus",
    302: "custom",
}

MOP_INTENSITY_CODES = {
    200: "off",
    201: "mild",
    202: "moderate",
    203: "intense",
    204: "custom",
}

DOCK_ERROR_TO_TEXT = {
    0: "ok",
    38: 'water empty',
    39: 'waste water tank full',
}

DOCK_TYPE_MAP = {
    0: RoborockDockType.NO_DOCK,
    3: RoborockDockType.EMPTY_WASH_FILL_DOCK,
}

DUST_COLLECTION_MAP = {
    0: RoborockDockDustCollectionType.SMART,
    1: RoborockDockDustCollectionType.LIGHT,
    2: RoborockDockDustCollectionType.BALANCED,
    4: RoborockDockDustCollectionType.MAX,
}

WASH_MODE_MAP = {
    0: RoborockDockWashingModeType.LIGHT,
    1: RoborockDockWashingModeType.BALANCED,
    2: RoborockDockWashingModeType.DEEP,
}
