# Python Sample App

[Python Sample App](https://github.com/becosta/python-sample-app) is a starter template for new python applications.
You can clone it, edit some basic stuff and get started on your new app.

## Installing

First set some variables:
```sh
your_project_name=<project_name>
your_main_package_name=<main_package_name>
```

Then clone or download this repository:
```sh
$ git clone https://github.com/becosta/python-sample-app.git
$ rm -rf python-sample-app/.git/
```
Or:
```sh
$ curl -LkSs https://api.github.com/repos/becosta/python-sample-app/tarball | tar -xvzp -C . ; mv becosta-python-sample-app-* python-sample-app
```

Next thing to do is to rename the project directory (python-sample-app) to your project's name.
```sh
$ mv python-sample-app ${your_project_name} && cd ${your_project_name}
```

Then you can move on to renaming the main package directory (python_sample_app).
```sh
$ mv python_sample_app ${your_main_package_name}
```

## Application layout

Your new application layout is as following:
```
python-sample-app
├── apidoc/
|   └── .gitkeep
├── dist/
|   └── .gitkeep
├── doc/
|   └── .gitkeep
├── python_sample_app/
|   ├── test/
|   |   └── __init__.py
|   ├── __init__.py
|   └── main.py
├── scripts/
|   └── .gitkeep
├── .gitignore
├── LICENSE.md
├── README.md
└── setup.py
```

## Editing to match your project needs

After this you need to edit setup.py: ```$ editor setup.py```
```python
name='<your_project>',
version='<your_project_version>',
description='<your_project_description>',
author='<your_name>',
author_email='<you@example.com>',
license="<your_project_license>",
url="<your_project_url>",
packages=['<your_project_main_package>'],
entry_points={
        'console_scripts': [
            '<your_command>=<your_project_main_package>.main:main',
        ],
},
```
Note that ```<your_command>``` is the name of the entry script that will be generated by ```$ pip install -e .```. In other words this is the name of the command you'll use to call your application from the console later on. Also, note that you can have more than one entry point [see the setuptools documentation](https://setuptools.readthedocs.io/en/latest/setuptools.html#dynamic-discovery-of-services-and-plugins) for more information.

Once done, edit ```LICENSE.md```, ```README.md``` and ```.gitignore``` according to your needs. If you don't need any of the ```apidoc```, ```dist```, ```doc``` and ```scripts``` directories you should remove them now.

Finally you can create your git repository, install your project locally and run it:
```sh
$ git init && git add .
$ git commit -m "Iniatial commit"
$ pip install -e .
$ <your_command>
Hello World!
$
```

## Start coding

To get started, create a module in ```${your_project_name}/${your_main_package_name}``` and call it in ```${your_project_name}/${your_main_package_name}/main.py```.

A simple example would be :
```python
## ${your_project_name}/${your_main_package_name}/application.py
def class Application:
    def run(self):
        print("Hello World! From module application.")


# ${your_project_name}/${your_main_package_name}/main.py
import <your_main_package_name>.application
def main():
    <your_main_package_name>.application.Application().run()
```

You can then add more modules, either as simple as a flat file like application.py or more complex with a full directory tree.

## Distributing your project

You can easily distribute your project to [PyPi](https://pypi.python.org/pypi)

Once you have created an account on PyPi, a pretty basic example would be:
```sh
pip install twine
python setup.py sdist
twine upload dist/*
```

See the [PyPi tutorial](https://wiki.python.org/moin/CheeseShopTutorial#Submitting_Packages_to_the_Package_Index) for more information
