# Python sample package with data

How to distribute a Python package with data.

Tested on Ubuntu 19.10, Python 3.7.5, wheel==0.32.3, setuptools==41.1.0, twine==3.1.1.

How end users use the package:

```
python3 -m pip install --user python-sample-package-with-data
python-sapmle-package-with-data
```

Expected output:

```
hello data
```

How maintainers publish it:

```
# One time setup.
python3 -m pip install --user setuptools wheel twine

# Every time you want to publish.
python setup.py sdist bdist_wheel
twine upload dist/*
```

Bibliography:

- https://stackoverflow.com/questions/47577762/how-do-i-distribute-my-pip-package-with-data-files-correctly
https://stackoverflow.com/questions/47817944/python-pkg-resources-and-file-access-in-packages
https://stackoverflow.com/questions/39104/finding-a-file-in-a-python-module-distribution
https://stackoverflow.com/questions/14211575/any-python-function-to-get-data-files-root-directory
https://stackoverflow.com/questions/14422340/manifest-in-package-data-and-data-files-clarification
https://stackoverflow.com/questions/3596979/manifest-in-ignored-on-python-setup-py-install-no-data-files-installed/3597263#3597263
https://stackoverflow.com/questions/11235820/setup-py-not-installing-data-files
