#! /bin/sh
# This is a test against the experimental results for Au nanoshells published by:
# A. M. Schwartzberg, T. Y. Olson, C. E. Talley and J. Z. Zhang,
# J. Phys. Chem. B, 110 (2006) 19935-19944.
#
# This is for the second case: Rc=28.0 nm, tsh=6.0 nm

PROGRAM='../../../scattnlay'

$PROGRAM  -l 2 0.439823 1.000000 0.000000 0.534071 1.534326 1.992028 -c  400.0
$PROGRAM  -l 2 0.438726 1.000000 0.000000 0.532739 1.534219 1.992945 -c  401.0
$PROGRAM  -l 2 0.437635 1.000000 0.000000 0.531414 1.534085 1.993810 -c  402.0
$PROGRAM  -l 2 0.436549 1.000000 0.000000 0.530095 1.533933 1.994624 -c  403.0
$PROGRAM  -l 2 0.435468 1.000000 0.000000 0.528783 1.533770 1.995385 -c  404.0
$PROGRAM  -l 2 0.434393 1.000000 0.000000 0.527477 1.533604 1.996094 -c  405.0
$PROGRAM  -l 2 0.433323 1.000000 0.000000 0.526178 1.533440 1.996750 -c  406.0
$PROGRAM  -l 2 0.432259 1.000000 0.000000 0.524885 1.533285 1.997353 -c  407.0
$PROGRAM  -l 2 0.431199 1.000000 0.000000 0.523599 1.533142 1.997902 -c  408.0
$PROGRAM  -l 2 0.430145 1.000000 0.000000 0.522319 1.533016 1.998398 -c  409.0
$PROGRAM  -l 2 0.429096 1.000000 0.000000 0.521045 1.532911 1.998840 -c  410.0
$PROGRAM  -l 2 0.428052 1.000000 0.000000 0.519777 1.532827 1.999227 -c  411.0
$PROGRAM  -l 2 0.427013 1.000000 0.000000 0.518515 1.532767 1.999561 -c  412.0
$PROGRAM  -l 2 0.425979 1.000000 0.000000 0.517260 1.532732 1.999839 -c  413.0
$PROGRAM  -l 2 0.424950 1.000000 0.000000 0.516011 1.532822 2.000060 -c  414.0
$PROGRAM  -l 2 0.423926 1.000000 0.000000 0.514767 1.533514 2.000213 -c  415.0
$PROGRAM  -l 2 0.422907 1.000000 0.000000 0.513530 1.534180 2.000311 -c  416.0
$PROGRAM  -l 2 0.421893 1.000000 0.000000 0.512298 1.534807 2.000356 -c  417.0
$PROGRAM  -l 2 0.420883 1.000000 0.000000 0.511073 1.535378 2.000347 -c  418.0
$PROGRAM  -l 2 0.419879 1.000000 0.000000 0.509853 1.535881 2.000285 -c  419.0
$PROGRAM  -l 2 0.418879 1.000000 0.000000 0.508639 1.536302 2.000169 -c  420.0
$PROGRAM  -l 2 0.417884 1.000000 0.000000 0.507431 1.536631 1.999999 -c  421.0
$PROGRAM  -l 2 0.416894 1.000000 0.000000 0.506228 1.536855 1.999775 -c  422.0
$PROGRAM  -l 2 0.415908 1.000000 0.000000 0.505032 1.536965 1.999498 -c  423.0
$PROGRAM  -l 2 0.414928 1.000000 0.000000 0.503841 1.536951 1.999168 -c  424.0
$PROGRAM  -l 2 0.413951 1.000000 0.000000 0.502655 1.536806 1.998783 -c  425.0
$PROGRAM  -l 2 0.412980 1.000000 0.000000 0.501475 1.536522 1.998344 -c  426.0
$PROGRAM  -l 2 0.412012 1.000000 0.000000 0.500301 1.536092 1.997851 -c  427.0
$PROGRAM  -l 2 0.411050 1.000000 0.000000 0.499132 1.535510 1.997304 -c  428.0
$PROGRAM  -l 2 0.410092 1.000000 0.000000 0.497968 1.534772 1.996701 -c  429.0
$PROGRAM  -l 2 0.409138 1.000000 0.000000 0.496810 1.533873 1.996044 -c  430.0
$PROGRAM  -l 2 0.408189 1.000000 0.000000 0.495658 1.532812 1.995332 -c  431.0
$PROGRAM  -l 2 0.407244 1.000000 0.000000 0.494510 1.530543 1.994795 -c  432.0
$PROGRAM  -l 2 0.406303 1.000000 0.000000 0.493368 1.528044 1.994216 -c  433.0
$PROGRAM  -l 2 0.405367 1.000000 0.000000 0.492232 1.525452 1.993563 -c  434.0
$PROGRAM  -l 2 0.404435 1.000000 0.000000 0.491100 1.522784 1.992833 -c  435.0
$PROGRAM  -l 2 0.403508 1.000000 0.000000 0.489974 1.520057 1.992022 -c  436.0
$PROGRAM  -l 2 0.402584 1.000000 0.000000 0.488852 1.517284 1.991126 -c  437.0
$PROGRAM  -l 2 0.401665 1.000000 0.000000 0.487736 1.514481 1.990143 -c  438.0
$PROGRAM  -l 2 0.400750 1.000000 0.000000 0.486625 1.511660 1.989070 -c  439.0
$PROGRAM  -l 2 0.399839 1.000000 0.000000 0.485519 1.508833 1.987906 -c  440.0
$PROGRAM  -l 2 0.398933 1.000000 0.000000 0.484418 1.506010 1.986647 -c  441.0
$PROGRAM  -l 2 0.398030 1.000000 0.000000 0.483322 1.503201 1.985295 -c  442.0
$PROGRAM  -l 2 0.397132 1.000000 0.000000 0.482231 1.500414 1.983847 -c  443.0
$PROGRAM  -l 2 0.396237 1.000000 0.000000 0.481145 1.497657 1.982303 -c  444.0
$PROGRAM  -l 2 0.395347 1.000000 0.000000 0.480064 1.494936 1.980663 -c  445.0
$PROGRAM  -l 2 0.394460 1.000000 0.000000 0.478988 1.492255 1.978929 -c  446.0
$PROGRAM  -l 2 0.393578 1.000000 0.000000 0.477916 1.489619 1.977100 -c  447.0
$PROGRAM  -l 2 0.392700 1.000000 0.000000 0.476849 1.487031 1.975179 -c  448.0
$PROGRAM  -l 2 0.391825 1.000000 0.000000 0.475787 1.484493 1.973166 -c  449.0
$PROGRAM  -l 2 0.390954 1.000000 0.000000 0.474730 1.482004 1.971064 -c  450.0
$PROGRAM  -l 2 0.390087 1.000000 0.000000 0.473677 1.479566 1.968876 -c  451.0
$PROGRAM  -l 2 0.389224 1.000000 0.000000 0.472630 1.477958 1.966534 -c  452.0
$PROGRAM  -l 2 0.388365 1.000000 0.000000 0.471586 1.477059 1.964053 -c  453.0
$PROGRAM  -l 2 0.387510 1.000000 0.000000 0.470547 1.476104 1.961506 -c  454.0
$PROGRAM  -l 2 0.386658 1.000000 0.000000 0.469513 1.475070 1.958896 -c  455.0
$PROGRAM  -l 2 0.385810 1.000000 0.000000 0.468484 1.473936 1.956231 -c  456.0
$PROGRAM  -l 2 0.384966 1.000000 0.000000 0.467459 1.472680 1.953516 -c  457.0
$PROGRAM  -l 2 0.384125 1.000000 0.000000 0.466438 1.471283 1.950758 -c  458.0
$PROGRAM  -l 2 0.383289 1.000000 0.000000 0.465422 1.469725 1.947963 -c  459.0
$PROGRAM  -l 2 0.382455 1.000000 0.000000 0.464410 1.467989 1.945137 -c  460.0
$PROGRAM  -l 2 0.381626 1.000000 0.000000 0.463403 1.466055 1.942288 -c  461.0
$PROGRAM  -l 2 0.380800 1.000000 0.000000 0.462400 1.463909 1.939422 -c  462.0
$PROGRAM  -l 2 0.379977 1.000000 0.000000 0.461401 1.461534 1.936548 -c  463.0
$PROGRAM  -l 2 0.379158 1.000000 0.000000 0.460406 1.458916 1.933672 -c  464.0
$PROGRAM  -l 2 0.378343 1.000000 0.000000 0.459416 1.456040 1.930802 -c  465.0
$PROGRAM  -l 2 0.377531 1.000000 0.000000 0.458430 1.452893 1.927945 -c  466.0
$PROGRAM  -l 2 0.376723 1.000000 0.000000 0.457449 1.449463 1.925111 -c  467.0
$PROGRAM  -l 2 0.375918 1.000000 0.000000 0.456471 1.445738 1.922306 -c  468.0
$PROGRAM  -l 2 0.375116 1.000000 0.000000 0.455498 1.441709 1.919541 -c  469.0
$PROGRAM  -l 2 0.374318 1.000000 0.000000 0.454529 1.437365 1.916822 -c  470.0
$PROGRAM  -l 2 0.373523 1.000000 0.000000 0.453564 1.432697 1.914158 -c  471.0
$PROGRAM  -l 2 0.372732 1.000000 0.000000 0.452603 1.427697 1.911560 -c  472.0
$PROGRAM  -l 2 0.371944 1.000000 0.000000 0.451646 1.422301 1.907924 -c  473.0
$PROGRAM  -l 2 0.371159 1.000000 0.000000 0.450693 1.416557 1.904318 -c  474.0
$PROGRAM  -l 2 0.370378 1.000000 0.000000 0.449745 1.410467 1.900863 -c  475.0
$PROGRAM  -l 2 0.369600 1.000000 0.000000 0.448800 1.404026 1.897582 -c  476.0
$PROGRAM  -l 2 0.368825 1.000000 0.000000 0.447859 1.397231 1.894497 -c  477.0
$PROGRAM  -l 2 0.368053 1.000000 0.000000 0.446922 1.390079 1.891627 -c  478.0
$PROGRAM  -l 2 0.367285 1.000000 0.000000 0.445989 1.382569 1.888991 -c  479.0
$PROGRAM  -l 2 0.366520 1.000000 0.000000 0.445060 1.374698 1.886608 -c  480.0
$PROGRAM  -l 2 0.365758 1.000000 0.000000 0.444134 1.366468 1.884495 -c  481.0
$PROGRAM  -l 2 0.364999 1.000000 0.000000 0.443213 1.357876 1.882669 -c  482.0
$PROGRAM  -l 2 0.364243 1.000000 0.000000 0.442295 1.348925 1.881143 -c  483.0
$PROGRAM  -l 2 0.363491 1.000000 0.000000 0.441382 1.339616 1.879933 -c  484.0
$PROGRAM  -l 2 0.362741 1.000000 0.000000 0.440472 1.329951 1.879051 -c  485.0
$PROGRAM  -l 2 0.361995 1.000000 0.000000 0.439565 1.319932 1.878510 -c  486.0
$PROGRAM  -l 2 0.361252 1.000000 0.000000 0.438663 1.309563 1.878320 -c  487.0
$PROGRAM  -l 2 0.360511 1.000000 0.000000 0.437764 1.298848 1.878493 -c  488.0
$PROGRAM  -l 2 0.359774 1.000000 0.000000 0.436868 1.287791 1.879037 -c  489.0
$PROGRAM  -l 2 0.359040 1.000000 0.000000 0.435977 1.276398 1.879960 -c  490.0
$PROGRAM  -l 2 0.358309 1.000000 0.000000 0.435089 1.264675 1.881270 -c  491.0
$PROGRAM  -l 2 0.357580 1.000000 0.000000 0.434205 1.252627 1.882974 -c  492.0
$PROGRAM  -l 2 0.356855 1.000000 0.000000 0.433324 1.240262 1.885077 -c  493.0
$PROGRAM  -l 2 0.356133 1.000000 0.000000 0.432447 1.227588 1.887585 -c  494.0
$PROGRAM  -l 2 0.355413 1.000000 0.000000 0.431573 1.214613 1.890500 -c  495.0
$PROGRAM  -l 2 0.354697 1.000000 0.000000 0.430703 1.201345 1.893826 -c  496.0
$PROGRAM  -l 2 0.353983 1.000000 0.000000 0.429836 1.186834 1.898078 -c  497.0
$PROGRAM  -l 2 0.353272 1.000000 0.000000 0.428973 1.170494 1.903570 -c  498.0
$PROGRAM  -l 2 0.352564 1.000000 0.000000 0.428114 1.154015 1.909403 -c  499.0
$PROGRAM  -l 2 0.351859 1.000000 0.000000 0.427257 1.137431 1.915567 -c  500.0
$PROGRAM  -l 2 0.351157 1.000000 0.000000 0.426405 1.120775 1.922051 -c  501.0
$PROGRAM  -l 2 0.350457 1.000000 0.000000 0.425555 1.104077 1.928843 -c  502.0
$PROGRAM  -l 2 0.349761 1.000000 0.000000 0.424709 1.087369 1.935936 -c  503.0
$PROGRAM  -l 2 0.349067 1.000000 0.000000 0.423867 1.070679 1.943320 -c  504.0
$PROGRAM  -l 2 0.348375 1.000000 0.000000 0.423027 1.054035 1.950985 -c  505.0
$PROGRAM  -l 2 0.347687 1.000000 0.000000 0.422191 1.037466 1.958922 -c  506.0
$PROGRAM  -l 2 0.347001 1.000000 0.000000 0.421358 1.020997 1.967125 -c  507.0
$PROGRAM  -l 2 0.346318 1.000000 0.000000 0.420529 1.004653 1.975584 -c  508.0
$PROGRAM  -l 2 0.345638 1.000000 0.000000 0.419703 0.988460 1.984292 -c  509.0
$PROGRAM  -l 2 0.344960 1.000000 0.000000 0.418880 0.972441 1.993241 -c  510.0
$PROGRAM  -l 2 0.344285 1.000000 0.000000 0.418060 0.956618 2.002425 -c  511.0
$PROGRAM  -l 2 0.343612 1.000000 0.000000 0.417244 0.941014 2.011836 -c  512.0
$PROGRAM  -l 2 0.342943 1.000000 0.000000 0.416430 0.925648 2.021468 -c  513.0
$PROGRAM  -l 2 0.342275 1.000000 0.000000 0.415620 0.910542 2.031313 -c  514.0
$PROGRAM  -l 2 0.341611 1.000000 0.000000 0.414813 0.895714 2.041365 -c  515.0
$PROGRAM  -l 2 0.340949 1.000000 0.000000 0.414009 0.881182 2.051618 -c  516.0
$PROGRAM  -l 2 0.340289 1.000000 0.000000 0.413209 0.866963 2.062064 -c  517.0
$PROGRAM  -l 2 0.339632 1.000000 0.000000 0.412411 0.853074 2.072699 -c  518.0
$PROGRAM  -l 2 0.338978 1.000000 0.000000 0.411616 0.839529 2.083515 -c  519.0
$PROGRAM  -l 2 0.338326 1.000000 0.000000 0.410825 0.826343 2.094505 -c  520.0
$PROGRAM  -l 2 0.337677 1.000000 0.000000 0.410036 0.813529 2.105664 -c  521.0
$PROGRAM  -l 2 0.337030 1.000000 0.000000 0.409251 0.801941 2.117082 -c  522.0
$PROGRAM  -l 2 0.336386 1.000000 0.000000 0.408468 0.792403 2.128847 -c  523.0
$PROGRAM  -l 2 0.335744 1.000000 0.000000 0.407689 0.783182 2.140752 -c  524.0
$PROGRAM  -l 2 0.335104 1.000000 0.000000 0.406912 0.774266 2.152789 -c  525.0
$PROGRAM  -l 2 0.334467 1.000000 0.000000 0.406138 0.765642 2.164947 -c  526.0
$PROGRAM  -l 2 0.333832 1.000000 0.000000 0.405368 0.757301 2.177218 -c  527.0
$PROGRAM  -l 2 0.333200 1.000000 0.000000 0.404600 0.749229 2.189593 -c  528.0
$PROGRAM  -l 2 0.332570 1.000000 0.000000 0.403835 0.741417 2.202063 -c  529.0
$PROGRAM  -l 2 0.331943 1.000000 0.000000 0.403073 0.733853 2.214619 -c  530.0
$PROGRAM  -l 2 0.331318 1.000000 0.000000 0.402314 0.726527 2.227253 -c  531.0
$PROGRAM  -l 2 0.330695 1.000000 0.000000 0.401558 0.719429 2.239956 -c  532.0
$PROGRAM  -l 2 0.330074 1.000000 0.000000 0.400805 0.712548 2.252720 -c  533.0
$PROGRAM  -l 2 0.329456 1.000000 0.000000 0.400054 0.705874 2.265537 -c  534.0
$PROGRAM  -l 2 0.328840 1.000000 0.000000 0.399306 0.699398 2.278400 -c  535.0
$PROGRAM  -l 2 0.328227 1.000000 0.000000 0.398561 0.693111 2.291301 -c  536.0
$PROGRAM  -l 2 0.327616 1.000000 0.000000 0.397819 0.687002 2.304233 -c  537.0
$PROGRAM  -l 2 0.327007 1.000000 0.000000 0.397080 0.681063 2.317188 -c  538.0
$PROGRAM  -l 2 0.326400 1.000000 0.000000 0.396343 0.675286 2.330160 -c  539.0
$PROGRAM  -l 2 0.325796 1.000000 0.000000 0.395609 0.669661 2.343142 -c  540.0
$PROGRAM  -l 2 0.325193 1.000000 0.000000 0.394878 0.664180 2.356127 -c  541.0
$PROGRAM  -l 2 0.324593 1.000000 0.000000 0.394149 0.658835 2.369110 -c  542.0
$PROGRAM  -l 2 0.323996 1.000000 0.000000 0.393423 0.653619 2.382083 -c  543.0
$PROGRAM  -l 2 0.323400 1.000000 0.000000 0.392700 0.648523 2.395043 -c  544.0
$PROGRAM  -l 2 0.322807 1.000000 0.000000 0.391980 0.643540 2.407983 -c  545.0
$PROGRAM  -l 2 0.322216 1.000000 0.000000 0.391262 0.638663 2.420897 -c  546.0
$PROGRAM  -l 2 0.321626 1.000000 0.000000 0.390546 0.633885 2.433782 -c  547.0
$PROGRAM  -l 2 0.321040 1.000000 0.000000 0.389834 0.629199 2.446632 -c  548.0
$PROGRAM  -l 2 0.320455 1.000000 0.000000 0.389124 0.624600 2.459442 -c  549.0
$PROGRAM  -l 2 0.319872 1.000000 0.000000 0.388416 0.619632 2.471696 -c  550.0
$PROGRAM  -l 2 0.319292 1.000000 0.000000 0.387711 0.614489 2.483615 -c  551.0
$PROGRAM  -l 2 0.318713 1.000000 0.000000 0.387009 0.609433 2.495506 -c  552.0
$PROGRAM  -l 2 0.318137 1.000000 0.000000 0.386309 0.604462 2.507369 -c  553.0
$PROGRAM  -l 2 0.317563 1.000000 0.000000 0.385612 0.599577 2.519206 -c  554.0
$PROGRAM  -l 2 0.316990 1.000000 0.000000 0.384917 0.594775 2.531019 -c  555.0
$PROGRAM  -l 2 0.316420 1.000000 0.000000 0.384225 0.590057 2.542809 -c  556.0
$PROGRAM  -l 2 0.315852 1.000000 0.000000 0.383535 0.585420 2.554577 -c  557.0
$PROGRAM  -l 2 0.315286 1.000000 0.000000 0.382848 0.580864 2.566325 -c  558.0
$PROGRAM  -l 2 0.314722 1.000000 0.000000 0.382163 0.576389 2.578055 -c  559.0
$PROGRAM  -l 2 0.314160 1.000000 0.000000 0.381480 0.571993 2.589767 -c  560.0
$PROGRAM  -l 2 0.313600 1.000000 0.000000 0.380800 0.567675 2.601463 -c  561.0
$PROGRAM  -l 2 0.313042 1.000000 0.000000 0.380123 0.563434 2.613144 -c  562.0
$PROGRAM  -l 2 0.312486 1.000000 0.000000 0.379447 0.559269 2.624812 -c  563.0
$PROGRAM  -l 2 0.311932 1.000000 0.000000 0.378775 0.555179 2.636468 -c  564.0
$PROGRAM  -l 2 0.311380 1.000000 0.000000 0.378104 0.551164 2.648111 -c  565.0
$PROGRAM  -l 2 0.310830 1.000000 0.000000 0.377436 0.547222 2.659744 -c  566.0
$PROGRAM  -l 2 0.310282 1.000000 0.000000 0.376771 0.543352 2.671368 -c  567.0
$PROGRAM  -l 2 0.309735 1.000000 0.000000 0.376107 0.539553 2.682983 -c  568.0
$PROGRAM  -l 2 0.309191 1.000000 0.000000 0.375446 0.535825 2.694589 -c  569.0
$PROGRAM  -l 2 0.308649 1.000000 0.000000 0.374788 0.532166 2.706189 -c  570.0
$PROGRAM  -l 2 0.308108 1.000000 0.000000 0.374131 0.528576 2.717783 -c  571.0
$PROGRAM  -l 2 0.307569 1.000000 0.000000 0.373477 0.525053 2.729370 -c  572.0
$PROGRAM  -l 2 0.307033 1.000000 0.000000 0.372825 0.521596 2.740953 -c  573.0
$PROGRAM  -l 2 0.306498 1.000000 0.000000 0.372176 0.518205 2.752532 -c  574.0
$PROGRAM  -l 2 0.305965 1.000000 0.000000 0.371529 0.514878 2.764107 -c  575.0
$PROGRAM  -l 2 0.305434 1.000000 0.000000 0.370884 0.511614 2.775678 -c  576.0
$PROGRAM  -l 2 0.304904 1.000000 0.000000 0.370241 0.508414 2.787246 -c  577.0
$PROGRAM  -l 2 0.304377 1.000000 0.000000 0.369600 0.505274 2.798811 -c  578.0
$PROGRAM  -l 2 0.303851 1.000000 0.000000 0.368962 0.502195 2.810375 -c  579.0
$PROGRAM  -l 2 0.303327 1.000000 0.000000 0.368326 0.499176 2.821936 -c  580.0
$PROGRAM  -l 2 0.302805 1.000000 0.000000 0.367692 0.496215 2.833496 -c  581.0
$PROGRAM  -l 2 0.302285 1.000000 0.000000 0.367060 0.493311 2.845054 -c  582.0
$PROGRAM  -l 2 0.301766 1.000000 0.000000 0.366431 0.490476 2.856647 -c  583.0
$PROGRAM  -l 2 0.301250 1.000000 0.000000 0.365803 0.487792 2.868559 -c  584.0
$PROGRAM  -l 2 0.300735 1.000000 0.000000 0.365178 0.485161 2.880459 -c  585.0
$PROGRAM  -l 2 0.300221 1.000000 0.000000 0.364555 0.482579 2.892346 -c  586.0
$PROGRAM  -l 2 0.299710 1.000000 0.000000 0.363934 0.480046 2.904217 -c  587.0
$PROGRAM  -l 2 0.299200 1.000000 0.000000 0.363315 0.477560 2.916070 -c  588.0
$PROGRAM  -l 2 0.298692 1.000000 0.000000 0.362698 0.475120 2.927906 -c  589.0
$PROGRAM  -l 2 0.298186 1.000000 0.000000 0.362083 0.472724 2.939720 -c  590.0
$PROGRAM  -l 2 0.297682 1.000000 0.000000 0.361470 0.470371 2.951512 -c  591.0
$PROGRAM  -l 2 0.297179 1.000000 0.000000 0.360860 0.468060 2.963281 -c  592.0
$PROGRAM  -l 2 0.296678 1.000000 0.000000 0.360251 0.465790 2.975024 -c  593.0
$PROGRAM  -l 2 0.296178 1.000000 0.000000 0.359645 0.463558 2.986741 -c  594.0
$PROGRAM  -l 2 0.295680 1.000000 0.000000 0.359040 0.461364 2.998429 -c  595.0
$PROGRAM  -l 2 0.295184 1.000000 0.000000 0.358438 0.459207 3.010088 -c  596.0
$PROGRAM  -l 2 0.294690 1.000000 0.000000 0.357838 0.457085 3.021717 -c  597.0
$PROGRAM  -l 2 0.294197 1.000000 0.000000 0.357239 0.454998 3.033313 -c  598.0
$PROGRAM  -l 2 0.293706 1.000000 0.000000 0.356643 0.452943 3.044876 -c  599.0
$PROGRAM  -l 2 0.293216 1.000000 0.000000 0.356048 0.450921 3.056404 -c  600.0
$PROGRAM  -l 2 0.292728 1.000000 0.000000 0.355456 0.448930 3.067896 -c  601.0
$PROGRAM  -l 2 0.292242 1.000000 0.000000 0.354866 0.446969 3.079352 -c  602.0
$PROGRAM  -l 2 0.291758 1.000000 0.000000 0.354277 0.445036 3.090769 -c  603.0
$PROGRAM  -l 2 0.291275 1.000000 0.000000 0.353690 0.443132 3.102148 -c  604.0
$PROGRAM  -l 2 0.290793 1.000000 0.000000 0.353106 0.441255 3.113486 -c  605.0
$PROGRAM  -l 2 0.290313 1.000000 0.000000 0.352523 0.439404 3.124784 -c  606.0
$PROGRAM  -l 2 0.289835 1.000000 0.000000 0.351942 0.437578 3.136040 -c  607.0
$PROGRAM  -l 2 0.289358 1.000000 0.000000 0.351364 0.435777 3.147253 -c  608.0
$PROGRAM  -l 2 0.288883 1.000000 0.000000 0.350787 0.434000 3.158422 -c  609.0
$PROGRAM  -l 2 0.288410 1.000000 0.000000 0.350212 0.432245 3.169547 -c  610.0
$PROGRAM  -l 2 0.287938 1.000000 0.000000 0.349638 0.430513 3.180627 -c  611.0
$PROGRAM  -l 2 0.287467 1.000000 0.000000 0.349067 0.428802 3.191662 -c  612.0
$PROGRAM  -l 2 0.286998 1.000000 0.000000 0.348498 0.427112 3.202649 -c  613.0
$PROGRAM  -l 2 0.286531 1.000000 0.000000 0.347930 0.425442 3.213590 -c  614.0
$PROGRAM  -l 2 0.286065 1.000000 0.000000 0.347364 0.423791 3.224483 -c  615.0
$PROGRAM  -l 2 0.285600 1.000000 0.000000 0.346800 0.422160 3.235328 -c  616.0
$PROGRAM  -l 2 0.285138 1.000000 0.000000 0.346238 0.420547 3.246124 -c  617.0
$PROGRAM  -l 2 0.284676 1.000000 0.000000 0.345678 0.418865 3.256786 -c  618.0
$PROGRAM  -l 2 0.284216 1.000000 0.000000 0.345120 0.417003 3.267204 -c  619.0
$PROGRAM  -l 2 0.283758 1.000000 0.000000 0.344563 0.415163 3.277578 -c  620.0
$PROGRAM  -l 2 0.283301 1.000000 0.000000 0.344008 0.413346 3.287907 -c  621.0
$PROGRAM  -l 2 0.282845 1.000000 0.000000 0.343455 0.411553 3.298193 -c  622.0
$PROGRAM  -l 2 0.282391 1.000000 0.000000 0.342904 0.409783 3.308437 -c  623.0
$PROGRAM  -l 2 0.281939 1.000000 0.000000 0.342354 0.408038 3.318639 -c  624.0
$PROGRAM  -l 2 0.281488 1.000000 0.000000 0.341807 0.406319 3.328800 -c  625.0
$PROGRAM  -l 2 0.281038 1.000000 0.000000 0.341261 0.404627 3.338922 -c  626.0
$PROGRAM  -l 2 0.280590 1.000000 0.000000 0.340716 0.402961 3.349004 -c  627.0
$PROGRAM  -l 2 0.280143 1.000000 0.000000 0.340174 0.401322 3.359048 -c  628.0
$PROGRAM  -l 2 0.279698 1.000000 0.000000 0.339633 0.399712 3.369054 -c  629.0
$PROGRAM  -l 2 0.279254 1.000000 0.000000 0.339094 0.398131 3.379022 -c  630.0
$PROGRAM  -l 2 0.278811 1.000000 0.000000 0.338556 0.396579 3.388955 -c  631.0
$PROGRAM  -l 2 0.278370 1.000000 0.000000 0.338021 0.395056 3.398853 -c  632.0
$PROGRAM  -l 2 0.277930 1.000000 0.000000 0.337487 0.393564 3.408715 -c  633.0
$PROGRAM  -l 2 0.277492 1.000000 0.000000 0.336954 0.392104 3.418543 -c  634.0
$PROGRAM  -l 2 0.277055 1.000000 0.000000 0.336424 0.390674 3.428338 -c  635.0
$PROGRAM  -l 2 0.276619 1.000000 0.000000 0.335895 0.389276 3.438101 -c  636.0
$PROGRAM  -l 2 0.276185 1.000000 0.000000 0.335368 0.387911 3.447831 -c  637.0
$PROGRAM  -l 2 0.275752 1.000000 0.000000 0.334842 0.386579 3.457530 -c  638.0
$PROGRAM  -l 2 0.275321 1.000000 0.000000 0.334318 0.385280 3.467199 -c  639.0
$PROGRAM  -l 2 0.274890 1.000000 0.000000 0.333796 0.384014 3.476838 -c  640.0
$PROGRAM  -l 2 0.274462 1.000000 0.000000 0.333275 0.382783 3.486447 -c  641.0
$PROGRAM  -l 2 0.274034 1.000000 0.000000 0.332756 0.381585 3.496028 -c  642.0
$PROGRAM  -l 2 0.273608 1.000000 0.000000 0.332238 0.380423 3.505580 -c  643.0
$PROGRAM  -l 2 0.273183 1.000000 0.000000 0.331722 0.379295 3.515105 -c  644.0
$PROGRAM  -l 2 0.272760 1.000000 0.000000 0.331208 0.378203 3.524603 -c  645.0
$PROGRAM  -l 2 0.272337 1.000000 0.000000 0.330695 0.377147 3.534075 -c  646.0
$PROGRAM  -l 2 0.271916 1.000000 0.000000 0.330184 0.376126 3.543521 -c  647.0
$PROGRAM  -l 2 0.271497 1.000000 0.000000 0.329675 0.375142 3.552943 -c  648.0
$PROGRAM  -l 2 0.271078 1.000000 0.000000 0.329167 0.374193 3.562339 -c  649.0
$PROGRAM  -l 2 0.270661 1.000000 0.000000 0.328660 0.373282 3.571712 -c  650.0
$PROGRAM  -l 2 0.270246 1.000000 0.000000 0.328155 0.372407 3.581061 -c  651.0
$PROGRAM  -l 2 0.269831 1.000000 0.000000 0.327652 0.371569 3.590387 -c  652.0
$PROGRAM  -l 2 0.269418 1.000000 0.000000 0.327150 0.370768 3.599692 -c  653.0
$PROGRAM  -l 2 0.269006 1.000000 0.000000 0.326650 0.370004 3.608974 -c  654.0
$PROGRAM  -l 2 0.268595 1.000000 0.000000 0.326151 0.369278 3.618235 -c  655.0
$PROGRAM  -l 2 0.268186 1.000000 0.000000 0.325654 0.368589 3.627475 -c  656.0
$PROGRAM  -l 2 0.267778 1.000000 0.000000 0.325159 0.367937 3.636695 -c  657.0
$PROGRAM  -l 2 0.267371 1.000000 0.000000 0.324664 0.367323 3.645894 -c  658.0
$PROGRAM  -l 2 0.266965 1.000000 0.000000 0.324172 0.366746 3.655075 -c  659.0
$PROGRAM  -l 2 0.266560 1.000000 0.000000 0.323681 0.366207 3.664236 -c  660.0
$PROGRAM  -l 2 0.266157 1.000000 0.000000 0.323191 0.365830 3.673419 -c  661.0
$PROGRAM  -l 2 0.265755 1.000000 0.000000 0.322703 0.365573 3.682610 -c  662.0
$PROGRAM  -l 2 0.265354 1.000000 0.000000 0.322216 0.365350 3.691782 -c  663.0
$PROGRAM  -l 2 0.264955 1.000000 0.000000 0.321731 0.365158 3.700935 -c  664.0
$PROGRAM  -l 2 0.264556 1.000000 0.000000 0.321247 0.364997 3.710069 -c  665.0
$PROGRAM  -l 2 0.264159 1.000000 0.000000 0.320765 0.364867 3.719185 -c  666.0
$PROGRAM  -l 2 0.263763 1.000000 0.000000 0.320284 0.364766 3.728282 -c  667.0
$PROGRAM  -l 2 0.263368 1.000000 0.000000 0.319804 0.364695 3.737362 -c  668.0
$PROGRAM  -l 2 0.262975 1.000000 0.000000 0.319326 0.364652 3.746424 -c  669.0
$PROGRAM  -l 2 0.262582 1.000000 0.000000 0.318850 0.364637 3.755467 -c  670.0
$PROGRAM  -l 2 0.262191 1.000000 0.000000 0.318374 0.364648 3.764494 -c  671.0
$PROGRAM  -l 2 0.261800 1.000000 0.000000 0.317901 0.364687 3.773504 -c  672.0
$PROGRAM  -l 2 0.261411 1.000000 0.000000 0.317428 0.364751 3.782496 -c  673.0
$PROGRAM  -l 2 0.261024 1.000000 0.000000 0.316957 0.364840 3.791472 -c  674.0
$PROGRAM  -l 2 0.260637 1.000000 0.000000 0.316488 0.364955 3.800431 -c  675.0
$PROGRAM  -l 2 0.260251 1.000000 0.000000 0.316020 0.365093 3.809374 -c  676.0
$PROGRAM  -l 2 0.259867 1.000000 0.000000 0.315553 0.365254 3.818300 -c  677.0
$PROGRAM  -l 2 0.259484 1.000000 0.000000 0.315087 0.365439 3.827211 -c  678.0
$PROGRAM  -l 2 0.259102 1.000000 0.000000 0.314623 0.365645 3.836106 -c  679.0
$PROGRAM  -l 2 0.258721 1.000000 0.000000 0.314161 0.365873 3.844985 -c  680.0
$PROGRAM  -l 2 0.258341 1.000000 0.000000 0.313699 0.366123 3.853850 -c  681.0
$PROGRAM  -l 2 0.257962 1.000000 0.000000 0.313239 0.366393 3.862699 -c  682.0
$PROGRAM  -l 2 0.257584 1.000000 0.000000 0.312781 0.366683 3.871533 -c  683.0
$PROGRAM  -l 2 0.257208 1.000000 0.000000 0.312323 0.366992 3.880353 -c  684.0
$PROGRAM  -l 2 0.256832 1.000000 0.000000 0.311867 0.367320 3.889158 -c  685.0
$PROGRAM  -l 2 0.256458 1.000000 0.000000 0.311413 0.367667 3.897949 -c  686.0
$PROGRAM  -l 2 0.256084 1.000000 0.000000 0.310960 0.368031 3.906725 -c  687.0
$PROGRAM  -l 2 0.255712 1.000000 0.000000 0.310508 0.368413 3.915488 -c  688.0
$PROGRAM  -l 2 0.255341 1.000000 0.000000 0.310057 0.368812 3.924237 -c  689.0
$PROGRAM  -l 2 0.254971 1.000000 0.000000 0.309608 0.369227 3.932973 -c  690.0
$PROGRAM  -l 2 0.254602 1.000000 0.000000 0.309160 0.369657 3.941695 -c  691.0
$PROGRAM  -l 2 0.254234 1.000000 0.000000 0.308713 0.370104 3.950404 -c  692.0
$PROGRAM  -l 2 0.253867 1.000000 0.000000 0.308267 0.370565 3.959100 -c  693.0
$PROGRAM  -l 2 0.253501 1.000000 0.000000 0.307823 0.371040 3.967783 -c  694.0
$PROGRAM  -l 2 0.253137 1.000000 0.000000 0.307380 0.371529 3.976454 -c  695.0
$PROGRAM  -l 2 0.252773 1.000000 0.000000 0.306939 0.372032 3.985112 -c  696.0
$PROGRAM  -l 2 0.252410 1.000000 0.000000 0.306498 0.372548 3.993759 -c  697.0
$PROGRAM  -l 2 0.252049 1.000000 0.000000 0.306059 0.373077 4.002392 -c  698.0
$PROGRAM  -l 2 0.251688 1.000000 0.000000 0.305621 0.373617 4.011015 -c  699.0
$PROGRAM  -l 2 0.251329 1.000000 0.000000 0.305185 0.374170 4.019625 -c  700.0
$PROGRAM  -l 2 0.250970 1.000000 0.000000 0.304749 0.374734 4.028224 -c  701.0
$PROGRAM  -l 2 0.250613 1.000000 0.000000 0.304315 0.375308 4.036812 -c  702.0
$PROGRAM  -l 2 0.250256 1.000000 0.000000 0.303882 0.375893 4.045388 -c  703.0
$PROGRAM  -l 2 0.249901 1.000000 0.000000 0.303451 0.376489 4.053954 -c  704.0
$PROGRAM  -l 2 0.249546 1.000000 0.000000 0.303020 0.377094 4.062508 -c  705.0
$PROGRAM  -l 2 0.249193 1.000000 0.000000 0.302591 0.377666 4.071051 -c  706.0
$PROGRAM  -l 2 0.248840 1.000000 0.000000 0.302163 0.378216 4.079580 -c  707.0
$PROGRAM  -l 2 0.248489 1.000000 0.000000 0.301736 0.378775 4.088101 -c  708.0
$PROGRAM  -l 2 0.248138 1.000000 0.000000 0.301311 0.379343 4.096612 -c  709.0
$PROGRAM  -l 2 0.247789 1.000000 0.000000 0.300886 0.379921 4.105111 -c  710.0
$PROGRAM  -l 2 0.247440 1.000000 0.000000 0.300463 0.380509 4.113602 -c  711.0
$PROGRAM  -l 2 0.247093 1.000000 0.000000 0.300041 0.381106 4.122082 -c  712.0
$PROGRAM  -l 2 0.246746 1.000000 0.000000 0.299620 0.381711 4.130553 -c  713.0
$PROGRAM  -l 2 0.246401 1.000000 0.000000 0.299201 0.382326 4.139016 -c  714.0
$PROGRAM  -l 2 0.246056 1.000000 0.000000 0.298782 0.382949 4.147469 -c  715.0
$PROGRAM  -l 2 0.245712 1.000000 0.000000 0.298365 0.383581 4.155913 -c  716.0
$PROGRAM  -l 2 0.245370 1.000000 0.000000 0.297949 0.384221 4.164348 -c  717.0
$PROGRAM  -l 2 0.245028 1.000000 0.000000 0.297534 0.384869 4.172776 -c  718.0
$PROGRAM  -l 2 0.244687 1.000000 0.000000 0.297120 0.385526 4.181194 -c  719.0
$PROGRAM  -l 2 0.244347 1.000000 0.000000 0.296707 0.386190 4.189604 -c  720.0
$PROGRAM  -l 2 0.244008 1.000000 0.000000 0.296296 0.386862 4.198006 -c  721.0
$PROGRAM  -l 2 0.243670 1.000000 0.000000 0.295885 0.387542 4.206400 -c  722.0
$PROGRAM  -l 2 0.243333 1.000000 0.000000 0.295476 0.388229 4.214786 -c  723.0
$PROGRAM  -l 2 0.242997 1.000000 0.000000 0.295068 0.388924 4.223165 -c  724.0
$PROGRAM  -l 2 0.242662 1.000000 0.000000 0.294661 0.389626 4.231535 -c  725.0
$PROGRAM  -l 2 0.242328 1.000000 0.000000 0.294255 0.390335 4.239899 -c  726.0
$PROGRAM  -l 2 0.241995 1.000000 0.000000 0.293850 0.391051 4.248256 -c  727.0
$PROGRAM  -l 2 0.241662 1.000000 0.000000 0.293447 0.391773 4.256605 -c  728.0
$PROGRAM  -l 2 0.241331 1.000000 0.000000 0.293044 0.392503 4.264947 -c  729.0
$PROGRAM  -l 2 0.241000 1.000000 0.000000 0.292643 0.393238 4.273283 -c  730.0
$PROGRAM  -l 2 0.240670 1.000000 0.000000 0.292243 0.393980 4.281612 -c  731.0
$PROGRAM  -l 2 0.240342 1.000000 0.000000 0.291843 0.394729 4.289934 -c  732.0
$PROGRAM  -l 2 0.240014 1.000000 0.000000 0.291445 0.395483 4.298250 -c  733.0
$PROGRAM  -l 2 0.239687 1.000000 0.000000 0.291048 0.396243 4.306559 -c  734.0
$PROGRAM  -l 2 0.239361 1.000000 0.000000 0.290652 0.397009 4.314863 -c  735.0
$PROGRAM  -l 2 0.239035 1.000000 0.000000 0.290257 0.397781 4.323160 -c  736.0
$PROGRAM  -l 2 0.238711 1.000000 0.000000 0.289863 0.398558 4.331451 -c  737.0
$PROGRAM  -l 2 0.238388 1.000000 0.000000 0.289471 0.399341 4.339736 -c  738.0
$PROGRAM  -l 2 0.238065 1.000000 0.000000 0.289079 0.400129 4.348016 -c  739.0
$PROGRAM  -l 2 0.237743 1.000000 0.000000 0.288688 0.400922 4.356290 -c  740.0
$PROGRAM  -l 2 0.237422 1.000000 0.000000 0.288299 0.401720 4.364560 -c  741.0
$PROGRAM  -l 2 0.237102 1.000000 0.000000 0.287910 0.402523 4.372824 -c  742.0
$PROGRAM  -l 2 0.236783 1.000000 0.000000 0.287523 0.403331 4.381082 -c  743.0
$PROGRAM  -l 2 0.236465 1.000000 0.000000 0.287136 0.404143 4.389335 -c  744.0
$PROGRAM  -l 2 0.236148 1.000000 0.000000 0.286751 0.404960 4.397583 -c  745.0
$PROGRAM  -l 2 0.235831 1.000000 0.000000 0.286366 0.405781 4.405828 -c  746.0
$PROGRAM  -l 2 0.235515 1.000000 0.000000 0.285983 0.406607 4.414066 -c  747.0
$PROGRAM  -l 2 0.235201 1.000000 0.000000 0.285601 0.407437 4.422300 -c  748.0
$PROGRAM  -l 2 0.234887 1.000000 0.000000 0.285219 0.408270 4.430529 -c  749.0
$PROGRAM  -l 2 0.234573 1.000000 0.000000 0.284839 0.409108 4.438754 -c  750.0
$PROGRAM  -l 2 0.234261 1.000000 0.000000 0.284460 0.409949 4.446975 -c  751.0
$PROGRAM  -l 2 0.233950 1.000000 0.000000 0.284082 0.410794 4.455192 -c  752.0
$PROGRAM  -l 2 0.233639 1.000000 0.000000 0.283704 0.411643 4.463404 -c  753.0
$PROGRAM  -l 2 0.233329 1.000000 0.000000 0.283328 0.412495 4.471612 -c  754.0
$PROGRAM  -l 2 0.233020 1.000000 0.000000 0.282953 0.413350 4.479816 -c  755.0
$PROGRAM  -l 2 0.232712 1.000000 0.000000 0.282578 0.414208 4.488017 -c  756.0
$PROGRAM  -l 2 0.232404 1.000000 0.000000 0.282205 0.415070 4.496214 -c  757.0
$PROGRAM  -l 2 0.232098 1.000000 0.000000 0.281833 0.415960 4.504411 -c  758.0
$PROGRAM  -l 2 0.231792 1.000000 0.000000 0.281462 0.416855 4.512606 -c  759.0
$PROGRAM  -l 2 0.231487 1.000000 0.000000 0.281091 0.417753 4.520796 -c  760.0
$PROGRAM  -l 2 0.231183 1.000000 0.000000 0.280722 0.418652 4.528983 -c  761.0
$PROGRAM  -l 2 0.230879 1.000000 0.000000 0.280353 0.419554 4.537167 -c  762.0
$PROGRAM  -l 2 0.230577 1.000000 0.000000 0.279986 0.420458 4.545347 -c  763.0
$PROGRAM  -l 2 0.230275 1.000000 0.000000 0.279620 0.421363 4.553524 -c  764.0
$PROGRAM  -l 2 0.229974 1.000000 0.000000 0.279254 0.422271 4.561698 -c  765.0
$PROGRAM  -l 2 0.229674 1.000000 0.000000 0.278890 0.423179 4.569869 -c  766.0
$PROGRAM  -l 2 0.229374 1.000000 0.000000 0.278526 0.424090 4.578036 -c  767.0
$PROGRAM  -l 2 0.229076 1.000000 0.000000 0.278163 0.425001 4.586200 -c  768.0
$PROGRAM  -l 2 0.228778 1.000000 0.000000 0.277802 0.425914 4.594362 -c  769.0
$PROGRAM  -l 2 0.228481 1.000000 0.000000 0.277441 0.426827 4.602521 -c  770.0
$PROGRAM  -l 2 0.228184 1.000000 0.000000 0.277081 0.427742 4.610677 -c  771.0
$PROGRAM  -l 2 0.227889 1.000000 0.000000 0.276722 0.428657 4.618830 -c  772.0
$PROGRAM  -l 2 0.227594 1.000000 0.000000 0.276364 0.429573 4.626980 -c  773.0
$PROGRAM  -l 2 0.227300 1.000000 0.000000 0.276007 0.430489 4.635128 -c  774.0
$PROGRAM  -l 2 0.227007 1.000000 0.000000 0.275651 0.431406 4.643273 -c  775.0
$PROGRAM  -l 2 0.226714 1.000000 0.000000 0.275296 0.432322 4.651416 -c  776.0
$PROGRAM  -l 2 0.226422 1.000000 0.000000 0.274941 0.433239 4.659555 -c  777.0
$PROGRAM  -l 2 0.226131 1.000000 0.000000 0.274588 0.434156 4.667693 -c  778.0
$PROGRAM  -l 2 0.225841 1.000000 0.000000 0.274235 0.435073 4.675828 -c  779.0
$PROGRAM  -l 2 0.225551 1.000000 0.000000 0.273884 0.435989 4.683960 -c  780.0
$PROGRAM  -l 2 0.225263 1.000000 0.000000 0.273533 0.436905 4.692090 -c  781.0
$PROGRAM  -l 2 0.224975 1.000000 0.000000 0.273183 0.437821 4.700218 -c  782.0
$PROGRAM  -l 2 0.224687 1.000000 0.000000 0.272834 0.438736 4.708344 -c  783.0
$PROGRAM  -l 2 0.224401 1.000000 0.000000 0.272486 0.439651 4.716468 -c  784.0
$PROGRAM  -l 2 0.224115 1.000000 0.000000 0.272139 0.440564 4.724588 -c  785.0
$PROGRAM  -l 2 0.223830 1.000000 0.000000 0.271793 0.441477 4.732708 -c  786.0
$PROGRAM  -l 2 0.223545 1.000000 0.000000 0.271448 0.442389 4.740825 -c  787.0
$PROGRAM  -l 2 0.223262 1.000000 0.000000 0.271103 0.443300 4.748940 -c  788.0
$PROGRAM  -l 2 0.222979 1.000000 0.000000 0.270760 0.444209 4.757053 -c  789.0
$PROGRAM  -l 2 0.222696 1.000000 0.000000 0.270417 0.445118 4.765164 -c  790.0
$PROGRAM  -l 2 0.222415 1.000000 0.000000 0.270075 0.446025 4.773273 -c  791.0
$PROGRAM  -l 2 0.222134 1.000000 0.000000 0.269734 0.446930 4.781380 -c  792.0
$PROGRAM  -l 2 0.221854 1.000000 0.000000 0.269394 0.447835 4.789484 -c  793.0
$PROGRAM  -l 2 0.221574 1.000000 0.000000 0.269055 0.448737 4.797588 -c  794.0
$PROGRAM  -l 2 0.221296 1.000000 0.000000 0.268716 0.449638 4.805689 -c  795.0
$PROGRAM  -l 2 0.221018 1.000000 0.000000 0.268379 0.450537 4.813788 -c  796.0
$PROGRAM  -l 2 0.220740 1.000000 0.000000 0.268042 0.451435 4.821886 -c  797.0
$PROGRAM  -l 2 0.220464 1.000000 0.000000 0.267706 0.452331 4.829981 -c  798.0
$PROGRAM  -l 2 0.220188 1.000000 0.000000 0.267371 0.453224 4.838075 -c  799.0
$PROGRAM  -l 2 0.219913 1.000000 0.000000 0.267037 0.454116 4.846167 -c  800.0
$PROGRAM  -l 2 0.219638 1.000000 0.000000 0.266703 0.455006 4.854258 -c  801.0
$PROGRAM  -l 2 0.219364 1.000000 0.000000 0.266371 0.455894 4.862345 -c  802.0
$PROGRAM  -l 2 0.219091 1.000000 0.000000 0.266039 0.456779 4.870432 -c  803.0
$PROGRAM  -l 2 0.218819 1.000000 0.000000 0.265708 0.457662 4.878518 -c  804.0
$PROGRAM  -l 2 0.218547 1.000000 0.000000 0.265378 0.458544 4.886601 -c  805.0
$PROGRAM  -l 2 0.218276 1.000000 0.000000 0.265049 0.459422 4.894682 -c  806.0
$PROGRAM  -l 2 0.218005 1.000000 0.000000 0.264720 0.460299 4.902762 -c  807.0
$PROGRAM  -l 2 0.217735 1.000000 0.000000 0.264393 0.461173 4.910840 -c  808.0
$PROGRAM  -l 2 0.217466 1.000000 0.000000 0.264066 0.462045 4.918916 -c  809.0
$PROGRAM  -l 2 0.217198 1.000000 0.000000 0.263740 0.462914 4.926991 -c  810.0
$PROGRAM  -l 2 0.216930 1.000000 0.000000 0.263415 0.463781 4.935062 -c  811.0
$PROGRAM  -l 2 0.216663 1.000000 0.000000 0.263090 0.464645 4.943133 -c  812.0
$PROGRAM  -l 2 0.216396 1.000000 0.000000 0.262767 0.465506 4.951203 -c  813.0
$PROGRAM  -l 2 0.216130 1.000000 0.000000 0.262444 0.466366 4.959270 -c  814.0
$PROGRAM  -l 2 0.215865 1.000000 0.000000 0.262122 0.467222 4.967336 -c  815.0
$PROGRAM  -l 2 0.215601 1.000000 0.000000 0.261801 0.468076 4.975400 -c  816.0
$PROGRAM  -l 2 0.215337 1.000000 0.000000 0.261480 0.468927 4.983462 -c  817.0
$PROGRAM  -l 2 0.215074 1.000000 0.000000 0.261161 0.469776 4.991522 -c  818.0
$PROGRAM  -l 2 0.214811 1.000000 0.000000 0.260842 0.470621 4.999580 -c  819.0
$PROGRAM  -l 2 0.214549 1.000000 0.000000 0.260524 0.471465 5.007637 -c  820.0
$PROGRAM  -l 2 0.214288 1.000000 0.000000 0.260206 0.472305 5.015692 -c  821.0
$PROGRAM  -l 2 0.214027 1.000000 0.000000 0.259890 0.473143 5.023744 -c  822.0
$PROGRAM  -l 2 0.213767 1.000000 0.000000 0.259574 0.473868 5.031893 -c  823.0
$PROGRAM  -l 2 0.213507 1.000000 0.000000 0.259259 0.474558 5.040067 -c  824.0
$PROGRAM  -l 2 0.213249 1.000000 0.000000 0.258945 0.475247 5.048238 -c  825.0
$PROGRAM  -l 2 0.212990 1.000000 0.000000 0.258631 0.475935 5.056405 -c  826.0
$PROGRAM  -l 2 0.212733 1.000000 0.000000 0.258319 0.476622 5.064569 -c  827.0
$PROGRAM  -l 2 0.212476 1.000000 0.000000 0.258007 0.477309 5.072728 -c  828.0
$PROGRAM  -l 2 0.212220 1.000000 0.000000 0.257695 0.477996 5.080884 -c  829.0
$PROGRAM  -l 2 0.211964 1.000000 0.000000 0.257385 0.478683 5.089035 -c  830.0
$PROGRAM  -l 2 0.211709 1.000000 0.000000 0.257075 0.479369 5.097181 -c  831.0
$PROGRAM  -l 2 0.211455 1.000000 0.000000 0.256766 0.480057 5.105322 -c  832.0
$PROGRAM  -l 2 0.211201 1.000000 0.000000 0.256458 0.480744 5.113459 -c  833.0
$PROGRAM  -l 2 0.210947 1.000000 0.000000 0.256150 0.481432 5.121591 -c  834.0
$PROGRAM  -l 2 0.210695 1.000000 0.000000 0.255844 0.482121 5.129718 -c  835.0
$PROGRAM  -l 2 0.210443 1.000000 0.000000 0.255538 0.482811 5.137839 -c  836.0
$PROGRAM  -l 2 0.210191 1.000000 0.000000 0.255232 0.483502 5.145954 -c  837.0
$PROGRAM  -l 2 0.209941 1.000000 0.000000 0.254928 0.484194 5.154064 -c  838.0
$PROGRAM  -l 2 0.209690 1.000000 0.000000 0.254624 0.484888 5.162168 -c  839.0
$PROGRAM  -l 2 0.209441 1.000000 0.000000 0.254321 0.485583 5.170266 -c  840.0
$PROGRAM  -l 2 0.209192 1.000000 0.000000 0.254018 0.486280 5.178357 -c  841.0
$PROGRAM  -l 2 0.208943 1.000000 0.000000 0.253717 0.486979 5.186444 -c  842.0
$PROGRAM  -l 2 0.208695 1.000000 0.000000 0.253416 0.487680 5.194522 -c  843.0
$PROGRAM  -l 2 0.208448 1.000000 0.000000 0.253116 0.488383 5.202594 -c  844.0
$PROGRAM  -l 2 0.208201 1.000000 0.000000 0.252816 0.489088 5.210661 -c  845.0
$PROGRAM  -l 2 0.207955 1.000000 0.000000 0.252517 0.489796 5.218720 -c  846.0
$PROGRAM  -l 2 0.207710 1.000000 0.000000 0.252219 0.490507 5.226772 -c  847.0
$PROGRAM  -l 2 0.207465 1.000000 0.000000 0.251922 0.491220 5.234816 -c  848.0
$PROGRAM  -l 2 0.207220 1.000000 0.000000 0.251625 0.491937 5.242854 -c  849.0
$PROGRAM  -l 2 0.206977 1.000000 0.000000 0.251329 0.492656 5.250884 -c  850.0
$PROGRAM  -l 2 0.206733 1.000000 0.000000 0.251033 0.493378 5.258907 -c  851.0
$PROGRAM  -l 2 0.206491 1.000000 0.000000 0.250739 0.494104 5.266922 -c  852.0
$PROGRAM  -l 2 0.206249 1.000000 0.000000 0.250445 0.494834 5.274929 -c  853.0
$PROGRAM  -l 2 0.206007 1.000000 0.000000 0.250152 0.495566 5.282928 -c  854.0
$PROGRAM  -l 2 0.205766 1.000000 0.000000 0.249859 0.496303 5.290920 -c  855.0
$PROGRAM  -l 2 0.205526 1.000000 0.000000 0.249567 0.497043 5.298903 -c  856.0
$PROGRAM  -l 2 0.205286 1.000000 0.000000 0.249276 0.497788 5.306879 -c  857.0
$PROGRAM  -l 2 0.205047 1.000000 0.000000 0.248985 0.498536 5.314845 -c  858.0
$PROGRAM  -l 2 0.204808 1.000000 0.000000 0.248696 0.499288 5.322804 -c  859.0
$PROGRAM  -l 2 0.204570 1.000000 0.000000 0.248406 0.500045 5.330754 -c  860.0
$PROGRAM  -l 2 0.204332 1.000000 0.000000 0.248118 0.500807 5.338695 -c  861.0
$PROGRAM  -l 2 0.204095 1.000000 0.000000 0.247830 0.501572 5.346628 -c  862.0
$PROGRAM  -l 2 0.203859 1.000000 0.000000 0.247543 0.502343 5.354552 -c  863.0
$PROGRAM  -l 2 0.203623 1.000000 0.000000 0.247256 0.503118 5.362466 -c  864.0
$PROGRAM  -l 2 0.203387 1.000000 0.000000 0.246971 0.503898 5.370374 -c  865.0
$PROGRAM  -l 2 0.203153 1.000000 0.000000 0.246685 0.504683 5.378270 -c  866.0
$PROGRAM  -l 2 0.202918 1.000000 0.000000 0.246401 0.505473 5.386158 -c  867.0
$PROGRAM  -l 2 0.202685 1.000000 0.000000 0.246117 0.506268 5.394037 -c  868.0
$PROGRAM  -l 2 0.202451 1.000000 0.000000 0.245834 0.507069 5.401906 -c  869.0
$PROGRAM  -l 2 0.202219 1.000000 0.000000 0.245551 0.507874 5.409766 -c  870.0
$PROGRAM  -l 2 0.201986 1.000000 0.000000 0.245269 0.508686 5.417617 -c  871.0
$PROGRAM  -l 2 0.201755 1.000000 0.000000 0.244988 0.509502 5.425458 -c  872.0
$PROGRAM  -l 2 0.201524 1.000000 0.000000 0.244707 0.510325 5.433290 -c  873.0
$PROGRAM  -l 2 0.201293 1.000000 0.000000 0.244427 0.511153 5.441112 -c  874.0
$PROGRAM  -l 2 0.201063 1.000000 0.000000 0.244148 0.511987 5.448923 -c  875.0
$PROGRAM  -l 2 0.200834 1.000000 0.000000 0.243869 0.512826 5.456726 -c  876.0
$PROGRAM  -l 2 0.200605 1.000000 0.000000 0.243591 0.513672 5.464518 -c  877.0
$PROGRAM  -l 2 0.200376 1.000000 0.000000 0.243314 0.514524 5.472301 -c  878.0
$PROGRAM  -l 2 0.200148 1.000000 0.000000 0.243037 0.515382 5.480074 -c  879.0
$PROGRAM  -l 2 0.199921 1.000000 0.000000 0.242761 0.516246 5.487836 -c  880.0
$PROGRAM  -l 2 0.199694 1.000000 0.000000 0.242485 0.517116 5.495589 -c  881.0
$PROGRAM  -l 2 0.199467 1.000000 0.000000 0.242210 0.517993 5.503332 -c  882.0
$PROGRAM  -l 2 0.199241 1.000000 0.000000 0.241936 0.518876 5.511064 -c  883.0
$PROGRAM  -l 2 0.199016 1.000000 0.000000 0.241662 0.519765 5.518788 -c  884.0
$PROGRAM  -l 2 0.198791 1.000000 0.000000 0.241389 0.520661 5.526500 -c  885.0
$PROGRAM  -l 2 0.198567 1.000000 0.000000 0.241117 0.521564 5.534201 -c  886.0
$PROGRAM  -l 2 0.198343 1.000000 0.000000 0.240845 0.522473 5.541893 -c  887.0
$PROGRAM  -l 2 0.198120 1.000000 0.000000 0.240574 0.523389 5.549575 -c  888.0
$PROGRAM  -l 2 0.197897 1.000000 0.000000 0.240303 0.524312 5.557246 -c  889.0
$PROGRAM  -l 2 0.197674 1.000000 0.000000 0.240033 0.525241 5.564907 -c  890.0
$PROGRAM  -l 2 0.197453 1.000000 0.000000 0.239764 0.526178 5.572557 -c  891.0
$PROGRAM  -l 2 0.197231 1.000000 0.000000 0.239495 0.527121 5.580197 -c  892.0
$PROGRAM  -l 2 0.197010 1.000000 0.000000 0.239227 0.528071 5.587827 -c  893.0
$PROGRAM  -l 2 0.196790 1.000000 0.000000 0.238959 0.529153 5.595280 -c  894.0
$PROGRAM  -l 2 0.196570 1.000000 0.000000 0.238692 0.530277 5.602678 -c  895.0
$PROGRAM  -l 2 0.196351 1.000000 0.000000 0.238426 0.531407 5.610065 -c  896.0
$PROGRAM  -l 2 0.196132 1.000000 0.000000 0.238160 0.532544 5.617444 -c  897.0
$PROGRAM  -l 2 0.195913 1.000000 0.000000 0.237895 0.533686 5.624814 -c  898.0
$PROGRAM  -l 2 0.195695 1.000000 0.000000 0.237630 0.534834 5.632175 -c  899.0
$PROGRAM  -l 2 0.195478 1.000000 0.000000 0.237366 0.535988 5.639527 -c  900.0
$PROGRAM  -l 2 0.195261 1.000000 0.000000 0.237103 0.537148 5.646872 -c  901.0
$PROGRAM  -l 2 0.195045 1.000000 0.000000 0.236840 0.538313 5.654209 -c  902.0
$PROGRAM  -l 2 0.194829 1.000000 0.000000 0.236578 0.539484 5.661537 -c  903.0
$PROGRAM  -l 2 0.194613 1.000000 0.000000 0.236316 0.540660 5.668857 -c  904.0
$PROGRAM  -l 2 0.194398 1.000000 0.000000 0.236055 0.541841 5.676171 -c  905.0
$PROGRAM  -l 2 0.194183 1.000000 0.000000 0.235794 0.543027 5.683477 -c  906.0
$PROGRAM  -l 2 0.193969 1.000000 0.000000 0.235534 0.544218 5.690776 -c  907.0
$PROGRAM  -l 2 0.193756 1.000000 0.000000 0.235275 0.545414 5.698068 -c  908.0
$PROGRAM  -l 2 0.193543 1.000000 0.000000 0.235016 0.546615 5.705353 -c  909.0
$PROGRAM  -l 2 0.193330 1.000000 0.000000 0.234758 0.547821 5.712632 -c  910.0
$PROGRAM  -l 2 0.193118 1.000000 0.000000 0.234500 0.549031 5.719905 -c  911.0
$PROGRAM  -l 2 0.192906 1.000000 0.000000 0.234243 0.550245 5.727170 -c  912.0
$PROGRAM  -l 2 0.192695 1.000000 0.000000 0.233986 0.551464 5.734430 -c  913.0
$PROGRAM  -l 2 0.192484 1.000000 0.000000 0.233730 0.552687 5.741684 -c  914.0
$PROGRAM  -l 2 0.192273 1.000000 0.000000 0.233475 0.553915 5.748933 -c  915.0
$PROGRAM  -l 2 0.192064 1.000000 0.000000 0.233220 0.555146 5.756176 -c  916.0
$PROGRAM  -l 2 0.191854 1.000000 0.000000 0.232966 0.556381 5.763414 -c  917.0
$PROGRAM  -l 2 0.191645 1.000000 0.000000 0.232712 0.557621 5.770646 -c  918.0
$PROGRAM  -l 2 0.191437 1.000000 0.000000 0.232459 0.558863 5.777873 -c  919.0
$PROGRAM  -l 2 0.191229 1.000000 0.000000 0.232206 0.560110 5.785096 -c  920.0
$PROGRAM  -l 2 0.191021 1.000000 0.000000 0.231954 0.561360 5.792314 -c  921.0
$PROGRAM  -l 2 0.190814 1.000000 0.000000 0.231702 0.562614 5.799528 -c  922.0
$PROGRAM  -l 2 0.190607 1.000000 0.000000 0.231451 0.563871 5.806737 -c  923.0
$PROGRAM  -l 2 0.190401 1.000000 0.000000 0.231201 0.565131 5.813941 -c  924.0
$PROGRAM  -l 2 0.190195 1.000000 0.000000 0.230951 0.566394 5.821142 -c  925.0
$PROGRAM  -l 2 0.189989 1.000000 0.000000 0.230701 0.567661 5.828340 -c  926.0
$PROGRAM  -l 2 0.189785 1.000000 0.000000 0.230453 0.568930 5.835532 -c  927.0
$PROGRAM  -l 2 0.189580 1.000000 0.000000 0.230204 0.570203 5.842723 -c  928.0
$PROGRAM  -l 2 0.189376 1.000000 0.000000 0.229956 0.571478 5.849909 -c  929.0
$PROGRAM  -l 2 0.189172 1.000000 0.000000 0.229709 0.572756 5.857092 -c  930.0
$PROGRAM  -l 2 0.188969 1.000000 0.000000 0.229462 0.574037 5.864273 -c  931.0
$PROGRAM  -l 2 0.188766 1.000000 0.000000 0.229216 0.575320 5.871450 -c  932.0
$PROGRAM  -l 2 0.188564 1.000000 0.000000 0.228971 0.576605 5.878625 -c  933.0
$PROGRAM  -l 2 0.188362 1.000000 0.000000 0.228725 0.577893 5.885796 -c  934.0
$PROGRAM  -l 2 0.188161 1.000000 0.000000 0.228481 0.579184 5.892965 -c  935.0
$PROGRAM  -l 2 0.187960 1.000000 0.000000 0.228237 0.580476 5.900132 -c  936.0
$PROGRAM  -l 2 0.187759 1.000000 0.000000 0.227993 0.581771 5.907297 -c  937.0
$PROGRAM  -l 2 0.187559 1.000000 0.000000 0.227750 0.583068 5.914459 -c  938.0
$PROGRAM  -l 2 0.187359 1.000000 0.000000 0.227508 0.584366 5.921620 -c  939.0
$PROGRAM  -l 2 0.187160 1.000000 0.000000 0.227266 0.585667 5.928779 -c  940.0
$PROGRAM  -l 2 0.186961 1.000000 0.000000 0.227024 0.586969 5.935936 -c  941.0
$PROGRAM  -l 2 0.186762 1.000000 0.000000 0.226783 0.588274 5.943092 -c  942.0
$PROGRAM  -l 2 0.186564 1.000000 0.000000 0.226543 0.589579 5.950246 -c  943.0
$PROGRAM  -l 2 0.186367 1.000000 0.000000 0.226303 0.590887 5.957399 -c  944.0
$PROGRAM  -l 2 0.186170 1.000000 0.000000 0.226063 0.592196 5.964551 -c  945.0
$PROGRAM  -l 2 0.185973 1.000000 0.000000 0.225824 0.593506 5.971702 -c  946.0
$PROGRAM  -l 2 0.185776 1.000000 0.000000 0.225586 0.594818 5.978852 -c  947.0
$PROGRAM  -l 2 0.185580 1.000000 0.000000 0.225348 0.596131 5.986001 -c  948.0
$PROGRAM  -l 2 0.185385 1.000000 0.000000 0.225110 0.597445 5.993150 -c  949.0
$PROGRAM  -l 2 0.185190 1.000000 0.000000 0.224873 0.598760 6.000299 -c  950.0
$PROGRAM  -l 2 0.184995 1.000000 0.000000 0.224637 0.600077 6.007446 -c  951.0
$PROGRAM  -l 2 0.184801 1.000000 0.000000 0.224401 0.601394 6.014594 -c  952.0
$PROGRAM  -l 2 0.184607 1.000000 0.000000 0.224165 0.602713 6.021741 -c  953.0
$PROGRAM  -l 2 0.184413 1.000000 0.000000 0.223930 0.604032 6.028889 -c  954.0
$PROGRAM  -l 2 0.184220 1.000000 0.000000 0.223696 0.605352 6.036037 -c  955.0
$PROGRAM  -l 2 0.184027 1.000000 0.000000 0.223462 0.606673 6.043184 -c  956.0
$PROGRAM  -l 2 0.183835 1.000000 0.000000 0.223228 0.607994 6.050332 -c  957.0
$PROGRAM  -l 2 0.183643 1.000000 0.000000 0.222995 0.609316 6.057481 -c  958.0
$PROGRAM  -l 2 0.183452 1.000000 0.000000 0.222763 0.610639 6.064630 -c  959.0
$PROGRAM  -l 2 0.183261 1.000000 0.000000 0.222531 0.611962 6.071780 -c  960.0
$PROGRAM  -l 2 0.183070 1.000000 0.000000 0.222299 0.613286 6.078930 -c  961.0
$PROGRAM  -l 2 0.182880 1.000000 0.000000 0.222068 0.614610 6.086081 -c  962.0
$PROGRAM  -l 2 0.182690 1.000000 0.000000 0.221838 0.615934 6.093234 -c  963.0
$PROGRAM  -l 2 0.182500 1.000000 0.000000 0.221607 0.617258 6.100387 -c  964.0
$PROGRAM  -l 2 0.182311 1.000000 0.000000 0.221378 0.618583 6.107542 -c  965.0
$PROGRAM  -l 2 0.182122 1.000000 0.000000 0.221149 0.619908 6.114698 -c  966.0
$PROGRAM  -l 2 0.181934 1.000000 0.000000 0.220920 0.621233 6.121855 -c  967.0
$PROGRAM  -l 2 0.181746 1.000000 0.000000 0.220692 0.622557 6.129013 -c  968.0
$PROGRAM  -l 2 0.181559 1.000000 0.000000 0.220464 0.623882 6.136174 -c  969.0
$PROGRAM  -l 2 0.181371 1.000000 0.000000 0.220237 0.625207 6.143337 -c  970.0
$PROGRAM  -l 2 0.181185 1.000000 0.000000 0.220010 0.626532 6.150499 -c  971.0
$PROGRAM  -l 2 0.180998 1.000000 0.000000 0.219784 0.627856 6.157665 -c  972.0
$PROGRAM  -l 2 0.180812 1.000000 0.000000 0.219558 0.629180 6.164833 -c  973.0
$PROGRAM  -l 2 0.180627 1.000000 0.000000 0.219332 0.630504 6.172002 -c  974.0
$PROGRAM  -l 2 0.180441 1.000000 0.000000 0.219107 0.631828 6.179173 -c  975.0
$PROGRAM  -l 2 0.180256 1.000000 0.000000 0.218883 0.633151 6.186347 -c  976.0
$PROGRAM  -l 2 0.180072 1.000000 0.000000 0.218659 0.634474 6.193524 -c  977.0
$PROGRAM  -l 2 0.179888 1.000000 0.000000 0.218435 0.635796 6.200702 -c  978.0
$PROGRAM  -l 2 0.179704 1.000000 0.000000 0.218212 0.637118 6.207883 -c  979.0
$PROGRAM  -l 2 0.179521 1.000000 0.000000 0.217989 0.638439 6.215066 -c  980.0
$PROGRAM  -l 2 0.179338 1.000000 0.000000 0.217767 0.639760 6.222252 -c  981.0
$PROGRAM  -l 2 0.179155 1.000000 0.000000 0.217545 0.641080 6.229441 -c  982.0
$PROGRAM  -l 2 0.178973 1.000000 0.000000 0.217324 0.642399 6.236633 -c  983.0
$PROGRAM  -l 2 0.178791 1.000000 0.000000 0.217103 0.643717 6.243827 -c  984.0
$PROGRAM  -l 2 0.178609 1.000000 0.000000 0.216883 0.645035 6.251024 -c  985.0
$PROGRAM  -l 2 0.178428 1.000000 0.000000 0.216663 0.646284 6.258314 -c  986.0
$PROGRAM  -l 2 0.178247 1.000000 0.000000 0.216443 0.647490 6.265660 -c  987.0
$PROGRAM  -l 2 0.178067 1.000000 0.000000 0.216224 0.648696 6.273009 -c  988.0
$PROGRAM  -l 2 0.177887 1.000000 0.000000 0.216006 0.649902 6.280359 -c  989.0
$PROGRAM  -l 2 0.177707 1.000000 0.000000 0.215788 0.651108 6.287711 -c  990.0
$PROGRAM  -l 2 0.177528 1.000000 0.000000 0.215570 0.652313 6.295067 -c  991.0
$PROGRAM  -l 2 0.177349 1.000000 0.000000 0.215352 0.653519 6.302423 -c  992.0
$PROGRAM  -l 2 0.177170 1.000000 0.000000 0.215136 0.654726 6.309781 -c  993.0
$PROGRAM  -l 2 0.176992 1.000000 0.000000 0.214919 0.655932 6.317142 -c  994.0
$PROGRAM  -l 2 0.176814 1.000000 0.000000 0.214703 0.657138 6.324504 -c  995.0
$PROGRAM  -l 2 0.176637 1.000000 0.000000 0.214488 0.658344 6.331868 -c  996.0
$PROGRAM  -l 2 0.176460 1.000000 0.000000 0.214272 0.659551 6.339234 -c  997.0
$PROGRAM  -l 2 0.176283 1.000000 0.000000 0.214058 0.660758 6.346602 -c  998.0
$PROGRAM  -l 2 0.176106 1.000000 0.000000 0.213843 0.661965 6.353971 -c  999.0
$PROGRAM  -l 2 0.175930 1.000000 0.000000 0.213630 0.663173 6.361342 -c 1000.0
$PROGRAM  -l 2 0.175755 1.000000 0.000000 0.213416 0.664380 6.368715 -c 1001.0
$PROGRAM  -l 2 0.175579 1.000000 0.000000 0.213203 0.665589 6.376090 -c 1002.0
$PROGRAM  -l 2 0.175404 1.000000 0.000000 0.212991 0.666797 6.383466 -c 1003.0
$PROGRAM  -l 2 0.175229 1.000000 0.000000 0.212779 0.668006 6.390844 -c 1004.0
$PROGRAM  -l 2 0.175055 1.000000 0.000000 0.212567 0.669216 6.398224 -c 1005.0
$PROGRAM  -l 2 0.174881 1.000000 0.000000 0.212356 0.670425 6.405605 -c 1006.0
$PROGRAM  -l 2 0.174707 1.000000 0.000000 0.212145 0.671636 6.412988 -c 1007.0
$PROGRAM  -l 2 0.174534 1.000000 0.000000 0.211934 0.672847 6.420372 -c 1008.0
$PROGRAM  -l 2 0.174361 1.000000 0.000000 0.211724 0.674058 6.427758 -c 1009.0
$PROGRAM  -l 2 0.174188 1.000000 0.000000 0.211515 0.675270 6.435145 -c 1010.0
$PROGRAM  -l 2 0.174016 1.000000 0.000000 0.211305 0.676483 6.442534 -c 1011.0
$PROGRAM  -l 2 0.173844 1.000000 0.000000 0.211096 0.677697 6.449925 -c 1012.0
$PROGRAM  -l 2 0.173673 1.000000 0.000000 0.210888 0.678911 6.457316 -c 1013.0
$PROGRAM  -l 2 0.173501 1.000000 0.000000 0.210680 0.680126 6.464710 -c 1014.0
$PROGRAM  -l 2 0.173330 1.000000 0.000000 0.210473 0.681341 6.472105 -c 1015.0
$PROGRAM  -l 2 0.173160 1.000000 0.000000 0.210265 0.682557 6.479501 -c 1016.0
$PROGRAM  -l 2 0.172989 1.000000 0.000000 0.210059 0.683774 6.486898 -c 1017.0
$PROGRAM  -l 2 0.172820 1.000000 0.000000 0.209852 0.684992 6.494297 -c 1018.0
$PROGRAM  -l 2 0.172650 1.000000 0.000000 0.209646 0.686211 6.501697 -c 1019.0
$PROGRAM  -l 2 0.172481 1.000000 0.000000 0.209441 0.687431 6.509098 -c 1020.0
$PROGRAM  -l 2 0.172312 1.000000 0.000000 0.209236 0.688651 6.516501 -c 1021.0
$PROGRAM  -l 2 0.172143 1.000000 0.000000 0.209031 0.689872 6.523904 -c 1022.0
$PROGRAM  -l 2 0.171975 1.000000 0.000000 0.208827 0.691095 6.531309 -c 1023.0
$PROGRAM  -l 2 0.171807 1.000000 0.000000 0.208623 0.692318 6.538715 -c 1024.0
$PROGRAM  -l 2 0.171639 1.000000 0.000000 0.208419 0.693543 6.546123 -c 1025.0
$PROGRAM  -l 2 0.171472 1.000000 0.000000 0.208216 0.694768 6.553532 -c 1026.0
$PROGRAM  -l 2 0.171305 1.000000 0.000000 0.208013 0.695994 6.560942 -c 1027.0
$PROGRAM  -l 2 0.171138 1.000000 0.000000 0.207811 0.697222 6.568352 -c 1028.0
$PROGRAM  -l 2 0.170972 1.000000 0.000000 0.207609 0.698450 6.575764 -c 1029.0
$PROGRAM  -l 2 0.170806 1.000000 0.000000 0.207407 0.699680 6.583178 -c 1030.0
$PROGRAM  -l 2 0.170640 1.000000 0.000000 0.207206 0.700911 6.590591 -c 1031.0
$PROGRAM  -l 2 0.170475 1.000000 0.000000 0.207005 0.702143 6.598006 -c 1032.0
$PROGRAM  -l 2 0.170310 1.000000 0.000000 0.206805 0.703376 6.605423 -c 1033.0
$PROGRAM  -l 2 0.170145 1.000000 0.000000 0.206605 0.704610 6.612840 -c 1034.0
$PROGRAM  -l 2 0.169981 1.000000 0.000000 0.206405 0.705846 6.620258 -c 1035.0
$PROGRAM  -l 2 0.169817 1.000000 0.000000 0.206206 0.707082 6.627677 -c 1036.0
$PROGRAM  -l 2 0.169653 1.000000 0.000000 0.206007 0.708321 6.635097 -c 1037.0
$PROGRAM  -l 2 0.169490 1.000000 0.000000 0.205809 0.709560 6.642518 -c 1038.0
$PROGRAM  -l 2 0.169327 1.000000 0.000000 0.205611 0.710801 6.649940 -c 1039.0
$PROGRAM  -l 2 0.169164 1.000000 0.000000 0.205413 0.712043 6.657362 -c 1040.0
$PROGRAM  -l 2 0.169001 1.000000 0.000000 0.205216 0.713286 6.664786 -c 1041.0
$PROGRAM  -l 2 0.168839 1.000000 0.000000 0.205019 0.714531 6.672209 -c 1042.0
$PROGRAM  -l 2 0.168677 1.000000 0.000000 0.204822 0.715777 6.679635 -c 1043.0
$PROGRAM  -l 2 0.168516 1.000000 0.000000 0.204626 0.717024 6.687061 -c 1044.0
$PROGRAM  -l 2 0.168354 1.000000 0.000000 0.204430 0.718273 6.694487 -c 1045.0
$PROGRAM  -l 2 0.168193 1.000000 0.000000 0.204235 0.719524 6.701915 -c 1046.0
$PROGRAM  -l 2 0.168033 1.000000 0.000000 0.204040 0.720775 6.709343 -c 1047.0
$PROGRAM  -l 2 0.167872 1.000000 0.000000 0.203845 0.722029 6.716772 -c 1048.0
$PROGRAM  -l 2 0.167712 1.000000 0.000000 0.203651 0.723284 6.724202 -c 1049.0
$PROGRAM  -l 2 0.167553 1.000000 0.000000 0.203457 0.724540 6.731632 -c 1050.0
$PROGRAM  -l 2 0.167393 1.000000 0.000000 0.203263 0.725798 6.739063 -c 1051.0
$PROGRAM  -l 2 0.167234 1.000000 0.000000 0.203070 0.727057 6.746493 -c 1052.0
$PROGRAM  -l 2 0.167075 1.000000 0.000000 0.202877 0.728318 6.753926 -c 1053.0
$PROGRAM  -l 2 0.166917 1.000000 0.000000 0.202685 0.729581 6.761359 -c 1054.0
$PROGRAM  -l 2 0.166759 1.000000 0.000000 0.202493 0.730845 6.768792 -c 1055.0
$PROGRAM  -l 2 0.166601 1.000000 0.000000 0.202301 0.732111 6.776226 -c 1056.0
$PROGRAM  -l 2 0.166443 1.000000 0.000000 0.202109 0.733378 6.783660 -c 1057.0
$PROGRAM  -l 2 0.166286 1.000000 0.000000 0.201918 0.734647 6.791095 -c 1058.0
$PROGRAM  -l 2 0.166129 1.000000 0.000000 0.201728 0.735918 6.798531 -c 1059.0
$PROGRAM  -l 2 0.165972 1.000000 0.000000 0.201537 0.737190 6.805967 -c 1060.0
$PROGRAM  -l 2 0.165816 1.000000 0.000000 0.201347 0.738464 6.813403 -c 1061.0
$PROGRAM  -l 2 0.165659 1.000000 0.000000 0.201158 0.739740 6.820840 -c 1062.0
$PROGRAM  -l 2 0.165504 1.000000 0.000000 0.200969 0.741018 6.828277 -c 1063.0
$PROGRAM  -l 2 0.165348 1.000000 0.000000 0.200780 0.742297 6.835715 -c 1064.0
$PROGRAM  -l 2 0.165193 1.000000 0.000000 0.200591 0.743578 6.843152 -c 1065.0
$PROGRAM  -l 2 0.165038 1.000000 0.000000 0.200403 0.744861 6.850590 -c 1066.0
$PROGRAM  -l 2 0.164883 1.000000 0.000000 0.200215 0.746145 6.858030 -c 1067.0
$PROGRAM  -l 2 0.164729 1.000000 0.000000 0.200028 0.747431 6.865469 -c 1068.0
$PROGRAM  -l 2 0.164575 1.000000 0.000000 0.199841 0.748720 6.872908 -c 1069.0
$PROGRAM  -l 2 0.164421 1.000000 0.000000 0.199654 0.750010 6.880348 -c 1070.0
$PROGRAM  -l 2 0.164267 1.000000 0.000000 0.199468 0.751301 6.887788 -c 1071.0
$PROGRAM  -l 2 0.164114 1.000000 0.000000 0.199281 0.752595 6.895228 -c 1072.0
$PROGRAM  -l 2 0.163961 1.000000 0.000000 0.199096 0.753890 6.902669 -c 1073.0
$PROGRAM  -l 2 0.163809 1.000000 0.000000 0.198910 0.755188 6.910110 -c 1074.0
$PROGRAM  -l 2 0.163656 1.000000 0.000000 0.198725 0.756487 6.917551 -c 1075.0
$PROGRAM  -l 2 0.163504 1.000000 0.000000 0.198541 0.757788 6.924992 -c 1076.0
$PROGRAM  -l 2 0.163352 1.000000 0.000000 0.198356 0.759090 6.932434 -c 1077.0
$PROGRAM  -l 2 0.163201 1.000000 0.000000 0.198172 0.760395 6.939875 -c 1078.0
$PROGRAM  -l 2 0.163049 1.000000 0.000000 0.197989 0.761702 6.947317 -c 1079.0
$PROGRAM  -l 2 0.162898 1.000000 0.000000 0.197805 0.763010 6.954759 -c 1080.0
$PROGRAM  -l 2 0.162748 1.000000 0.000000 0.197622 0.764321 6.962200 -c 1081.0
$PROGRAM  -l 2 0.162597 1.000000 0.000000 0.197440 0.765633 6.969643 -c 1082.0
$PROGRAM  -l 2 0.162447 1.000000 0.000000 0.197257 0.766948 6.977085 -c 1083.0
$PROGRAM  -l 2 0.162297 1.000000 0.000000 0.197075 0.768264 6.984528 -c 1084.0
$PROGRAM  -l 2 0.162148 1.000000 0.000000 0.196894 0.769582 6.991970 -c 1085.0
$PROGRAM  -l 2 0.161998 1.000000 0.000000 0.196712 0.770903 6.999412 -c 1086.0
$PROGRAM  -l 2 0.161849 1.000000 0.000000 0.196531 0.772225 7.006855 -c 1087.0
$PROGRAM  -l 2 0.161701 1.000000 0.000000 0.196351 0.773549 7.014298 -c 1088.0
$PROGRAM  -l 2 0.161552 1.000000 0.000000 0.196171 0.774875 7.021740 -c 1089.0
$PROGRAM  -l 2 0.161404 1.000000 0.000000 0.195991 0.776273 7.029177 -c 1090.0
$PROGRAM  -l 2 0.161256 1.000000 0.000000 0.195811 0.777682 7.036613 -c 1091.0
$PROGRAM  -l 2 0.161108 1.000000 0.000000 0.195632 0.779092 7.044050 -c 1092.0
$PROGRAM  -l 2 0.160961 1.000000 0.000000 0.195453 0.780504 7.051486 -c 1093.0
$PROGRAM  -l 2 0.160814 1.000000 0.000000 0.195274 0.781917 7.058922 -c 1094.0
$PROGRAM  -l 2 0.160667 1.000000 0.000000 0.195096 0.783332 7.066358 -c 1095.0
$PROGRAM  -l 2 0.160520 1.000000 0.000000 0.194918 0.784748 7.073795 -c 1096.0
$PROGRAM  -l 2 0.160374 1.000000 0.000000 0.194740 0.786166 7.081231 -c 1097.0
$PROGRAM  -l 2 0.160228 1.000000 0.000000 0.194563 0.787586 7.088667 -c 1098.0
$PROGRAM  -l 2 0.160082 1.000000 0.000000 0.194386 0.789007 7.096102 -c 1099.0
$PROGRAM  -l 2 0.159937 1.000000 0.000000 0.194209 0.790430 7.103539 -c 1100.0
