#! /bin/sh
# This is a test against the program n-mie (version 3a) for the test case
# distributed by them (extended for x up to 100)
# n-mie is based in the algorithm described in:
# Wu Z.P., Wang Y.P.
# Electromagnetic scattering for multilayered spheres:
# recursive algorithms
# Radio Science 1991. V. 26. P. 1393-1401.
# Voshchinnikov N.V., Mathis J.S.
# Calculating Cross Sections of Composite Interstellar Grains
# Astrophys. J. 1999. V. 526. #1. 
# 
# The test consist in 5 layers with the following parameters
# m1=1.8 i1.7
# m2=0.8 i0.7
# m3=1.2 i0.09
# m4=2.8 i0.2
# m5=1.5 i0.4
# 
# v1/Vt=0.1
# v2/Vt=0.26
# v3/Vt=0.044
# v4/Vt=0.3666

PROGRAM='../../../scattnlay'

$PROGRAM -l 5 0.4642 1.8000 1.7000 0.7114 0.8000 0.7000 0.7393 1.2000 0.0900 0.9168 2.8000 0.2000 1.0000 1.5000 0.4000 -c 1.0
$PROGRAM -l 5 0.9283 1.8000 1.7000 1.4228 0.8000 0.7000 1.4785 1.2000 0.0900 1.8336 2.8000 0.2000 2.0000 1.5000 0.4000 -c 2.0
$PROGRAM -l 5 1.3925 1.8000 1.7000 2.1341 0.8000 0.7000 2.2178 1.2000 0.0900 2.7504 2.8000 0.2000 3.0000 1.5000 0.4000 -c 3.0
$PROGRAM -l 5 1.8566 1.8000 1.7000 2.8455 0.8000 0.7000 2.9570 1.2000 0.0900 3.6672 2.8000 0.2000 4.0000 1.5000 0.4000 -c 4.0
$PROGRAM -l 5 2.3208 1.8000 1.7000 3.5569 0.8000 0.7000 3.6963 1.2000 0.0900 4.5840 2.8000 0.2000 5.0000 1.5000 0.4000 -c 5.0
$PROGRAM -l 5 2.7850 1.8000 1.7000 4.2683 0.8000 0.7000 4.4355 1.2000 0.0900 5.5008 2.8000 0.2000 6.0000 1.5000 0.4000 -c 6.0
$PROGRAM -l 5 3.2491 1.8000 1.7000 4.9797 0.8000 0.7000 5.1748 1.2000 0.0900 6.4176 2.8000 0.2000 7.0000 1.5000 0.4000 -c 7.0
$PROGRAM -l 5 3.7133 1.8000 1.7000 5.6910 0.8000 0.7000 5.9140 1.2000 0.0900 7.3344 2.8000 0.2000 8.0000 1.5000 0.4000 -c 8.0
$PROGRAM -l 5 4.1774 1.8000 1.7000 6.4024 0.8000 0.7000 6.6533 1.2000 0.0900 8.2512 2.8000 0.2000 9.0000 1.5000 0.4000 -c 9.0
$PROGRAM -l 5 4.6416 1.8000 1.7000 7.1138 0.8000 0.7000 7.3925 1.2000 0.0900 9.1680 2.8000 0.2000 10.0000 1.5000 0.4000 -c 10.0
$PROGRAM -l 5 5.1057 1.8000 1.7000 7.8252 0.8000 0.7000 8.1318 1.2000 0.0900 10.0848 2.8000 0.2000 11.0000 1.5000 0.4000 -c 11.0
$PROGRAM -l 5 5.5699 1.8000 1.7000 8.5365 0.8000 0.7000 8.8711 1.2000 0.0900 11.0016 2.8000 0.2000 12.0000 1.5000 0.4000 -c 12.0
$PROGRAM -l 5 6.0341 1.8000 1.7000 9.2479 0.8000 0.7000 9.6103 1.2000 0.0900 11.9184 2.8000 0.2000 13.0000 1.5000 0.4000 -c 13.0
$PROGRAM -l 5 6.4982 1.8000 1.7000 9.9593 0.8000 0.7000 10.3496 1.2000 0.0900 12.8353 2.8000 0.2000 14.0000 1.5000 0.4000 -c 14.0
$PROGRAM -l 5 6.9624 1.8000 1.7000 10.6707 0.8000 0.7000 11.0888 1.2000 0.0900 13.7521 2.8000 0.2000 15.0000 1.5000 0.4000 -c 15.0
$PROGRAM -l 5 7.4265 1.8000 1.7000 11.3821 0.8000 0.7000 11.8281 1.2000 0.0900 14.6689 2.8000 0.2000 16.0000 1.5000 0.4000 -c 16.0
$PROGRAM -l 5 7.8907 1.8000 1.7000 12.0934 0.8000 0.7000 12.5673 1.2000 0.0900 15.5857 2.8000 0.2000 17.0000 1.5000 0.4000 -c 17.0
$PROGRAM -l 5 8.3549 1.8000 1.7000 12.8048 0.8000 0.7000 13.3066 1.2000 0.0900 16.5025 2.8000 0.2000 18.0000 1.5000 0.4000 -c 18.0
$PROGRAM -l 5 8.8190 1.8000 1.7000 13.5162 0.8000 0.7000 14.0458 1.2000 0.0900 17.4193 2.8000 0.2000 19.0000 1.5000 0.4000 -c 19.0
$PROGRAM -l 5 9.2832 1.8000 1.7000 14.2276 0.8000 0.7000 14.7851 1.2000 0.0900 18.3361 2.8000 0.2000 20.0000 1.5000 0.4000 -c 20.0
$PROGRAM -l 5 9.7473 1.8000 1.7000 14.9390 0.8000 0.7000 15.5243 1.2000 0.0900 19.2529 2.8000 0.2000 21.0000 1.5000 0.4000 -c 21.0
$PROGRAM -l 5 10.2115 1.8000 1.7000 15.6503 0.8000 0.7000 16.2636 1.2000 0.0900 20.1697 2.8000 0.2000 22.0000 1.5000 0.4000 -c 22.0
$PROGRAM -l 5 10.6757 1.8000 1.7000 16.3617 0.8000 0.7000 17.0028 1.2000 0.0900 21.0865 2.8000 0.2000 23.0000 1.5000 0.4000 -c 23.0
$PROGRAM -l 5 11.1398 1.8000 1.7000 17.0731 0.8000 0.7000 17.7421 1.2000 0.0900 22.0033 2.8000 0.2000 24.0000 1.5000 0.4000 -c 24.0
$PROGRAM -l 5 11.6040 1.8000 1.7000 17.7845 0.8000 0.7000 18.4814 1.2000 0.0900 22.9201 2.8000 0.2000 25.0000 1.5000 0.4000 -c 25.0
$PROGRAM -l 5 12.0681 1.8000 1.7000 18.4958 0.8000 0.7000 19.2206 1.2000 0.0900 23.8369 2.8000 0.2000 26.0000 1.5000 0.4000 -c 26.0
$PROGRAM -l 5 12.5323 1.8000 1.7000 19.2072 0.8000 0.7000 19.9599 1.2000 0.0900 24.7537 2.8000 0.2000 27.0000 1.5000 0.4000 -c 27.0
$PROGRAM -l 5 12.9964 1.8000 1.7000 19.9186 0.8000 0.7000 20.6991 1.2000 0.0900 25.6705 2.8000 0.2000 28.0000 1.5000 0.4000 -c 28.0
$PROGRAM -l 5 13.4606 1.8000 1.7000 20.6300 0.8000 0.7000 21.4384 1.2000 0.0900 26.5873 2.8000 0.2000 29.0000 1.5000 0.4000 -c 29.0
$PROGRAM -l 5 13.9248 1.8000 1.7000 21.3414 0.8000 0.7000 22.1776 1.2000 0.0900 27.5041 2.8000 0.2000 30.0000 1.5000 0.4000 -c 30.0
$PROGRAM -l 5 14.3889 1.8000 1.7000 22.0527 0.8000 0.7000 22.9169 1.2000 0.0900 28.4209 2.8000 0.2000 31.0000 1.5000 0.4000 -c 31.0
$PROGRAM -l 5 14.8531 1.8000 1.7000 22.7641 0.8000 0.7000 23.6561 1.2000 0.0900 29.3377 2.8000 0.2000 32.0000 1.5000 0.4000 -c 32.0
$PROGRAM -l 5 15.3172 1.8000 1.7000 23.4755 0.8000 0.7000 24.3954 1.2000 0.0900 30.2545 2.8000 0.2000 33.0000 1.5000 0.4000 -c 33.0
$PROGRAM -l 5 15.7814 1.8000 1.7000 24.1869 0.8000 0.7000 25.1346 1.2000 0.0900 31.1713 2.8000 0.2000 34.0000 1.5000 0.4000 -c 34.0
$PROGRAM -l 5 16.2456 1.8000 1.7000 24.8983 0.8000 0.7000 25.8739 1.2000 0.0900 32.0881 2.8000 0.2000 35.0000 1.5000 0.4000 -c 35.0
$PROGRAM -l 5 16.7097 1.8000 1.7000 25.6096 0.8000 0.7000 26.6132 1.2000 0.0900 33.0049 2.8000 0.2000 36.0000 1.5000 0.4000 -c 36.0
$PROGRAM -l 5 17.1739 1.8000 1.7000 26.3210 0.8000 0.7000 27.3524 1.2000 0.0900 33.9217 2.8000 0.2000 37.0000 1.5000 0.4000 -c 37.0
$PROGRAM -l 5 17.6380 1.8000 1.7000 27.0324 0.8000 0.7000 28.0917 1.2000 0.0900 34.8385 2.8000 0.2000 38.0000 1.5000 0.4000 -c 38.0
$PROGRAM -l 5 18.1022 1.8000 1.7000 27.7438 0.8000 0.7000 28.8309 1.2000 0.0900 35.7553 2.8000 0.2000 39.0000 1.5000 0.4000 -c 39.0
$PROGRAM -l 5 18.5664 1.8000 1.7000 28.4551 0.8000 0.7000 29.5702 1.2000 0.0900 36.6721 2.8000 0.2000 40.0000 1.5000 0.4000 -c 40.0
$PROGRAM -l 5 19.0305 1.8000 1.7000 29.1665 0.8000 0.7000 30.3094 1.2000 0.0900 37.5889 2.8000 0.2000 41.0000 1.5000 0.4000 -c 41.0
$PROGRAM -l 5 19.4947 1.8000 1.7000 29.8779 0.8000 0.7000 31.0487 1.2000 0.0900 38.5058 2.8000 0.2000 42.0000 1.5000 0.4000 -c 42.0
$PROGRAM -l 5 19.9588 1.8000 1.7000 30.5893 0.8000 0.7000 31.7879 1.2000 0.0900 39.4226 2.8000 0.2000 43.0000 1.5000 0.4000 -c 43.0
$PROGRAM -l 5 20.4230 1.8000 1.7000 31.3007 0.8000 0.7000 32.5272 1.2000 0.0900 40.3394 2.8000 0.2000 44.0000 1.5000 0.4000 -c 44.0
$PROGRAM -l 5 20.8871 1.8000 1.7000 32.0120 0.8000 0.7000 33.2664 1.2000 0.0900 41.2562 2.8000 0.2000 45.0000 1.5000 0.4000 -c 45.0
$PROGRAM -l 5 21.3513 1.8000 1.7000 32.7234 0.8000 0.7000 34.0057 1.2000 0.0900 42.1730 2.8000 0.2000 46.0000 1.5000 0.4000 -c 46.0
$PROGRAM -l 5 21.8155 1.8000 1.7000 33.4348 0.8000 0.7000 34.7449 1.2000 0.0900 43.0898 2.8000 0.2000 47.0000 1.5000 0.4000 -c 47.0
$PROGRAM -l 5 22.2796 1.8000 1.7000 34.1462 0.8000 0.7000 35.4842 1.2000 0.0900 44.0066 2.8000 0.2000 48.0000 1.5000 0.4000 -c 48.0
$PROGRAM -l 5 22.7438 1.8000 1.7000 34.8576 0.8000 0.7000 36.2235 1.2000 0.0900 44.9234 2.8000 0.2000 49.0000 1.5000 0.4000 -c 49.0
$PROGRAM -l 5 23.2079 1.8000 1.7000 35.5689 0.8000 0.7000 36.9627 1.2000 0.0900 45.8402 2.8000 0.2000 50.0000 1.5000 0.4000 -c 50.0
$PROGRAM -l 5 23.6721 1.8000 1.7000 36.2803 0.8000 0.7000 37.7020 1.2000 0.0900 46.7570 2.8000 0.2000 51.0000 1.5000 0.4000 -c 51.0
$PROGRAM -l 5 24.1363 1.8000 1.7000 36.9917 0.8000 0.7000 38.4412 1.2000 0.0900 47.6738 2.8000 0.2000 52.0000 1.5000 0.4000 -c 52.0
$PROGRAM -l 5 24.6004 1.8000 1.7000 37.7031 0.8000 0.7000 39.1805 1.2000 0.0900 48.5906 2.8000 0.2000 53.0000 1.5000 0.4000 -c 53.0
$PROGRAM -l 5 25.0646 1.8000 1.7000 38.4144 0.8000 0.7000 39.9197 1.2000 0.0900 49.5074 2.8000 0.2000 54.0000 1.5000 0.4000 -c 54.0
$PROGRAM -l 5 25.5287 1.8000 1.7000 39.1258 0.8000 0.7000 40.6590 1.2000 0.0900 50.4242 2.8000 0.2000 55.0000 1.5000 0.4000 -c 55.0
$PROGRAM -l 5 25.9929 1.8000 1.7000 39.8372 0.8000 0.7000 41.3982 1.2000 0.0900 51.3410 2.8000 0.2000 56.0000 1.5000 0.4000 -c 56.0
$PROGRAM -l 5 26.4571 1.8000 1.7000 40.5486 0.8000 0.7000 42.1375 1.2000 0.0900 52.2578 2.8000 0.2000 57.0000 1.5000 0.4000 -c 57.0
$PROGRAM -l 5 26.9212 1.8000 1.7000 41.2600 0.8000 0.7000 42.8767 1.2000 0.0900 53.1746 2.8000 0.2000 58.0000 1.5000 0.4000 -c 58.0
$PROGRAM -l 5 27.3854 1.8000 1.7000 41.9713 0.8000 0.7000 43.6160 1.2000 0.0900 54.0914 2.8000 0.2000 59.0000 1.5000 0.4000 -c 59.0
$PROGRAM -l 5 27.8495 1.8000 1.7000 42.6827 0.8000 0.7000 44.3553 1.2000 0.0900 55.0082 2.8000 0.2000 60.0000 1.5000 0.4000 -c 60.0
$PROGRAM -l 5 28.3137 1.8000 1.7000 43.3941 0.8000 0.7000 45.0945 1.2000 0.0900 55.9250 2.8000 0.2000 61.0000 1.5000 0.4000 -c 61.0
$PROGRAM -l 5 28.7779 1.8000 1.7000 44.1055 0.8000 0.7000 45.8338 1.2000 0.0900 56.8418 2.8000 0.2000 62.0000 1.5000 0.4000 -c 62.0
$PROGRAM -l 5 29.2420 1.8000 1.7000 44.8169 0.8000 0.7000 46.5730 1.2000 0.0900 57.7586 2.8000 0.2000 63.0000 1.5000 0.4000 -c 63.0
$PROGRAM -l 5 29.7062 1.8000 1.7000 45.5282 0.8000 0.7000 47.3123 1.2000 0.0900 58.6754 2.8000 0.2000 64.0000 1.5000 0.4000 -c 64.0
$PROGRAM -l 5 30.1703 1.8000 1.7000 46.2396 0.8000 0.7000 48.0515 1.2000 0.0900 59.5922 2.8000 0.2000 65.0000 1.5000 0.4000 -c 65.0
$PROGRAM -l 5 30.6345 1.8000 1.7000 46.9510 0.8000 0.7000 48.7908 1.2000 0.0900 60.5090 2.8000 0.2000 66.0000 1.5000 0.4000 -c 66.0
$PROGRAM -l 5 31.0986 1.8000 1.7000 47.6624 0.8000 0.7000 49.5300 1.2000 0.0900 61.4258 2.8000 0.2000 67.0000 1.5000 0.4000 -c 67.0
$PROGRAM -l 5 31.5628 1.8000 1.7000 48.3737 0.8000 0.7000 50.2693 1.2000 0.0900 62.3426 2.8000 0.2000 68.0000 1.5000 0.4000 -c 68.0
$PROGRAM -l 5 32.0270 1.8000 1.7000 49.0851 0.8000 0.7000 51.0085 1.2000 0.0900 63.2595 2.8000 0.2000 69.0000 1.5000 0.4000 -c 69.0
$PROGRAM -l 5 32.4911 1.8000 1.7000 49.7965 0.8000 0.7000 51.7478 1.2000 0.0900 64.1763 2.8000 0.2000 70.0000 1.5000 0.4000 -c 70.0
$PROGRAM -l 5 32.9553 1.8000 1.7000 50.5079 0.8000 0.7000 52.4870 1.2000 0.0900 65.0931 2.8000 0.2000 71.0000 1.5000 0.4000 -c 71.0
$PROGRAM -l 5 33.4194 1.8000 1.7000 51.2193 0.8000 0.7000 53.2263 1.2000 0.0900 66.0099 2.8000 0.2000 72.0000 1.5000 0.4000 -c 72.0
$PROGRAM -l 5 33.8836 1.8000 1.7000 51.9306 0.8000 0.7000 53.9656 1.2000 0.0900 66.9267 2.8000 0.2000 73.0000 1.5000 0.4000 -c 73.0
$PROGRAM -l 5 34.3478 1.8000 1.7000 52.6420 0.8000 0.7000 54.7048 1.2000 0.0900 67.8435 2.8000 0.2000 74.0000 1.5000 0.4000 -c 74.0
$PROGRAM -l 5 34.8119 1.8000 1.7000 53.3534 0.8000 0.7000 55.4441 1.2000 0.0900 68.7603 2.8000 0.2000 75.0000 1.5000 0.4000 -c 75.0
$PROGRAM -l 5 35.2761 1.8000 1.7000 54.0648 0.8000 0.7000 56.1833 1.2000 0.0900 69.6771 2.8000 0.2000 76.0000 1.5000 0.4000 -c 76.0
$PROGRAM -l 5 35.7402 1.8000 1.7000 54.7762 0.8000 0.7000 56.9226 1.2000 0.0900 70.5939 2.8000 0.2000 77.0000 1.5000 0.4000 -c 77.0
$PROGRAM -l 5 36.2044 1.8000 1.7000 55.4875 0.8000 0.7000 57.6618 1.2000 0.0900 71.5107 2.8000 0.2000 78.0000 1.5000 0.4000 -c 78.0
$PROGRAM -l 5 36.6686 1.8000 1.7000 56.1989 0.8000 0.7000 58.4011 1.2000 0.0900 72.4275 2.8000 0.2000 79.0000 1.5000 0.4000 -c 79.0
$PROGRAM -l 5 37.1327 1.8000 1.7000 56.9103 0.8000 0.7000 59.1403 1.2000 0.0900 73.3443 2.8000 0.2000 80.0000 1.5000 0.4000 -c 80.0
$PROGRAM -l 5 37.5969 1.8000 1.7000 57.6217 0.8000 0.7000 59.8796 1.2000 0.0900 74.2611 2.8000 0.2000 81.0000 1.5000 0.4000 -c 81.0
$PROGRAM -l 5 38.0610 1.8000 1.7000 58.3331 0.8000 0.7000 60.6188 1.2000 0.0900 75.1779 2.8000 0.2000 82.0000 1.5000 0.4000 -c 82.0
$PROGRAM -l 5 38.5252 1.8000 1.7000 59.0444 0.8000 0.7000 61.3581 1.2000 0.0900 76.0947 2.8000 0.2000 83.0000 1.5000 0.4000 -c 83.0
$PROGRAM -l 5 38.9893 1.8000 1.7000 59.7558 0.8000 0.7000 62.0974 1.2000 0.0900 77.0115 2.8000 0.2000 84.0000 1.5000 0.4000 -c 84.0
$PROGRAM -l 5 39.4535 1.8000 1.7000 60.4672 0.8000 0.7000 62.8366 1.2000 0.0900 77.9283 2.8000 0.2000 85.0000 1.5000 0.4000 -c 85.0
$PROGRAM -l 5 39.9177 1.8000 1.7000 61.1786 0.8000 0.7000 63.5759 1.2000 0.0900 78.8451 2.8000 0.2000 86.0000 1.5000 0.4000 -c 86.0
$PROGRAM -l 5 40.3818 1.8000 1.7000 61.8899 0.8000 0.7000 64.3151 1.2000 0.0900 79.7619 2.8000 0.2000 87.0000 1.5000 0.4000 -c 87.0
$PROGRAM -l 5 40.8460 1.8000 1.7000 62.6013 0.8000 0.7000 65.0544 1.2000 0.0900 80.6787 2.8000 0.2000 88.0000 1.5000 0.4000 -c 88.0
$PROGRAM -l 5 41.3101 1.8000 1.7000 63.3127 0.8000 0.7000 65.7936 1.2000 0.0900 81.5955 2.8000 0.2000 89.0000 1.5000 0.4000 -c 89.0
$PROGRAM -l 5 41.7743 1.8000 1.7000 64.0241 0.8000 0.7000 66.5329 1.2000 0.0900 82.5123 2.8000 0.2000 90.0000 1.5000 0.4000 -c 90.0
$PROGRAM -l 5 42.2385 1.8000 1.7000 64.7355 0.8000 0.7000 67.2721 1.2000 0.0900 83.4291 2.8000 0.2000 91.0000 1.5000 0.4000 -c 91.0
$PROGRAM -l 5 42.7026 1.8000 1.7000 65.4468 0.8000 0.7000 68.0114 1.2000 0.0900 84.3459 2.8000 0.2000 92.0000 1.5000 0.4000 -c 92.0
$PROGRAM -l 5 43.1668 1.8000 1.7000 66.1582 0.8000 0.7000 68.7506 1.2000 0.0900 85.2627 2.8000 0.2000 93.0000 1.5000 0.4000 -c 93.0
$PROGRAM -l 5 43.6309 1.8000 1.7000 66.8696 0.8000 0.7000 69.4899 1.2000 0.0900 86.1795 2.8000 0.2000 94.0000 1.5000 0.4000 -c 94.0
$PROGRAM -l 5 44.0951 1.8000 1.7000 67.5810 0.8000 0.7000 70.2291 1.2000 0.0900 87.0963 2.8000 0.2000 95.0000 1.5000 0.4000 -c 95.0
$PROGRAM -l 5 44.5593 1.8000 1.7000 68.2924 0.8000 0.7000 70.9684 1.2000 0.0900 88.0132 2.8000 0.2000 96.0000 1.5000 0.4000 -c 96.0
$PROGRAM -l 5 45.0234 1.8000 1.7000 69.0037 0.8000 0.7000 71.7077 1.2000 0.0900 88.9300 2.8000 0.2000 97.0000 1.5000 0.4000 -c 97.0
$PROGRAM -l 5 45.4876 1.8000 1.7000 69.7151 0.8000 0.7000 72.4469 1.2000 0.0900 89.8468 2.8000 0.2000 98.0000 1.5000 0.4000 -c 98.0
$PROGRAM -l 5 45.9517 1.8000 1.7000 70.4265 0.8000 0.7000 73.1862 1.2000 0.0900 90.7636 2.8000 0.2000 99.0000 1.5000 0.4000 -c 99.0
$PROGRAM -l 5 46.4159 1.8000 1.7000 71.1379 0.8000 0.7000 73.9254 1.2000 0.0900 91.6804 2.8000 0.2000 100.0000 1.5000 0.4000 -c 100.0

