#! /bin/sh
# This is a test against the program n-mie (version 3a) for a water sphere surrounded by soot
# n-mie is based in the algorithm described in:
# Wu Z.P., Wang Y.P.
# Electromagnetic scattering for multilayered spheres:
# recursive algorithms
# Radio Science 1991. V. 26. P. 1393-1401.
# Voshchinnikov N.V., Mathis J.S.
# Calculating Cross Sections of Composite Interstellar Grains
# Astrophys. J. 1999. V. 526. #1. 
# 
# The refractive indices of water and soot are m1 1.33 i0.00, m2 1.59 i0.66, respectively.
# The volume fraction of soot is 0.01.
# This test case was described in:
# W. Yang, Appl. Opt. 42 (2003) 1710-1720.

PROGRAM='../../../scattnlay'

$PROGRAM  -l 2 0.099668871748 1.33 0.0 0.1 1.59 0.66 -c 0.1
$PROGRAM  -l 2 1.096357589225 1.33 0.0 1.1 1.59 0.66 -c 1.1
$PROGRAM  -l 2 2.093046306702 1.33 0.0 2.1 1.59 0.66 -c 2.1
$PROGRAM  -l 2 3.089735024180 1.33 0.0 3.1 1.59 0.66 -c 3.1
$PROGRAM  -l 2 4.086423741657 1.33 0.0 4.1 1.59 0.66 -c 4.1
$PROGRAM  -l 2 5.083112459134 1.33 0.0 5.1 1.59 0.66 -c 5.1
$PROGRAM  -l 2 6.079801176612 1.33 0.0 6.1 1.59 0.66 -c 6.1
$PROGRAM  -l 2 7.076489894089 1.33 0.0 7.1 1.59 0.66 -c 7.1
$PROGRAM  -l 2 8.073178611566 1.33 0.0 8.1 1.59 0.66 -c 8.1
$PROGRAM  -l 2 9.069867329044 1.33 0.0 9.1 1.59 0.66 -c 9.1
$PROGRAM  -l 2 10.066556046521 1.33 0.0 10.1 1.59 0.66 -c 10.1
$PROGRAM  -l 2 11.063244763998 1.33 0.0 11.1 1.59 0.66 -c 11.1
$PROGRAM  -l 2 12.059933481476 1.33 0.0 12.1 1.59 0.66 -c 12.1
$PROGRAM  -l 2 13.056622198953 1.33 0.0 13.1 1.59 0.66 -c 13.1
$PROGRAM  -l 2 14.053310916430 1.33 0.0 14.1 1.59 0.66 -c 14.1
$PROGRAM  -l 2 15.049999633908 1.33 0.0 15.1 1.59 0.66 -c 15.1
$PROGRAM  -l 2 16.046688351385 1.33 0.0 16.1 1.59 0.66 -c 16.1
$PROGRAM  -l 2 17.043377068862 1.33 0.0 17.1 1.59 0.66 -c 17.1
$PROGRAM  -l 2 18.040065786340 1.33 0.0 18.1 1.59 0.66 -c 18.1
$PROGRAM  -l 2 19.036754503817 1.33 0.0 19.1 1.59 0.66 -c 19.1
$PROGRAM  -l 2 20.033443221294 1.33 0.0 20.1 1.59 0.66 -c 20.1
$PROGRAM  -l 2 21.030131938772 1.33 0.0 21.1 1.59 0.66 -c 21.1
$PROGRAM  -l 2 22.026820656249 1.33 0.0 22.1 1.59 0.66 -c 22.1
$PROGRAM  -l 2 23.023509373727 1.33 0.0 23.1 1.59 0.66 -c 23.1
$PROGRAM  -l 2 24.020198091204 1.33 0.0 24.1 1.59 0.66 -c 24.1
$PROGRAM  -l 2 25.016886808681 1.33 0.0 25.1 1.59 0.66 -c 25.1
$PROGRAM  -l 2 26.013575526159 1.33 0.0 26.1 1.59 0.66 -c 26.1
$PROGRAM  -l 2 27.010264243636 1.33 0.0 27.1 1.59 0.66 -c 27.1
$PROGRAM  -l 2 28.006952961113 1.33 0.0 28.1 1.59 0.66 -c 28.1
$PROGRAM  -l 2 29.003641678591 1.33 0.0 29.1 1.59 0.66 -c 29.1
$PROGRAM  -l 2 30.000330396068 1.33 0.0 30.1 1.59 0.66 -c 30.1
$PROGRAM  -l 2 30.997019113545 1.33 0.0 31.1 1.59 0.66 -c 31.1
$PROGRAM  -l 2 31.993707831023 1.33 0.0 32.1 1.59 0.66 -c 32.1
$PROGRAM  -l 2 32.990396548500 1.33 0.0 33.1 1.59 0.66 -c 33.1
$PROGRAM  -l 2 33.987085265977 1.33 0.0 34.1 1.59 0.66 -c 34.1
$PROGRAM  -l 2 34.983773983455 1.33 0.0 35.1 1.59 0.66 -c 35.1
$PROGRAM  -l 2 35.980462700932 1.33 0.0 36.1 1.59 0.66 -c 36.1
$PROGRAM  -l 2 36.977151418409 1.33 0.0 37.1 1.59 0.66 -c 37.1
$PROGRAM  -l 2 37.973840135887 1.33 0.0 38.1 1.59 0.66 -c 38.1
$PROGRAM  -l 2 38.970528853364 1.33 0.0 39.1 1.59 0.66 -c 39.1
$PROGRAM  -l 2 39.967217570841 1.33 0.0 40.1 1.59 0.66 -c 40.1
$PROGRAM  -l 2 40.963906288319 1.33 0.0 41.1 1.59 0.66 -c 41.1
$PROGRAM  -l 2 41.960595005796 1.33 0.0 42.1 1.59 0.66 -c 42.1
$PROGRAM  -l 2 42.957283723273 1.33 0.0 43.1 1.59 0.66 -c 43.1
$PROGRAM  -l 2 43.953972440751 1.33 0.0 44.1 1.59 0.66 -c 44.1
$PROGRAM  -l 2 44.950661158228 1.33 0.0 45.1 1.59 0.66 -c 45.1
$PROGRAM  -l 2 45.947349875705 1.33 0.0 46.1 1.59 0.66 -c 46.1
$PROGRAM  -l 2 46.944038593183 1.33 0.0 47.1 1.59 0.66 -c 47.1
$PROGRAM  -l 2 47.940727310660 1.33 0.0 48.1 1.59 0.66 -c 48.1
$PROGRAM  -l 2 48.937416028137 1.33 0.0 49.1 1.59 0.66 -c 49.1
$PROGRAM  -l 2 49.934104745615 1.33 0.0 50.1 1.59 0.66 -c 50.1
$PROGRAM  -l 2 50.930793463092 1.33 0.0 51.1 1.59 0.66 -c 51.1
$PROGRAM  -l 2 51.927482180569 1.33 0.0 52.1 1.59 0.66 -c 52.1
$PROGRAM  -l 2 52.924170898047 1.33 0.0 53.1 1.59 0.66 -c 53.1
$PROGRAM  -l 2 53.920859615524 1.33 0.0 54.1 1.59 0.66 -c 54.1
$PROGRAM  -l 2 54.917548333001 1.33 0.0 55.1 1.59 0.66 -c 55.1
$PROGRAM  -l 2 55.914237050479 1.33 0.0 56.1 1.59 0.66 -c 56.1
$PROGRAM  -l 2 56.910925767956 1.33 0.0 57.1 1.59 0.66 -c 57.1
$PROGRAM  -l 2 57.907614485433 1.33 0.0 58.1 1.59 0.66 -c 58.1
$PROGRAM  -l 2 58.904303202911 1.33 0.0 59.1 1.59 0.66 -c 59.1
$PROGRAM  -l 2 59.900991920388 1.33 0.0 60.1 1.59 0.66 -c 60.1
$PROGRAM  -l 2 60.897680637865 1.33 0.0 61.1 1.59 0.66 -c 61.1
$PROGRAM  -l 2 61.894369355343 1.33 0.0 62.1 1.59 0.66 -c 62.1
$PROGRAM  -l 2 62.891058072820 1.33 0.0 63.1 1.59 0.66 -c 63.1
$PROGRAM  -l 2 63.887746790297 1.33 0.0 64.1 1.59 0.66 -c 64.1
$PROGRAM  -l 2 64.884435507775 1.33 0.0 65.1 1.59 0.66 -c 65.1
$PROGRAM  -l 2 65.881124225252 1.33 0.0 66.1 1.59 0.66 -c 66.1
$PROGRAM  -l 2 66.877812942729 1.33 0.0 67.1 1.59 0.66 -c 67.1
$PROGRAM  -l 2 67.874501660207 1.33 0.0 68.1 1.59 0.66 -c 68.1
$PROGRAM  -l 2 68.871190377684 1.33 0.0 69.1 1.59 0.66 -c 69.1
$PROGRAM  -l 2 69.867879095161 1.33 0.0 70.1 1.59 0.66 -c 70.1
$PROGRAM  -l 2 70.864567812639 1.33 0.0 71.1 1.59 0.66 -c 71.1
$PROGRAM  -l 2 71.861256530116 1.33 0.0 72.1 1.59 0.66 -c 72.1
$PROGRAM  -l 2 72.857945247593 1.33 0.0 73.1 1.59 0.66 -c 73.1
$PROGRAM  -l 2 73.854633965071 1.33 0.0 74.1 1.59 0.66 -c 74.1
$PROGRAM  -l 2 74.851322682548 1.33 0.0 75.1 1.59 0.66 -c 75.1
$PROGRAM  -l 2 75.848011400025 1.33 0.0 76.1 1.59 0.66 -c 76.1
$PROGRAM  -l 2 76.844700117503 1.33 0.0 77.1 1.59 0.66 -c 77.1
$PROGRAM  -l 2 77.841388834980 1.33 0.0 78.1 1.59 0.66 -c 78.1
$PROGRAM  -l 2 78.838077552457 1.33 0.0 79.1 1.59 0.66 -c 79.1
$PROGRAM  -l 2 79.834766269935 1.33 0.0 80.1 1.59 0.66 -c 80.1
$PROGRAM  -l 2 80.831454987412 1.33 0.0 81.1 1.59 0.66 -c 81.1
$PROGRAM  -l 2 81.828143704889 1.33 0.0 82.1 1.59 0.66 -c 82.1
$PROGRAM  -l 2 82.824832422367 1.33 0.0 83.1 1.59 0.66 -c 83.1
$PROGRAM  -l 2 83.821521139844 1.33 0.0 84.1 1.59 0.66 -c 84.1
$PROGRAM  -l 2 84.818209857321 1.33 0.0 85.1 1.59 0.66 -c 85.1
$PROGRAM  -l 2 85.814898574799 1.33 0.0 86.1 1.59 0.66 -c 86.1
$PROGRAM  -l 2 86.811587292276 1.33 0.0 87.1 1.59 0.66 -c 87.1
$PROGRAM  -l 2 87.808276009753 1.33 0.0 88.1 1.59 0.66 -c 88.1
$PROGRAM  -l 2 88.804964727231 1.33 0.0 89.1 1.59 0.66 -c 89.1
$PROGRAM  -l 2 89.801653444708 1.33 0.0 90.1 1.59 0.66 -c 90.1
$PROGRAM  -l 2 90.798342162186 1.33 0.0 91.1 1.59 0.66 -c 91.1
$PROGRAM  -l 2 91.795030879663 1.33 0.0 92.1 1.59 0.66 -c 92.1
$PROGRAM  -l 2 92.791719597140 1.33 0.0 93.1 1.59 0.66 -c 93.1
$PROGRAM  -l 2 93.788408314618 1.33 0.0 94.1 1.59 0.66 -c 94.1
$PROGRAM  -l 2 94.785097032095 1.33 0.0 95.1 1.59 0.66 -c 95.1
$PROGRAM  -l 2 95.781785749572 1.33 0.0 96.1 1.59 0.66 -c 96.1
$PROGRAM  -l 2 96.778474467050 1.33 0.0 97.1 1.59 0.66 -c 97.1
$PROGRAM  -l 2 97.775163184527 1.33 0.0 98.1 1.59 0.66 -c 98.1
$PROGRAM  -l 2 98.771851902004 1.33 0.0 99.1 1.59 0.66 -c 99.1
$PROGRAM  -l 2 99.768540619482 1.33 0.0 100.1 1.59 0.66 -c 100.1

