#! /bin/sh
# This is a test against the experimental results for Au nanoshells published by:
# A. M. Schwartzberg, T. Y. Olson, C. E. Talley and J. Z. Zhang,
# J. Phys. Chem. B, 110 (2006) 19935-19944.
#
# This is for the first case: Rc=24.5 nm, tsh=5.7 nm

PROGRAM='../../../scattnlay'

$PROGRAM  -l 2 0.384845 1.000000 0.000000 0.474380 1.537798 1.993858 -c  400.0
$PROGRAM  -l 2 0.383885 1.000000 0.000000 0.473197 1.537717 1.994786 -c  401.0
$PROGRAM  -l 2 0.382930 1.000000 0.000000 0.472020 1.537609 1.995662 -c  402.0
$PROGRAM  -l 2 0.381980 1.000000 0.000000 0.470849 1.537483 1.996487 -c  403.0
$PROGRAM  -l 2 0.381035 1.000000 0.000000 0.469684 1.537348 1.997259 -c  404.0
$PROGRAM  -l 2 0.380094 1.000000 0.000000 0.468524 1.537208 1.997980 -c  405.0
$PROGRAM  -l 2 0.379158 1.000000 0.000000 0.467370 1.537072 1.998647 -c  406.0
$PROGRAM  -l 2 0.378226 1.000000 0.000000 0.466222 1.536944 1.999261 -c  407.0
$PROGRAM  -l 2 0.377299 1.000000 0.000000 0.465079 1.536829 1.999822 -c  408.0
$PROGRAM  -l 2 0.376377 1.000000 0.000000 0.463942 1.536731 2.000329 -c  409.0
$PROGRAM  -l 2 0.375459 1.000000 0.000000 0.462810 1.536653 2.000783 -c  410.0
$PROGRAM  -l 2 0.374545 1.000000 0.000000 0.461684 1.536597 2.001182 -c  411.0
$PROGRAM  -l 2 0.373636 1.000000 0.000000 0.460564 1.536565 2.001528 -c  412.0
$PROGRAM  -l 2 0.372731 1.000000 0.000000 0.459449 1.536559 2.001818 -c  413.0
$PROGRAM  -l 2 0.371831 1.000000 0.000000 0.458339 1.536677 2.002052 -c  414.0
$PROGRAM  -l 2 0.370935 1.000000 0.000000 0.457234 1.537396 2.002218 -c  415.0
$PROGRAM  -l 2 0.370044 1.000000 0.000000 0.456135 1.538090 2.002329 -c  416.0
$PROGRAM  -l 2 0.369156 1.000000 0.000000 0.455041 1.538745 2.002387 -c  417.0
$PROGRAM  -l 2 0.368273 1.000000 0.000000 0.453953 1.539344 2.002392 -c  418.0
$PROGRAM  -l 2 0.367394 1.000000 0.000000 0.452869 1.539876 2.002342 -c  419.0
$PROGRAM  -l 2 0.366519 1.000000 0.000000 0.451791 1.540326 2.002240 -c  420.0
$PROGRAM  -l 2 0.365649 1.000000 0.000000 0.450718 1.540683 2.002084 -c  421.0
$PROGRAM  -l 2 0.364782 1.000000 0.000000 0.449650 1.540937 2.001874 -c  422.0
$PROGRAM  -l 2 0.363920 1.000000 0.000000 0.448587 1.541077 2.001610 -c  423.0
$PROGRAM  -l 2 0.363062 1.000000 0.000000 0.447529 1.541094 2.001293 -c  424.0
$PROGRAM  -l 2 0.362207 1.000000 0.000000 0.446476 1.540979 2.000922 -c  425.0
$PROGRAM  -l 2 0.361357 1.000000 0.000000 0.445428 1.540726 2.000497 -c  426.0
$PROGRAM  -l 2 0.360511 1.000000 0.000000 0.444385 1.540327 2.000018 -c  427.0
$PROGRAM  -l 2 0.359669 1.000000 0.000000 0.443347 1.539777 1.999484 -c  428.0
$PROGRAM  -l 2 0.358830 1.000000 0.000000 0.442313 1.539072 1.998896 -c  429.0
$PROGRAM  -l 2 0.357996 1.000000 0.000000 0.441284 1.538206 1.998253 -c  430.0
$PROGRAM  -l 2 0.357165 1.000000 0.000000 0.440261 1.537178 1.997554 -c  431.0
$PROGRAM  -l 2 0.356338 1.000000 0.000000 0.439242 1.534945 1.997030 -c  432.0
$PROGRAM  -l 2 0.355515 1.000000 0.000000 0.438227 1.532483 1.996463 -c  433.0
$PROGRAM  -l 2 0.354696 1.000000 0.000000 0.437217 1.529927 1.995823 -c  434.0
$PROGRAM  -l 2 0.353881 1.000000 0.000000 0.436212 1.527297 1.995106 -c  435.0
$PROGRAM  -l 2 0.353069 1.000000 0.000000 0.435212 1.524607 1.994307 -c  436.0
$PROGRAM  -l 2 0.352261 1.000000 0.000000 0.434216 1.521872 1.993425 -c  437.0
$PROGRAM  -l 2 0.351457 1.000000 0.000000 0.433225 1.519108 1.992455 -c  438.0
$PROGRAM  -l 2 0.350656 1.000000 0.000000 0.432238 1.516325 1.991395 -c  439.0
$PROGRAM  -l 2 0.349860 1.000000 0.000000 0.431255 1.513537 1.990244 -c  440.0
$PROGRAM  -l 2 0.349066 1.000000 0.000000 0.430277 1.510754 1.988999 -c  441.0
$PROGRAM  -l 2 0.348276 1.000000 0.000000 0.429304 1.507985 1.987660 -c  442.0
$PROGRAM  -l 2 0.347490 1.000000 0.000000 0.428335 1.505238 1.986226 -c  443.0
$PROGRAM  -l 2 0.346708 1.000000 0.000000 0.427370 1.502521 1.984697 -c  444.0
$PROGRAM  -l 2 0.345929 1.000000 0.000000 0.426410 1.499841 1.983072 -c  445.0
$PROGRAM  -l 2 0.345153 1.000000 0.000000 0.425454 1.497201 1.981352 -c  446.0
$PROGRAM  -l 2 0.344381 1.000000 0.000000 0.424502 1.494606 1.979539 -c  447.0
$PROGRAM  -l 2 0.343612 1.000000 0.000000 0.423554 1.492060 1.977632 -c  448.0
$PROGRAM  -l 2 0.342847 1.000000 0.000000 0.422611 1.489563 1.975635 -c  449.0
$PROGRAM  -l 2 0.342085 1.000000 0.000000 0.421672 1.487116 1.973549 -c  450.0
$PROGRAM  -l 2 0.341326 1.000000 0.000000 0.420737 1.484720 1.971377 -c  451.0
$PROGRAM  -l 2 0.340571 1.000000 0.000000 0.419806 1.483154 1.969053 -c  452.0
$PROGRAM  -l 2 0.339819 1.000000 0.000000 0.418880 1.482295 1.966591 -c  453.0
$PROGRAM  -l 2 0.339071 1.000000 0.000000 0.417957 1.481380 1.964062 -c  454.0
$PROGRAM  -l 2 0.338326 1.000000 0.000000 0.417038 1.480387 1.961472 -c  455.0
$PROGRAM  -l 2 0.337584 1.000000 0.000000 0.416124 1.479294 1.958826 -c  456.0
$PROGRAM  -l 2 0.336845 1.000000 0.000000 0.415213 1.478080 1.956130 -c  457.0
$PROGRAM  -l 2 0.336110 1.000000 0.000000 0.414307 1.476726 1.953391 -c  458.0
$PROGRAM  -l 2 0.335377 1.000000 0.000000 0.413404 1.475211 1.950615 -c  459.0
$PROGRAM  -l 2 0.334648 1.000000 0.000000 0.412505 1.473518 1.947808 -c  460.0
$PROGRAM  -l 2 0.333922 1.000000 0.000000 0.411611 1.471630 1.944979 -c  461.0
$PROGRAM  -l 2 0.333200 1.000000 0.000000 0.410720 1.469529 1.942132 -c  462.0
$PROGRAM  -l 2 0.332480 1.000000 0.000000 0.409833 1.467200 1.939277 -c  463.0
$PROGRAM  -l 2 0.331764 1.000000 0.000000 0.408949 1.464629 1.936419 -c  464.0
$PROGRAM  -l 2 0.331050 1.000000 0.000000 0.408070 1.461801 1.933568 -c  465.0
$PROGRAM  -l 2 0.330340 1.000000 0.000000 0.407194 1.458703 1.930729 -c  466.0
$PROGRAM  -l 2 0.329632 1.000000 0.000000 0.406322 1.455323 1.927913 -c  467.0
$PROGRAM  -l 2 0.328928 1.000000 0.000000 0.405454 1.451650 1.925126 -c  468.0
$PROGRAM  -l 2 0.328227 1.000000 0.000000 0.404590 1.447672 1.922377 -c  469.0
$PROGRAM  -l 2 0.327528 1.000000 0.000000 0.403729 1.443381 1.919675 -c  470.0
$PROGRAM  -l 2 0.326833 1.000000 0.000000 0.402872 1.438768 1.917028 -c  471.0
$PROGRAM  -l 2 0.326140 1.000000 0.000000 0.402018 1.433824 1.914445 -c  472.0
$PROGRAM  -l 2 0.325451 1.000000 0.000000 0.401168 1.428486 1.910826 -c  473.0
$PROGRAM  -l 2 0.324764 1.000000 0.000000 0.400322 1.422802 1.907237 -c  474.0
$PROGRAM  -l 2 0.324081 1.000000 0.000000 0.399479 1.416773 1.903799 -c  475.0
$PROGRAM  -l 2 0.323400 1.000000 0.000000 0.398640 1.410394 1.900533 -c  476.0
$PROGRAM  -l 2 0.322722 1.000000 0.000000 0.397804 1.403662 1.897462 -c  477.0
$PROGRAM  -l 2 0.322047 1.000000 0.000000 0.396972 1.396575 1.894605 -c  478.0
$PROGRAM  -l 2 0.321374 1.000000 0.000000 0.396143 1.389131 1.891981 -c  479.0
$PROGRAM  -l 2 0.320705 1.000000 0.000000 0.395318 1.381327 1.889608 -c  480.0
$PROGRAM  -l 2 0.320038 1.000000 0.000000 0.394496 1.373165 1.887504 -c  481.0
$PROGRAM  -l 2 0.319374 1.000000 0.000000 0.393677 1.364643 1.885685 -c  482.0
$PROGRAM  -l 2 0.318713 1.000000 0.000000 0.392862 1.355762 1.884165 -c  483.0
$PROGRAM  -l 2 0.318054 1.000000 0.000000 0.392051 1.346525 1.882958 -c  484.0
$PROGRAM  -l 2 0.317399 1.000000 0.000000 0.391242 1.336932 1.882078 -c  485.0
$PROGRAM  -l 2 0.316746 1.000000 0.000000 0.390437 1.326987 1.881537 -c  486.0
$PROGRAM  -l 2 0.316095 1.000000 0.000000 0.389636 1.316692 1.881345 -c  487.0
$PROGRAM  -l 2 0.315447 1.000000 0.000000 0.388837 1.306053 1.881513 -c  488.0
$PROGRAM  -l 2 0.314802 1.000000 0.000000 0.388042 1.295072 1.882050 -c  489.0
$PROGRAM  -l 2 0.314160 1.000000 0.000000 0.387250 1.283756 1.882964 -c  490.0
$PROGRAM  -l 2 0.313520 1.000000 0.000000 0.386461 1.272110 1.884263 -c  491.0
$PROGRAM  -l 2 0.312883 1.000000 0.000000 0.385676 1.260141 1.885953 -c  492.0
$PROGRAM  -l 2 0.312248 1.000000 0.000000 0.384894 1.247855 1.888039 -c  493.0
$PROGRAM  -l 2 0.311616 1.000000 0.000000 0.384115 1.235260 1.890527 -c  494.0
$PROGRAM  -l 2 0.310987 1.000000 0.000000 0.383339 1.222364 1.893420 -c  495.0
$PROGRAM  -l 2 0.310360 1.000000 0.000000 0.382566 1.209176 1.896721 -c  496.0
$PROGRAM  -l 2 0.309735 1.000000 0.000000 0.381796 1.194747 1.900942 -c  497.0
$PROGRAM  -l 2 0.309113 1.000000 0.000000 0.381029 1.178491 1.906393 -c  498.0
$PROGRAM  -l 2 0.308494 1.000000 0.000000 0.380266 1.162095 1.912183 -c  499.0
$PROGRAM  -l 2 0.307877 1.000000 0.000000 0.379505 1.145595 1.918300 -c  500.0
$PROGRAM  -l 2 0.307262 1.000000 0.000000 0.378748 1.129020 1.924735 -c  501.0
$PROGRAM  -l 2 0.306650 1.000000 0.000000 0.377993 1.112403 1.931477 -c  502.0
$PROGRAM  -l 2 0.306040 1.000000 0.000000 0.377242 1.095775 1.938517 -c  503.0
$PROGRAM  -l 2 0.305433 1.000000 0.000000 0.376493 1.079163 1.945845 -c  504.0
$PROGRAM  -l 2 0.304828 1.000000 0.000000 0.375748 1.062596 1.953452 -c  505.0
$PROGRAM  -l 2 0.304226 1.000000 0.000000 0.375005 1.046101 1.961331 -c  506.0
$PROGRAM  -l 2 0.303626 1.000000 0.000000 0.374265 1.029706 1.969473 -c  507.0
$PROGRAM  -l 2 0.303028 1.000000 0.000000 0.373529 1.013433 1.977869 -c  508.0
$PROGRAM  -l 2 0.302433 1.000000 0.000000 0.372795 0.997310 1.986513 -c  509.0
$PROGRAM  -l 2 0.301840 1.000000 0.000000 0.372064 0.981358 1.995398 -c  510.0
$PROGRAM  -l 2 0.301249 1.000000 0.000000 0.371336 0.965600 2.004515 -c  511.0
$PROGRAM  -l 2 0.300661 1.000000 0.000000 0.370611 0.950058 2.013860 -c  512.0
$PROGRAM  -l 2 0.300075 1.000000 0.000000 0.369888 0.934754 2.023424 -c  513.0
$PROGRAM  -l 2 0.299491 1.000000 0.000000 0.369169 0.919705 2.033201 -c  514.0
$PROGRAM  -l 2 0.298910 1.000000 0.000000 0.368452 0.904933 2.043185 -c  515.0
$PROGRAM  -l 2 0.298330 1.000000 0.000000 0.367738 0.890454 2.053369 -c  516.0
$PROGRAM  -l 2 0.297753 1.000000 0.000000 0.367026 0.876286 2.063747 -c  517.0
$PROGRAM  -l 2 0.297178 1.000000 0.000000 0.366318 0.862445 2.074314 -c  518.0
$PROGRAM  -l 2 0.296606 1.000000 0.000000 0.365612 0.848947 2.085062 -c  519.0
$PROGRAM  -l 2 0.296035 1.000000 0.000000 0.364909 0.835804 2.095985 -c  520.0
$PROGRAM  -l 2 0.295467 1.000000 0.000000 0.364209 0.823031 2.107078 -c  521.0
$PROGRAM  -l 2 0.294901 1.000000 0.000000 0.363511 0.811480 2.118433 -c  522.0
$PROGRAM  -l 2 0.294337 1.000000 0.000000 0.362816 0.801972 2.130142 -c  523.0
$PROGRAM  -l 2 0.293776 1.000000 0.000000 0.362123 0.792780 2.141991 -c  524.0
$PROGRAM  -l 2 0.293216 1.000000 0.000000 0.361434 0.783891 2.153974 -c  525.0
$PROGRAM  -l 2 0.292659 1.000000 0.000000 0.360747 0.775293 2.166079 -c  526.0
$PROGRAM  -l 2 0.292103 1.000000 0.000000 0.360062 0.766975 2.178298 -c  527.0
$PROGRAM  -l 2 0.291550 1.000000 0.000000 0.359380 0.758926 2.190622 -c  528.0
$PROGRAM  -l 2 0.290999 1.000000 0.000000 0.358701 0.751135 2.203042 -c  529.0
$PROGRAM  -l 2 0.290450 1.000000 0.000000 0.358024 0.743592 2.215548 -c  530.0
$PROGRAM  -l 2 0.289903 1.000000 0.000000 0.357350 0.736285 2.228134 -c  531.0
$PROGRAM  -l 2 0.289358 1.000000 0.000000 0.356678 0.729204 2.240790 -c  532.0
$PROGRAM  -l 2 0.288815 1.000000 0.000000 0.356009 0.722340 2.253508 -c  533.0
$PROGRAM  -l 2 0.288274 1.000000 0.000000 0.355342 0.715683 2.266280 -c  534.0
$PROGRAM  -l 2 0.287735 1.000000 0.000000 0.354678 0.709222 2.279098 -c  535.0
$PROGRAM  -l 2 0.287199 1.000000 0.000000 0.354016 0.702949 2.291956 -c  536.0
$PROGRAM  -l 2 0.286664 1.000000 0.000000 0.353357 0.696855 2.304845 -c  537.0
$PROGRAM  -l 2 0.286131 1.000000 0.000000 0.352700 0.690929 2.317758 -c  538.0
$PROGRAM  -l 2 0.285600 1.000000 0.000000 0.352046 0.685164 2.330688 -c  539.0
$PROGRAM  -l 2 0.285071 1.000000 0.000000 0.351394 0.679552 2.343630 -c  540.0
$PROGRAM  -l 2 0.284544 1.000000 0.000000 0.350744 0.674083 2.356576 -c  541.0
$PROGRAM  -l 2 0.284019 1.000000 0.000000 0.350097 0.668750 2.369520 -c  542.0
$PROGRAM  -l 2 0.283496 1.000000 0.000000 0.349452 0.663545 2.382455 -c  543.0
$PROGRAM  -l 2 0.282975 1.000000 0.000000 0.348810 0.658460 2.395378 -c  544.0
$PROGRAM  -l 2 0.282456 1.000000 0.000000 0.348170 0.653488 2.408281 -c  545.0
$PROGRAM  -l 2 0.281939 1.000000 0.000000 0.347532 0.648621 2.421160 -c  546.0
$PROGRAM  -l 2 0.281423 1.000000 0.000000 0.346897 0.643854 2.434009 -c  547.0
$PROGRAM  -l 2 0.280910 1.000000 0.000000 0.346264 0.639179 2.446824 -c  548.0
$PROGRAM  -l 2 0.280398 1.000000 0.000000 0.345633 0.634590 2.459600 -c  549.0
$PROGRAM  -l 2 0.279888 1.000000 0.000000 0.345005 0.629635 2.471819 -c  550.0
$PROGRAM  -l 2 0.279380 1.000000 0.000000 0.344379 0.624506 2.483704 -c  551.0
$PROGRAM  -l 2 0.278874 1.000000 0.000000 0.343755 0.619464 2.495560 -c  552.0
$PROGRAM  -l 2 0.278370 1.000000 0.000000 0.343133 0.614507 2.507389 -c  553.0
$PROGRAM  -l 2 0.277867 1.000000 0.000000 0.342514 0.609635 2.519193 -c  554.0
$PROGRAM  -l 2 0.277367 1.000000 0.000000 0.341897 0.604847 2.530972 -c  555.0
$PROGRAM  -l 2 0.276868 1.000000 0.000000 0.341282 0.600142 2.542729 -c  556.0
$PROGRAM  -l 2 0.276371 1.000000 0.000000 0.340669 0.595519 2.554466 -c  557.0
$PROGRAM  -l 2 0.275875 1.000000 0.000000 0.340059 0.590977 2.566182 -c  558.0
$PROGRAM  -l 2 0.275382 1.000000 0.000000 0.339450 0.586515 2.577881 -c  559.0
$PROGRAM  -l 2 0.274890 1.000000 0.000000 0.338844 0.582132 2.589563 -c  560.0
$PROGRAM  -l 2 0.274400 1.000000 0.000000 0.338240 0.577827 2.601229 -c  561.0
$PROGRAM  -l 2 0.273912 1.000000 0.000000 0.337638 0.573599 2.612880 -c  562.0
$PROGRAM  -l 2 0.273425 1.000000 0.000000 0.337039 0.569447 2.624518 -c  563.0
$PROGRAM  -l 2 0.272941 1.000000 0.000000 0.336441 0.565370 2.636144 -c  564.0
$PROGRAM  -l 2 0.272458 1.000000 0.000000 0.335846 0.561368 2.647759 -c  565.0
$PROGRAM  -l 2 0.271976 1.000000 0.000000 0.335252 0.557439 2.659364 -c  566.0
$PROGRAM  -l 2 0.271497 1.000000 0.000000 0.334661 0.553582 2.670959 -c  567.0
$PROGRAM  -l 2 0.271019 1.000000 0.000000 0.334072 0.549796 2.682547 -c  568.0
$PROGRAM  -l 2 0.270542 1.000000 0.000000 0.333485 0.546080 2.694126 -c  569.0
$PROGRAM  -l 2 0.270068 1.000000 0.000000 0.332900 0.542434 2.705699 -c  570.0
$PROGRAM  -l 2 0.269595 1.000000 0.000000 0.332317 0.538856 2.717267 -c  571.0
$PROGRAM  -l 2 0.269123 1.000000 0.000000 0.331736 0.535346 2.728828 -c  572.0
$PROGRAM  -l 2 0.268654 1.000000 0.000000 0.331157 0.531901 2.740385 -c  573.0
$PROGRAM  -l 2 0.268186 1.000000 0.000000 0.330580 0.528523 2.751939 -c  574.0
$PROGRAM  -l 2 0.267719 1.000000 0.000000 0.330005 0.525208 2.763488 -c  575.0
$PROGRAM  -l 2 0.267254 1.000000 0.000000 0.329432 0.521957 2.775035 -c  576.0
$PROGRAM  -l 2 0.266791 1.000000 0.000000 0.328861 0.518769 2.786578 -c  577.0
$PROGRAM  -l 2 0.266330 1.000000 0.000000 0.328292 0.515642 2.798120 -c  578.0
$PROGRAM  -l 2 0.265870 1.000000 0.000000 0.327725 0.512575 2.809659 -c  579.0
$PROGRAM  -l 2 0.265411 1.000000 0.000000 0.327160 0.509568 2.821197 -c  580.0
$PROGRAM  -l 2 0.264954 1.000000 0.000000 0.326597 0.506619 2.832733 -c  581.0
$PROGRAM  -l 2 0.264499 1.000000 0.000000 0.326036 0.503728 2.844268 -c  582.0
$PROGRAM  -l 2 0.264046 1.000000 0.000000 0.325477 0.500905 2.855839 -c  583.0
$PROGRAM  -l 2 0.263593 1.000000 0.000000 0.324919 0.498232 2.867729 -c  584.0
$PROGRAM  -l 2 0.263143 1.000000 0.000000 0.324364 0.495611 2.879607 -c  585.0
$PROGRAM  -l 2 0.262694 1.000000 0.000000 0.323810 0.493041 2.891472 -c  586.0
$PROGRAM  -l 2 0.262246 1.000000 0.000000 0.323259 0.490519 2.903322 -c  587.0
$PROGRAM  -l 2 0.261800 1.000000 0.000000 0.322709 0.488044 2.915154 -c  588.0
$PROGRAM  -l 2 0.261356 1.000000 0.000000 0.322161 0.485615 2.926968 -c  589.0
$PROGRAM  -l 2 0.260913 1.000000 0.000000 0.321615 0.483231 2.938762 -c  590.0
$PROGRAM  -l 2 0.260471 1.000000 0.000000 0.321071 0.480889 2.950534 -c  591.0
$PROGRAM  -l 2 0.260031 1.000000 0.000000 0.320528 0.478590 2.962282 -c  592.0
$PROGRAM  -l 2 0.259593 1.000000 0.000000 0.319988 0.476331 2.974006 -c  593.0
$PROGRAM  -l 2 0.259156 1.000000 0.000000 0.319449 0.474111 2.985703 -c  594.0
$PROGRAM  -l 2 0.258720 1.000000 0.000000 0.318912 0.471929 2.997371 -c  595.0
$PROGRAM  -l 2 0.258286 1.000000 0.000000 0.318377 0.469783 3.009011 -c  596.0
$PROGRAM  -l 2 0.257854 1.000000 0.000000 0.317844 0.467674 3.020620 -c  597.0
$PROGRAM  -l 2 0.257422 1.000000 0.000000 0.317312 0.465599 3.032197 -c  598.0
$PROGRAM  -l 2 0.256993 1.000000 0.000000 0.316783 0.463557 3.043741 -c  599.0
$PROGRAM  -l 2 0.256564 1.000000 0.000000 0.316255 0.461547 3.055250 -c  600.0
$PROGRAM  -l 2 0.256137 1.000000 0.000000 0.315729 0.459568 3.066724 -c  601.0
$PROGRAM  -l 2 0.255712 1.000000 0.000000 0.315204 0.457620 3.078161 -c  602.0
$PROGRAM  -l 2 0.255288 1.000000 0.000000 0.314681 0.455700 3.089560 -c  603.0
$PROGRAM  -l 2 0.254865 1.000000 0.000000 0.314160 0.453809 3.100920 -c  604.0
$PROGRAM  -l 2 0.254444 1.000000 0.000000 0.313641 0.451946 3.112241 -c  605.0
$PROGRAM  -l 2 0.254024 1.000000 0.000000 0.313124 0.450108 3.123521 -c  606.0
$PROGRAM  -l 2 0.253606 1.000000 0.000000 0.312608 0.448296 3.134759 -c  607.0
$PROGRAM  -l 2 0.253188 1.000000 0.000000 0.312094 0.446509 3.145954 -c  608.0
$PROGRAM  -l 2 0.252773 1.000000 0.000000 0.311581 0.444745 3.157106 -c  609.0
$PROGRAM  -l 2 0.252358 1.000000 0.000000 0.311070 0.443005 3.168213 -c  610.0
$PROGRAM  -l 2 0.251945 1.000000 0.000000 0.310561 0.441287 3.179276 -c  611.0
$PROGRAM  -l 2 0.251534 1.000000 0.000000 0.310054 0.439590 3.190293 -c  612.0
$PROGRAM  -l 2 0.251123 1.000000 0.000000 0.309548 0.437915 3.201263 -c  613.0
$PROGRAM  -l 2 0.250714 1.000000 0.000000 0.309044 0.436260 3.212187 -c  614.0
$PROGRAM  -l 2 0.250307 1.000000 0.000000 0.308541 0.434624 3.223063 -c  615.0
$PROGRAM  -l 2 0.249900 1.000000 0.000000 0.308040 0.433008 3.233891 -c  616.0
$PROGRAM  -l 2 0.249495 1.000000 0.000000 0.307541 0.431411 3.244670 -c  617.0
$PROGRAM  -l 2 0.249092 1.000000 0.000000 0.307044 0.429745 3.255315 -c  618.0
$PROGRAM  -l 2 0.248689 1.000000 0.000000 0.306547 0.427900 3.265716 -c  619.0
$PROGRAM  -l 2 0.248288 1.000000 0.000000 0.306053 0.426077 3.276072 -c  620.0
$PROGRAM  -l 2 0.247888 1.000000 0.000000 0.305560 0.424277 3.286384 -c  621.0
$PROGRAM  -l 2 0.247490 1.000000 0.000000 0.305069 0.422500 3.296652 -c  622.0
$PROGRAM  -l 2 0.247092 1.000000 0.000000 0.304579 0.420748 3.306879 -c  623.0
$PROGRAM  -l 2 0.246697 1.000000 0.000000 0.304091 0.419021 3.317063 -c  624.0
$PROGRAM  -l 2 0.246302 1.000000 0.000000 0.303605 0.417320 3.327207 -c  625.0
$PROGRAM  -l 2 0.245908 1.000000 0.000000 0.303120 0.415645 3.337312 -c  626.0
$PROGRAM  -l 2 0.245516 1.000000 0.000000 0.302636 0.413997 3.347377 -c  627.0
$PROGRAM  -l 2 0.245125 1.000000 0.000000 0.302154 0.412377 3.357404 -c  628.0
$PROGRAM  -l 2 0.244735 1.000000 0.000000 0.301674 0.410785 3.367393 -c  629.0
$PROGRAM  -l 2 0.244347 1.000000 0.000000 0.301195 0.409222 3.377345 -c  630.0
$PROGRAM  -l 2 0.243960 1.000000 0.000000 0.300718 0.407689 3.387261 -c  631.0
$PROGRAM  -l 2 0.243574 1.000000 0.000000 0.300242 0.406185 3.397142 -c  632.0
$PROGRAM  -l 2 0.243189 1.000000 0.000000 0.299768 0.404712 3.406988 -c  633.0
$PROGRAM  -l 2 0.242805 1.000000 0.000000 0.299295 0.403270 3.416800 -c  634.0
$PROGRAM  -l 2 0.242423 1.000000 0.000000 0.298824 0.401860 3.426579 -c  635.0
$PROGRAM  -l 2 0.242042 1.000000 0.000000 0.298354 0.400482 3.436325 -c  636.0
$PROGRAM  -l 2 0.241662 1.000000 0.000000 0.297885 0.399136 3.446040 -c  637.0
$PROGRAM  -l 2 0.241283 1.000000 0.000000 0.297418 0.397823 3.455723 -c  638.0
$PROGRAM  -l 2 0.240906 1.000000 0.000000 0.296953 0.396544 3.465375 -c  639.0
$PROGRAM  -l 2 0.240529 1.000000 0.000000 0.296489 0.395298 3.474998 -c  640.0
$PROGRAM  -l 2 0.240154 1.000000 0.000000 0.296026 0.394086 3.484592 -c  641.0
$PROGRAM  -l 2 0.239780 1.000000 0.000000 0.295565 0.392909 3.494157 -c  642.0
$PROGRAM  -l 2 0.239407 1.000000 0.000000 0.295106 0.391767 3.503694 -c  643.0
$PROGRAM  -l 2 0.239035 1.000000 0.000000 0.294647 0.390660 3.513204 -c  644.0
$PROGRAM  -l 2 0.238665 1.000000 0.000000 0.294191 0.389588 3.522686 -c  645.0
$PROGRAM  -l 2 0.238295 1.000000 0.000000 0.293735 0.388552 3.532143 -c  646.0
$PROGRAM  -l 2 0.237927 1.000000 0.000000 0.293281 0.387552 3.541574 -c  647.0
$PROGRAM  -l 2 0.237560 1.000000 0.000000 0.292829 0.386588 3.550980 -c  648.0
$PROGRAM  -l 2 0.237194 1.000000 0.000000 0.292377 0.385661 3.560362 -c  649.0
$PROGRAM  -l 2 0.236829 1.000000 0.000000 0.291928 0.384770 3.569720 -c  650.0
$PROGRAM  -l 2 0.236465 1.000000 0.000000 0.291479 0.383916 3.579054 -c  651.0
$PROGRAM  -l 2 0.236102 1.000000 0.000000 0.291032 0.383100 3.588366 -c  652.0
$PROGRAM  -l 2 0.235741 1.000000 0.000000 0.290586 0.382320 3.597656 -c  653.0
$PROGRAM  -l 2 0.235380 1.000000 0.000000 0.290142 0.381578 3.606924 -c  654.0
$PROGRAM  -l 2 0.235021 1.000000 0.000000 0.289699 0.380873 3.616170 -c  655.0
$PROGRAM  -l 2 0.234663 1.000000 0.000000 0.289258 0.380205 3.625396 -c  656.0
$PROGRAM  -l 2 0.234305 1.000000 0.000000 0.288817 0.379575 3.634601 -c  657.0
$PROGRAM  -l 2 0.233949 1.000000 0.000000 0.288378 0.378983 3.643787 -c  658.0
$PROGRAM  -l 2 0.233594 1.000000 0.000000 0.287941 0.378428 3.652954 -c  659.0
$PROGRAM  -l 2 0.233240 1.000000 0.000000 0.287504 0.377910 3.662101 -c  660.0
$PROGRAM  -l 2 0.232888 1.000000 0.000000 0.287070 0.377555 3.671271 -c  661.0
$PROGRAM  -l 2 0.232536 1.000000 0.000000 0.286636 0.377321 3.680449 -c  662.0
$PROGRAM  -l 2 0.232185 1.000000 0.000000 0.286204 0.377119 3.689608 -c  663.0
$PROGRAM  -l 2 0.231835 1.000000 0.000000 0.285773 0.376950 3.698748 -c  664.0
$PROGRAM  -l 2 0.231487 1.000000 0.000000 0.285343 0.376811 3.707869 -c  665.0
$PROGRAM  -l 2 0.231139 1.000000 0.000000 0.284914 0.376703 3.716972 -c  666.0
$PROGRAM  -l 2 0.230793 1.000000 0.000000 0.284487 0.376625 3.726057 -c  667.0
$PROGRAM  -l 2 0.230447 1.000000 0.000000 0.284061 0.376576 3.735124 -c  668.0
$PROGRAM  -l 2 0.230103 1.000000 0.000000 0.283637 0.376556 3.744174 -c  669.0
$PROGRAM  -l 2 0.229759 1.000000 0.000000 0.283213 0.376563 3.753205 -c  670.0
$PROGRAM  -l 2 0.229417 1.000000 0.000000 0.282791 0.376598 3.762219 -c  671.0
$PROGRAM  -l 2 0.229075 1.000000 0.000000 0.282371 0.376659 3.771216 -c  672.0
$PROGRAM  -l 2 0.228735 1.000000 0.000000 0.281951 0.376747 3.780196 -c  673.0
$PROGRAM  -l 2 0.228396 1.000000 0.000000 0.281533 0.376859 3.789160 -c  674.0
$PROGRAM  -l 2 0.228057 1.000000 0.000000 0.281116 0.376996 3.798107 -c  675.0
$PROGRAM  -l 2 0.227720 1.000000 0.000000 0.280700 0.377158 3.807038 -c  676.0
$PROGRAM  -l 2 0.227384 1.000000 0.000000 0.280285 0.377343 3.815952 -c  677.0
$PROGRAM  -l 2 0.227048 1.000000 0.000000 0.279872 0.377551 3.824851 -c  678.0
$PROGRAM  -l 2 0.226714 1.000000 0.000000 0.279460 0.377781 3.833734 -c  679.0
$PROGRAM  -l 2 0.226380 1.000000 0.000000 0.279049 0.378033 3.842601 -c  680.0
$PROGRAM  -l 2 0.226048 1.000000 0.000000 0.278639 0.378306 3.851454 -c  681.0
$PROGRAM  -l 2 0.225717 1.000000 0.000000 0.278230 0.378599 3.860291 -c  682.0
$PROGRAM  -l 2 0.225386 1.000000 0.000000 0.277823 0.378913 3.869114 -c  683.0
$PROGRAM  -l 2 0.225057 1.000000 0.000000 0.277417 0.379246 3.877921 -c  684.0
$PROGRAM  -l 2 0.224728 1.000000 0.000000 0.277012 0.379599 3.886714 -c  685.0
$PROGRAM  -l 2 0.224400 1.000000 0.000000 0.276608 0.379969 3.895494 -c  686.0
$PROGRAM  -l 2 0.224074 1.000000 0.000000 0.276205 0.380358 3.904258 -c  687.0
$PROGRAM  -l 2 0.223748 1.000000 0.000000 0.275804 0.380764 3.913009 -c  688.0
$PROGRAM  -l 2 0.223423 1.000000 0.000000 0.275404 0.381187 3.921747 -c  689.0
$PROGRAM  -l 2 0.223100 1.000000 0.000000 0.275004 0.381626 3.930471 -c  690.0
$PROGRAM  -l 2 0.222777 1.000000 0.000000 0.274606 0.382082 3.939181 -c  691.0
$PROGRAM  -l 2 0.222455 1.000000 0.000000 0.274210 0.382552 3.947879 -c  692.0
$PROGRAM  -l 2 0.222134 1.000000 0.000000 0.273814 0.383038 3.956563 -c  693.0
$PROGRAM  -l 2 0.221814 1.000000 0.000000 0.273419 0.383538 3.965235 -c  694.0
$PROGRAM  -l 2 0.221495 1.000000 0.000000 0.273026 0.384052 3.973894 -c  695.0
$PROGRAM  -l 2 0.221176 1.000000 0.000000 0.272634 0.384580 3.982541 -c  696.0
$PROGRAM  -l 2 0.220859 1.000000 0.000000 0.272243 0.385121 3.991176 -c  697.0
$PROGRAM  -l 2 0.220543 1.000000 0.000000 0.271852 0.385674 3.999798 -c  698.0
$PROGRAM  -l 2 0.220227 1.000000 0.000000 0.271464 0.386240 4.008408 -c  699.0
$PROGRAM  -l 2 0.219912 1.000000 0.000000 0.271076 0.386818 4.017007 -c  700.0
$PROGRAM  -l 2 0.219599 1.000000 0.000000 0.270689 0.387407 4.025594 -c  701.0
$PROGRAM  -l 2 0.219286 1.000000 0.000000 0.270303 0.388007 4.034171 -c  702.0
$PROGRAM  -l 2 0.218974 1.000000 0.000000 0.269919 0.388617 4.042736 -c  703.0
$PROGRAM  -l 2 0.218663 1.000000 0.000000 0.269536 0.389238 4.051290 -c  704.0
$PROGRAM  -l 2 0.218353 1.000000 0.000000 0.269153 0.389868 4.059833 -c  705.0
$PROGRAM  -l 2 0.218044 1.000000 0.000000 0.268772 0.390466 4.068364 -c  706.0
$PROGRAM  -l 2 0.217735 1.000000 0.000000 0.268392 0.391041 4.076882 -c  707.0
$PROGRAM  -l 2 0.217428 1.000000 0.000000 0.268013 0.391626 4.085391 -c  708.0
$PROGRAM  -l 2 0.217121 1.000000 0.000000 0.267635 0.392220 4.093889 -c  709.0
$PROGRAM  -l 2 0.216815 1.000000 0.000000 0.267258 0.392824 4.102377 -c  710.0
$PROGRAM  -l 2 0.216510 1.000000 0.000000 0.266882 0.393437 4.110856 -c  711.0
$PROGRAM  -l 2 0.216206 1.000000 0.000000 0.266507 0.394060 4.119324 -c  712.0
$PROGRAM  -l 2 0.215903 1.000000 0.000000 0.266133 0.394691 4.127784 -c  713.0
$PROGRAM  -l 2 0.215600 1.000000 0.000000 0.265761 0.395332 4.136235 -c  714.0
$PROGRAM  -l 2 0.215299 1.000000 0.000000 0.265389 0.395981 4.144676 -c  715.0
$PROGRAM  -l 2 0.214998 1.000000 0.000000 0.265018 0.396639 4.153108 -c  716.0
$PROGRAM  -l 2 0.214698 1.000000 0.000000 0.264649 0.397305 4.161532 -c  717.0
$PROGRAM  -l 2 0.214399 1.000000 0.000000 0.264280 0.397980 4.169947 -c  718.0
$PROGRAM  -l 2 0.214101 1.000000 0.000000 0.263912 0.398663 4.178353 -c  719.0
$PROGRAM  -l 2 0.213804 1.000000 0.000000 0.263546 0.399353 4.186752 -c  720.0
$PROGRAM  -l 2 0.213507 1.000000 0.000000 0.263180 0.400052 4.195142 -c  721.0
$PROGRAM  -l 2 0.213212 1.000000 0.000000 0.262816 0.400758 4.203525 -c  722.0
$PROGRAM  -l 2 0.212917 1.000000 0.000000 0.262452 0.401472 4.211899 -c  723.0
$PROGRAM  -l 2 0.212623 1.000000 0.000000 0.262090 0.402193 4.220265 -c  724.0
$PROGRAM  -l 2 0.212329 1.000000 0.000000 0.261728 0.402922 4.228624 -c  725.0
$PROGRAM  -l 2 0.212037 1.000000 0.000000 0.261368 0.403657 4.236976 -c  726.0
$PROGRAM  -l 2 0.211745 1.000000 0.000000 0.261008 0.404400 4.245320 -c  727.0
$PROGRAM  -l 2 0.211454 1.000000 0.000000 0.260650 0.405149 4.253658 -c  728.0
$PROGRAM  -l 2 0.211164 1.000000 0.000000 0.260292 0.405905 4.261988 -c  729.0
$PROGRAM  -l 2 0.210875 1.000000 0.000000 0.259936 0.406668 4.270312 -c  730.0
$PROGRAM  -l 2 0.210587 1.000000 0.000000 0.259580 0.407437 4.278629 -c  731.0
$PROGRAM  -l 2 0.210299 1.000000 0.000000 0.259226 0.408212 4.286939 -c  732.0
$PROGRAM  -l 2 0.210012 1.000000 0.000000 0.258872 0.408993 4.295243 -c  733.0
$PROGRAM  -l 2 0.209726 1.000000 0.000000 0.258519 0.409781 4.303540 -c  734.0
$PROGRAM  -l 2 0.209441 1.000000 0.000000 0.258167 0.410574 4.311832 -c  735.0
$PROGRAM  -l 2 0.209156 1.000000 0.000000 0.257817 0.411373 4.320117 -c  736.0
$PROGRAM  -l 2 0.208872 1.000000 0.000000 0.257467 0.412177 4.328396 -c  737.0
$PROGRAM  -l 2 0.208589 1.000000 0.000000 0.257118 0.412987 4.336669 -c  738.0
$PROGRAM  -l 2 0.208307 1.000000 0.000000 0.256770 0.413802 4.344937 -c  739.0
$PROGRAM  -l 2 0.208025 1.000000 0.000000 0.256423 0.414623 4.353199 -c  740.0
$PROGRAM  -l 2 0.207745 1.000000 0.000000 0.256077 0.415448 4.361456 -c  741.0
$PROGRAM  -l 2 0.207465 1.000000 0.000000 0.255732 0.416278 4.369708 -c  742.0
$PROGRAM  -l 2 0.207185 1.000000 0.000000 0.255388 0.417114 4.377955 -c  743.0
$PROGRAM  -l 2 0.206907 1.000000 0.000000 0.255045 0.417954 4.386195 -c  744.0
$PROGRAM  -l 2 0.206629 1.000000 0.000000 0.254702 0.418798 4.394432 -c  745.0
$PROGRAM  -l 2 0.206352 1.000000 0.000000 0.254361 0.419647 4.402664 -c  746.0
$PROGRAM  -l 2 0.206076 1.000000 0.000000 0.254020 0.420500 4.410889 -c  747.0
$PROGRAM  -l 2 0.205801 1.000000 0.000000 0.253681 0.421357 4.419111 -c  748.0
$PROGRAM  -l 2 0.205526 1.000000 0.000000 0.253342 0.422219 4.427329 -c  749.0
$PROGRAM  -l 2 0.205252 1.000000 0.000000 0.253004 0.423084 4.435541 -c  750.0
$PROGRAM  -l 2 0.204978 1.000000 0.000000 0.252667 0.423953 4.443750 -c  751.0
$PROGRAM  -l 2 0.204706 1.000000 0.000000 0.252331 0.424826 4.451954 -c  752.0
$PROGRAM  -l 2 0.204434 1.000000 0.000000 0.251996 0.425702 4.460154 -c  753.0
$PROGRAM  -l 2 0.204163 1.000000 0.000000 0.251662 0.426582 4.468350 -c  754.0
$PROGRAM  -l 2 0.203892 1.000000 0.000000 0.251329 0.427465 4.476542 -c  755.0
$PROGRAM  -l 2 0.203623 1.000000 0.000000 0.250996 0.428352 4.484730 -c  756.0
$PROGRAM  -l 2 0.203354 1.000000 0.000000 0.250665 0.429241 4.492914 -c  757.0
$PROGRAM  -l 2 0.203085 1.000000 0.000000 0.250334 0.430160 4.501100 -c  758.0
$PROGRAM  -l 2 0.202818 1.000000 0.000000 0.250004 0.431083 4.509281 -c  759.0
$PROGRAM  -l 2 0.202551 1.000000 0.000000 0.249675 0.432008 4.517459 -c  760.0
$PROGRAM  -l 2 0.202285 1.000000 0.000000 0.249347 0.432936 4.525634 -c  761.0
$PROGRAM  -l 2 0.202019 1.000000 0.000000 0.249020 0.433866 4.533806 -c  762.0
$PROGRAM  -l 2 0.201755 1.000000 0.000000 0.248693 0.434798 4.541973 -c  763.0
$PROGRAM  -l 2 0.201491 1.000000 0.000000 0.248368 0.435732 4.550138 -c  764.0
$PROGRAM  -l 2 0.201227 1.000000 0.000000 0.248043 0.436668 4.558299 -c  765.0
$PROGRAM  -l 2 0.200965 1.000000 0.000000 0.247720 0.437605 4.566457 -c  766.0
$PROGRAM  -l 2 0.200703 1.000000 0.000000 0.247397 0.438543 4.574612 -c  767.0
$PROGRAM  -l 2 0.200441 1.000000 0.000000 0.247074 0.439483 4.582764 -c  768.0
$PROGRAM  -l 2 0.200181 1.000000 0.000000 0.246753 0.440424 4.590912 -c  769.0
$PROGRAM  -l 2 0.199921 1.000000 0.000000 0.246433 0.441367 4.599059 -c  770.0
$PROGRAM  -l 2 0.199661 1.000000 0.000000 0.246113 0.442309 4.607202 -c  771.0
$PROGRAM  -l 2 0.199403 1.000000 0.000000 0.245794 0.443253 4.615343 -c  772.0
$PROGRAM  -l 2 0.199145 1.000000 0.000000 0.245476 0.444198 4.623480 -c  773.0
$PROGRAM  -l 2 0.198887 1.000000 0.000000 0.245159 0.445142 4.631615 -c  774.0
$PROGRAM  -l 2 0.198631 1.000000 0.000000 0.244843 0.446088 4.639747 -c  775.0
$PROGRAM  -l 2 0.198375 1.000000 0.000000 0.244527 0.447033 4.647877 -c  776.0
$PROGRAM  -l 2 0.198119 1.000000 0.000000 0.244213 0.447979 4.656004 -c  777.0
$PROGRAM  -l 2 0.197865 1.000000 0.000000 0.243899 0.448924 4.664128 -c  778.0
$PROGRAM  -l 2 0.197611 1.000000 0.000000 0.243586 0.449870 4.672250 -c  779.0
$PROGRAM  -l 2 0.197357 1.000000 0.000000 0.243273 0.450815 4.680370 -c  780.0
$PROGRAM  -l 2 0.197105 1.000000 0.000000 0.242962 0.451760 4.688487 -c  781.0
$PROGRAM  -l 2 0.196853 1.000000 0.000000 0.242651 0.452705 4.696602 -c  782.0
$PROGRAM  -l 2 0.196601 1.000000 0.000000 0.242341 0.453649 4.704714 -c  783.0
$PROGRAM  -l 2 0.196351 1.000000 0.000000 0.242032 0.454592 4.712825 -c  784.0
$PROGRAM  -l 2 0.196100 1.000000 0.000000 0.241724 0.455535 4.720932 -c  785.0
$PROGRAM  -l 2 0.195851 1.000000 0.000000 0.241416 0.456476 4.729039 -c  786.0
$PROGRAM  -l 2 0.195602 1.000000 0.000000 0.241109 0.457417 4.737143 -c  787.0
$PROGRAM  -l 2 0.195354 1.000000 0.000000 0.240804 0.458357 4.745245 -c  788.0
$PROGRAM  -l 2 0.195106 1.000000 0.000000 0.240498 0.459296 4.753345 -c  789.0
$PROGRAM  -l 2 0.194859 1.000000 0.000000 0.240194 0.460233 4.761442 -c  790.0
$PROGRAM  -l 2 0.194613 1.000000 0.000000 0.239890 0.461169 4.769537 -c  791.0
$PROGRAM  -l 2 0.194367 1.000000 0.000000 0.239587 0.462104 4.777631 -c  792.0
$PROGRAM  -l 2 0.194122 1.000000 0.000000 0.239285 0.463038 4.785722 -c  793.0
$PROGRAM  -l 2 0.193878 1.000000 0.000000 0.238984 0.463970 4.793812 -c  794.0
$PROGRAM  -l 2 0.193634 1.000000 0.000000 0.238683 0.464900 4.801900 -c  795.0
$PROGRAM  -l 2 0.193391 1.000000 0.000000 0.238383 0.465828 4.809985 -c  796.0
$PROGRAM  -l 2 0.193148 1.000000 0.000000 0.238084 0.466755 4.818069 -c  797.0
$PROGRAM  -l 2 0.192906 1.000000 0.000000 0.237786 0.467680 4.826151 -c  798.0
$PROGRAM  -l 2 0.192664 1.000000 0.000000 0.237488 0.468603 4.834231 -c  799.0
$PROGRAM  -l 2 0.192424 1.000000 0.000000 0.237191 0.469525 4.842309 -c  800.0
$PROGRAM  -l 2 0.192183 1.000000 0.000000 0.236895 0.470444 4.850387 -c  801.0
$PROGRAM  -l 2 0.191944 1.000000 0.000000 0.236600 0.471361 4.858460 -c  802.0
$PROGRAM  -l 2 0.191705 1.000000 0.000000 0.236305 0.472276 4.866533 -c  803.0
$PROGRAM  -l 2 0.191466 1.000000 0.000000 0.236011 0.473189 4.874605 -c  804.0
$PROGRAM  -l 2 0.191228 1.000000 0.000000 0.235718 0.474099 4.882674 -c  805.0
$PROGRAM  -l 2 0.190991 1.000000 0.000000 0.235426 0.475008 4.890741 -c  806.0
$PROGRAM  -l 2 0.190754 1.000000 0.000000 0.235134 0.475914 4.898807 -c  807.0
$PROGRAM  -l 2 0.190518 1.000000 0.000000 0.234843 0.476818 4.906871 -c  808.0
$PROGRAM  -l 2 0.190283 1.000000 0.000000 0.234553 0.477719 4.914933 -c  809.0
$PROGRAM  -l 2 0.190048 1.000000 0.000000 0.234263 0.478618 4.922994 -c  810.0
$PROGRAM  -l 2 0.189814 1.000000 0.000000 0.233974 0.479514 4.931051 -c  811.0
$PROGRAM  -l 2 0.189580 1.000000 0.000000 0.233686 0.480408 4.939108 -c  812.0
$PROGRAM  -l 2 0.189347 1.000000 0.000000 0.233399 0.481300 4.947163 -c  813.0
$PROGRAM  -l 2 0.189114 1.000000 0.000000 0.233112 0.482188 4.955216 -c  814.0
$PROGRAM  -l 2 0.188882 1.000000 0.000000 0.232826 0.483075 4.963267 -c  815.0
$PROGRAM  -l 2 0.188651 1.000000 0.000000 0.232541 0.483958 4.971317 -c  816.0
$PROGRAM  -l 2 0.188420 1.000000 0.000000 0.232256 0.484839 4.979365 -c  817.0
$PROGRAM  -l 2 0.188189 1.000000 0.000000 0.231972 0.485718 4.987411 -c  818.0
$PROGRAM  -l 2 0.187960 1.000000 0.000000 0.231689 0.486594 4.995454 -c  819.0
$PROGRAM  -l 2 0.187730 1.000000 0.000000 0.231406 0.487467 5.003497 -c  820.0
$PROGRAM  -l 2 0.187502 1.000000 0.000000 0.231125 0.488337 5.011537 -c  821.0
$PROGRAM  -l 2 0.187274 1.000000 0.000000 0.230843 0.489205 5.019574 -c  822.0
$PROGRAM  -l 2 0.187046 1.000000 0.000000 0.230563 0.489960 5.027708 -c  823.0
$PROGRAM  -l 2 0.186819 1.000000 0.000000 0.230283 0.490679 5.035867 -c  824.0
$PROGRAM  -l 2 0.186593 1.000000 0.000000 0.230004 0.491398 5.044023 -c  825.0
$PROGRAM  -l 2 0.186367 1.000000 0.000000 0.229725 0.492115 5.052175 -c  826.0
$PROGRAM  -l 2 0.186141 1.000000 0.000000 0.229448 0.492833 5.060323 -c  827.0
$PROGRAM  -l 2 0.185917 1.000000 0.000000 0.229171 0.493549 5.068467 -c  828.0
$PROGRAM  -l 2 0.185692 1.000000 0.000000 0.228894 0.494266 5.076607 -c  829.0
$PROGRAM  -l 2 0.185469 1.000000 0.000000 0.228618 0.494982 5.084743 -c  830.0
$PROGRAM  -l 2 0.185245 1.000000 0.000000 0.228343 0.495699 5.092874 -c  831.0
$PROGRAM  -l 2 0.185023 1.000000 0.000000 0.228069 0.496416 5.101000 -c  832.0
$PROGRAM  -l 2 0.184801 1.000000 0.000000 0.227795 0.497133 5.109121 -c  833.0
$PROGRAM  -l 2 0.184579 1.000000 0.000000 0.227522 0.497851 5.117237 -c  834.0
$PROGRAM  -l 2 0.184358 1.000000 0.000000 0.227249 0.498570 5.125349 -c  835.0
$PROGRAM  -l 2 0.184137 1.000000 0.000000 0.226978 0.499290 5.133454 -c  836.0
$PROGRAM  -l 2 0.183917 1.000000 0.000000 0.226706 0.500011 5.141554 -c  837.0
$PROGRAM  -l 2 0.183698 1.000000 0.000000 0.226436 0.500733 5.149648 -c  838.0
$PROGRAM  -l 2 0.183479 1.000000 0.000000 0.226166 0.501457 5.157737 -c  839.0
$PROGRAM  -l 2 0.183261 1.000000 0.000000 0.225897 0.502182 5.165819 -c  840.0
$PROGRAM  -l 2 0.183043 1.000000 0.000000 0.225628 0.502910 5.173895 -c  841.0
$PROGRAM  -l 2 0.182825 1.000000 0.000000 0.225360 0.503639 5.181965 -c  842.0
$PROGRAM  -l 2 0.182608 1.000000 0.000000 0.225093 0.504370 5.190028 -c  843.0
$PROGRAM  -l 2 0.182392 1.000000 0.000000 0.224826 0.505103 5.198084 -c  844.0
$PROGRAM  -l 2 0.182176 1.000000 0.000000 0.224560 0.505839 5.206135 -c  845.0
$PROGRAM  -l 2 0.181961 1.000000 0.000000 0.224295 0.506578 5.214178 -c  846.0
$PROGRAM  -l 2 0.181746 1.000000 0.000000 0.224030 0.507319 5.222214 -c  847.0
$PROGRAM  -l 2 0.181532 1.000000 0.000000 0.223766 0.508062 5.230243 -c  848.0
$PROGRAM  -l 2 0.181318 1.000000 0.000000 0.223502 0.508809 5.238264 -c  849.0
$PROGRAM  -l 2 0.181105 1.000000 0.000000 0.223239 0.509559 5.246279 -c  850.0
$PROGRAM  -l 2 0.180892 1.000000 0.000000 0.222977 0.510312 5.254285 -c  851.0
$PROGRAM  -l 2 0.180679 1.000000 0.000000 0.222715 0.511069 5.262284 -c  852.0
$PROGRAM  -l 2 0.180468 1.000000 0.000000 0.222454 0.511829 5.270275 -c  853.0
$PROGRAM  -l 2 0.180256 1.000000 0.000000 0.222194 0.512593 5.278259 -c  854.0
$PROGRAM  -l 2 0.180046 1.000000 0.000000 0.221934 0.513360 5.286234 -c  855.0
$PROGRAM  -l 2 0.179835 1.000000 0.000000 0.221674 0.514131 5.294201 -c  856.0
$PROGRAM  -l 2 0.179625 1.000000 0.000000 0.221416 0.514906 5.302161 -c  857.0
$PROGRAM  -l 2 0.179416 1.000000 0.000000 0.221158 0.515686 5.310111 -c  858.0
$PROGRAM  -l 2 0.179207 1.000000 0.000000 0.220900 0.516469 5.318053 -c  859.0
$PROGRAM  -l 2 0.178999 1.000000 0.000000 0.220643 0.517257 5.325988 -c  860.0
$PROGRAM  -l 2 0.178791 1.000000 0.000000 0.220387 0.518050 5.333912 -c  861.0
$PROGRAM  -l 2 0.178583 1.000000 0.000000 0.220131 0.518847 5.341829 -c  862.0
$PROGRAM  -l 2 0.178376 1.000000 0.000000 0.219876 0.519648 5.349736 -c  863.0
$PROGRAM  -l 2 0.178170 1.000000 0.000000 0.219622 0.520455 5.357634 -c  864.0
$PROGRAM  -l 2 0.177964 1.000000 0.000000 0.219368 0.521266 5.365525 -c  865.0
$PROGRAM  -l 2 0.177759 1.000000 0.000000 0.219115 0.522083 5.373405 -c  866.0
$PROGRAM  -l 2 0.177554 1.000000 0.000000 0.218862 0.522904 5.381277 -c  867.0
$PROGRAM  -l 2 0.177349 1.000000 0.000000 0.218610 0.523731 5.389139 -c  868.0
$PROGRAM  -l 2 0.177145 1.000000 0.000000 0.218358 0.524563 5.396992 -c  869.0
$PROGRAM  -l 2 0.176941 1.000000 0.000000 0.218107 0.525400 5.404835 -c  870.0
$PROGRAM  -l 2 0.176738 1.000000 0.000000 0.217857 0.526243 5.412670 -c  871.0
$PROGRAM  -l 2 0.176535 1.000000 0.000000 0.217607 0.527091 5.420494 -c  872.0
$PROGRAM  -l 2 0.176333 1.000000 0.000000 0.217358 0.527946 5.428309 -c  873.0
$PROGRAM  -l 2 0.176131 1.000000 0.000000 0.217109 0.528805 5.436115 -c  874.0
$PROGRAM  -l 2 0.175930 1.000000 0.000000 0.216861 0.529671 5.443910 -c  875.0
$PROGRAM  -l 2 0.175729 1.000000 0.000000 0.216613 0.530543 5.451696 -c  876.0
$PROGRAM  -l 2 0.175529 1.000000 0.000000 0.216366 0.531421 5.459471 -c  877.0
$PROGRAM  -l 2 0.175329 1.000000 0.000000 0.216120 0.532304 5.467238 -c  878.0
$PROGRAM  -l 2 0.175130 1.000000 0.000000 0.215874 0.533194 5.474994 -c  879.0
$PROGRAM  -l 2 0.174931 1.000000 0.000000 0.215629 0.534091 5.482740 -c  880.0
$PROGRAM  -l 2 0.174732 1.000000 0.000000 0.215384 0.534993 5.490476 -c  881.0
$PROGRAM  -l 2 0.174534 1.000000 0.000000 0.215140 0.535902 5.498202 -c  882.0
$PROGRAM  -l 2 0.174336 1.000000 0.000000 0.214896 0.536817 5.505918 -c  883.0
$PROGRAM  -l 2 0.174139 1.000000 0.000000 0.214653 0.537739 5.513624 -c  884.0
$PROGRAM  -l 2 0.173942 1.000000 0.000000 0.214410 0.538668 5.521319 -c  885.0
$PROGRAM  -l 2 0.173746 1.000000 0.000000 0.214168 0.539603 5.529004 -c  886.0
$PROGRAM  -l 2 0.173550 1.000000 0.000000 0.213927 0.540544 5.536679 -c  887.0
$PROGRAM  -l 2 0.173355 1.000000 0.000000 0.213686 0.541493 5.544344 -c  888.0
$PROGRAM  -l 2 0.173160 1.000000 0.000000 0.213446 0.542448 5.551998 -c  889.0
$PROGRAM  -l 2 0.172965 1.000000 0.000000 0.213206 0.543411 5.559643 -c  890.0
$PROGRAM  -l 2 0.172771 1.000000 0.000000 0.212967 0.544380 5.567276 -c  891.0
$PROGRAM  -l 2 0.172577 1.000000 0.000000 0.212728 0.545356 5.574899 -c  892.0
$PROGRAM  -l 2 0.172384 1.000000 0.000000 0.212490 0.546339 5.582512 -c  893.0
$PROGRAM  -l 2 0.172191 1.000000 0.000000 0.212252 0.547455 5.589948 -c  894.0
$PROGRAM  -l 2 0.171999 1.000000 0.000000 0.212015 0.548613 5.597330 -c  895.0
$PROGRAM  -l 2 0.171807 1.000000 0.000000 0.211778 0.549777 5.604700 -c  896.0
$PROGRAM  -l 2 0.171615 1.000000 0.000000 0.211542 0.550947 5.612062 -c  897.0
$PROGRAM  -l 2 0.171424 1.000000 0.000000 0.211307 0.552124 5.619415 -c  898.0
$PROGRAM  -l 2 0.171234 1.000000 0.000000 0.211072 0.553306 5.626759 -c  899.0
$PROGRAM  -l 2 0.171043 1.000000 0.000000 0.210837 0.554494 5.634095 -c  900.0
$PROGRAM  -l 2 0.170853 1.000000 0.000000 0.210603 0.555688 5.641424 -c  901.0
$PROGRAM  -l 2 0.170664 1.000000 0.000000 0.210370 0.556887 5.648743 -c  902.0
$PROGRAM  -l 2 0.170475 1.000000 0.000000 0.210137 0.558092 5.656055 -c  903.0
$PROGRAM  -l 2 0.170286 1.000000 0.000000 0.209904 0.559302 5.663359 -c  904.0
$PROGRAM  -l 2 0.170098 1.000000 0.000000 0.209672 0.560518 5.670655 -c  905.0
$PROGRAM  -l 2 0.169911 1.000000 0.000000 0.209441 0.561739 5.677944 -c  906.0
$PROGRAM  -l 2 0.169723 1.000000 0.000000 0.209210 0.562964 5.685227 -c  907.0
$PROGRAM  -l 2 0.169536 1.000000 0.000000 0.208979 0.564195 5.692501 -c  908.0
$PROGRAM  -l 2 0.169350 1.000000 0.000000 0.208750 0.565430 5.699770 -c  909.0
$PROGRAM  -l 2 0.169164 1.000000 0.000000 0.208520 0.566671 5.707032 -c  910.0
$PROGRAM  -l 2 0.168978 1.000000 0.000000 0.208291 0.567915 5.714287 -c  911.0
$PROGRAM  -l 2 0.168793 1.000000 0.000000 0.208063 0.569165 5.721536 -c  912.0
$PROGRAM  -l 2 0.168608 1.000000 0.000000 0.207835 0.570418 5.728779 -c  913.0
$PROGRAM  -l 2 0.168423 1.000000 0.000000 0.207608 0.571676 5.736016 -c  914.0
$PROGRAM  -l 2 0.168239 1.000000 0.000000 0.207381 0.572938 5.743248 -c  915.0
$PROGRAM  -l 2 0.168056 1.000000 0.000000 0.207154 0.574205 5.750474 -c  916.0
$PROGRAM  -l 2 0.167872 1.000000 0.000000 0.206928 0.575475 5.757694 -c  917.0
$PROGRAM  -l 2 0.167690 1.000000 0.000000 0.206703 0.576749 5.764909 -c  918.0
$PROGRAM  -l 2 0.167507 1.000000 0.000000 0.206478 0.578027 5.772119 -c  919.0
$PROGRAM  -l 2 0.167325 1.000000 0.000000 0.206254 0.579308 5.779325 -c  920.0
$PROGRAM  -l 2 0.167143 1.000000 0.000000 0.206030 0.580594 5.786525 -c  921.0
$PROGRAM  -l 2 0.166962 1.000000 0.000000 0.205806 0.581882 5.793722 -c  922.0
$PROGRAM  -l 2 0.166781 1.000000 0.000000 0.205583 0.583174 5.800915 -c  923.0
$PROGRAM  -l 2 0.166601 1.000000 0.000000 0.205361 0.584470 5.808101 -c  924.0
$PROGRAM  -l 2 0.166421 1.000000 0.000000 0.205139 0.585769 5.815285 -c  925.0
$PROGRAM  -l 2 0.166241 1.000000 0.000000 0.204917 0.587070 5.822465 -c  926.0
$PROGRAM  -l 2 0.166061 1.000000 0.000000 0.204696 0.588375 5.829640 -c  927.0
$PROGRAM  -l 2 0.165882 1.000000 0.000000 0.204476 0.589683 5.836813 -c  928.0
$PROGRAM  -l 2 0.165704 1.000000 0.000000 0.204255 0.590994 5.843983 -c  929.0
$PROGRAM  -l 2 0.165526 1.000000 0.000000 0.204036 0.592307 5.851148 -c  930.0
$PROGRAM  -l 2 0.165348 1.000000 0.000000 0.203817 0.593623 5.858311 -c  931.0
$PROGRAM  -l 2 0.165171 1.000000 0.000000 0.203598 0.594942 5.865470 -c  932.0
$PROGRAM  -l 2 0.164994 1.000000 0.000000 0.203380 0.596263 5.872627 -c  933.0
$PROGRAM  -l 2 0.164817 1.000000 0.000000 0.203162 0.597586 5.879782 -c  934.0
$PROGRAM  -l 2 0.164641 1.000000 0.000000 0.202945 0.598912 5.886932 -c  935.0
$PROGRAM  -l 2 0.164465 1.000000 0.000000 0.202728 0.600240 5.894082 -c  936.0
$PROGRAM  -l 2 0.164289 1.000000 0.000000 0.202512 0.601571 5.901229 -c  937.0
$PROGRAM  -l 2 0.164114 1.000000 0.000000 0.202296 0.602903 5.908374 -c  938.0
$PROGRAM  -l 2 0.163939 1.000000 0.000000 0.202080 0.604238 5.915517 -c  939.0
$PROGRAM  -l 2 0.163765 1.000000 0.000000 0.201865 0.605574 5.922658 -c  940.0
$PROGRAM  -l 2 0.163591 1.000000 0.000000 0.201651 0.606912 5.929798 -c  941.0
$PROGRAM  -l 2 0.163417 1.000000 0.000000 0.201437 0.608252 5.936935 -c  942.0
$PROGRAM  -l 2 0.163244 1.000000 0.000000 0.201223 0.609594 5.944072 -c  943.0
$PROGRAM  -l 2 0.163071 1.000000 0.000000 0.201010 0.610937 5.951206 -c  944.0
$PROGRAM  -l 2 0.162898 1.000000 0.000000 0.200797 0.612282 5.958341 -c  945.0
$PROGRAM  -l 2 0.162726 1.000000 0.000000 0.200585 0.613628 5.965474 -c  946.0
$PROGRAM  -l 2 0.162554 1.000000 0.000000 0.200373 0.614976 5.972606 -c  947.0
$PROGRAM  -l 2 0.162383 1.000000 0.000000 0.200162 0.616325 5.979737 -c  948.0
$PROGRAM  -l 2 0.162212 1.000000 0.000000 0.199951 0.617675 5.986868 -c  949.0
$PROGRAM  -l 2 0.162041 1.000000 0.000000 0.199740 0.619026 5.993998 -c  950.0
$PROGRAM  -l 2 0.161871 1.000000 0.000000 0.199530 0.620379 6.001128 -c  951.0
$PROGRAM  -l 2 0.161701 1.000000 0.000000 0.199321 0.621732 6.008257 -c  952.0
$PROGRAM  -l 2 0.161531 1.000000 0.000000 0.199112 0.623086 6.015386 -c  953.0
$PROGRAM  -l 2 0.161362 1.000000 0.000000 0.198903 0.624442 6.022516 -c  954.0
$PROGRAM  -l 2 0.161193 1.000000 0.000000 0.198695 0.625798 6.029645 -c  955.0
$PROGRAM  -l 2 0.161024 1.000000 0.000000 0.198487 0.627155 6.036774 -c  956.0
$PROGRAM  -l 2 0.160856 1.000000 0.000000 0.198279 0.628512 6.043904 -c  957.0
$PROGRAM  -l 2 0.160688 1.000000 0.000000 0.198072 0.629871 6.051034 -c  958.0
$PROGRAM  -l 2 0.160520 1.000000 0.000000 0.197866 0.631230 6.058165 -c  959.0
$PROGRAM  -l 2 0.160353 1.000000 0.000000 0.197660 0.632589 6.065296 -c  960.0
$PROGRAM  -l 2 0.160186 1.000000 0.000000 0.197454 0.633949 6.072428 -c  961.0
$PROGRAM  -l 2 0.160020 1.000000 0.000000 0.197249 0.635309 6.079561 -c  962.0
$PROGRAM  -l 2 0.159854 1.000000 0.000000 0.197044 0.636669 6.086695 -c  963.0
$PROGRAM  -l 2 0.159688 1.000000 0.000000 0.196840 0.638030 6.093830 -c  964.0
$PROGRAM  -l 2 0.159522 1.000000 0.000000 0.196636 0.639391 6.100966 -c  965.0
$PROGRAM  -l 2 0.159357 1.000000 0.000000 0.196432 0.640752 6.108103 -c  966.0
$PROGRAM  -l 2 0.159192 1.000000 0.000000 0.196229 0.642113 6.115242 -c  967.0
$PROGRAM  -l 2 0.159028 1.000000 0.000000 0.196026 0.643474 6.122381 -c  968.0
$PROGRAM  -l 2 0.158864 1.000000 0.000000 0.195824 0.644836 6.129523 -c  969.0
$PROGRAM  -l 2 0.158700 1.000000 0.000000 0.195622 0.646196 6.136667 -c  970.0
$PROGRAM  -l 2 0.158537 1.000000 0.000000 0.195421 0.647558 6.143811 -c  971.0
$PROGRAM  -l 2 0.158373 1.000000 0.000000 0.195220 0.648918 6.150957 -c  972.0
$PROGRAM  -l 2 0.158211 1.000000 0.000000 0.195019 0.650279 6.158106 -c  973.0
$PROGRAM  -l 2 0.158048 1.000000 0.000000 0.194819 0.651639 6.165257 -c  974.0
$PROGRAM  -l 2 0.157886 1.000000 0.000000 0.194619 0.652999 6.172409 -c  975.0
$PROGRAM  -l 2 0.157724 1.000000 0.000000 0.194419 0.654359 6.179564 -c  976.0
$PROGRAM  -l 2 0.157563 1.000000 0.000000 0.194220 0.655718 6.186721 -c  977.0
$PROGRAM  -l 2 0.157402 1.000000 0.000000 0.194022 0.657077 6.193881 -c  978.0
$PROGRAM  -l 2 0.157241 1.000000 0.000000 0.193824 0.658435 6.201042 -c  979.0
$PROGRAM  -l 2 0.157081 1.000000 0.000000 0.193626 0.659793 6.208207 -c  980.0
$PROGRAM  -l 2 0.156920 1.000000 0.000000 0.193429 0.661150 6.215373 -c  981.0
$PROGRAM  -l 2 0.156761 1.000000 0.000000 0.193232 0.662506 6.222542 -c  982.0
$PROGRAM  -l 2 0.156601 1.000000 0.000000 0.193035 0.663862 6.229715 -c  983.0
$PROGRAM  -l 2 0.156442 1.000000 0.000000 0.192839 0.665217 6.236890 -c  984.0
$PROGRAM  -l 2 0.156283 1.000000 0.000000 0.192643 0.666571 6.244068 -c  985.0
$PROGRAM  -l 2 0.156125 1.000000 0.000000 0.192448 0.667856 6.251338 -c  986.0
$PROGRAM  -l 2 0.155967 1.000000 0.000000 0.192253 0.669098 6.258665 -c  987.0
$PROGRAM  -l 2 0.155809 1.000000 0.000000 0.192058 0.670340 6.265993 -c  988.0
$PROGRAM  -l 2 0.155651 1.000000 0.000000 0.191864 0.671582 6.273324 -c  989.0
$PROGRAM  -l 2 0.155494 1.000000 0.000000 0.191670 0.672824 6.280656 -c  990.0
$PROGRAM  -l 2 0.155337 1.000000 0.000000 0.191477 0.674065 6.287992 -c  991.0
$PROGRAM  -l 2 0.155180 1.000000 0.000000 0.191284 0.675307 6.295328 -c  992.0
$PROGRAM  -l 2 0.155024 1.000000 0.000000 0.191091 0.676549 6.302667 -c  993.0
$PROGRAM  -l 2 0.154868 1.000000 0.000000 0.190899 0.677792 6.310007 -c  994.0
$PROGRAM  -l 2 0.154713 1.000000 0.000000 0.190707 0.679034 6.317349 -c  995.0
$PROGRAM  -l 2 0.154557 1.000000 0.000000 0.190515 0.680276 6.324693 -c  996.0
$PROGRAM  -l 2 0.154402 1.000000 0.000000 0.190324 0.681519 6.332039 -c  997.0
$PROGRAM  -l 2 0.154248 1.000000 0.000000 0.190134 0.682762 6.339387 -c  998.0
$PROGRAM  -l 2 0.154093 1.000000 0.000000 0.189943 0.684005 6.346736 -c  999.0
$PROGRAM  -l 2 0.153939 1.000000 0.000000 0.189753 0.685249 6.354087 -c 1000.0
$PROGRAM  -l 2 0.153785 1.000000 0.000000 0.189564 0.686493 6.361439 -c 1001.0
$PROGRAM  -l 2 0.153632 1.000000 0.000000 0.189375 0.687737 6.368794 -c 1002.0
$PROGRAM  -l 2 0.153479 1.000000 0.000000 0.189186 0.688982 6.376150 -c 1003.0
$PROGRAM  -l 2 0.153326 1.000000 0.000000 0.188997 0.690227 6.383507 -c 1004.0
$PROGRAM  -l 2 0.153173 1.000000 0.000000 0.188809 0.691472 6.390867 -c 1005.0
$PROGRAM  -l 2 0.153021 1.000000 0.000000 0.188622 0.692718 6.398228 -c 1006.0
$PROGRAM  -l 2 0.152869 1.000000 0.000000 0.188434 0.693965 6.405590 -c 1007.0
$PROGRAM  -l 2 0.152717 1.000000 0.000000 0.188247 0.695212 6.412954 -c 1008.0
$PROGRAM  -l 2 0.152566 1.000000 0.000000 0.188061 0.696460 6.420319 -c 1009.0
$PROGRAM  -l 2 0.152415 1.000000 0.000000 0.187875 0.697708 6.427686 -c 1010.0
$PROGRAM  -l 2 0.152264 1.000000 0.000000 0.187689 0.698957 6.435055 -c 1011.0
$PROGRAM  -l 2 0.152114 1.000000 0.000000 0.187503 0.700207 6.442425 -c 1012.0
$PROGRAM  -l 2 0.151963 1.000000 0.000000 0.187318 0.701457 6.449795 -c 1013.0
$PROGRAM  -l 2 0.151814 1.000000 0.000000 0.187134 0.702708 6.457168 -c 1014.0
$PROGRAM  -l 2 0.151664 1.000000 0.000000 0.186949 0.703960 6.464543 -c 1015.0
$PROGRAM  -l 2 0.151515 1.000000 0.000000 0.186765 0.705212 6.471917 -c 1016.0
$PROGRAM  -l 2 0.151366 1.000000 0.000000 0.186582 0.706466 6.479294 -c 1017.0
$PROGRAM  -l 2 0.151217 1.000000 0.000000 0.186398 0.707720 6.486672 -c 1018.0
$PROGRAM  -l 2 0.151069 1.000000 0.000000 0.186215 0.708975 6.494051 -c 1019.0
$PROGRAM  -l 2 0.150921 1.000000 0.000000 0.186033 0.710231 6.501432 -c 1020.0
$PROGRAM  -l 2 0.150773 1.000000 0.000000 0.185851 0.711488 6.508814 -c 1021.0
$PROGRAM  -l 2 0.150625 1.000000 0.000000 0.185669 0.712745 6.516196 -c 1022.0
$PROGRAM  -l 2 0.150478 1.000000 0.000000 0.185487 0.714004 6.523580 -c 1023.0
$PROGRAM  -l 2 0.150331 1.000000 0.000000 0.185306 0.715264 6.530965 -c 1024.0
$PROGRAM  -l 2 0.150184 1.000000 0.000000 0.185125 0.716524 6.538352 -c 1025.0
$PROGRAM  -l 2 0.150038 1.000000 0.000000 0.184945 0.717786 6.545739 -c 1026.0
$PROGRAM  -l 2 0.149892 1.000000 0.000000 0.184765 0.719049 6.553128 -c 1027.0
$PROGRAM  -l 2 0.149746 1.000000 0.000000 0.184585 0.720313 6.560518 -c 1028.0
$PROGRAM  -l 2 0.149601 1.000000 0.000000 0.184406 0.721578 6.567908 -c 1029.0
$PROGRAM  -l 2 0.149455 1.000000 0.000000 0.184227 0.722844 6.575301 -c 1030.0
$PROGRAM  -l 2 0.149310 1.000000 0.000000 0.184048 0.724111 6.582693 -c 1031.0
$PROGRAM  -l 2 0.149166 1.000000 0.000000 0.183870 0.725379 6.590087 -c 1032.0
$PROGRAM  -l 2 0.149021 1.000000 0.000000 0.183692 0.726649 6.597482 -c 1033.0
$PROGRAM  -l 2 0.148877 1.000000 0.000000 0.183514 0.727920 6.604878 -c 1034.0
$PROGRAM  -l 2 0.148733 1.000000 0.000000 0.183337 0.729192 6.612275 -c 1035.0
$PROGRAM  -l 2 0.148590 1.000000 0.000000 0.183160 0.730465 6.619671 -c 1036.0
$PROGRAM  -l 2 0.148447 1.000000 0.000000 0.182983 0.731740 6.627071 -c 1037.0
$PROGRAM  -l 2 0.148303 1.000000 0.000000 0.182807 0.733016 6.634470 -c 1038.0
$PROGRAM  -l 2 0.148161 1.000000 0.000000 0.182631 0.734293 6.641870 -c 1039.0
$PROGRAM  -l 2 0.148018 1.000000 0.000000 0.182455 0.735571 6.649271 -c 1040.0
$PROGRAM  -l 2 0.147876 1.000000 0.000000 0.182280 0.736851 6.656673 -c 1041.0
$PROGRAM  -l 2 0.147734 1.000000 0.000000 0.182105 0.738133 6.664075 -c 1042.0
$PROGRAM  -l 2 0.147593 1.000000 0.000000 0.181930 0.739415 6.671479 -c 1043.0
$PROGRAM  -l 2 0.147451 1.000000 0.000000 0.181756 0.740700 6.678883 -c 1044.0
$PROGRAM  -l 2 0.147310 1.000000 0.000000 0.181582 0.741985 6.686288 -c 1045.0
$PROGRAM  -l 2 0.147169 1.000000 0.000000 0.181409 0.743272 6.693694 -c 1046.0
$PROGRAM  -l 2 0.147029 1.000000 0.000000 0.181235 0.744561 6.701101 -c 1047.0
$PROGRAM  -l 2 0.146888 1.000000 0.000000 0.181062 0.745851 6.708507 -c 1048.0
$PROGRAM  -l 2 0.146748 1.000000 0.000000 0.180890 0.747142 6.715915 -c 1049.0
$PROGRAM  -l 2 0.146609 1.000000 0.000000 0.180718 0.748435 6.723324 -c 1050.0
$PROGRAM  -l 2 0.146469 1.000000 0.000000 0.180546 0.749730 6.730732 -c 1051.0
$PROGRAM  -l 2 0.146330 1.000000 0.000000 0.180374 0.751026 6.738141 -c 1052.0
$PROGRAM  -l 2 0.146191 1.000000 0.000000 0.180203 0.752324 6.745552 -c 1053.0
$PROGRAM  -l 2 0.146052 1.000000 0.000000 0.180032 0.753623 6.752962 -c 1054.0
$PROGRAM  -l 2 0.145914 1.000000 0.000000 0.179861 0.754924 6.760374 -c 1055.0
$PROGRAM  -l 2 0.145776 1.000000 0.000000 0.179691 0.756226 6.767786 -c 1056.0
$PROGRAM  -l 2 0.145638 1.000000 0.000000 0.179521 0.757531 6.775198 -c 1057.0
$PROGRAM  -l 2 0.145500 1.000000 0.000000 0.179351 0.758837 6.782610 -c 1058.0
$PROGRAM  -l 2 0.145363 1.000000 0.000000 0.179182 0.760144 6.790024 -c 1059.0
$PROGRAM  -l 2 0.145226 1.000000 0.000000 0.179013 0.761453 6.797438 -c 1060.0
$PROGRAM  -l 2 0.145089 1.000000 0.000000 0.178844 0.762764 6.804852 -c 1061.0
$PROGRAM  -l 2 0.144952 1.000000 0.000000 0.178676 0.764077 6.812266 -c 1062.0
$PROGRAM  -l 2 0.144816 1.000000 0.000000 0.178507 0.765391 6.819681 -c 1063.0
$PROGRAM  -l 2 0.144680 1.000000 0.000000 0.178340 0.766707 6.827097 -c 1064.0
$PROGRAM  -l 2 0.144544 1.000000 0.000000 0.178172 0.768025 6.834512 -c 1065.0
$PROGRAM  -l 2 0.144408 1.000000 0.000000 0.178005 0.769345 6.841928 -c 1066.0
$PROGRAM  -l 2 0.144273 1.000000 0.000000 0.177838 0.770667 6.849345 -c 1067.0
$PROGRAM  -l 2 0.144138 1.000000 0.000000 0.177672 0.771990 6.856761 -c 1068.0
$PROGRAM  -l 2 0.144003 1.000000 0.000000 0.177506 0.773315 6.864178 -c 1069.0
$PROGRAM  -l 2 0.143868 1.000000 0.000000 0.177340 0.774642 6.871595 -c 1070.0
$PROGRAM  -l 2 0.143734 1.000000 0.000000 0.177174 0.775970 6.879013 -c 1071.0
$PROGRAM  -l 2 0.143600 1.000000 0.000000 0.177009 0.777301 6.886430 -c 1072.0
$PROGRAM  -l 2 0.143466 1.000000 0.000000 0.176844 0.778633 6.893849 -c 1073.0
$PROGRAM  -l 2 0.143332 1.000000 0.000000 0.176679 0.779968 6.901267 -c 1074.0
$PROGRAM  -l 2 0.143199 1.000000 0.000000 0.176515 0.781304 6.908685 -c 1075.0
$PROGRAM  -l 2 0.143066 1.000000 0.000000 0.176351 0.782642 6.916104 -c 1076.0
$PROGRAM  -l 2 0.142933 1.000000 0.000000 0.176187 0.783982 6.923523 -c 1077.0
$PROGRAM  -l 2 0.142801 1.000000 0.000000 0.176024 0.785324 6.930941 -c 1078.0
$PROGRAM  -l 2 0.142668 1.000000 0.000000 0.175860 0.786668 6.938360 -c 1079.0
$PROGRAM  -l 2 0.142536 1.000000 0.000000 0.175698 0.788013 6.945780 -c 1080.0
$PROGRAM  -l 2 0.142404 1.000000 0.000000 0.175535 0.789361 6.953198 -c 1081.0
$PROGRAM  -l 2 0.142273 1.000000 0.000000 0.175373 0.790711 6.960618 -c 1082.0
$PROGRAM  -l 2 0.142141 1.000000 0.000000 0.175211 0.792062 6.968036 -c 1083.0
$PROGRAM  -l 2 0.142010 1.000000 0.000000 0.175049 0.793415 6.975457 -c 1084.0
$PROGRAM  -l 2 0.141879 1.000000 0.000000 0.174888 0.794771 6.982876 -c 1085.0
$PROGRAM  -l 2 0.141749 1.000000 0.000000 0.174727 0.796128 6.990295 -c 1086.0
$PROGRAM  -l 2 0.141618 1.000000 0.000000 0.174566 0.797488 6.997715 -c 1087.0
$PROGRAM  -l 2 0.141488 1.000000 0.000000 0.174406 0.798849 7.005134 -c 1088.0
$PROGRAM  -l 2 0.141358 1.000000 0.000000 0.174246 0.800213 7.012554 -c 1089.0
$PROGRAM  -l 2 0.141228 1.000000 0.000000 0.174086 0.801648 7.019968 -c 1090.0
$PROGRAM  -l 2 0.141099 1.000000 0.000000 0.173926 0.803094 7.027381 -c 1091.0
$PROGRAM  -l 2 0.140970 1.000000 0.000000 0.173767 0.804542 7.034795 -c 1092.0
$PROGRAM  -l 2 0.140841 1.000000 0.000000 0.173608 0.805991 7.042208 -c 1093.0
$PROGRAM  -l 2 0.140712 1.000000 0.000000 0.173449 0.807441 7.049621 -c 1094.0
$PROGRAM  -l 2 0.140584 1.000000 0.000000 0.173291 0.808894 7.057035 -c 1095.0
$PROGRAM  -l 2 0.140455 1.000000 0.000000 0.173133 0.810348 7.064448 -c 1096.0
$PROGRAM  -l 2 0.140327 1.000000 0.000000 0.172975 0.811803 7.071860 -c 1097.0
$PROGRAM  -l 2 0.140200 1.000000 0.000000 0.172817 0.813260 7.079274 -c 1098.0
$PROGRAM  -l 2 0.140072 1.000000 0.000000 0.172660 0.814719 7.086686 -c 1099.0
$PROGRAM  -l 2 0.139945 1.000000 0.000000 0.172503 0.816179 7.094099 -c 1100.0
