#! /bin/sh
# This is a test against the experimental results for Au nanoshells published by:
# A. M. Schwartzberg, T. Y. Olson, C. E. Talley and J. Z. Zhang,
# J. Phys. Chem. B, 110 (2006) 19935-19944.
#
# This is for the third case: Rc=32.0 nm, tsh=5.8 nm

PROGRAM='../../../scattnlay'

$PROGRAM  -l 2 0.502655 1.000000 0.000000 0.593761 1.536601 1.993229 -c  400.0
$PROGRAM  -l 2 0.501401 1.000000 0.000000 0.592280 1.536510 1.994153 -c  401.0
$PROGRAM  -l 2 0.500154 1.000000 0.000000 0.590807 1.536394 1.995026 -c  402.0
$PROGRAM  -l 2 0.498913 1.000000 0.000000 0.589341 1.536259 1.995847 -c  403.0
$PROGRAM  -l 2 0.497678 1.000000 0.000000 0.587882 1.536114 1.996615 -c  404.0
$PROGRAM  -l 2 0.496449 1.000000 0.000000 0.586431 1.535965 1.997332 -c  405.0
$PROGRAM  -l 2 0.495227 1.000000 0.000000 0.584986 1.535819 1.997995 -c  406.0
$PROGRAM  -l 2 0.494010 1.000000 0.000000 0.583549 1.535682 1.998605 -c  407.0
$PROGRAM  -l 2 0.492799 1.000000 0.000000 0.582119 1.535558 1.999162 -c  408.0
$PROGRAM  -l 2 0.491594 1.000000 0.000000 0.580696 1.535450 1.999666 -c  409.0
$PROGRAM  -l 2 0.490395 1.000000 0.000000 0.579279 1.535362 2.000115 -c  410.0
$PROGRAM  -l 2 0.489202 1.000000 0.000000 0.577870 1.535297 2.000511 -c  411.0
$PROGRAM  -l 2 0.488015 1.000000 0.000000 0.576467 1.535256 2.000852 -c  412.0
$PROGRAM  -l 2 0.486833 1.000000 0.000000 0.575071 1.535239 2.001138 -c  413.0
$PROGRAM  -l 2 0.485657 1.000000 0.000000 0.573682 1.535347 2.001368 -c  414.0
$PROGRAM  -l 2 0.484487 1.000000 0.000000 0.572300 1.536057 2.001529 -c  415.0
$PROGRAM  -l 2 0.483322 1.000000 0.000000 0.570924 1.536742 2.001636 -c  416.0
$PROGRAM  -l 2 0.482163 1.000000 0.000000 0.569555 1.537387 2.001689 -c  417.0
$PROGRAM  -l 2 0.481010 1.000000 0.000000 0.568193 1.537976 2.001689 -c  418.0
$PROGRAM  -l 2 0.479862 1.000000 0.000000 0.566837 1.538498 2.001635 -c  419.0
$PROGRAM  -l 2 0.478719 1.000000 0.000000 0.565487 1.538938 2.001528 -c  420.0
$PROGRAM  -l 2 0.477582 1.000000 0.000000 0.564144 1.539286 2.001367 -c  421.0
$PROGRAM  -l 2 0.476450 1.000000 0.000000 0.562807 1.539529 2.001153 -c  422.0
$PROGRAM  -l 2 0.475324 1.000000 0.000000 0.561476 1.539659 2.000885 -c  423.0
$PROGRAM  -l 2 0.474203 1.000000 0.000000 0.560152 1.539665 2.000563 -c  424.0
$PROGRAM  -l 2 0.473087 1.000000 0.000000 0.558834 1.539540 2.000187 -c  425.0
$PROGRAM  -l 2 0.471977 1.000000 0.000000 0.557522 1.539276 1.999758 -c  426.0
$PROGRAM  -l 2 0.470871 1.000000 0.000000 0.556217 1.538866 1.999274 -c  427.0
$PROGRAM  -l 2 0.469771 1.000000 0.000000 0.554917 1.538306 1.998735 -c  428.0
$PROGRAM  -l 2 0.468676 1.000000 0.000000 0.553624 1.537589 1.998142 -c  429.0
$PROGRAM  -l 2 0.467586 1.000000 0.000000 0.552336 1.536712 1.997494 -c  430.0
$PROGRAM  -l 2 0.466501 1.000000 0.000000 0.551055 1.535672 1.996791 -c  431.0
$PROGRAM  -l 2 0.465421 1.000000 0.000000 0.549779 1.533427 1.996262 -c  432.0
$PROGRAM  -l 2 0.464347 1.000000 0.000000 0.548509 1.530952 1.995691 -c  433.0
$PROGRAM  -l 2 0.463277 1.000000 0.000000 0.547246 1.528384 1.995047 -c  434.0
$PROGRAM  -l 2 0.462212 1.000000 0.000000 0.545988 1.525741 1.994325 -c  435.0
$PROGRAM  -l 2 0.461152 1.000000 0.000000 0.544735 1.523038 1.993522 -c  436.0
$PROGRAM  -l 2 0.460096 1.000000 0.000000 0.543489 1.520290 1.992635 -c  437.0
$PROGRAM  -l 2 0.459046 1.000000 0.000000 0.542248 1.517512 1.991661 -c  438.0
$PROGRAM  -l 2 0.458000 1.000000 0.000000 0.541013 1.514717 1.990596 -c  439.0
$PROGRAM  -l 2 0.456959 1.000000 0.000000 0.539783 1.511915 1.989441 -c  440.0
$PROGRAM  -l 2 0.455923 1.000000 0.000000 0.538559 1.509118 1.988191 -c  441.0
$PROGRAM  -l 2 0.454892 1.000000 0.000000 0.537341 1.506335 1.986848 -c  442.0
$PROGRAM  -l 2 0.453865 1.000000 0.000000 0.536128 1.503575 1.985409 -c  443.0
$PROGRAM  -l 2 0.452843 1.000000 0.000000 0.534920 1.500844 1.983874 -c  444.0
$PROGRAM  -l 2 0.451825 1.000000 0.000000 0.533718 1.498149 1.982245 -c  445.0
$PROGRAM  -l 2 0.450812 1.000000 0.000000 0.532522 1.495495 1.980520 -c  446.0
$PROGRAM  -l 2 0.449803 1.000000 0.000000 0.531330 1.492887 1.978701 -c  447.0
$PROGRAM  -l 2 0.448799 1.000000 0.000000 0.530144 1.490326 1.976790 -c  448.0
$PROGRAM  -l 2 0.447800 1.000000 0.000000 0.528964 1.487815 1.974787 -c  449.0
$PROGRAM  -l 2 0.446805 1.000000 0.000000 0.527788 1.485354 1.972696 -c  450.0
$PROGRAM  -l 2 0.445814 1.000000 0.000000 0.526618 1.482943 1.970518 -c  451.0
$PROGRAM  -l 2 0.444828 1.000000 0.000000 0.525453 1.481362 1.968188 -c  452.0
$PROGRAM  -l 2 0.443846 1.000000 0.000000 0.524293 1.480489 1.965720 -c  453.0
$PROGRAM  -l 2 0.442868 1.000000 0.000000 0.523138 1.479561 1.963184 -c  454.0
$PROGRAM  -l 2 0.441895 1.000000 0.000000 0.521988 1.478554 1.960587 -c  455.0
$PROGRAM  -l 2 0.440926 1.000000 0.000000 0.520844 1.477447 1.957935 -c  456.0
$PROGRAM  -l 2 0.439961 1.000000 0.000000 0.519704 1.476218 1.955232 -c  457.0
$PROGRAM  -l 2 0.439000 1.000000 0.000000 0.518569 1.474849 1.952487 -c  458.0
$PROGRAM  -l 2 0.438044 1.000000 0.000000 0.517439 1.473320 1.949704 -c  459.0
$PROGRAM  -l 2 0.437092 1.000000 0.000000 0.516315 1.471612 1.946891 -c  460.0
$PROGRAM  -l 2 0.436144 1.000000 0.000000 0.515195 1.469708 1.944055 -c  461.0
$PROGRAM  -l 2 0.435200 1.000000 0.000000 0.514080 1.467591 1.941202 -c  462.0
$PROGRAM  -l 2 0.434260 1.000000 0.000000 0.512969 1.465247 1.938340 -c  463.0
$PROGRAM  -l 2 0.433324 1.000000 0.000000 0.511864 1.462659 1.935476 -c  464.0
$PROGRAM  -l 2 0.432392 1.000000 0.000000 0.510763 1.459815 1.932618 -c  465.0
$PROGRAM  -l 2 0.431464 1.000000 0.000000 0.509667 1.456700 1.929773 -c  466.0
$PROGRAM  -l 2 0.430540 1.000000 0.000000 0.508575 1.453303 1.926951 -c  467.0
$PROGRAM  -l 2 0.429620 1.000000 0.000000 0.507489 1.449612 1.924158 -c  468.0
$PROGRAM  -l 2 0.428704 1.000000 0.000000 0.506407 1.445616 1.921403 -c  469.0
$PROGRAM  -l 2 0.427792 1.000000 0.000000 0.505329 1.441307 1.918695 -c  470.0
$PROGRAM  -l 2 0.426884 1.000000 0.000000 0.504256 1.436675 1.916042 -c  471.0
$PROGRAM  -l 2 0.425979 1.000000 0.000000 0.503188 1.431712 1.913454 -c  472.0
$PROGRAM  -l 2 0.425079 1.000000 0.000000 0.502124 1.426354 1.909830 -c  473.0
$PROGRAM  -l 2 0.424182 1.000000 0.000000 0.501065 1.420649 1.906235 -c  474.0
$PROGRAM  -l 2 0.423289 1.000000 0.000000 0.500010 1.414599 1.902791 -c  475.0
$PROGRAM  -l 2 0.422400 1.000000 0.000000 0.498960 1.408199 1.899520 -c  476.0
$PROGRAM  -l 2 0.421514 1.000000 0.000000 0.497914 1.401445 1.896444 -c  477.0
$PROGRAM  -l 2 0.420632 1.000000 0.000000 0.496872 1.394336 1.893582 -c  478.0
$PROGRAM  -l 2 0.419754 1.000000 0.000000 0.495835 1.386869 1.890954 -c  479.0
$PROGRAM  -l 2 0.418880 1.000000 0.000000 0.494802 1.379042 1.888578 -c  480.0
$PROGRAM  -l 2 0.418009 1.000000 0.000000 0.493773 1.370856 1.886471 -c  481.0
$PROGRAM  -l 2 0.417142 1.000000 0.000000 0.492749 1.362311 1.884649 -c  482.0
$PROGRAM  -l 2 0.416278 1.000000 0.000000 0.491728 1.353406 1.883127 -c  483.0
$PROGRAM  -l 2 0.415418 1.000000 0.000000 0.490712 1.344144 1.881920 -c  484.0
$PROGRAM  -l 2 0.414561 1.000000 0.000000 0.489701 1.334526 1.881039 -c  485.0
$PROGRAM  -l 2 0.413708 1.000000 0.000000 0.488693 1.324555 1.880498 -c  486.0
$PROGRAM  -l 2 0.412859 1.000000 0.000000 0.487690 1.314235 1.880307 -c  487.0
$PROGRAM  -l 2 0.412013 1.000000 0.000000 0.486690 1.303570 1.880477 -c  488.0
$PROGRAM  -l 2 0.411170 1.000000 0.000000 0.485695 1.292563 1.881016 -c  489.0
$PROGRAM  -l 2 0.410331 1.000000 0.000000 0.484704 1.281220 1.881933 -c  490.0
$PROGRAM  -l 2 0.409496 1.000000 0.000000 0.483717 1.269548 1.883236 -c  491.0
$PROGRAM  -l 2 0.408663 1.000000 0.000000 0.482733 1.257552 1.884931 -c  492.0
$PROGRAM  -l 2 0.407834 1.000000 0.000000 0.481754 1.245239 1.887023 -c  493.0
$PROGRAM  -l 2 0.407009 1.000000 0.000000 0.480779 1.232616 1.889517 -c  494.0
$PROGRAM  -l 2 0.406187 1.000000 0.000000 0.479808 1.219693 1.892418 -c  495.0
$PROGRAM  -l 2 0.405368 1.000000 0.000000 0.478840 1.206478 1.895728 -c  496.0
$PROGRAM  -l 2 0.404552 1.000000 0.000000 0.477877 1.192021 1.899959 -c  497.0
$PROGRAM  -l 2 0.403740 1.000000 0.000000 0.476917 1.175735 1.905424 -c  498.0
$PROGRAM  -l 2 0.402931 1.000000 0.000000 0.475962 1.159311 1.911229 -c  499.0
$PROGRAM  -l 2 0.402125 1.000000 0.000000 0.475010 1.142782 1.917363 -c  500.0
$PROGRAM  -l 2 0.401322 1.000000 0.000000 0.474062 1.126179 1.923814 -c  501.0
$PROGRAM  -l 2 0.400523 1.000000 0.000000 0.473117 1.109535 1.930574 -c  502.0
$PROGRAM  -l 2 0.399726 1.000000 0.000000 0.472177 1.092878 1.937632 -c  503.0
$PROGRAM  -l 2 0.398933 1.000000 0.000000 0.471240 1.076239 1.944979 -c  504.0
$PROGRAM  -l 2 0.398143 1.000000 0.000000 0.470307 1.059646 1.952606 -c  505.0
$PROGRAM  -l 2 0.397356 1.000000 0.000000 0.469377 1.043126 1.960505 -c  506.0
$PROGRAM  -l 2 0.396573 1.000000 0.000000 0.468452 1.026705 1.968667 -c  507.0
$PROGRAM  -l 2 0.395792 1.000000 0.000000 0.467529 1.010408 1.977085 -c  508.0
$PROGRAM  -l 2 0.395014 1.000000 0.000000 0.466611 0.994261 1.985752 -c  509.0
$PROGRAM  -l 2 0.394240 1.000000 0.000000 0.465696 0.978285 1.994658 -c  510.0
$PROGRAM  -l 2 0.393468 1.000000 0.000000 0.464785 0.962505 2.003799 -c  511.0
$PROGRAM  -l 2 0.392700 1.000000 0.000000 0.463877 0.946942 2.013166 -c  512.0
$PROGRAM  -l 2 0.391934 1.000000 0.000000 0.462973 0.931616 2.022753 -c  513.0
$PROGRAM  -l 2 0.391172 1.000000 0.000000 0.462072 0.916548 2.032554 -c  514.0
$PROGRAM  -l 2 0.390412 1.000000 0.000000 0.461175 0.901757 2.042561 -c  515.0
$PROGRAM  -l 2 0.389656 1.000000 0.000000 0.460281 0.887260 2.052769 -c  516.0
$PROGRAM  -l 2 0.388902 1.000000 0.000000 0.459391 0.873074 2.063171 -c  517.0
$PROGRAM  -l 2 0.388151 1.000000 0.000000 0.458504 0.859216 2.073761 -c  518.0
$PROGRAM  -l 2 0.387403 1.000000 0.000000 0.457620 0.845702 2.084532 -c  519.0
$PROGRAM  -l 2 0.386658 1.000000 0.000000 0.456740 0.832544 2.095479 -c  520.0
$PROGRAM  -l 2 0.385916 1.000000 0.000000 0.455864 0.819757 2.106594 -c  521.0
$PROGRAM  -l 2 0.385177 1.000000 0.000000 0.454990 0.808193 2.117971 -c  522.0
$PROGRAM  -l 2 0.384441 1.000000 0.000000 0.454120 0.798675 2.129699 -c  523.0
$PROGRAM  -l 2 0.383707 1.000000 0.000000 0.453254 0.789473 2.141568 -c  524.0
$PROGRAM  -l 2 0.382976 1.000000 0.000000 0.452390 0.780574 2.153569 -c  525.0
$PROGRAM  -l 2 0.382248 1.000000 0.000000 0.451530 0.771968 2.165692 -c  526.0
$PROGRAM  -l 2 0.381523 1.000000 0.000000 0.450674 0.763642 2.177929 -c  527.0
$PROGRAM  -l 2 0.380800 1.000000 0.000000 0.449820 0.755585 2.190271 -c  528.0
$PROGRAM  -l 2 0.380080 1.000000 0.000000 0.448970 0.747787 2.202708 -c  529.0
$PROGRAM  -l 2 0.379363 1.000000 0.000000 0.448123 0.740236 2.215231 -c  530.0
$PROGRAM  -l 2 0.378649 1.000000 0.000000 0.447279 0.732922 2.227834 -c  531.0
$PROGRAM  -l 2 0.377937 1.000000 0.000000 0.446438 0.725836 2.240506 -c  532.0
$PROGRAM  -l 2 0.377228 1.000000 0.000000 0.445600 0.718966 2.253239 -c  533.0
$PROGRAM  -l 2 0.376521 1.000000 0.000000 0.444766 0.712303 2.266027 -c  534.0
$PROGRAM  -l 2 0.375818 1.000000 0.000000 0.443935 0.705837 2.278861 -c  535.0
$PROGRAM  -l 2 0.375117 1.000000 0.000000 0.443106 0.699559 2.291734 -c  536.0
$PROGRAM  -l 2 0.374418 1.000000 0.000000 0.442281 0.693459 2.304637 -c  537.0
$PROGRAM  -l 2 0.373722 1.000000 0.000000 0.441459 0.687529 2.317565 -c  538.0
$PROGRAM  -l 2 0.373029 1.000000 0.000000 0.440640 0.681760 2.330510 -c  539.0
$PROGRAM  -l 2 0.372338 1.000000 0.000000 0.439824 0.676143 2.343465 -c  540.0
$PROGRAM  -l 2 0.371650 1.000000 0.000000 0.439011 0.670670 2.356425 -c  541.0
$PROGRAM  -l 2 0.370964 1.000000 0.000000 0.438201 0.665333 2.369382 -c  542.0
$PROGRAM  -l 2 0.370281 1.000000 0.000000 0.437394 0.660124 2.382331 -c  543.0
$PROGRAM  -l 2 0.369600 1.000000 0.000000 0.436590 0.655035 2.395266 -c  544.0
$PROGRAM  -l 2 0.368922 1.000000 0.000000 0.435789 0.650059 2.408182 -c  545.0
$PROGRAM  -l 2 0.368246 1.000000 0.000000 0.434991 0.645190 2.421073 -c  546.0
$PROGRAM  -l 2 0.367573 1.000000 0.000000 0.434196 0.640419 2.433934 -c  547.0
$PROGRAM  -l 2 0.366902 1.000000 0.000000 0.433403 0.635740 2.446762 -c  548.0
$PROGRAM  -l 2 0.366234 1.000000 0.000000 0.432614 0.631147 2.459550 -c  549.0
$PROGRAM  -l 2 0.365568 1.000000 0.000000 0.431827 0.626188 2.471780 -c  550.0
$PROGRAM  -l 2 0.364905 1.000000 0.000000 0.431044 0.621054 2.483677 -c  551.0
$PROGRAM  -l 2 0.364244 1.000000 0.000000 0.430263 0.616007 2.495545 -c  552.0
$PROGRAM  -l 2 0.363585 1.000000 0.000000 0.429485 0.611045 2.507386 -c  553.0
$PROGRAM  -l 2 0.362929 1.000000 0.000000 0.428710 0.606169 2.519201 -c  554.0
$PROGRAM  -l 2 0.362275 1.000000 0.000000 0.427937 0.601376 2.530992 -c  555.0
$PROGRAM  -l 2 0.361623 1.000000 0.000000 0.427167 0.596666 2.542761 -c  556.0
$PROGRAM  -l 2 0.360974 1.000000 0.000000 0.426401 0.592039 2.554508 -c  557.0
$PROGRAM  -l 2 0.360327 1.000000 0.000000 0.425636 0.587492 2.566235 -c  558.0
$PROGRAM  -l 2 0.359683 1.000000 0.000000 0.424875 0.583025 2.577945 -c  559.0
$PROGRAM  -l 2 0.359040 1.000000 0.000000 0.424116 0.578637 2.589637 -c  560.0
$PROGRAM  -l 2 0.358400 1.000000 0.000000 0.423360 0.574328 2.601314 -c  561.0
$PROGRAM  -l 2 0.357763 1.000000 0.000000 0.422607 0.570095 2.612975 -c  562.0
$PROGRAM  -l 2 0.357127 1.000000 0.000000 0.421856 0.565939 2.624624 -c  563.0
$PROGRAM  -l 2 0.356494 1.000000 0.000000 0.421108 0.561858 2.636260 -c  564.0
$PROGRAM  -l 2 0.355863 1.000000 0.000000 0.420363 0.557851 2.647885 -c  565.0
$PROGRAM  -l 2 0.355234 1.000000 0.000000 0.419620 0.553917 2.659499 -c  566.0
$PROGRAM  -l 2 0.354608 1.000000 0.000000 0.418880 0.550056 2.671104 -c  567.0
$PROGRAM  -l 2 0.353983 1.000000 0.000000 0.418143 0.546266 2.682701 -c  568.0
$PROGRAM  -l 2 0.353361 1.000000 0.000000 0.417408 0.542546 2.694290 -c  569.0
$PROGRAM  -l 2 0.352741 1.000000 0.000000 0.416676 0.538895 2.705872 -c  570.0
$PROGRAM  -l 2 0.352124 1.000000 0.000000 0.415946 0.535313 2.717449 -c  571.0
$PROGRAM  -l 2 0.351508 1.000000 0.000000 0.415219 0.531798 2.729019 -c  572.0
$PROGRAM  -l 2 0.350895 1.000000 0.000000 0.414494 0.528350 2.740585 -c  573.0
$PROGRAM  -l 2 0.350283 1.000000 0.000000 0.413772 0.524967 2.752148 -c  574.0
$PROGRAM  -l 2 0.349674 1.000000 0.000000 0.413052 0.521648 2.763706 -c  575.0
$PROGRAM  -l 2 0.349067 1.000000 0.000000 0.412335 0.518393 2.775261 -c  576.0
$PROGRAM  -l 2 0.348462 1.000000 0.000000 0.411621 0.515200 2.786813 -c  577.0
$PROGRAM  -l 2 0.347859 1.000000 0.000000 0.410909 0.512068 2.798363 -c  578.0
$PROGRAM  -l 2 0.347258 1.000000 0.000000 0.410199 0.508997 2.809910 -c  579.0
$PROGRAM  -l 2 0.346660 1.000000 0.000000 0.409492 0.505986 2.821456 -c  580.0
$PROGRAM  -l 2 0.346063 1.000000 0.000000 0.408787 0.503033 2.833001 -c  581.0
$PROGRAM  -l 2 0.345468 1.000000 0.000000 0.408085 0.500138 2.844544 -c  582.0
$PROGRAM  -l 2 0.344876 1.000000 0.000000 0.407385 0.497310 2.856122 -c  583.0
$PROGRAM  -l 2 0.344285 1.000000 0.000000 0.406687 0.494634 2.868020 -c  584.0
$PROGRAM  -l 2 0.343697 1.000000 0.000000 0.405992 0.492009 2.879906 -c  585.0
$PROGRAM  -l 2 0.343110 1.000000 0.000000 0.405299 0.489435 2.891778 -c  586.0
$PROGRAM  -l 2 0.342526 1.000000 0.000000 0.404609 0.486909 2.903635 -c  587.0
$PROGRAM  -l 2 0.341943 1.000000 0.000000 0.403920 0.484431 2.915475 -c  588.0
$PROGRAM  -l 2 0.341363 1.000000 0.000000 0.403235 0.481998 2.927296 -c  589.0
$PROGRAM  -l 2 0.340784 1.000000 0.000000 0.402551 0.479610 2.939097 -c  590.0
$PROGRAM  -l 2 0.340207 1.000000 0.000000 0.401870 0.477264 2.950876 -c  591.0
$PROGRAM  -l 2 0.339633 1.000000 0.000000 0.401191 0.474961 2.962631 -c  592.0
$PROGRAM  -l 2 0.339060 1.000000 0.000000 0.400515 0.472698 2.974362 -c  593.0
$PROGRAM  -l 2 0.338489 1.000000 0.000000 0.399840 0.470474 2.986066 -c  594.0
$PROGRAM  -l 2 0.337920 1.000000 0.000000 0.399168 0.468288 2.997741 -c  595.0
$PROGRAM  -l 2 0.337353 1.000000 0.000000 0.398499 0.466138 3.009387 -c  596.0
$PROGRAM  -l 2 0.336788 1.000000 0.000000 0.397831 0.464024 3.021003 -c  597.0
$PROGRAM  -l 2 0.336225 1.000000 0.000000 0.397166 0.461945 3.032586 -c  598.0
$PROGRAM  -l 2 0.335664 1.000000 0.000000 0.396503 0.459899 3.044137 -c  599.0
$PROGRAM  -l 2 0.335104 1.000000 0.000000 0.395842 0.457885 3.055653 -c  600.0
$PROGRAM  -l 2 0.334547 1.000000 0.000000 0.395183 0.455902 3.067133 -c  601.0
$PROGRAM  -l 2 0.333991 1.000000 0.000000 0.394527 0.453949 3.078577 -c  602.0
$PROGRAM  -l 2 0.333437 1.000000 0.000000 0.393873 0.452025 3.089982 -c  603.0
$PROGRAM  -l 2 0.332885 1.000000 0.000000 0.393221 0.450129 3.101349 -c  604.0
$PROGRAM  -l 2 0.332335 1.000000 0.000000 0.392571 0.448261 3.112676 -c  605.0
$PROGRAM  -l 2 0.331787 1.000000 0.000000 0.391923 0.446419 3.123961 -c  606.0
$PROGRAM  -l 2 0.331240 1.000000 0.000000 0.391277 0.444602 3.135206 -c  607.0
$PROGRAM  -l 2 0.330695 1.000000 0.000000 0.390634 0.442810 3.146407 -c  608.0
$PROGRAM  -l 2 0.330152 1.000000 0.000000 0.389992 0.441042 3.157565 -c  609.0
$PROGRAM  -l 2 0.329611 1.000000 0.000000 0.389353 0.439297 3.168679 -c  610.0
$PROGRAM  -l 2 0.329071 1.000000 0.000000 0.388716 0.437574 3.179747 -c  611.0
$PROGRAM  -l 2 0.328534 1.000000 0.000000 0.388081 0.435872 3.190770 -c  612.0
$PROGRAM  -l 2 0.327998 1.000000 0.000000 0.387447 0.434192 3.201746 -c  613.0
$PROGRAM  -l 2 0.327464 1.000000 0.000000 0.386816 0.432531 3.212676 -c  614.0
$PROGRAM  -l 2 0.326931 1.000000 0.000000 0.386187 0.430891 3.223558 -c  615.0
$PROGRAM  -l 2 0.326400 1.000000 0.000000 0.385561 0.429269 3.234392 -c  616.0
$PROGRAM  -l 2 0.325871 1.000000 0.000000 0.384936 0.427666 3.245177 -c  617.0
$PROGRAM  -l 2 0.325344 1.000000 0.000000 0.384313 0.425995 3.255828 -c  618.0
$PROGRAM  -l 2 0.324819 1.000000 0.000000 0.383692 0.424144 3.266235 -c  619.0
$PROGRAM  -l 2 0.324295 1.000000 0.000000 0.383073 0.422316 3.276597 -c  620.0
$PROGRAM  -l 2 0.323772 1.000000 0.000000 0.382456 0.420510 3.286915 -c  621.0
$PROGRAM  -l 2 0.323252 1.000000 0.000000 0.381841 0.418727 3.297189 -c  622.0
$PROGRAM  -l 2 0.322733 1.000000 0.000000 0.381228 0.416969 3.307422 -c  623.0
$PROGRAM  -l 2 0.322216 1.000000 0.000000 0.380617 0.415236 3.317612 -c  624.0
$PROGRAM  -l 2 0.321700 1.000000 0.000000 0.380008 0.413529 3.327762 -c  625.0
$PROGRAM  -l 2 0.321186 1.000000 0.000000 0.379401 0.411848 3.337873 -c  626.0
$PROGRAM  -l 2 0.320674 1.000000 0.000000 0.378796 0.410194 3.347944 -c  627.0
$PROGRAM  -l 2 0.320164 1.000000 0.000000 0.378193 0.408567 3.357976 -c  628.0
$PROGRAM  -l 2 0.319655 1.000000 0.000000 0.377592 0.406969 3.367971 -c  629.0
$PROGRAM  -l 2 0.319147 1.000000 0.000000 0.376993 0.405400 3.377929 -c  630.0
$PROGRAM  -l 2 0.318641 1.000000 0.000000 0.376395 0.403860 3.387851 -c  631.0
$PROGRAM  -l 2 0.318137 1.000000 0.000000 0.375800 0.402350 3.397738 -c  632.0
$PROGRAM  -l 2 0.317635 1.000000 0.000000 0.375206 0.400870 3.407589 -c  633.0
$PROGRAM  -l 2 0.317134 1.000000 0.000000 0.374614 0.399422 3.417407 -c  634.0
$PROGRAM  -l 2 0.316634 1.000000 0.000000 0.374024 0.398005 3.427192 -c  635.0
$PROGRAM  -l 2 0.316136 1.000000 0.000000 0.373436 0.396620 3.436944 -c  636.0
$PROGRAM  -l 2 0.315640 1.000000 0.000000 0.372850 0.395268 3.446664 -c  637.0
$PROGRAM  -l 2 0.315145 1.000000 0.000000 0.372265 0.393948 3.456352 -c  638.0
$PROGRAM  -l 2 0.314652 1.000000 0.000000 0.371683 0.392662 3.466010 -c  639.0
$PROGRAM  -l 2 0.314160 1.000000 0.000000 0.371102 0.391409 3.475639 -c  640.0
$PROGRAM  -l 2 0.313670 1.000000 0.000000 0.370523 0.390191 3.485238 -c  641.0
$PROGRAM  -l 2 0.313182 1.000000 0.000000 0.369946 0.389007 3.494808 -c  642.0
$PROGRAM  -l 2 0.312695 1.000000 0.000000 0.369371 0.387857 3.504350 -c  643.0
$PROGRAM  -l 2 0.312209 1.000000 0.000000 0.368797 0.386743 3.513866 -c  644.0
$PROGRAM  -l 2 0.311725 1.000000 0.000000 0.368225 0.385664 3.523354 -c  645.0
$PROGRAM  -l 2 0.311243 1.000000 0.000000 0.367655 0.384621 3.532816 -c  646.0
$PROGRAM  -l 2 0.310762 1.000000 0.000000 0.367087 0.383614 3.542252 -c  647.0
$PROGRAM  -l 2 0.310282 1.000000 0.000000 0.366521 0.382643 3.551663 -c  648.0
$PROGRAM  -l 2 0.309804 1.000000 0.000000 0.365956 0.381709 3.561050 -c  649.0
$PROGRAM  -l 2 0.309327 1.000000 0.000000 0.365393 0.380811 3.570413 -c  650.0
$PROGRAM  -l 2 0.308852 1.000000 0.000000 0.364832 0.379950 3.579753 -c  651.0
$PROGRAM  -l 2 0.308378 1.000000 0.000000 0.364272 0.379126 3.589070 -c  652.0
$PROGRAM  -l 2 0.307906 1.000000 0.000000 0.363714 0.378339 3.598364 -c  653.0
$PROGRAM  -l 2 0.307435 1.000000 0.000000 0.363158 0.377589 3.607637 -c  654.0
$PROGRAM  -l 2 0.306966 1.000000 0.000000 0.362604 0.376877 3.616889 -c  655.0
$PROGRAM  -l 2 0.306498 1.000000 0.000000 0.362051 0.376202 3.626119 -c  656.0
$PROGRAM  -l 2 0.306032 1.000000 0.000000 0.361500 0.375564 3.635330 -c  657.0
$PROGRAM  -l 2 0.305566 1.000000 0.000000 0.360950 0.374964 3.644520 -c  658.0
$PROGRAM  -l 2 0.305103 1.000000 0.000000 0.360403 0.374402 3.653692 -c  659.0
$PROGRAM  -l 2 0.304641 1.000000 0.000000 0.359857 0.373877 3.662844 -c  660.0
$PROGRAM  -l 2 0.304180 1.000000 0.000000 0.359312 0.373514 3.672018 -c  661.0
$PROGRAM  -l 2 0.303720 1.000000 0.000000 0.358769 0.373273 3.681201 -c  662.0
$PROGRAM  -l 2 0.303262 1.000000 0.000000 0.358228 0.373063 3.690364 -c  663.0
$PROGRAM  -l 2 0.302805 1.000000 0.000000 0.357689 0.372886 3.699509 -c  664.0
$PROGRAM  -l 2 0.302350 1.000000 0.000000 0.357151 0.372740 3.708635 -c  665.0
$PROGRAM  -l 2 0.301896 1.000000 0.000000 0.356615 0.372624 3.717742 -c  666.0
$PROGRAM  -l 2 0.301443 1.000000 0.000000 0.356080 0.372538 3.726831 -c  667.0
$PROGRAM  -l 2 0.300992 1.000000 0.000000 0.355547 0.372482 3.735903 -c  668.0
$PROGRAM  -l 2 0.300542 1.000000 0.000000 0.355016 0.372454 3.744956 -c  669.0
$PROGRAM  -l 2 0.300094 1.000000 0.000000 0.354486 0.372453 3.753992 -c  670.0
$PROGRAM  -l 2 0.299646 1.000000 0.000000 0.353957 0.372480 3.763011 -c  671.0
$PROGRAM  -l 2 0.299201 1.000000 0.000000 0.353431 0.372534 3.772012 -c  672.0
$PROGRAM  -l 2 0.298756 1.000000 0.000000 0.352906 0.372613 3.780997 -c  673.0
$PROGRAM  -l 2 0.298313 1.000000 0.000000 0.352382 0.372717 3.789964 -c  674.0
$PROGRAM  -l 2 0.297871 1.000000 0.000000 0.351860 0.372847 3.798915 -c  675.0
$PROGRAM  -l 2 0.297430 1.000000 0.000000 0.351339 0.373000 3.807850 -c  676.0
$PROGRAM  -l 2 0.296991 1.000000 0.000000 0.350820 0.373177 3.816769 -c  677.0
$PROGRAM  -l 2 0.296553 1.000000 0.000000 0.350303 0.373377 3.825672 -c  678.0
$PROGRAM  -l 2 0.296116 1.000000 0.000000 0.349787 0.373599 3.834559 -c  679.0
$PROGRAM  -l 2 0.295681 1.000000 0.000000 0.349273 0.373843 3.843431 -c  680.0
$PROGRAM  -l 2 0.295246 1.000000 0.000000 0.348760 0.374107 3.852287 -c  681.0
$PROGRAM  -l 2 0.294813 1.000000 0.000000 0.348248 0.374393 3.861129 -c  682.0
$PROGRAM  -l 2 0.294382 1.000000 0.000000 0.347739 0.374698 3.869955 -c  683.0
$PROGRAM  -l 2 0.293951 1.000000 0.000000 0.347230 0.375023 3.878767 -c  684.0
$PROGRAM  -l 2 0.293522 1.000000 0.000000 0.346723 0.375367 3.887564 -c  685.0
$PROGRAM  -l 2 0.293094 1.000000 0.000000 0.346218 0.375730 3.896348 -c  686.0
$PROGRAM  -l 2 0.292668 1.000000 0.000000 0.345714 0.376110 3.905116 -c  687.0
$PROGRAM  -l 2 0.292242 1.000000 0.000000 0.345211 0.376508 3.913872 -c  688.0
$PROGRAM  -l 2 0.291818 1.000000 0.000000 0.344710 0.376923 3.922613 -c  689.0
$PROGRAM  -l 2 0.291395 1.000000 0.000000 0.344211 0.377354 3.931341 -c  690.0
$PROGRAM  -l 2 0.290974 1.000000 0.000000 0.343713 0.377800 3.940056 -c  691.0
$PROGRAM  -l 2 0.290553 1.000000 0.000000 0.343216 0.378263 3.948757 -c  692.0
$PROGRAM  -l 2 0.290134 1.000000 0.000000 0.342721 0.378740 3.957446 -c  693.0
$PROGRAM  -l 2 0.289716 1.000000 0.000000 0.342227 0.379231 3.966121 -c  694.0
$PROGRAM  -l 2 0.289299 1.000000 0.000000 0.341734 0.379737 3.974785 -c  695.0
$PROGRAM  -l 2 0.288883 1.000000 0.000000 0.341243 0.380256 3.983435 -c  696.0
$PROGRAM  -l 2 0.288469 1.000000 0.000000 0.340754 0.380788 3.992074 -c  697.0
$PROGRAM  -l 2 0.288056 1.000000 0.000000 0.340266 0.381333 4.000700 -c  698.0
$PROGRAM  -l 2 0.287644 1.000000 0.000000 0.339779 0.381890 4.009315 -c  699.0
$PROGRAM  -l 2 0.287233 1.000000 0.000000 0.339294 0.382459 4.017918 -c  700.0
$PROGRAM  -l 2 0.286823 1.000000 0.000000 0.338810 0.383040 4.026509 -c  701.0
$PROGRAM  -l 2 0.286414 1.000000 0.000000 0.338327 0.383631 4.035090 -c  702.0
$PROGRAM  -l 2 0.286007 1.000000 0.000000 0.337846 0.384233 4.043659 -c  703.0
$PROGRAM  -l 2 0.285601 1.000000 0.000000 0.337366 0.384845 4.052216 -c  704.0
$PROGRAM  -l 2 0.285195 1.000000 0.000000 0.336887 0.385467 4.060764 -c  705.0
$PROGRAM  -l 2 0.284792 1.000000 0.000000 0.336410 0.386056 4.069299 -c  706.0
$PROGRAM  -l 2 0.284389 1.000000 0.000000 0.335934 0.386622 4.077820 -c  707.0
$PROGRAM  -l 2 0.283987 1.000000 0.000000 0.335460 0.387198 4.086334 -c  708.0
$PROGRAM  -l 2 0.283587 1.000000 0.000000 0.334987 0.387783 4.094836 -c  709.0
$PROGRAM  -l 2 0.283187 1.000000 0.000000 0.334515 0.388378 4.103328 -c  710.0
$PROGRAM  -l 2 0.282789 1.000000 0.000000 0.334044 0.388982 4.111811 -c  711.0
$PROGRAM  -l 2 0.282392 1.000000 0.000000 0.333575 0.389596 4.120284 -c  712.0
$PROGRAM  -l 2 0.281996 1.000000 0.000000 0.333107 0.390219 4.128747 -c  713.0
$PROGRAM  -l 2 0.281601 1.000000 0.000000 0.332641 0.390850 4.137202 -c  714.0
$PROGRAM  -l 2 0.281207 1.000000 0.000000 0.332176 0.391491 4.145648 -c  715.0
$PROGRAM  -l 2 0.280814 1.000000 0.000000 0.331712 0.392139 4.154084 -c  716.0
$PROGRAM  -l 2 0.280422 1.000000 0.000000 0.331249 0.392797 4.162512 -c  717.0
$PROGRAM  -l 2 0.280032 1.000000 0.000000 0.330788 0.393462 4.170931 -c  718.0
$PROGRAM  -l 2 0.279642 1.000000 0.000000 0.330328 0.394136 4.179341 -c  719.0
$PROGRAM  -l 2 0.279254 1.000000 0.000000 0.329869 0.394818 4.187744 -c  720.0
$PROGRAM  -l 2 0.278867 1.000000 0.000000 0.329411 0.395507 4.196138 -c  721.0
$PROGRAM  -l 2 0.278480 1.000000 0.000000 0.328955 0.396204 4.204525 -c  722.0
$PROGRAM  -l 2 0.278095 1.000000 0.000000 0.328500 0.396909 4.212903 -c  723.0
$PROGRAM  -l 2 0.277711 1.000000 0.000000 0.328046 0.397621 4.221274 -c  724.0
$PROGRAM  -l 2 0.277328 1.000000 0.000000 0.327594 0.398341 4.229637 -c  725.0
$PROGRAM  -l 2 0.276946 1.000000 0.000000 0.327143 0.399067 4.237993 -c  726.0
$PROGRAM  -l 2 0.276565 1.000000 0.000000 0.326693 0.399800 4.246341 -c  727.0
$PROGRAM  -l 2 0.276185 1.000000 0.000000 0.326244 0.400540 4.254683 -c  728.0
$PROGRAM  -l 2 0.275806 1.000000 0.000000 0.325796 0.401287 4.263017 -c  729.0
$PROGRAM  -l 2 0.275429 1.000000 0.000000 0.325350 0.402041 4.271345 -c  730.0
$PROGRAM  -l 2 0.275052 1.000000 0.000000 0.324905 0.402800 4.279666 -c  731.0
$PROGRAM  -l 2 0.274676 1.000000 0.000000 0.324461 0.403566 4.287980 -c  732.0
$PROGRAM  -l 2 0.274301 1.000000 0.000000 0.324018 0.404338 4.296289 -c  733.0
$PROGRAM  -l 2 0.273928 1.000000 0.000000 0.323577 0.405116 4.304590 -c  734.0
$PROGRAM  -l 2 0.273555 1.000000 0.000000 0.323137 0.405900 4.312886 -c  735.0
$PROGRAM  -l 2 0.273183 1.000000 0.000000 0.322698 0.406690 4.321176 -c  736.0
$PROGRAM  -l 2 0.272813 1.000000 0.000000 0.322260 0.407485 4.329459 -c  737.0
$PROGRAM  -l 2 0.272443 1.000000 0.000000 0.321823 0.408285 4.337736 -c  738.0
$PROGRAM  -l 2 0.272074 1.000000 0.000000 0.321388 0.409091 4.346008 -c  739.0
$PROGRAM  -l 2 0.271707 1.000000 0.000000 0.320953 0.409902 4.354274 -c  740.0
$PROGRAM  -l 2 0.271340 1.000000 0.000000 0.320520 0.410718 4.362536 -c  741.0
$PROGRAM  -l 2 0.270974 1.000000 0.000000 0.320088 0.411539 4.370792 -c  742.0
$PROGRAM  -l 2 0.270610 1.000000 0.000000 0.319658 0.412365 4.379043 -c  743.0
$PROGRAM  -l 2 0.270246 1.000000 0.000000 0.319228 0.413195 4.387287 -c  744.0
$PROGRAM  -l 2 0.269883 1.000000 0.000000 0.318799 0.414030 4.395528 -c  745.0
$PROGRAM  -l 2 0.269521 1.000000 0.000000 0.318372 0.414870 4.403764 -c  746.0
$PROGRAM  -l 2 0.269161 1.000000 0.000000 0.317946 0.415713 4.411994 -c  747.0
$PROGRAM  -l 2 0.268801 1.000000 0.000000 0.317521 0.416561 4.420220 -c  748.0
$PROGRAM  -l 2 0.268442 1.000000 0.000000 0.317097 0.417413 4.428442 -c  749.0
$PROGRAM  -l 2 0.268084 1.000000 0.000000 0.316674 0.418269 4.436659 -c  750.0
$PROGRAM  -l 2 0.267727 1.000000 0.000000 0.316252 0.419128 4.444872 -c  751.0
$PROGRAM  -l 2 0.267371 1.000000 0.000000 0.315832 0.419991 4.453080 -c  752.0
$PROGRAM  -l 2 0.267016 1.000000 0.000000 0.315412 0.420858 4.461285 -c  753.0
$PROGRAM  -l 2 0.266662 1.000000 0.000000 0.314994 0.421728 4.469484 -c  754.0
$PROGRAM  -l 2 0.266308 1.000000 0.000000 0.314577 0.422602 4.477681 -c  755.0
$PROGRAM  -l 2 0.265956 1.000000 0.000000 0.314161 0.423479 4.485874 -c  756.0
$PROGRAM  -l 2 0.265605 1.000000 0.000000 0.313746 0.424359 4.494062 -c  757.0
$PROGRAM  -l 2 0.265255 1.000000 0.000000 0.313332 0.425268 4.502252 -c  758.0
$PROGRAM  -l 2 0.264905 1.000000 0.000000 0.312919 0.426181 4.510438 -c  759.0
$PROGRAM  -l 2 0.264556 1.000000 0.000000 0.312507 0.427097 4.518620 -c  760.0
$PROGRAM  -l 2 0.264209 1.000000 0.000000 0.312097 0.428015 4.526799 -c  761.0
$PROGRAM  -l 2 0.263862 1.000000 0.000000 0.311687 0.428935 4.534975 -c  762.0
$PROGRAM  -l 2 0.263516 1.000000 0.000000 0.311279 0.429857 4.543147 -c  763.0
$PROGRAM  -l 2 0.263171 1.000000 0.000000 0.310871 0.430782 4.551315 -c  764.0
$PROGRAM  -l 2 0.262827 1.000000 0.000000 0.310465 0.431707 4.559482 -c  765.0
$PROGRAM  -l 2 0.262484 1.000000 0.000000 0.310060 0.432635 4.567644 -c  766.0
$PROGRAM  -l 2 0.262142 1.000000 0.000000 0.309655 0.433564 4.575803 -c  767.0
$PROGRAM  -l 2 0.261801 1.000000 0.000000 0.309252 0.434494 4.583959 -c  768.0
$PROGRAM  -l 2 0.261460 1.000000 0.000000 0.308850 0.435425 4.592112 -c  769.0
$PROGRAM  -l 2 0.261121 1.000000 0.000000 0.308449 0.436357 4.600263 -c  770.0
$PROGRAM  -l 2 0.260782 1.000000 0.000000 0.308049 0.437291 4.608411 -c  771.0
$PROGRAM  -l 2 0.260444 1.000000 0.000000 0.307650 0.438224 4.616556 -c  772.0
$PROGRAM  -l 2 0.260107 1.000000 0.000000 0.307252 0.439159 4.624697 -c  773.0
$PROGRAM  -l 2 0.259771 1.000000 0.000000 0.306855 0.440094 4.632837 -c  774.0
$PROGRAM  -l 2 0.259436 1.000000 0.000000 0.306459 0.441029 4.640973 -c  775.0
$PROGRAM  -l 2 0.259102 1.000000 0.000000 0.306064 0.441965 4.649108 -c  776.0
$PROGRAM  -l 2 0.258768 1.000000 0.000000 0.305670 0.442901 4.657239 -c  777.0
$PROGRAM  -l 2 0.258436 1.000000 0.000000 0.305277 0.443836 4.665368 -c  778.0
$PROGRAM  -l 2 0.258104 1.000000 0.000000 0.304885 0.444772 4.673494 -c  779.0
$PROGRAM  -l 2 0.257773 1.000000 0.000000 0.304494 0.445708 4.681619 -c  780.0
$PROGRAM  -l 2 0.257443 1.000000 0.000000 0.304105 0.446643 4.689740 -c  781.0
$PROGRAM  -l 2 0.257114 1.000000 0.000000 0.303716 0.447577 4.697860 -c  782.0
$PROGRAM  -l 2 0.256785 1.000000 0.000000 0.303328 0.448511 4.705977 -c  783.0
$PROGRAM  -l 2 0.256458 1.000000 0.000000 0.302941 0.449445 4.714092 -c  784.0
$PROGRAM  -l 2 0.256131 1.000000 0.000000 0.302555 0.450377 4.722204 -c  785.0
$PROGRAM  -l 2 0.255805 1.000000 0.000000 0.302170 0.451309 4.730316 -c  786.0
$PROGRAM  -l 2 0.255480 1.000000 0.000000 0.301786 0.452240 4.738424 -c  787.0
$PROGRAM  -l 2 0.255156 1.000000 0.000000 0.301403 0.453170 4.746530 -c  788.0
$PROGRAM  -l 2 0.254833 1.000000 0.000000 0.301021 0.454098 4.754635 -c  789.0
$PROGRAM  -l 2 0.254510 1.000000 0.000000 0.300640 0.455026 4.762737 -c  790.0
$PROGRAM  -l 2 0.254188 1.000000 0.000000 0.300260 0.455952 4.770837 -c  791.0
$PROGRAM  -l 2 0.253867 1.000000 0.000000 0.299881 0.456877 4.778935 -c  792.0
$PROGRAM  -l 2 0.253547 1.000000 0.000000 0.299503 0.457800 4.787031 -c  793.0
$PROGRAM  -l 2 0.253228 1.000000 0.000000 0.299125 0.458722 4.795125 -c  794.0
$PROGRAM  -l 2 0.252909 1.000000 0.000000 0.298749 0.459642 4.803218 -c  795.0
$PROGRAM  -l 2 0.252592 1.000000 0.000000 0.298374 0.460561 4.811308 -c  796.0
$PROGRAM  -l 2 0.252275 1.000000 0.000000 0.298000 0.461477 4.819397 -c  797.0
$PROGRAM  -l 2 0.251959 1.000000 0.000000 0.297626 0.462392 4.827484 -c  798.0
$PROGRAM  -l 2 0.251643 1.000000 0.000000 0.297254 0.463305 4.835568 -c  799.0
$PROGRAM  -l 2 0.251329 1.000000 0.000000 0.296882 0.464216 4.843651 -c  800.0
$PROGRAM  -l 2 0.251015 1.000000 0.000000 0.296511 0.465126 4.851733 -c  801.0
$PROGRAM  -l 2 0.250702 1.000000 0.000000 0.296142 0.466033 4.859812 -c  802.0
$PROGRAM  -l 2 0.250390 1.000000 0.000000 0.295773 0.466938 4.867889 -c  803.0
$PROGRAM  -l 2 0.250078 1.000000 0.000000 0.295405 0.467840 4.875966 -c  804.0
$PROGRAM  -l 2 0.249768 1.000000 0.000000 0.295038 0.468741 4.884040 -c  805.0
$PROGRAM  -l 2 0.249458 1.000000 0.000000 0.294672 0.469639 4.892112 -c  806.0
$PROGRAM  -l 2 0.249149 1.000000 0.000000 0.294307 0.470535 4.900183 -c  807.0
$PROGRAM  -l 2 0.248840 1.000000 0.000000 0.293943 0.471428 4.908251 -c  808.0
$PROGRAM  -l 2 0.248533 1.000000 0.000000 0.293579 0.472319 4.916318 -c  809.0
$PROGRAM  -l 2 0.248226 1.000000 0.000000 0.293217 0.473208 4.924384 -c  810.0
$PROGRAM  -l 2 0.247920 1.000000 0.000000 0.292855 0.474094 4.932446 -c  811.0
$PROGRAM  -l 2 0.247615 1.000000 0.000000 0.292495 0.474978 4.940508 -c  812.0
$PROGRAM  -l 2 0.247310 1.000000 0.000000 0.292135 0.475859 4.948568 -c  813.0
$PROGRAM  -l 2 0.247006 1.000000 0.000000 0.291776 0.476738 4.956626 -c  814.0
$PROGRAM  -l 2 0.246703 1.000000 0.000000 0.291418 0.477614 4.964683 -c  815.0
$PROGRAM  -l 2 0.246401 1.000000 0.000000 0.291061 0.478487 4.972737 -c  816.0
$PROGRAM  -l 2 0.246099 1.000000 0.000000 0.290705 0.479358 4.980790 -c  817.0
$PROGRAM  -l 2 0.245798 1.000000 0.000000 0.290349 0.480226 4.988841 -c  818.0
$PROGRAM  -l 2 0.245498 1.000000 0.000000 0.289995 0.481092 4.996889 -c  819.0
$PROGRAM  -l 2 0.245199 1.000000 0.000000 0.289641 0.481954 5.004937 -c  820.0
$PROGRAM  -l 2 0.244900 1.000000 0.000000 0.289288 0.482815 5.012982 -c  821.0
$PROGRAM  -l 2 0.244602 1.000000 0.000000 0.288936 0.483672 5.021025 -c  822.0
$PROGRAM  -l 2 0.244305 1.000000 0.000000 0.288585 0.484417 5.029163 -c  823.0
$PROGRAM  -l 2 0.244009 1.000000 0.000000 0.288235 0.485126 5.037328 -c  824.0
$PROGRAM  -l 2 0.243713 1.000000 0.000000 0.287886 0.485834 5.045489 -c  825.0
$PROGRAM  -l 2 0.243418 1.000000 0.000000 0.287537 0.486542 5.053646 -c  826.0
$PROGRAM  -l 2 0.243123 1.000000 0.000000 0.287189 0.487249 5.061800 -c  827.0
$PROGRAM  -l 2 0.242830 1.000000 0.000000 0.286843 0.487955 5.069949 -c  828.0
$PROGRAM  -l 2 0.242537 1.000000 0.000000 0.286497 0.488661 5.078095 -c  829.0
$PROGRAM  -l 2 0.242245 1.000000 0.000000 0.286151 0.489368 5.086236 -c  830.0
$PROGRAM  -l 2 0.241953 1.000000 0.000000 0.285807 0.490074 5.094372 -c  831.0
$PROGRAM  -l 2 0.241662 1.000000 0.000000 0.285464 0.490781 5.102503 -c  832.0
$PROGRAM  -l 2 0.241372 1.000000 0.000000 0.285121 0.491488 5.110630 -c  833.0
$PROGRAM  -l 2 0.241083 1.000000 0.000000 0.284779 0.492195 5.118752 -c  834.0
$PROGRAM  -l 2 0.240794 1.000000 0.000000 0.284438 0.492904 5.126869 -c  835.0
$PROGRAM  -l 2 0.240506 1.000000 0.000000 0.284098 0.493614 5.134979 -c  836.0
$PROGRAM  -l 2 0.240219 1.000000 0.000000 0.283758 0.494324 5.143084 -c  837.0
$PROGRAM  -l 2 0.239932 1.000000 0.000000 0.283420 0.495036 5.151184 -c  838.0
$PROGRAM  -l 2 0.239646 1.000000 0.000000 0.283082 0.495750 5.159278 -c  839.0
$PROGRAM  -l 2 0.239361 1.000000 0.000000 0.282745 0.496465 5.167366 -c  840.0
$PROGRAM  -l 2 0.239076 1.000000 0.000000 0.282409 0.497182 5.175447 -c  841.0
$PROGRAM  -l 2 0.238792 1.000000 0.000000 0.282073 0.497900 5.183523 -c  842.0
$PROGRAM  -l 2 0.238509 1.000000 0.000000 0.281739 0.498621 5.191591 -c  843.0
$PROGRAM  -l 2 0.238226 1.000000 0.000000 0.281405 0.499344 5.199653 -c  844.0
$PROGRAM  -l 2 0.237944 1.000000 0.000000 0.281072 0.500069 5.207709 -c  845.0
$PROGRAM  -l 2 0.237663 1.000000 0.000000 0.280740 0.500797 5.215758 -c  846.0
$PROGRAM  -l 2 0.237383 1.000000 0.000000 0.280408 0.501528 5.223799 -c  847.0
$PROGRAM  -l 2 0.237103 1.000000 0.000000 0.280078 0.502261 5.231833 -c  848.0
$PROGRAM  -l 2 0.236823 1.000000 0.000000 0.279748 0.502998 5.239860 -c  849.0
$PROGRAM  -l 2 0.236545 1.000000 0.000000 0.279418 0.503737 5.247880 -c  850.0
$PROGRAM  -l 2 0.236267 1.000000 0.000000 0.279090 0.504480 5.255892 -c  851.0
$PROGRAM  -l 2 0.235989 1.000000 0.000000 0.278763 0.505226 5.263897 -c  852.0
$PROGRAM  -l 2 0.235713 1.000000 0.000000 0.278436 0.505975 5.271894 -c  853.0
$PROGRAM  -l 2 0.235437 1.000000 0.000000 0.278110 0.506728 5.279883 -c  854.0
$PROGRAM  -l 2 0.235161 1.000000 0.000000 0.277784 0.507485 5.287864 -c  855.0
$PROGRAM  -l 2 0.234887 1.000000 0.000000 0.277460 0.508245 5.295836 -c  856.0
$PROGRAM  -l 2 0.234613 1.000000 0.000000 0.277136 0.509010 5.303801 -c  857.0
$PROGRAM  -l 2 0.234339 1.000000 0.000000 0.276813 0.509779 5.311757 -c  858.0
$PROGRAM  -l 2 0.234066 1.000000 0.000000 0.276491 0.510552 5.319705 -c  859.0
$PROGRAM  -l 2 0.233794 1.000000 0.000000 0.276169 0.511329 5.327645 -c  860.0
$PROGRAM  -l 2 0.233523 1.000000 0.000000 0.275849 0.512111 5.335575 -c  861.0
$PROGRAM  -l 2 0.233252 1.000000 0.000000 0.275529 0.512897 5.343498 -c  862.0
$PROGRAM  -l 2 0.232982 1.000000 0.000000 0.275209 0.513688 5.351411 -c  863.0
$PROGRAM  -l 2 0.232712 1.000000 0.000000 0.274891 0.514484 5.359315 -c  864.0
$PROGRAM  -l 2 0.232443 1.000000 0.000000 0.274573 0.515284 5.367212 -c  865.0
$PROGRAM  -l 2 0.232174 1.000000 0.000000 0.274256 0.516090 5.375097 -c  866.0
$PROGRAM  -l 2 0.231907 1.000000 0.000000 0.273940 0.516900 5.382974 -c  867.0
$PROGRAM  -l 2 0.231639 1.000000 0.000000 0.273624 0.517716 5.390843 -c  868.0
$PROGRAM  -l 2 0.231373 1.000000 0.000000 0.273309 0.518537 5.398701 -c  869.0
$PROGRAM  -l 2 0.231107 1.000000 0.000000 0.272995 0.519364 5.406550 -c  870.0
$PROGRAM  -l 2 0.230842 1.000000 0.000000 0.272682 0.520196 5.414390 -c  871.0
$PROGRAM  -l 2 0.230577 1.000000 0.000000 0.272369 0.521033 5.422220 -c  872.0
$PROGRAM  -l 2 0.230313 1.000000 0.000000 0.272057 0.521877 5.430041 -c  873.0
$PROGRAM  -l 2 0.230049 1.000000 0.000000 0.271746 0.522726 5.437853 -c  874.0
$PROGRAM  -l 2 0.229786 1.000000 0.000000 0.271435 0.523580 5.445653 -c  875.0
$PROGRAM  -l 2 0.229524 1.000000 0.000000 0.271125 0.524441 5.453445 -c  876.0
$PROGRAM  -l 2 0.229262 1.000000 0.000000 0.270816 0.525308 5.461226 -c  877.0
$PROGRAM  -l 2 0.229001 1.000000 0.000000 0.270508 0.526181 5.468998 -c  878.0
$PROGRAM  -l 2 0.228741 1.000000 0.000000 0.270200 0.527059 5.476761 -c  879.0
$PROGRAM  -l 2 0.228481 1.000000 0.000000 0.269893 0.527945 5.484512 -c  880.0
$PROGRAM  -l 2 0.228221 1.000000 0.000000 0.269587 0.528836 5.492254 -c  881.0
$PROGRAM  -l 2 0.227963 1.000000 0.000000 0.269281 0.529734 5.499986 -c  882.0
$PROGRAM  -l 2 0.227705 1.000000 0.000000 0.268976 0.530638 5.507707 -c  883.0
$PROGRAM  -l 2 0.227447 1.000000 0.000000 0.268672 0.531549 5.515420 -c  884.0
$PROGRAM  -l 2 0.227190 1.000000 0.000000 0.268368 0.532466 5.523121 -c  885.0
$PROGRAM  -l 2 0.226934 1.000000 0.000000 0.268065 0.533390 5.530811 -c  886.0
$PROGRAM  -l 2 0.226678 1.000000 0.000000 0.267763 0.534321 5.538492 -c  887.0
$PROGRAM  -l 2 0.226422 1.000000 0.000000 0.267461 0.535258 5.546163 -c  888.0
$PROGRAM  -l 2 0.226168 1.000000 0.000000 0.267161 0.536202 5.553823 -c  889.0
$PROGRAM  -l 2 0.225914 1.000000 0.000000 0.266860 0.537153 5.561473 -c  890.0
$PROGRAM  -l 2 0.225660 1.000000 0.000000 0.266561 0.538111 5.569113 -c  891.0
$PROGRAM  -l 2 0.225407 1.000000 0.000000 0.266262 0.539076 5.576741 -c  892.0
$PROGRAM  -l 2 0.225155 1.000000 0.000000 0.265964 0.540048 5.584360 -c  893.0
$PROGRAM  -l 2 0.224903 1.000000 0.000000 0.265666 0.541152 5.591802 -c  894.0
$PROGRAM  -l 2 0.224652 1.000000 0.000000 0.265370 0.542298 5.599189 -c  895.0
$PROGRAM  -l 2 0.224401 1.000000 0.000000 0.265073 0.543451 5.606566 -c  896.0
$PROGRAM  -l 2 0.224151 1.000000 0.000000 0.264778 0.544609 5.613933 -c  897.0
$PROGRAM  -l 2 0.223901 1.000000 0.000000 0.264483 0.545774 5.621293 -c  898.0
$PROGRAM  -l 2 0.223652 1.000000 0.000000 0.264189 0.546945 5.628643 -c  899.0
$PROGRAM  -l 2 0.223403 1.000000 0.000000 0.263895 0.548121 5.635984 -c  900.0
$PROGRAM  -l 2 0.223155 1.000000 0.000000 0.263602 0.549303 5.643318 -c  901.0
$PROGRAM  -l 2 0.222908 1.000000 0.000000 0.263310 0.550491 5.650644 -c  902.0
$PROGRAM  -l 2 0.222661 1.000000 0.000000 0.263019 0.551684 5.657961 -c  903.0
$PROGRAM  -l 2 0.222415 1.000000 0.000000 0.262728 0.552882 5.665271 -c  904.0
$PROGRAM  -l 2 0.222169 1.000000 0.000000 0.262437 0.554086 5.672573 -c  905.0
$PROGRAM  -l 2 0.221924 1.000000 0.000000 0.262148 0.555295 5.679868 -c  906.0
$PROGRAM  -l 2 0.221679 1.000000 0.000000 0.261859 0.556508 5.687157 -c  907.0
$PROGRAM  -l 2 0.221435 1.000000 0.000000 0.261570 0.557727 5.694437 -c  908.0
$PROGRAM  -l 2 0.221192 1.000000 0.000000 0.261283 0.558951 5.701712 -c  909.0
$PROGRAM  -l 2 0.220948 1.000000 0.000000 0.260995 0.560179 5.708979 -c  910.0
$PROGRAM  -l 2 0.220706 1.000000 0.000000 0.260709 0.561412 5.716241 -c  911.0
$PROGRAM  -l 2 0.220464 1.000000 0.000000 0.260423 0.562649 5.723495 -c  912.0
$PROGRAM  -l 2 0.220222 1.000000 0.000000 0.260138 0.563891 5.730744 -c  913.0
$PROGRAM  -l 2 0.219982 1.000000 0.000000 0.259853 0.565137 5.737987 -c  914.0
$PROGRAM  -l 2 0.219741 1.000000 0.000000 0.259569 0.566387 5.745225 -c  915.0
$PROGRAM  -l 2 0.219501 1.000000 0.000000 0.259286 0.567641 5.752456 -c  916.0
$PROGRAM  -l 2 0.219262 1.000000 0.000000 0.259003 0.568900 5.759683 -c  917.0
$PROGRAM  -l 2 0.219023 1.000000 0.000000 0.258721 0.570162 5.766904 -c  918.0
$PROGRAM  -l 2 0.218785 1.000000 0.000000 0.258439 0.571428 5.774120 -c  919.0
$PROGRAM  -l 2 0.218547 1.000000 0.000000 0.258159 0.572697 5.781332 -c  920.0
$PROGRAM  -l 2 0.218310 1.000000 0.000000 0.257878 0.573970 5.788538 -c  921.0
$PROGRAM  -l 2 0.218073 1.000000 0.000000 0.257598 0.575247 5.795741 -c  922.0
$PROGRAM  -l 2 0.217837 1.000000 0.000000 0.257319 0.576527 5.802939 -c  923.0
$PROGRAM  -l 2 0.217601 1.000000 0.000000 0.257041 0.577810 5.810132 -c  924.0
$PROGRAM  -l 2 0.217366 1.000000 0.000000 0.256763 0.579097 5.817322 -c  925.0
$PROGRAM  -l 2 0.217131 1.000000 0.000000 0.256486 0.580386 5.824508 -c  926.0
$PROGRAM  -l 2 0.216897 1.000000 0.000000 0.256209 0.581679 5.831689 -c  927.0
$PROGRAM  -l 2 0.216663 1.000000 0.000000 0.255933 0.582975 5.838868 -c  928.0
$PROGRAM  -l 2 0.216430 1.000000 0.000000 0.255658 0.584273 5.846044 -c  929.0
$PROGRAM  -l 2 0.216197 1.000000 0.000000 0.255383 0.585574 5.853215 -c  930.0
$PROGRAM  -l 2 0.215965 1.000000 0.000000 0.255108 0.586878 5.860384 -c  931.0
$PROGRAM  -l 2 0.215733 1.000000 0.000000 0.254835 0.588185 5.867550 -c  932.0
$PROGRAM  -l 2 0.215502 1.000000 0.000000 0.254561 0.589494 5.874713 -c  933.0
$PROGRAM  -l 2 0.215271 1.000000 0.000000 0.254289 0.590805 5.881873 -c  934.0
$PROGRAM  -l 2 0.215041 1.000000 0.000000 0.254017 0.592119 5.889030 -c  935.0
$PROGRAM  -l 2 0.214811 1.000000 0.000000 0.253746 0.593435 5.896186 -c  936.0
$PROGRAM  -l 2 0.214582 1.000000 0.000000 0.253475 0.594753 5.903339 -c  937.0
$PROGRAM  -l 2 0.214353 1.000000 0.000000 0.253205 0.596073 5.910490 -c  938.0
$PROGRAM  -l 2 0.214125 1.000000 0.000000 0.252935 0.597395 5.917640 -c  939.0
$PROGRAM  -l 2 0.213897 1.000000 0.000000 0.252666 0.598719 5.924786 -c  940.0
$PROGRAM  -l 2 0.213670 1.000000 0.000000 0.252397 0.600045 5.931932 -c  941.0
$PROGRAM  -l 2 0.213443 1.000000 0.000000 0.252129 0.601373 5.939076 -c  942.0
$PROGRAM  -l 2 0.213216 1.000000 0.000000 0.251862 0.602702 5.946219 -c  943.0
$PROGRAM  -l 2 0.212991 1.000000 0.000000 0.251595 0.604033 5.953360 -c  944.0
$PROGRAM  -l 2 0.212765 1.000000 0.000000 0.251329 0.605365 5.960501 -c  945.0
$PROGRAM  -l 2 0.212540 1.000000 0.000000 0.251063 0.606699 5.967639 -c  946.0
$PROGRAM  -l 2 0.212316 1.000000 0.000000 0.250798 0.608035 5.974778 -c  947.0
$PROGRAM  -l 2 0.212092 1.000000 0.000000 0.250534 0.609371 5.981915 -c  948.0
$PROGRAM  -l 2 0.211868 1.000000 0.000000 0.250270 0.610709 5.989052 -c  949.0
$PROGRAM  -l 2 0.211645 1.000000 0.000000 0.250006 0.612048 5.996189 -c  950.0
$PROGRAM  -l 2 0.211423 1.000000 0.000000 0.249743 0.613388 6.003325 -c  951.0
$PROGRAM  -l 2 0.211201 1.000000 0.000000 0.249481 0.614729 6.010461 -c  952.0
$PROGRAM  -l 2 0.210979 1.000000 0.000000 0.249219 0.616071 6.017596 -c  953.0
$PROGRAM  -l 2 0.210758 1.000000 0.000000 0.248958 0.617414 6.024732 -c  954.0
$PROGRAM  -l 2 0.210537 1.000000 0.000000 0.248697 0.618758 6.031868 -c  955.0
$PROGRAM  -l 2 0.210317 1.000000 0.000000 0.248437 0.620102 6.039003 -c  956.0
$PROGRAM  -l 2 0.210097 1.000000 0.000000 0.248177 0.621447 6.046140 -c  957.0
$PROGRAM  -l 2 0.209878 1.000000 0.000000 0.247918 0.622793 6.053276 -c  958.0
$PROGRAM  -l 2 0.209659 1.000000 0.000000 0.247660 0.624140 6.060413 -c  959.0
$PROGRAM  -l 2 0.209441 1.000000 0.000000 0.247402 0.625487 6.067551 -c  960.0
$PROGRAM  -l 2 0.209223 1.000000 0.000000 0.247144 0.626834 6.074689 -c  961.0
$PROGRAM  -l 2 0.209005 1.000000 0.000000 0.246888 0.628182 6.081828 -c  962.0
$PROGRAM  -l 2 0.208788 1.000000 0.000000 0.246631 0.629529 6.088968 -c  963.0
$PROGRAM  -l 2 0.208572 1.000000 0.000000 0.246375 0.630878 6.096110 -c  964.0
$PROGRAM  -l 2 0.208356 1.000000 0.000000 0.246120 0.632226 6.103252 -c  965.0
$PROGRAM  -l 2 0.208140 1.000000 0.000000 0.245865 0.633575 6.110396 -c  966.0
$PROGRAM  -l 2 0.207925 1.000000 0.000000 0.245611 0.634924 6.117541 -c  967.0
$PROGRAM  -l 2 0.207710 1.000000 0.000000 0.245357 0.636272 6.124687 -c  968.0
$PROGRAM  -l 2 0.207496 1.000000 0.000000 0.245104 0.637621 6.131835 -c  969.0
$PROGRAM  -l 2 0.207282 1.000000 0.000000 0.244851 0.638969 6.138986 -c  970.0
$PROGRAM  -l 2 0.207068 1.000000 0.000000 0.244599 0.640318 6.146136 -c  971.0
$PROGRAM  -l 2 0.206855 1.000000 0.000000 0.244348 0.641666 6.153290 -c  972.0
$PROGRAM  -l 2 0.206643 1.000000 0.000000 0.244096 0.643015 6.160445 -c  973.0
$PROGRAM  -l 2 0.206430 1.000000 0.000000 0.243846 0.644362 6.167602 -c  974.0
$PROGRAM  -l 2 0.206219 1.000000 0.000000 0.243596 0.645710 6.174761 -c  975.0
$PROGRAM  -l 2 0.206007 1.000000 0.000000 0.243346 0.647057 6.181923 -c  976.0
$PROGRAM  -l 2 0.205796 1.000000 0.000000 0.243097 0.648404 6.189087 -c  977.0
$PROGRAM  -l 2 0.205586 1.000000 0.000000 0.242849 0.649750 6.196253 -c  978.0
$PROGRAM  -l 2 0.205376 1.000000 0.000000 0.242600 0.651096 6.203421 -c  979.0
$PROGRAM  -l 2 0.205167 1.000000 0.000000 0.242353 0.652441 6.210592 -c  980.0
$PROGRAM  -l 2 0.204957 1.000000 0.000000 0.242106 0.653785 6.217765 -c  981.0
$PROGRAM  -l 2 0.204749 1.000000 0.000000 0.241859 0.655129 6.224941 -c  982.0
$PROGRAM  -l 2 0.204540 1.000000 0.000000 0.241613 0.656472 6.232121 -c  983.0
$PROGRAM  -l 2 0.204332 1.000000 0.000000 0.241368 0.657815 6.239302 -c  984.0
$PROGRAM  -l 2 0.204125 1.000000 0.000000 0.241123 0.659156 6.246486 -c  985.0
$PROGRAM  -l 2 0.203918 1.000000 0.000000 0.240878 0.660428 6.253763 -c  986.0
$PROGRAM  -l 2 0.203711 1.000000 0.000000 0.240634 0.661658 6.261097 -c  987.0
$PROGRAM  -l 2 0.203505 1.000000 0.000000 0.240391 0.662888 6.268433 -c  988.0
$PROGRAM  -l 2 0.203299 1.000000 0.000000 0.240148 0.664117 6.275770 -c  989.0
$PROGRAM  -l 2 0.203094 1.000000 0.000000 0.239905 0.665347 6.283110 -c  990.0
$PROGRAM  -l 2 0.202889 1.000000 0.000000 0.239663 0.666576 6.290452 -c  991.0
$PROGRAM  -l 2 0.202685 1.000000 0.000000 0.239421 0.667806 6.297795 -c  992.0
$PROGRAM  -l 2 0.202481 1.000000 0.000000 0.239180 0.669036 6.305141 -c  993.0
$PROGRAM  -l 2 0.202277 1.000000 0.000000 0.238940 0.670266 6.312488 -c  994.0
$PROGRAM  -l 2 0.202074 1.000000 0.000000 0.238699 0.671496 6.319837 -c  995.0
$PROGRAM  -l 2 0.201871 1.000000 0.000000 0.238460 0.672726 6.327188 -c  996.0
$PROGRAM  -l 2 0.201668 1.000000 0.000000 0.238221 0.673956 6.334541 -c  997.0
$PROGRAM  -l 2 0.201466 1.000000 0.000000 0.237982 0.675187 6.341895 -c  998.0
$PROGRAM  -l 2 0.201264 1.000000 0.000000 0.237744 0.676417 6.349251 -c  999.0
$PROGRAM  -l 2 0.201063 1.000000 0.000000 0.237506 0.677649 6.356610 -c 1000.0
$PROGRAM  -l 2 0.200862 1.000000 0.000000 0.237269 0.678880 6.363969 -c 1001.0
$PROGRAM  -l 2 0.200662 1.000000 0.000000 0.237032 0.680112 6.371331 -c 1002.0
$PROGRAM  -l 2 0.200462 1.000000 0.000000 0.236796 0.681344 6.378693 -c 1003.0
$PROGRAM  -l 2 0.200262 1.000000 0.000000 0.236560 0.682577 6.386058 -c 1004.0
$PROGRAM  -l 2 0.200063 1.000000 0.000000 0.236324 0.683810 6.393425 -c 1005.0
$PROGRAM  -l 2 0.199864 1.000000 0.000000 0.236089 0.685043 6.400793 -c 1006.0
$PROGRAM  -l 2 0.199666 1.000000 0.000000 0.235855 0.686278 6.408162 -c 1007.0
$PROGRAM  -l 2 0.199467 1.000000 0.000000 0.235621 0.687512 6.415533 -c 1008.0
$PROGRAM  -l 2 0.199270 1.000000 0.000000 0.235387 0.688748 6.422906 -c 1009.0
$PROGRAM  -l 2 0.199072 1.000000 0.000000 0.235154 0.689984 6.430280 -c 1010.0
$PROGRAM  -l 2 0.198876 1.000000 0.000000 0.234922 0.691220 6.437655 -c 1011.0
$PROGRAM  -l 2 0.198679 1.000000 0.000000 0.234690 0.692457 6.445032 -c 1012.0
$PROGRAM  -l 2 0.198483 1.000000 0.000000 0.234458 0.693695 6.452410 -c 1013.0
$PROGRAM  -l 2 0.198287 1.000000 0.000000 0.234227 0.694934 6.459790 -c 1014.0
$PROGRAM  -l 2 0.198092 1.000000 0.000000 0.233996 0.696173 6.467172 -c 1015.0
$PROGRAM  -l 2 0.197897 1.000000 0.000000 0.233766 0.697413 6.474554 -c 1016.0
$PROGRAM  -l 2 0.197702 1.000000 0.000000 0.233536 0.698654 6.481937 -c 1017.0
$PROGRAM  -l 2 0.197508 1.000000 0.000000 0.233306 0.699896 6.489323 -c 1018.0
$PROGRAM  -l 2 0.197314 1.000000 0.000000 0.233077 0.701138 6.496710 -c 1019.0
$PROGRAM  -l 2 0.197121 1.000000 0.000000 0.232849 0.702382 6.504097 -c 1020.0
$PROGRAM  -l 2 0.196928 1.000000 0.000000 0.232621 0.703626 6.511487 -c 1021.0
$PROGRAM  -l 2 0.196735 1.000000 0.000000 0.232393 0.704871 6.518876 -c 1022.0
$PROGRAM  -l 2 0.196543 1.000000 0.000000 0.232166 0.706117 6.526267 -c 1023.0
$PROGRAM  -l 2 0.196351 1.000000 0.000000 0.231939 0.707365 6.533660 -c 1024.0
$PROGRAM  -l 2 0.196159 1.000000 0.000000 0.231713 0.708613 6.541054 -c 1025.0
$PROGRAM  -l 2 0.195968 1.000000 0.000000 0.231487 0.709862 6.548448 -c 1026.0
$PROGRAM  -l 2 0.195777 1.000000 0.000000 0.231262 0.711112 6.555845 -c 1027.0
$PROGRAM  -l 2 0.195587 1.000000 0.000000 0.231037 0.712364 6.563242 -c 1028.0
$PROGRAM  -l 2 0.195397 1.000000 0.000000 0.230812 0.713616 6.570639 -c 1029.0
$PROGRAM  -l 2 0.195207 1.000000 0.000000 0.230588 0.714870 6.578040 -c 1030.0
$PROGRAM  -l 2 0.195018 1.000000 0.000000 0.230365 0.716125 6.585439 -c 1031.0
$PROGRAM  -l 2 0.194829 1.000000 0.000000 0.230141 0.717380 6.592840 -c 1032.0
$PROGRAM  -l 2 0.194640 1.000000 0.000000 0.229919 0.718637 6.600243 -c 1033.0
$PROGRAM  -l 2 0.194452 1.000000 0.000000 0.229696 0.719896 6.607646 -c 1034.0
$PROGRAM  -l 2 0.194264 1.000000 0.000000 0.229474 0.721155 6.615050 -c 1035.0
$PROGRAM  -l 2 0.194076 1.000000 0.000000 0.229253 0.722416 6.622455 -c 1036.0
$PROGRAM  -l 2 0.193889 1.000000 0.000000 0.229032 0.723678 6.629861 -c 1037.0
$PROGRAM  -l 2 0.193703 1.000000 0.000000 0.228811 0.724941 6.637268 -c 1038.0
$PROGRAM  -l 2 0.193516 1.000000 0.000000 0.228591 0.726206 6.644676 -c 1039.0
$PROGRAM  -l 2 0.193330 1.000000 0.000000 0.228371 0.727472 6.652084 -c 1040.0
$PROGRAM  -l 2 0.193144 1.000000 0.000000 0.228152 0.728739 6.659494 -c 1041.0
$PROGRAM  -l 2 0.192959 1.000000 0.000000 0.227933 0.730008 6.666903 -c 1042.0
$PROGRAM  -l 2 0.192774 1.000000 0.000000 0.227714 0.731278 6.674315 -c 1043.0
$PROGRAM  -l 2 0.192589 1.000000 0.000000 0.227496 0.732550 6.681726 -c 1044.0
$PROGRAM  -l 2 0.192405 1.000000 0.000000 0.227278 0.733823 6.689139 -c 1045.0
$PROGRAM  -l 2 0.192221 1.000000 0.000000 0.227061 0.735097 6.696552 -c 1046.0
$PROGRAM  -l 2 0.192037 1.000000 0.000000 0.226844 0.736373 6.703966 -c 1047.0
$PROGRAM  -l 2 0.191854 1.000000 0.000000 0.226628 0.737651 6.711380 -c 1048.0
$PROGRAM  -l 2 0.191671 1.000000 0.000000 0.226412 0.738929 6.718796 -c 1049.0
$PROGRAM  -l 2 0.191489 1.000000 0.000000 0.226196 0.740210 6.726212 -c 1050.0
$PROGRAM  -l 2 0.191307 1.000000 0.000000 0.225981 0.741492 6.733629 -c 1051.0
$PROGRAM  -l 2 0.191125 1.000000 0.000000 0.225766 0.742776 6.741045 -c 1052.0
$PROGRAM  -l 2 0.190943 1.000000 0.000000 0.225552 0.744061 6.748463 -c 1053.0
$PROGRAM  -l 2 0.190762 1.000000 0.000000 0.225338 0.745347 6.755882 -c 1054.0
$PROGRAM  -l 2 0.190581 1.000000 0.000000 0.225124 0.746636 6.763301 -c 1055.0
$PROGRAM  -l 2 0.190401 1.000000 0.000000 0.224911 0.747925 6.770720 -c 1056.0
$PROGRAM  -l 2 0.190221 1.000000 0.000000 0.224698 0.749217 6.778140 -c 1057.0
$PROGRAM  -l 2 0.190041 1.000000 0.000000 0.224486 0.750510 6.785560 -c 1058.0
$PROGRAM  -l 2 0.189861 1.000000 0.000000 0.224274 0.751805 6.792982 -c 1059.0
$PROGRAM  -l 2 0.189682 1.000000 0.000000 0.224062 0.753102 6.800403 -c 1060.0
$PROGRAM  -l 2 0.189504 1.000000 0.000000 0.223851 0.754400 6.807825 -c 1061.0
$PROGRAM  -l 2 0.189325 1.000000 0.000000 0.223640 0.755700 6.815247 -c 1062.0
$PROGRAM  -l 2 0.189147 1.000000 0.000000 0.223430 0.757002 6.822669 -c 1063.0
$PROGRAM  -l 2 0.188969 1.000000 0.000000 0.223220 0.758305 6.830093 -c 1064.0
$PROGRAM  -l 2 0.188792 1.000000 0.000000 0.223010 0.759610 6.837516 -c 1065.0
$PROGRAM  -l 2 0.188615 1.000000 0.000000 0.222801 0.760917 6.844939 -c 1066.0
$PROGRAM  -l 2 0.188438 1.000000 0.000000 0.222592 0.762226 6.852364 -c 1067.0
$PROGRAM  -l 2 0.188261 1.000000 0.000000 0.222384 0.763537 6.859789 -c 1068.0
$PROGRAM  -l 2 0.188085 1.000000 0.000000 0.222176 0.764849 6.867213 -c 1069.0
$PROGRAM  -l 2 0.187910 1.000000 0.000000 0.221968 0.766163 6.874638 -c 1070.0
$PROGRAM  -l 2 0.187734 1.000000 0.000000 0.221761 0.767479 6.882064 -c 1071.0
$PROGRAM  -l 2 0.187559 1.000000 0.000000 0.221554 0.768797 6.889489 -c 1072.0
$PROGRAM  -l 2 0.187384 1.000000 0.000000 0.221348 0.770117 6.896915 -c 1073.0
$PROGRAM  -l 2 0.187210 1.000000 0.000000 0.221141 0.771439 6.904341 -c 1074.0
$PROGRAM  -l 2 0.187036 1.000000 0.000000 0.220936 0.772762 6.911768 -c 1075.0
$PROGRAM  -l 2 0.186862 1.000000 0.000000 0.220730 0.774087 6.919194 -c 1076.0
$PROGRAM  -l 2 0.186688 1.000000 0.000000 0.220526 0.775415 6.926621 -c 1077.0
$PROGRAM  -l 2 0.186515 1.000000 0.000000 0.220321 0.776744 6.934047 -c 1078.0
$PROGRAM  -l 2 0.186342 1.000000 0.000000 0.220117 0.778075 6.941474 -c 1079.0
$PROGRAM  -l 2 0.186170 1.000000 0.000000 0.219913 0.779408 6.948901 -c 1080.0
$PROGRAM  -l 2 0.185997 1.000000 0.000000 0.219710 0.780743 6.956327 -c 1081.0
$PROGRAM  -l 2 0.185826 1.000000 0.000000 0.219506 0.782080 6.963755 -c 1082.0
$PROGRAM  -l 2 0.185654 1.000000 0.000000 0.219304 0.783418 6.971182 -c 1083.0
$PROGRAM  -l 2 0.185483 1.000000 0.000000 0.219101 0.784759 6.978610 -c 1084.0
$PROGRAM  -l 2 0.185312 1.000000 0.000000 0.218900 0.786102 6.986037 -c 1085.0
$PROGRAM  -l 2 0.185141 1.000000 0.000000 0.218698 0.787446 6.993464 -c 1086.0
$PROGRAM  -l 2 0.184971 1.000000 0.000000 0.218497 0.788793 7.000892 -c 1087.0
$PROGRAM  -l 2 0.184801 1.000000 0.000000 0.218296 0.790142 7.008320 -c 1088.0
$PROGRAM  -l 2 0.184631 1.000000 0.000000 0.218095 0.791492 7.015747 -c 1089.0
$PROGRAM  -l 2 0.184462 1.000000 0.000000 0.217895 0.792915 7.023169 -c 1090.0
$PROGRAM  -l 2 0.184293 1.000000 0.000000 0.217696 0.794348 7.030591 -c 1091.0
$PROGRAM  -l 2 0.184124 1.000000 0.000000 0.217496 0.795783 7.038012 -c 1092.0
$PROGRAM  -l 2 0.183955 1.000000 0.000000 0.217297 0.797219 7.045433 -c 1093.0
$PROGRAM  -l 2 0.183787 1.000000 0.000000 0.217099 0.798657 7.052855 -c 1094.0
$PROGRAM  -l 2 0.183619 1.000000 0.000000 0.216900 0.800096 7.060276 -c 1095.0
$PROGRAM  -l 2 0.183452 1.000000 0.000000 0.216703 0.801537 7.067697 -c 1096.0
$PROGRAM  -l 2 0.183285 1.000000 0.000000 0.216505 0.802980 7.075118 -c 1097.0
$PROGRAM  -l 2 0.183118 1.000000 0.000000 0.216308 0.804424 7.082539 -c 1098.0
$PROGRAM  -l 2 0.182951 1.000000 0.000000 0.216111 0.805870 7.089959 -c 1099.0
$PROGRAM  -l 2 0.182785 1.000000 0.000000 0.215915 0.807317 7.097381 -c 1100.0
