from enum import Enum


class StateCodes(Enum):
    """Represents all the State Codes that can be used to query
    both company and filing information.

    ### Usage:
    ----
        >>> from edgar.enums import StateCodes
        >>> StateCodes.Texas.value
    """

    Alabama = 'AL'
    Alaska = 'AK'
    Arizona = 'AZ'
    Arkansas = 'AR'
    California = 'CA'
    Colorado = 'CO'
    Connecticut = 'CT'
    Delaware = 'DE'
    District_of_Columbia = 'DC'
    Florida = 'FL'
    Georgia = 'GA'
    Hawaii = 'HI'
    Idaho = 'ID'
    Illinois = 'IL'
    Indiana = 'IN'
    Iowa = 'IA'
    Kansas = 'KS'
    Kentucky = 'KY'
    Louisiana = 'LA'
    Maine = 'ME'
    Maryland = 'MD'
    Massachusetts = 'MA'
    Michigan = 'MI'
    Minnesota = 'MN'
    Mississippi = 'MS'
    Missouri = 'MO'
    Montana = 'MT'
    Nebraska = 'NE'
    Nevada = 'NV'
    New_Hampshire = 'NH'
    New_Jersey = 'NJ'
    New_Mexico = 'NM'
    New_York = 'NY'
    North_Carolina = 'NC'
    North_Dakota = 'ND'
    Ohio = 'OH'
    Oklahoma = 'OK'
    Oregon = 'OR'
    Pennsylvania = 'PA'
    Rhode_Island = 'RI'
    South_Carolina = 'SC'
    South_Dakota = 'SD'
    Tennessee = 'TN'
    Texas = 'TX'
    United_States = 'X1'
    Utah = 'UT'
    Vermont = 'VT'
    Virginia = 'VA'
    Washington = 'WA'
    West_Virginia = 'WV'
    Wisconsin = 'WI'
    Wyoming = 'WY'
    Alberta_Canada = 'A0'
    British_Columbia_Canada = 'A1'
    Manitoba_Canada = 'A2'
    New_Brunswick_Canada = 'A3'
    Newfoundland_Canada = 'A4'
    Nova_Scotia_Canada = 'A5'
    Ontario_Canada = 'A6'
    Prince_Edward_Island_Canada = 'A7'
    Quebec_Canada = 'A8'
    Saskatchewan_Canada = 'A9'
    Yukon_Canada = 'B0'


class CountryCodes(Enum):
    """Represents the different Country Codes that can be used to query
    filings and company info.

    ### Usage:
    ----
        >>> from edgar.enums import CountryCodes
        >>> CountryCodes.AUSTRALIA.value
    """

    AFGHANISTAN = 'B2'
    ALBANIA = 'B3'
    ALGERIA = 'B4'
    AMERICAN_SAMOA = 'B5'
    ANDORRA = 'B6'
    ANGOLA = 'B7'
    ANGUILLA = '1A'
    ANTARCTICA = 'B8'
    ANTIGUA_AND_BARBUDA = 'B9'
    ARGENTINA = 'C1'
    ARMENIA = '1B'
    ARUBA = '1C'
    AUSTRALIA = 'C3'
    AUSTRIA = 'C4'
    AZERBAIJAN = '1D'
    BAHAMAS = 'C5'
    BAHRAIN = 'C6'
    BANGLADESH = 'C7'
    BARBADOS = 'C8'
    BELARUS = '1F'
    BELGIUM = 'C9'
    BELIZE = 'D1'
    BENIN = 'G6'
    BERMUDA = 'D0'
    BHUTAN = 'D2'
    BOLIVIA = 'D3'
    BOSNIA_AND_HERZEGOVINA = '1E'
    BOTSWANA = 'B1'
    BOUVET_ISLAND = 'D4'
    BRAZIL = 'D5'
    BRITISH_INDIAN_OCEAN_TERRITORY = 'D6'
    BRUNEI_DARUSSALAM = 'D9'
    BULGARIA = 'E0'
    BURKINA_FASO = 'X2'
    BURUNDI = 'E2'
    CAMBODIA = 'E3'
    CAMEROON = 'E4'
    CAPE_VERDE = 'E8'
    CAYMAN_ISLANDS = 'E9'
    CENTRAL_AFRICAN_REPUBLIC = 'F0'
    CHAD = 'F2'
    CHILE = 'F3'
    CHINA = 'F4'
    CHRISTMAS_ISLAND = 'F6'
    COCOS_KEELING_ISLANDS = 'F7'
    COLOMBIA = 'F8'
    COMOROS = 'F9'
    CONGO = 'G0'
    CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE = 'Y3'
    COOK_ISLANDS = 'G1'
    COSTA_RICA = 'G2'
    COTE_DIVOIRE = 'L7'
    CROATIA = '1M'
    CUBA = 'G3'
    CYPRUS = 'G4'
    CZECH_REPUBLIC = '2N'
    DENMARK = 'G7'
    DJIBOUTI = '1G'
    DOMINICA = 'G9'
    DOMINICAN_REPUBLIC = 'G8'
    EAST_TIMOR = '2F'
    ECUADOR = 'H1'
    EGYPT = 'H2'
    EL_SALVADOR = 'H3'
    EQUATORIAL_GUINEA = 'H4'
    ERITREA = '1J'
    ESTONIA = '1H'
    ETHIOPIA = 'H5'
    FALKLAND_ISLANDS_MALVINAS = 'H7'
    FAROE_ISLANDS = 'H6'
    FIJI = 'H8'
    FINLAND = 'H9'
    FRANCE = 'I0'
    FRENCH_GUIANA = 'I3'
    FRENCH_POLYNESIA = 'I4'
    FRENCH_SOUTHERN_TERRITORIES = '2C'
    GABON = 'I5'
    GAMBIA = 'I6'
    GEORGIA = '2Q'
    GERMANY = '2M'
    GHANA = 'J0'
    GIBRALTAR = 'J1'
    GREECE = 'J3'
    GREENLAND = 'J4'
    GRENADA = 'J5'
    GUADELOUPE = 'J6'
    GUAM = 'GU'
    GUATEMALA = 'J8'
    GUINEA = 'J9'
    GUINEA_BISSAU = 'S0'
    GUYANA = 'K0'
    HAITI = 'K1'
    HEARD_ISLAND_AND_MCDONALD_ISLANDS = 'K4'
    HOLY_SEE_VATICAN_CITY_STATE = 'X4'
    HONDURAS = 'K2'
    HONG_KONG = 'K3'
    HUNGARY = 'K5'
    ICELAND = 'K6'
    INDIA = 'K7'
    INDONESIA = 'K8'
    IRAN_ISLAMIC_REPUBLIC_OF = 'K9'
    IRAQ = 'L0'
    IRELAND = 'L2'
    ISRAEL = 'L3'
    ITALY = 'L6'
    JAMAICA = 'L8'
    JAPAN = 'M0'
    JORDAN = 'M2'
    KAZAKSTAN = '1P'
    KENYA = 'M3'
    KIRIBATI = 'J2'
    KOREA_DEMOCRATIC_PEOPLES_REPUBLIC_OF = 'M4'
    KOREA_REPUBLIC_OF = 'M5'
    KUWAIT = 'M6'
    KYRGYZSTAN = '1N'
    LAO_PEOPLES_DEMOCRATIC_REPUBLIC = 'M7'
    LATVIA = '1R'
    LEBANON = 'M8'
    LESOTHO = 'M9'
    LIBERIA = 'N0'
    LIBYAN_ARAB_JAMAHIRIYA = 'N1'
    LIECHTENSTEIN = 'N2'
    LITHUANIA = '1Q'
    LUXEMBOURG = 'N4'
    MACAU = 'N5'
    MACEDONIA_FORMER_YUGOSLAV_REP_OF = '1U'
    MADAGASCAR = 'N6'
    MALAWI = 'N7'
    MALAYSIA = 'N8'
    MALDIVES = 'N9'
    MALI = 'O0'
    MALTA = 'O1'
    MARSHALL_ISLANDS = '1T'
    MARTINIQUE = 'O2'
    MAURITANIA = 'O3'
    MAURITIUS = 'O4'
    MAYOTTE = '2P'
    MEXICO = 'O5'
    MICRONESIA_FEDERATED_STATES_OF = '1K'
    MOLDOVA_REPUBLIC_OF = '1S'
    MONACO = 'O9'
    MONGOLIA = 'P0'
    MONTSERRAT = 'P1'
    MOROCCO = 'P2'
    MOZAMBIQUE = 'P3'
    MYANMAR = 'E1'
    NAMIBIA = 'T6'
    NAURU = 'P5'
    NEPAL = 'P6'
    NETHERLANDS = 'P7'
    NETHERLANDS_ANTILLES = 'P8'
    NEW_CALEDONIA = '1W'
    NEW_ZEALAND = 'Q2'
    NICARAGUA = 'Q3'
    NIGER = 'Q4'
    NIGERIA = 'Q5'
    NIUE = 'Q6'
    NORFOLK_ISLAND = 'Q7'
    NORTHERN_MARIANA_ISLANDS = '1V'
    NORWAY = 'Q8'
    OMAN = 'P4'
    PAKISTAN = 'R0'
    PALAU = '1Y'
    PALESTINIAN_TERRITORY_OCCUPIED = '1X'
    PANAMA = 'R1'
    PAPUA_NEW_GUINEA = 'R2'
    PARAGUAY = 'R4'
    PERU = 'R5'
    PHILIPPINES = 'R6'
    PITCAIRN = 'R8'
    POLAND = 'R9'
    PORTUGAL = 'S1'
    PUERTO_RICO = 'PR'
    QATAR = 'S3'
    REUNION = 'S4'
    ROMANIA = 'S5'
    RUSSIAN_FEDERATION = '1Z'
    RWANDA = 'S6'
    SAINT_HELENA = 'U8'
    SAINT_KITTS_AND_NEVIS = 'U7'
    SAINT_LUCIA = 'U9'
    SAINT_PIERRE_AND_MIQUELON = 'V0'
    SAINT_VINCENT_AND_THE_GRENADINES = 'V1'
    SAMOA = 'Y0'
    SAN_MARINO = 'S8'
    SAO_TOME_AND_PRINCIPE = 'S9'
    SAUDI_ARABIA = 'T0'
    SENEGAL = 'T1'
    SEYCHELLES_ = 'T2'
    SIERRA_LEONE = 'T8'
    SINGAPORE = 'U0'
    SLOVAKIA = '2B'
    SLOVENIA = '2A'
    SOLOMON_ISLANDS = 'D7'
    SOMALIA = 'U1'
    SOUTH_AFRICA = 'T3'
    SOUTH_GEORGIASO_SANDWICH_ISLANDS = '1L'
    SPAIN = 'U3'
    SRI_LANKA = 'F1'
    SUDAN = 'V2'
    SURINAME = 'V3'
    SVALBARD_AND_JAN_MAYEN = 'L9'
    SWAZILAND = 'V6'
    SWEDEN = 'V7'
    SWITZERLAND = 'V8'
    SYRIAN_ARAB_REPUBLIC = 'V9'
    TAIWAN = 'F5'
    TAJIKISTAN = '2D'
    TANZANIA_UNITED_REPUBLIC_OF = 'W0'
    THAILAND = 'W1'
    TOGO = 'W2'
    TOKELAU = 'W3'
    TONGA = 'W4'
    TRINIDAD_AND_TOBAGO = 'W5'
    TUNISIA = 'W6'
    TURKEY = 'W8'
    TURKMENISTAN = '2E'
    TURKS_AND_CAICOS_ISLANDS = 'W7'
    TUVALU = '2G'
    UGANDA = 'W9'
    UKRAINE = '2H'
    UNITED_ARAB_EMIRATES = 'C0'
    UNITED_KINGDOM = 'X0'
    UNITED_STATES_MINOR_OUTLYING_ISLANDS = '2J'
    URUGUAY = 'X3'
    UZBEKISTAN = '2K'
    VANUATU = '2L'
    VENEZUELA = 'X5'
    VIETNAM = 'Q1'
    VIRGIN_ISLANDS_BRITISH = 'D8'
    VIRGIN_ISLANDS_US = 'VI'
    WALLIS_AND_FUTUNA = 'X8'
    WESTERN_SAHARA = 'U5'
    YEMEN = 'T7'
    YUGOSLAVIA = 'Y2'
    ZAMBIA = 'Y4'
    ZIMBABWE = 'Y5'


class FilingTypeCodes(Enum):
    """Available filing types to be used when creating 
    Filing object.

    ### Usage:
    ----
        >>> from edgar.enums import FilingTypeCodes
        >>> FilingTypeCodes.FILING_1.value

    """

    FILING_1 = '1'
    FILING_1A = '1-a'
    FILING_1E = '1-e'
    FILING_1K = '1-k'
    FILING_1N = '1-n'
    FILING_1SA = '1-sa'
    FILING_1U = '1-u'
    FILING_1Z = '1-z'
    FILING_10 = '10'
    FILING_10D = '10-d'
    FILING_10K = '10-k'
    FILING_10M = '10-m'
    FILING_10Q = '10-q'
    FILING_11K = '11-k'
    FILING_12B25 = '12b-25'
    FILING_13F = '13f'
    FILING_13H = '13h'
    FILING_144 = '144'
    FILING_15 = '15'
    FILING_15F = '15f'
    FILING_17H = '17-h'
    FILING_18 = '18'
    FILING_18K = '18-k'
    FILING_19B4 = '19b-4'
    FILING_19B4E = '19b-4(e)'
    FILING_19B7 = '19b-7'
    FILING_2E = '2-e'
    FILING_20F = '20-f'
    FILING_24F2 = '24f-2'
    FILING_25 = '25'
    FILING_3 = '3'
    FILING_4 = '4'
    FILING_40F = '40-f'
    FILING_8K = '8-k'
    FILING_ABS15G = 'abs-15g'
    FILING_ABSEE = 'abs-ee'
    FILING_ADV = 'adv'
    FILING_ADVE = 'adv-e'
    FILING_ADVH = 'adv-h'
    FILING_ADVNR = 'adv-nr'
    FILING_ADVW = 'adv-w'
    FILING_ATS = 'ats'
    FILING_ATSN = 'ats-n'
    FILING_ATSR = 'ats-r'
    FILING_BD = 'bd'
    FILING_BDN = 'bd-n'
    FILING_BDW = 'bdw'
    FILING_C = 'c'
    FILING_CA1 = 'ca-1'
    FILING_CB = 'cb'
    FILING_CFPORTAL = 'cfportal'
    FILING_CUSTODY = 'custody'
    FILING_D = 'd'
    FILING_DEF_14A = 'def 14a'
    FILING_F1 = 'f-1'
    FILING_F10 = 'f-10'
    FILING_F3 = 'f-3'
    FILING_F4 = 'f-4'
    FILING_F6 = 'f-6'
    FILING_F7 = 'f-7'
    FILING_F8 = 'f-8'
    FILING_F80 = 'f-80'
    FILING_FN = 'f-n'
    FILING_FX = 'f-x'
    FILING_ID = 'id'
    FILING_MA = 'ma'
    FILING_MAI = 'ma-i'
    FILING_MANR = 'ma-nr'
    FILING_MAW = 'ma-w'
    FILING_MSD = 'msd'
    FILING_MSDW = 'msdw'
    FILING_N14 = 'n-14'
    FILING_N17D1 = 'n-17d-1'
    FILING_N17F1 = 'n-17f-1'
    FILING_N17F2 = 'n-17f-2'
    FILING_N18F1 = 'n-18f-1'
    FILING_N1A = 'n-1a'
    FILING_N2 = 'n-2'
    FILING_N23C3 = 'n-23c-3'
    FILING_N27D1 = 'n27d-1'
    FILING_N3 = 'n-3'
    FILING_N4 = 'n-4'
    FILING_N5 = 'n-5'
    FILING_N54A = 'n-54a'
    FILING_N54C = 'n-54c'
    FILING_N6 = 'n-6'
    FILING_N6EI1 = 'n-6ei-1'
    FILING_N6F = 'n-6f'
    FILING_N8A = 'n-8a'
    FILING_N8B2 = 'n-8b-2'
    FILING_N8B4 = 'n-8b-4'
    FILING_N8F = 'n-8f'
    FILING_NCEN = 'n-cen'
    FILING_NCR = 'n-cr'
    FILING_NCSR = 'n-csr'
    FILING_NCSRS = 'n-csrs'
    FILING_NLIQUID = 'n-liquid'
    FILING_NMFP = 'n-mfp'
    FILING_NPORT = 'nport'
    FILING_NPORTP = 'nport-p'
    FILING_NPORTEX = 'nport-ex'
    FILING_NPX = 'n-px'
    FILING_NQ = 'n-q'
    FILING_NRSRO = 'nrsro'
    FILING_PF = 'pf'
    FILING_PILOT = 'pilot'
    FILING_R31 = 'r31'
    FILING_S1 = 's-1'
    FILING_S11 = 's-11'
    FILING_S20 = 's-20'
    FILING_S3 = 's-3'
    FILING_S4 = 's-4'
    FILING_S6 = 's-6'
    FILING_S8 = 's-8'
    FILING_SBSE = 'sbse'
    FILING_SBSEA = 'sbse-a'
    FILING_SBSEBD = 'sbse-bd'
    FILING_SBSEC = 'sbse-c'
    FILING_SBSEW = 'sbse-w'
    FILING_SCI = 'sci'
    FILING_SD = 'sd'
    FILING_SDR = 'sdr'
    FILING_SE = 'se'
    FILING_SF1 = 'sf-1'
    FILING_SF3 = 'sf-3'
    FILING_SIP = 'sip'
    FILING_T1 = 't-1'
    FILING_T2 = 't-2'
    FILING_T3 = 't-3'
    FILING_T4 = 't-4'
    FILING_T6 = 't-6'
    FILING_TA1 = 'ta-1'
    FILING_TA2 = 'ta-2'
    FILING_TAW = 'ta-w'
    FILING_TCR = 'tcr'
    FILING_TH = 'th'
    FILING_WBAPP = 'wb-app'


class StandardIndustrialClassificationCodes(Enum):

    """Represents all the SIC Codes that the SEC uses to
    organize and query companies.

    ### Usage:
    ----
        >>> from edgar.enums import StandardIndustrialClassificationCodes
        >>> StandardIndustrialClassificationCodes.FORESTRY.value
    """

    AGRICULTURAL_PRODUCTION_CROPS = '100'
    AGRICULTURAL_PROD_LIVESTOCK_AND_ANIMAL_SPECIALTIES = '200'
    AGRICULTURAL_SERVICES = '700'
    FORESTRY = '800'
    FISHING_HUNTING_AND_TRAPPING = '900'
    METAL_MINING = '1000'
    GOLD_AND_SILVER_ORES = '1040'
    MISCELLANEOUS_METAL_ORES = '1090'
    BITUMINOUS_COAL_AND_LIGNITE_MINING = '1220'
    BITUMINOUS_COAL_AND_LIGNITE_SURFACE_MINING = '1221'
    CRUDE_PETROLEUM_AND_NATURAL_GAS = '1311'
    DRILLING_OIL_AND_GAS_WELLS = '1381'
    OIL_AND_GAS_FIELD_EXPLORATION_SERVICES = '1382'
    OIL_AND_GAS_FIELD_SERVICES_NEC = '1389'
    MINING_AND_QUARRYING_OF_NONMETALLIC_MINERALS_NO_FUELS = '1400'
    GENERAL_BLDG_CONTRACTORS__RESIDENTIAL_BLDGS = '1520'
    OPERATIVE_BUILDERS = '1531'
    GENERAL_BLDG_CONTRACTORS__NONRESIDENTIAL_BLDGS = '1540'
    HEAVY_CONSTRUCTION_OTHER_THAN_BLDG_CONST__CONTRACTORS = '1600'
    WATER_SEWER_PIPELINE_COMM_AND_POWER_LINE_CONSTRUCTION = '1623'
    CONSTRUCTION__SPECIAL_TRADE_CONTRACTORS = '1700'
    ELECTRICAL_WORK = '1731'
    FOOD_AND_KINDRED_PRODUCTS = '2000'
    MEAT_PACKING_PLANTS = '2011'
    SAUSAGES_AND_OTHER_PREPARED_MEAT_PRODUCTS = '2013'
    POULTRY_SLAUGHTERING_AND_PROCESSING = '2015'
    DAIRY_PRODUCTS = '2020'
    ICE_CREAM_AND_FROZEN_DESSERTS = '2024'
    CANNED_FROZEN_AND_PRESERVD_FRUIT_VEG_AND_FOOD_SPECIALTIES = '2030'
    CANNED_FRUITS_VEG_PRESERVES_JAMS_AND_JELLIES = '2033'
    GRAIN_MILL_PRODUCTS = '2040'
    BAKERY_PRODUCTS = '2050'
    COOKIES_AND_CRACKERS = '2052'
    SUGAR_AND_CONFECTIONERY_PRODUCTS = '2060'
    FATS_AND_OILS = '2070'
    BEVERAGES = '2080'
    MALT_BEVERAGES = '2082'
    BOTTLED_AND_CANNED_SOFT_DRINKS_AND_CARBONATED_WATERS = '2086'
    MISCELLANEOUS_FOOD_PREPARATIONS_AND_KINDRED_PRODUCTS = '2090'
    PREPARED_FRESH_OR_FROZEN_FISH_AND_SEAFOODS = '2092'
    TOBACCO_PRODUCTS = '2100'
    CIGARETTES = '2111'
    TEXTILE_MILL_PRODUCTS = '2200'
    BROADWOVEN_FABRIC_MILLS_COTTON = '2211'
    BROADWOVEN_FABRIC_MILLS_MAN_MADE_FIBER_AND_SILK = '2221'
    KNITTING_MILLS = '2250'
    KNIT_OUTERWEAR_MILLS = '2253'
    CARPETS_AND_RUGS = '2273'
    APPAREL_AND_OTHER_FINISHD_PRODS_OF_FABRICS_AND_SIMILAR_MATL = '2300'
    MENS_AND_BOYS_FURNISHGS_WORK_CLOTHG_AND_ALLIED_GARMENTS = '2320'
    WOMENS_MISSES_AND_JUNIORS_OUTERWEAR = '2330'
    WOMENS_MISSES_CHILDRENS_AND_INFANTS_UNDERGARMENTS = '2340'
    MISCELLANEOUS_FABRICATED_TEXTILE_PRODUCTS = '2390'
    LUMBER_AND_WOOD_PRODUCTS_NO_FURNITURE = '2400'
    SAWMILLS_AND_PLANTING_MILLS_GENERAL = '2421'
    MILLWOOD_VENEER_PLYWOOD_AND_STRUCTURAL_WOOD_MEMBERS = '2430'
    MOBILE_HOMES = '2451'
    PREFABRICATED_WOOD_BLDGS_AND_COMPONENTS = '2452'
    HOUSEHOLD_FURNITURE = '2510'
    WOOD_HOUSEHOLD_FURNITURE_NO_UPHOLSTERED = '2511'
    OFFICE_FURNITURE = '2520'
    OFFICE_FURNITURE_NO_WOOD = '2522'
    PUBLIC_BLDG_AND_RELATED_FURNITURE = '2531'
    PARTITIONS_SHELVG_LOCKERS_AND_OFFICE_AND_STORE_FIXTURES = '2540'
    MISCELLANEOUS_FURNITURE_AND_FIXTURES = '2590'
    PAPERS_AND_ALLIED_PRODUCTS = '2600'
    PULP_MILLS = '2611'
    PAPER_MILLS = '2621'
    PAPERBOARD_MILLS = '2631'
    PAPERBOARD_CONTAINERS_AND_BOXES = '2650'
    CONVERTED_PAPER_AND_PAPERBOARD_PRODS_NO_CONTANERS_BOXES = '2670'
    PLASTICS_FOIL_AND_COATED_PAPER_BAGS = '2673'
    NEWSPAPERS_PUBLISHING_OR_PUBLISHING_AND_PRINTING = '2711'
    PERIODICALS_PUBLISHING_OR_PUBLISHING_AND_PRINTING = '2721'
    BOOKS_PUBLISHING_OR_PUBLISHING_AND_PRINTING = '2731'
    BOOK_PRINTING = '2732'
    MISCELLANEOUS_PUBLISHING = '2741'
    COMMERCIAL_PRINTING = '2750'
    MANIFOLD_BUSINESS_FORMS = '2761'
    GREETING_CARDS = '2771'
    BLANKBOOKS_LOOSELEAF_BINDERS_AND_BOOKBINDG_AND_RELATD_WORK = '2780'
    SERVICE_INDUSTRIES_FOR_THE_PRINTING_TRADE = '2790'
    CHEMICALS_AND_ALLIED_PRODUCTS = '2800'
    INDUSTRIAL_INORGANIC_CHEMICALS = '2810'
    PLASTIC_MATERIAL_SYNTH_RESIN_RUBBER_CELLULOS_NO_GLASS = '2820'
    PLASTIC_MATERIALS_SYNTH_RESINS_AND_NONVULCAN_ELASTOMERS = '2821'
    MEDICINAL_CHEMICALS_AND_BOTANICAL_PRODUCTS = '2833'
    PHARMACEUTICAL_PREPARATIONS = '2834'
    IN_VITRO_AND_IN_VIVO_DIAGNOSTIC_SUBSTANCES = '2835'
    BIOLOGICAL_PRODUCTS_NO_DISGNOSTIC_SUBSTANCES = '2836'
    SOAP_DETERGENTS_CLEANG_PREPARATIONS_PERFUMES_COSMETICS = '2840'
    SPECIALTY_CLEANING_POLISHING_AND_SANITATION_PREPARATIONS = '2842'
    PERFUMES_COSMETICS_AND_OTHER_TOILET_PREPARATIONS = '2844'
    PAINTS_VARNISHES_LACQUERS_ENAMELS_AND_ALLIED_PRODS = '2851'
    INDUSTRIAL_ORGANIC_CHEMICALS = '2860'
    AGRICULTURAL_CHEMICALS = '2870'
    MISCELLANEOUS_CHEMICAL_PRODUCTS = '2890'
    ADHESIVES_AND_SEALANTS = '2891'
    PETROLEUM_REFINING = '2911'
    ASPHALT_PAVING_AND_ROOFING_MATERIALS = '2950'
    MISCELLANEOUS_PRODUCTS_OF_PETROLEUM_AND_COAL = '2990'
    TIRES_AND_INNER_TUBES = '3011'
    RUBBER_AND_PLASTICS_FOOTWEAR = '3021'
    GASKETS_PACKG_AND_SEALG_DEVICES_AND_RUBBER_AND_PLASTICS_HOSE = '3050'
    FABRICATED_RUBBER_PRODUCTS_NEC = '3060'
    MISCELLANEOUS_PLASTICS_PRODUCTS = '3080'
    UNSUPPORTED_PLASTICS_FILM_AND_SHEET = '3081'
    PLASTICS_FOAM_PRODUCTS = '3086'
    PLASTICS_PRODUCTS_NEC = '3089'
    LEATHER_AND_LEATHER_PRODUCTS = '3100'
    FOOTWEAR_NO_RUBBER = '3140'
    FLAT_GLASS = '3211'
    GLASS_AND_GLASSWARE_PRESSED_OR_BLOWN = '3220'
    GLASS_CONTAINERS = '3221'
    GLASS_PRODUCTS_MADE_OF_PURCHASED_GLASS = '3231'
    CEMENT_HYDRAULIC = '3241'
    STRUCTURAL_CLAY_PRODUCTS = '3250'
    POTTERY_AND_RELATED_PRODUCTS = '3260'
    CONCRETE_GYPSUM_AND_PLASTER_PRODUCTS = '3270'
    CONCRETE_PRODUCTS_EXCEPT_BLOCK_AND_BRICK = '3272'
    CUT_STONE_AND_STONE_PRODUCTS = '3281'
    ABRASIVE_ASBESTOS_AND_MISC_NONMETALLIC_MINERAL_PRODS = '3290'
    STEEL_WORKS_BLAST_FURNACES_AND_ROLLING_AND_FINISHING_MILLS = '3310'
    STEEL_WORKS_BLAST_FURNACES_AND_ROLLING_MILLS_COKE_OVENS = '3312'
    STEEL_PIPE_AND_TUBES = '3317'
    IRON_AND_STEEL_FOUNDRIES = '3320'
    PRIMARY_SMELTING_AND_REFINING_OF_NONFERROUS_METALS = '3330'
    PRIMARY_PRODUCTION_OF_ALUMINUM = '3334'
    SECONDARY_SMELTING_AND_REFINING_OF_NONFERROUS_METALS = '3341'
    ROLLING_DRAWING_AND_EXTRUDING_OF_NONFERROUS_METALS = '3350'
    DRAWING_AND_INSULATING_OF_NONFERROUS_WIRE = '3357'
    NONFERROUS_FOUNDRIES_CASTINGS = '3360'
    MISCELLANEOUS_PRIMARY_METAL_PRODUCTS = '3390'
    METAL_CANS = '3411'
    METAL_SHIPPING_BARRELS_DRUMS_KEGS_AND_PAILS = '3412'
    CUTLERY_HANDTOOLS_AND_GENERAL_HARDWARE = '3420'
    HEATING_EQUIP_EXCEPT_ELEC_AND_WARM_AIR_AND_PLUMBING_FIXTURES = '3430'
    HEATING_EQUIPMENT_EXCEPT_ELECTRIC_AND_WARM_AIR_FURNACES = '3433'
    FABRICATED_STRUCTURAL_METAL_PRODUCTS = '3440'
    METAL_DOORS_SASH_FRAMES_MOLDINGS_AND_TRIM = '3442'
    FABRICATED_PLATE_WORK_BOILER_SHOPS = '3443'
    SHEET_METAL_WORK = '3444'
    PREFABRICATED_METAL_BUILDINGS_AND_COMPONENTS = '3448'
    SCREW_MACHINE_PRODUCTS = '3451'
    BOLTS_NUTS_SCREWS_RIVETS_AND_WASHERS = '3452'
    METAL_FORGINGS_AND_STAMPINGS = '3460'
    COATING_ENGRAVING_AND_ALLIED_SERVICES = '3470'
    ORDNANCE_AND_ACCESSORIES_NO_VEHICLES_GUIDED_MISSILES = '3480'
    MISCELLANEOUS_FABRICATED_METAL_PRODUCTS = '3490'
    ENGINES_AND_TURBINES = '3510'
    FARM_MACHINERY_AND_EQUIPMENT = '3523'
    LAWN_AND_GARDEN_TRACTORS_AND_HOME_LAWN_AND_GARDENS_EQUIP = '3524'
    CONSTRUCTION_MINING_AND_MATERIALS_HANDLING_MACHINERY_AND_EQUIP = '3530'
    CONSTRUCTION_MACHINERY_AND_EQUIP = '3531'
    MINING_MACHINERY_AND_EQUIP_NO_OIL_AND_GAS_FIELD_MACH_AND_EQUIP = '3532'
    OIL_AND_GAS_FIELD_MACHINERY_AND_EQUIPMENT = '3533'
    INDUSTRIAL_TRUCKS_TRACTORS_TRAILORS_AND_STACKERS = '3537'
    METALWORKG_MACHINERY_AND_EQUIPMENT = '3540'
    MACHINE_TOOLS_METAL_CUTTING_TYPES = '3541'
    SPECIAL_INDUSTRY_MACHINERY_NO_METALWORKING_MACHINERY = '3550'
    PRINTING_TRADES_MACHINERY_AND_EQUIPMENT = '3555'
    SPECIAL_INDUSTRY_MACHINERY_NEC = '3559'
    GENERAL_INDUSTRIAL_MACHINERY_AND_EQUIPMENT = '3560'
    PUMPS_AND_PUMPING_EQUIPMENT = '3561'
    BALL_AND_ROLLER_BEARINGS = '3562'
    INDUSTRIAL_AND_COMMERCIAL_FANS_AND_BLOWERS_AND_AIR_PURIFING_EQUIP = '3564'
    INDUSTRIAL_PROCESS_FURNACES_AND_OVENS = '3567'
    GENERAL_INDUSTRIAL_MACHINERY_AND_EQUIPMENT_NEC = '3569'
    COMPUTER_AND_OFFICE_EQUIPMENT = '3570'
    ELECTRONIC_COMPUTERS = '3571'
    COMPUTER_STORAGE_DEVICES = '3572'
    COMPUTER_TERMINALS = '3575'
    COMPUTER_COMMUNICATIONS_EQUIPMENT = '3576'
    COMPUTER_PERIPHERAL_EQUIPMENT_NEC = '3577'
    CALCULATING_AND_ACCOUNTING_MACHINES_NO_ELECTRONIC_COMPUTERS = '3578'
    OFFICE_MACHINES_NEC = '3579'
    REFRIGERATION_AND_SERVICE_INDUSTRY_MACHINERY = '3580'
    AIR_COND_AND_WARM_AIR_HEATG_EQUIP_AND_COMM_AND_INDL_REFRIG_EQUIP = '3585'
    MISC_INDUSTRIAL_AND_COMMERCIAL_MACHINERY_AND_EQUIPMENT = '3590'
    ELECTRONIC_AND_OTHER_ELECTRICAL_EQUIPMENT_NO_COMPUTER_EQUIP = '3600'
    POWER_DISTRIBUTION_AND_SPECIALTY_TRANSFORMERS = '3612'
    SWITCHGEAR_AND_SWITCHBOARD_APPARATUS = '3613'
    ELECTRICAL_INDUSTRIAL_APPARATUS = '3620'
    MOTORS_AND_GENERATORS = '3621'
    HOUSEHOLD_APPLIANCES = '3630'
    ELECTRIC_HOUSEWARES_AND_FANS = '3634'
    ELECTRIC_LIGHTING_AND_WIRING_EQUIPMENT = '3640'
    HOUSEHOLD_AUDIO_AND_VIDEO_EQUIPMENT = '3651'
    PHONOGRAPH_RECORDS_AND_PRERECORDED_AUDIO_TAPES_AND_DISKS = '3652'
    TELEPHONE_AND_TELEGRAPH_APPARATUS = '3661'
    RADIO_AND_TV_BROADCASTING_AND_COMMUNICATIONS_EQUIPMENT = '3663'
    COMMUNICATIONS_EQUIPMENT_NEC = '3669'
    ELECTRONIC_COMPONENTS_AND_ACCESSORIES = '3670'
    PRINTED_CIRCUIT_BOARDS = '3672'
    SEMICONDUCTORS_AND_RELATED_DEVICES = '3674'
    ELECTRONIC_COILS_TRANSFORMERS_AND_OTHER_INDUCTORS = '3677'
    ELECTRONIC_CONNECTORS = '3678'
    ELECTRONIC_COMPONENTS_NEC = '3679'
    MISCELLANEOUS_ELECTRICAL_MACHINERY_EQUIPMENT_AND_SUPPLIES = '3690'
    MAGNETIC_AND_OPTICAL_RECORDING_MEDIA = '3695'
    MOTOR_VEHICLES_AND_PASSENGER_CAR_BODIES = '3711'
    TRUCK_AND_BUS_BODIES = '3713'
    MOTOR_VEHICLE_PARTS_AND_ACCESSORIES = '3714'
    TRUCK_TRAILERS = '3715'
    MOTOR_HOMES = '3716'
    AIRCRAFT_AND_PARTS = '3720'
    AIRCRAFT = '3721'
    AIRCRAFT_ENGINES_AND_ENGINE_PARTS = '3724'
    AIRCRAFT_PARTS_AND_AUXILIARY_EQUIPMENT_NEC = '3728'
    SHIP_AND_BOAT_BUILDING_AND_REPAIRING = '3730'
    RAILROAD_EQUIPMENT = '3743'
    MOTORCYCLES_BICYCLES_AND_PARTS = '3751'
    GUIDED_MISSILES_AND_SPACE_VEHICLES_AND_PARTS = '3760'
    MISCELLANEOUS_TRANSPORTATION_EQUIPMENT = '3790'
    SEARCH_DETECTION_NAVAGATION_GUIDANCE_AERONAUTICAL_SYS = '3812'
    LABORATORY_APPARATUS_AND_FURNITURE = '3821'
    AUTO_CONTROLS_FOR_REGULATING_RESIDENTIAL_AND_COMML_ENVIRONMENTS = '3822'
    INDUSTRIAL_INSTRUMENTS_FOR_MEASUREMENT_DISPLAY_AND_CONTROL = '3823'
    TOTALIZING_FLUID_METERS_AND_COUNTING_DEVICES = '3824'
    INSTRUMENTS_FOR_MEAS_AND_TESTING_OF_ELECTRICITY_AND_ELEC_SIGNALS = '3825'
    LABORATORY_ANALYTICAL_INSTRUMENTS = '3826'
    OPTICAL_INSTRUMENTS_AND_LENSES = '3827'
    MEASURING_AND_CONTROLLING_DEVICES_NEC = '3829'
    SURGICAL_AND_MEDICAL_INSTRUMENTS_AND_APPARATUS = '3841'
    ORTHOPEDIC_PROSTHETIC_AND_SURGICAL_APPLIANCES_AND_SUPPLIES = '3842'
    DENTAL_EQUIPMENT_AND_SUPPLIES = '3843'
    X_RAY_APPARATUS_AND_TUBES_AND_RELATED_IRRADIATION_APPARATUS = '3844'
    ELECTROMEDICAL_AND_ELECTROTHERAPEUTIC_APPARATUS = '3845'
    OPHTHALMIC_GOODS = '3851'
    PHOTOGRAPHIC_EQUIPMENT_AND_SUPPLIES = '3861'
    WATCHES_CLOCKS_CLOCKWORK_OPERATED_DEVICES_PARTS = '3873'
    JEWELRY_SILVERWARE_AND_PLATED_WARE = '3910'
    JEWELRY_PRECIOUS_METAL = '3911'
    MUSICAL_INSTRUMENTS = '3931'
    DOLLS_AND_STUFFED_TOYS = '3942'
    GAMES_TOYS_AND_CHILDRENS_VEHICLES_NO_DOLLS_AND_BICYCLES = '3944'
    SPORTING_AND_ATHLETIC_GOODS_NEC = '3949'
    PENS_PENCILS_AND_OTHER_ARTISTS_MATERIALS = '3950'
    COSTUME_JEWELRY_AND_NOVELTIES = '3960'
    MISCELLANEOUS_MANUFACTURING_INDUSTRIES = '3990'
    RAILROADS_LINE_HAUL_OPERATING = '4011'
    RAILROAD_SWITCHING_AND_TERMINAL_ESTABLISHMENTS = '4013'
    LOCAL_AND_SUBURBAN_TRANSIT_AND_INTERURBAN_HWY_PASSENGER_TRANS = '4100'
    TRUCKING_AND_COURIER_SERVICES_NO_AIR = '4210'
    TRUCKING_NO_LOCAL = '4213'
    PUBLIC_WAREHOUSING_AND_STORAGE = '4220'
    TERMINAL_MAINTENANCE_FACILITIES_FOR_MOTOR_FREIGHT_TRANSPORT = '4231'
    WATER_TRANSPORTATION = '4400'
    DEEP_SEA_FOREIGN_TRANSPORTATION_OF_FREIGHT = '4412'
    AIR_TRANSPORTATION_SCHEDULED = '4512'
    AIR_COURIER_SERVICES = '4513'
    AIR_TRANSPORTATION_NONSCHEDULED = '4522'
    AIRPORTS_FLYING_FIELDS_AND_AIRPORT_TERMINAL_SERVICES = '4581'
    PIPE_LINES_NO_NATURAL_GAS = '4610'
    TRANSPORTATION_SERVICES = '4700'
    ARRANGEMENT_OF_TRANSPORTATION_OF_FREIGHT_AND_CARGO = '4731'
    RADIOTELEPHONE_COMMUNICATIONS = '4812'
    TELEPHONE_COMMUNICATIONS_NO_RADIOTELEPHONE = '4813'
    TELEGRAPH_AND_OTHER_MESSAGE_COMMUNICATIONS = '4822'
    RADIO_BROADCASTING_STATIONS = '4832'
    TELEVISION_BROADCASTING_STATIONS = '4833'
    CABLE_AND_OTHER_PAY_TELEVISION_SERVICES = '4841'
    COMMUNICATIONS_SERVICES_NEC = '4899'
    ELECTRIC_GAS_AND_SANITARY_SERVICES = '4900'
    ELECTRIC_SERVICES = '4911'
    NATURAL_GAS_TRANSMISSION = '4922'
    NATURAL_GAS_TRANSMISISON_AND_DISTRIBUTION = '4923'
    NATURAL_GAS_DISTRIBUTION = '4924'
    ELECTRIC_AND_OTHER_SERVICES_COMBINED = '4931'
    GAS_AND_OTHER_SERVICES_COMBINED = '4932'
    WATER_SUPPLY = '4941'
    SANITARY_SERVICES = '4950'
    REFUSE_SYSTEMS = '4953'
    HAZARDOUS_WASTE_MANAGEMENT = '4955'
    STEAM_AND_AIR_CONDITIONING_SUPPLY = '4961'
    COGENERATION_SERVICES_AND_SMALL_POWER_PRODUCERS = '4991'
    WHOLESALE_DURABLE_GOODS = '5000'
    WHOLESALE_MOTOR_VEHICLES_AND_MOTOR_VEHICLE_PARTS_AND_SUPPLIES = '5010'
    WHOLESALE_MOTOR_VEHICLE_SUPPLIES_AND_NEW_PARTS = '5013'
    WHOLESALE_FURNITURE_AND_HOME_FURNISHINGS = '5020'
    WHOLESALE_LUMBER_AND_OTHER_CONSTRUCTION_MATERIALS = '5030'
    WHOLESALE_LUMBER_PLYWOOD_MILLWORK_AND_WOOD_PANELS = '5031'
    WHOLESALE_PROFESSIONAL_AND_COMMERCIAL_EQUIPMENT_AND_SUPPLIES = '5040'
    WHOLESALE_COMPUTERS_AND_PERIPHERAL_EQUIPMENT_AND_SOFTWARE = '5045'
    WHOLESALE_MEDICAL_DENTAL_AND_HOSPITAL_EQUIPMENT_AND_SUPPLIES = '5047'
    WHOLESALE_METALS_AND_MINERALS_NO_PETROLEUM = '5050'
    WHOLESALE_METALS_SERVICE_CENTERS_AND_OFFICES = '5051'
    WHOLESALE_ELECTRICAL_APPARATUS_AND_EQUIPMENT_WIRING_SUPPLIES = '5063'
    WHOLESALE_ELECTRICAL_APPLIANCES_TV_AND_RADIO_SETS = '5064'
    WHOLESALE_ELECTRONIC_PARTS_AND_EQUIPMENT_NEC = '5065'
    WHOLESALE_HARDWARE_AND_PLUMBING_AND_HEATING_EQUIPMENT_AND_SUPPLIES = '5070'
    WHOLESALE_HARDWARE = '5072'
    WHOLESALE_MACHINERY_EQUIPMENT_AND_SUPPLIES = '5080'
    WHOLESALE_CONSTRUCTION_AND_MINING_NO_PETRO_MACHINERY_AND_EQUIP = '5082'
    WHOLESALE_INDUSTRIAL_MACHINERY_AND_EQUIPMENT = '5084'
    WHOLESALE_MISC_DURABLE_GOODS = '5090'
    WHOLESALE_JEWELRY_WATCHES_PRECIOUS_STONES_AND_METALS = '5094'
    WHOLESALE_DURABLE_GOODS_NEC = '5099'
    WHOLESALE_PAPER_AND_PAPER_PRODUCTS = '5110'
    WHOLESALE_DRUGS_PROPRIETARIES_AND_DRUGGISTS_SUNDRIES = '5122'
    WHOLESALE_APPAREL_PIECE_GOODS_AND_NOTIONS = '5130'
    WHOLESALE_GROCERIES_AND_RELATED_PRODUCTS = '5140'
    WHOLESALE_GROCERIES_GENERAL_LINE = '5141'
    WHOLESALE_FARM_PRODUCT_RAW_MATERIALS = '5150'
    WHOLESALE_CHEMICALS_AND_ALLIED_PRODUCTS = '5160'
    WHOLESALE_PETROLEUM_BULK_STATIONS_AND_TERMINALS = '5171'
    WHOLESALE_PETROLEUM_AND_PETROLEUM_PRODUCTS_NO_BULK_STATIONS = '5172'
    WHOLESALE_BEER_WINE_AND_DISTILLED_ALCOHOLIC_BEVERAGES = '5180'
    WHOLESALE_MISCELLANEOUS_NONDURABLE_GOODS = '5190'
    RETAIL_BUILDING_MATERIALS_HARDWARE_GARDEN_SUPPLY = '5200'
    RETAIL_LUMBER_AND_OTHER_BUILDING_MATERIALS_DEALERS = '5211'
    RETAIL_MOBILE_HOME_DEALERS = '5271'
    RETAIL_DEPARTMENT_STORES = '5311'
    RETAIL_VARIETY_STORES = '5331'
    RETAIL_MISC_GENERAL_MERCHANDISE_STORES = '5399'
    RETAIL_FOOD_STORES = '5400'
    RETAIL_GROCERY_STORES = '5411'
    RETAIL_CONVENIENCE_STORES = '5412'
    RETAIL_AUTO_DEALERS_AND_GASOLINE_STATIONS = '5500'
    RETAIL_AUTO_AND_HOME_SUPPLY_STORES = '5531'
    RETAIL_APPAREL_AND_ACCESSORY_STORES = '5600'
    RETAIL_WOMENS_CLOTHING_STORES = '5621'
    RETAIL_FAMILY_CLOTHING_STORES = '5651'
    RETAIL_SHOE_STORES = '5661'
    RETAIL_HOME_FURNITURE_FURNISHINGS_AND_EQUIPMENT_STORES = '5700'
    RETAIL_FURNITURE_STORES = '5712'
    RETAIL_RADIO_TV_AND_CONSUMER_ELECTRONICS_STORES = '5731'
    RETAIL_COMPUTER_AND_COMPUTER_SOFTWARE_STORES = '5734'
    RETAIL_RECORD_AND_PRERECORDED_TAPE_STORES = '5735'
    RETAIL_EATING_AND_DRINKING_PLACES = '5810'
    RETAIL_EATING_PLACES = '5812'
    RETAIL_MISCELLANEOUS_RETAIL = '5900'
    RETAIL_DRUG_STORES_AND_PROPRIETARY_STORES = '5912'
    RETAIL_MISCELLANEOUS_SHOPPING_GOODS_STORES = '5940'
    RETAIL_JEWELRY_STORES = '5944'
    RETAIL_HOBBY_TOY_AND_GAME_SHOPS = '5945'
    RETAIL_NONSTORE_RETAILERS = '5960'
    RETAIL_CATALOG_AND_MAIL_ORDER_HOUSES = '5961'
    RETAIL_RETAIL_STORES_NEC = '5990'
    NATIONAL_COMMERCIAL_BANKS = '6021'
    STATE_COMMERCIAL_BANKS = '6022'
    COMMERCIAL_BANKS_NEC = '6029'
    SAVINGS_INSTITUTION_FEDERALLY_CHARTERED = '6035'
    SAVINGS_INSTITUTIONS_NOT_FEDERALLY_CHARTERED = '6036'
    FUNCTIONS_RELATED_TO_DEPOSITORY_BANKING_NEC = '6099'
    FEDERAL_AND_FEDERALLY_SPONSORED_CREDIT_AGENCIES = '6111'
    PERSONAL_CREDIT_INSTITUTIONS = '6141'
    SHORT_TERM_BUSINESS_CREDIT_INSTITUTIONS = '6153'
    MISCELLANEOUS_BUSINESS_CREDIT_INSTITUTION = '6159'
    MORTGAGE_BANKERS_AND_LOAN_CORRESPONDENTS = '6162'
    LOAN_BROKERS = '6163'
    FINANCE_LESSORS = '6172'
    ASSET_BACKED_SECURITIES = '6189'
    FINANCE_SERVICES = '6199'
    SECURITY_AND_COMMODITY_BROKERS_DEALERS_EXCHANGES_AND_SERVICES = '6200'
    SECURITY_BROKERS_DEALERS_AND_FLOTATION_COMPANIES = '6211'
    COMMODITY_CONTRACTS_BROKERS_AND_DEALERS = '6221'
    INVESTMENT_ADVICE = '6282'
    LIFE_INSURANCE = '6311'
    ACCIDENT_AND_HEALTH_INSURANCE = '6321'
    HOSPITAL_AND_MEDICAL_SERVICE_PLANS = '6324'
    FIRE_MARINE_AND_CASUALTY_INSURANCE = '6331'
    SURETY_INSURANCE = '6351'
    TITLE_INSURANCE = '6361'
    INSURANCE_CARRIERS_NEC = '6399'
    INSURANCE_AGENTS_BROKERS_AND_SERVICE = '6411'
    REAL_ESTATE = '6500'
    REAL_ESTATE_OPERATORS_NO_DEVELOPERS_AND_LESSORS = '6510'
    OPERATORS_OF_NONRESIDENTIAL_BUILDINGS = '6512'
    OPERATORS_OF_APARTMENT_BUILDINGS = '6513'
    LESSORS_OF_REAL_PROPERTY_NEC = '6519'
    REAL_ESTATE_AGENTS_AND_MANAGERS_FOR_OTHERS = '6531'
    REAL_ESTATE_DEALERS_FOR_THEIR_OWN_ACCOUNT = '6532'
    LAND_SUBDIVIDERS_AND_DEVELOPERS_NO_CEMETERIES = '6552'
    BLANK_CHECKS = '6770'
    OIL_ROYALTY_TRADERS = '6792'
    PATENT_OWNERS_AND_LESSORS = '6794'
    MINERAL_ROYALTY_TRADERS = '6795'
    REAL_ESTATE_INVESTMENT_TRUSTS = '6798'
    INVESTORS_NEC = '6799'
    HOTELS_ROOMING_HOUSES_CAMPS_AND_OTHER_LODGING_PLACES = '7000'
    HOTELS_AND_MOTELS = '7011'
    SERVICES_PERSONAL_SERVICES = '7200'
    SERVICES_ADVERTISING = '7310'
    SERVICES_ADVERTISING_AGENCIES = '7311'
    SERVICES_CONSUMER_CREDIT_REPORTING_COLLECTION_AGENCIES = '7320'
    SERVICES_MAILING_REPRODUCTION_COMMERCIAL_ART_AND_PHOTOGRAPHY = '7330'
    SERVICES_DIRECT_MAIL_ADVERTISING_SERVICES = '7331'
    SERVICES_TO_DWELLINGS_AND_OTHER_BUILDINGS = '7340'
    SERVICES_MISCELLANEOUS_EQUIPMENT_RENTAL_AND_LEASING = '7350'
    SERVICES_EQUIPMENT_RENTAL_AND_LEASING_NEC = '7359'
    SERVICES_EMPLOYMENT_AGENCIES = '7361'
    SERVICES_HELP_SUPPLY_SERVICES = '7363'
    SERVICES_COMPUTER_PROGRAMMING_DATA_PROCESSING_ETC = '7370'
    SERVICES_COMPUTER_PROGRAMMING_SERVICES = '7371'
    SERVICES_PREPACKAGED_SOFTWARE = '7372'
    SERVICES_COMPUTER_INTEGRATED_SYSTEMS_DESIGN = '7373'
    SERVICES_COMPUTER_PROCESSING_AND_DATA_PREPARATION = '7374'
    SERVICES_COMPUTER_RENTAL_AND_LEASING = '7377'
    SERVICES_MISCELLANEOUS_BUSINESS_SERVICES = '7380'
    SERVICES_DETECTIVE_GUARD_AND_ARMORED_CAR_SERVICES = '7381'
    SERVICES_PHOTOFINISHING_LABORATORIES = '7384'
    SERVICES_TELEPHONE_INTERCONNECT_SYSTEMS = '7385'
    SERVICES_BUSINESS_SERVICES_NEC = '7389'
    SERVICES_AUTOMOTIVE_REPAIR_SERVICES_AND_PARKING = '7500'
    SERVICES_AUTO_RENTAL_AND_LEASING_NO_DRIVERS = '7510'
    SERVICES_MISCELLANEOUS_REPAIR_SERVICES = '7600'
    SERVICES_MOTION_PICTURE_AND_VIDEO_TAPE_PRODUCTION = '7812'
    SERVICES_ALLIED_TO_MOTION_PICTURE_PRODUCTION = '7819'
    SERVICES_MOTION_PICTURE_AND_VIDEO_TAPE_DISTRIBUTION = '7822'
    SERVICES_ALLIED_TO_MOTION_PICTURE_DISTRIBUTION = '7829'
    SERVICES_MOTION_PICTURE_THEATERS = '7830'
    SERVICES_VIDEO_TAPE_RENTAL = '7841'
    SERVICES_AMUSEMENT_AND_RECREATION_SERVICES = '7900'
    SERVICES_RACING_INCLUDING_TRACK_OPERATION = '7948'
    SERVICES_MISCELLANEOUS_AMUSEMENT_AND_RECREATION = '7990'
    SERVICES_MEMBERSHIP_SPORTS_AND_RECREATION_CLUBS = '7997'
    SERVICES_HEALTH_SERVICES = '8000'
    SERVICES_OFFICES_AND_CLINICS_OF_DOCTORS_OF_MEDICINE = '8011'
    SERVICES_NURSING_AND_PERSONAL_CARE_FACILITIES = '8050'
    SERVICES_SKILLED_NURSING_CARE_FACILITIES = '8051'
    SERVICES_HOSPITALS = '8060'
    SERVICES_GENERAL_MEDICAL_AND_SURGICAL_HOSPITALS_NEC = '8062'
    SERVICES_MEDICAL_LABORATORIES = '8071'
    SERVICES_HOME_HEALTH_CARE_SERVICES = '8082'
    SERVICES_MISC_HEALTH_AND_ALLIED_SERVICES_NEC = '8090'
    SERVICES_SPECIALTY_OUTPATIENT_FACILITIES_NEC = '8093'
    SERVICES_LEGAL_SERVICES = '8111'
    SERVICES_EDUCATIONAL_SERVICES = '8200'
    SERVICES_SOCIAL_SERVICES = '8300'
    SERVICES_CHILD_DAY_CARE_SERVICES = '8351'
    SERVICES_MEMBERSHIP_ORGANIZATIONS = '8600'
    SERVICES_ENGINEERING_ACCOUNTING_RESEARCH_MANAGEMENT = '8700'
    SERVICES_ENGINEERING_SERVICES = '8711'
    SERVICES_COMMERCIAL_PHYSICAL_AND_BIOLOGICAL_RESEARCH = '8731'
    SERVICES_TESTING_LABORATORIES = '8734'
    SERVICES_MANAGEMENT_SERVICES = '8741'
    SERVICES_MANAGEMENT_CONSULTING_SERVICES = '8742'
    SERVICES_FACILITIES_SUPPORT_MANAGEMENT_SERVICES = '8744'
    AMERICAN_DEPOSITARY_RECEIPTS = '8880'
    FOREIGN_GOVERNMENTS = '8888'
    SERVICES_SERVICES_NEC = '8900'
    INTERNATIONAL_AFFAIRS = '9721'
    NON_OPERATING_ESTABLISHMENTS = '9995'


class OtherFilingTypes(Enum):

    _1012B = '1012B'
    _1012BAD = '1012BAD'
    _1012G = '1012G'
    _1012GAD = '1012GAD'
    _10C = '10C'
    _10CAD = '10CAD'
    _10D = '10D'
    _10DAD = '10DAD'
    _10K = '10K'
    _10KAD = '10KAD'
    _10K405 = '10K405'
    _10K405AD = '10K405AD'
    _10KSB = '10KSB'
    _10KSBAD = '10KSBAD'
    _10KSB40 = '10KSB40'
    _10KSB40AD = '10KSB40AD'
    _10KT = '10KT'
    _10KTAD = '10KTAD'
    _10KT405 = '10KT405'
    _10KT405AD = '10KT405AD'
    _10Q = '10Q'
    _10QAD = '10QAD'
    _10QSB = '10QSB'
    _10QSBAD = '10QSBAD'
    _10QT = '10QT'
    _10QTAD = '10QTAD'
    _10SB12B = '10SB12B'
    _10SB12BAD = '10SB12BAD'
    _10SB12G = '10SB12G'
    _10SB12GAD = '10SB12GAD'
    _11K = '11K'
    _11KAD = '11KAD'
    _11KT = '11KT'
    _11KTAD = '11KTAD'
    _13FE = '13FE'
    _13FEAD = '13FEAD'
    _13FHR = '13FHR'
    _13FHRAD = '13FHRAD'
    _13FNT = '13FNT'
    _13FNTAD = '13FNTAD'
    _144 = '144'
    _144AD = '144AD'
    _1512B = '1512B'
    _1512BAD = '1512BAD'
    _1512G = '1512G'
    _1512GAD = '1512GAD'
    _1515D = '1515D'
    _1515DAD = '1515DAD'
    _15F12B = '15F12B'
    _15F12BAD = '15F12BAD'
    _15F12G = '15F12G'
    _15F12GAD = '15F12GAD'
    _15F15D = '15F15D'
    _15F15DAD = '15F15DAD'
    _1812B = '1812B'
    _1812BAD = '1812BAD'
    _1812G = '1812G'
    _1812GAD = '1812GAD'
    _18K = '18K'
    _18KAD = '18KAD'
    _1A = '1A'
    _1AAD = '1AAD'
    _1APOS = '1APOS'
    _1AW = '1AW'
    _1AWAD = '1AWAD'
    _1E = '1E'
    _1EAD = '1EAD'
    _1K = '1K'
    _1KAD = '1KAD'
    _1SA = '1SA'
    _1SAAD = '1SAAD'
    _1U = '1U'
    _1UAD = '1UAD'
    _1Z = '1Z'
    _1ZAD = '1ZAD'
    _1ZW = '1ZW'
    _1ZWAD = '1ZWAD'
    _20F = '20F'
    _20FAD = '20FAD'
    _20FR12B = '20FR12B'
    _20FR12BAD = '20FR12BAD'
    _20FR12G = '20FR12G'
    _20FR12GAD = '20FR12GAD'
    _24F2EL = '24F2EL'
    _24F2ELAD = '24F2ELAD'
    _24F2NT = '24F2NT'
    _24F2NTAD = '24F2NTAD'
    _24F2TM = '24F2TM'
    _24F2TMAD = '24F2TMAD'
    _24F3NT = '24F3NT'
    _24F3NTAD = '24F3NTAD'
    _25 = '25'
    _25AD = '25AD'
    _253G1 = '253G1'
    _253G2 = '253G2'
    _253G3 = '253G3'
    _253G4 = '253G4'
    _25NSE = '25NSE'
    _25NSEAD = '25NSEAD'
    _2E = '2E'
    _2EAD = '2EAD'
    _3 = '3'
    _3AD = '3AD'
    _305B2 = '305B2'
    _305B2AD = '305B2AD'
    _35APP = '35APP'
    _35APPAD = '35APPAD'
    _35CERT = '35CERT'
    _35CERTAD = '35CERTAD'
    _4 = '4'
    _4AD = '4AD'
    _4017F1 = '4017F1'
    _4017F1AD = '4017F1AD'
    _4017F2 = '4017F2'
    _4017F2AD = '4017F2AD'
    _4017G = '4017G'
    _4017GAD = '4017GAD'
    _4017GCS = '4017GCS'
    _4017GCSAD = '4017GCSAD'
    _4024B2 = '4024B2'
    _4024B2AD = '4024B2AD'
    _4033 = '4033'
    _4033AD = '4033AD'
    _406B = '406B'
    _406BAD = '406BAD'
    _408B25 = '408B25'
    _408F2 = '408F2'
    _408F2AD = '408F2AD'
    _408FA = '408FA'
    _408FAAD = '408FAAD'
    _408FB = '408FB'
    _408FBAD = '408FBAD'
    _408FL = '408FL'
    _408FLAD = '408FLAD'
    _408FLA = '408FLA'
    _408FLM = '408FLM'
    _408FLMA = '408FLMA'
    _408FM = '408FM'
    _408FMAD = '408FMAD'
    _40APP = '40APP'
    _40APPAD = '40APPAD'
    _40F = '40F'
    _40FAD = '40FAD'
    _40FR12B = '40FR12B'
    _40FR12BAD = '40FR12BAD'
    _40FR12G = '40FR12G'
    _40FR12GAD = '40FR12GAD'
    _40OIP = '40OIP'
    _40OIPAD = '40OIPAD'
    _424A = '424A'
    _424B1 = '424B1'
    _424B2 = '424B2'
    _424B3 = '424B3'
    _424B4 = '424B4'
    _424B5 = '424B5'
    _424B7 = '424B7'
    _424B8 = '424B8'
    _424H = '424H'
    _424HAD = '424HAD'
    _425 = '425'
    _45B3 = '45B3'
    _45B3AD = '45B3AD'
    _485A24E = '485A24E'
    _485A24F = '485A24F'
    _485APOS = '485APOS'
    _485B24E = '485B24E'
    _485B24F = '485B24F'
    _485BPOS = '485BPOS'
    _485BXT = '485BXT'
    _485BXTE = '485BXTE'
    _485BXTF = '485BXTF'
    _486A24F = '486A24F'
    _486APOS = '486APOS'
    _486B24F = '486B24F'
    _486BPOS = '486BPOS'
    _487 = '487'
    _497 = '497'
    _497AD = '497AD'
    _497H2 = '497H2'
    _497J = '497J'
    _497K = '497K'
    _497K1 = '497K1'
    _497K2 = '497K2'
    _497K3A = '497K3A'
    _497K3B = '497K3B'
    _5 = '5'
    _5AD = '5AD'
    _6BNTC = '6BNTC'
    _6BORDR = '6BORDR'
    _6K = '6K'
    _6KAD = '6KAD'
    _8A12B = '8A12B'
    _8A12BAD = '8A12BAD'
    _8A12G = '8A12G'
    _8A12GAD = '8A12GAD'
    _8B12B = '8B12B'
    _8B12BAD = '8B12BAD'
    _8B12G = '8B12G'
    _8F2NTC = '8F2NTC'
    _8F2ORDR = '8F2ORDR'
    _8K = '8K'
    _8KAD = '8KAD'
    _8K12B = '8K12B'
    _8K12BAD = '8K12BAD'
    _8K12G3 = '8K12G3'
    _8K12G3AD = '8K12G3AD'
    _8K15D5 = '8K15D5'
    _8K15D5AD = '8K15D5AD'
    ABS15G = 'ABS15G'
    ABS15GAD = 'ABS15GAD'
    ABSEE = 'ABSEE'
    ABSEEAD = 'ABSEEAD'
    ANNLRPT = 'ANNLRPT'
    ANNLRPTAD = 'ANNLRPTAD'
    APPNTC = 'APPNTC'
    APPORDR = 'APPORDR'
    APPWD = 'APPWD'
    APPWDAD = 'APPWDAD'
    ARS = 'ARS'
    ARSAD = 'ARSAD'
    AW = 'AW'
    AWWD = 'AWWD'
    BW2 = 'BW2'
    BW3 = 'BW3'
    C = 'C'
    CAD = 'CAD'
    CAWD = 'CAWD'
    CAR = 'CAR'
    CARAD = 'CARAD'
    CARAWD = 'CARAWD'
    CARW = 'CARW'
    CB = 'CB'
    CBAD = 'CBAD'
    CFPORTAL = 'CFPORTAL'
    CFPORTALAD = 'CFPORTALAD'
    CFPORTALWD = 'CFPORTALWD'
    CORRESP = 'CORRESP'
    CTORDER = 'CTORDER'
    CTR = 'CTR'
    CTRAD = 'CTRAD'
    CTRW = 'CTRW'
    CU = 'CU'
    CUAD = 'CUAD'
    CUW = 'CUW'
    CW = 'CW'
    CWAD = 'CWAD'
    D = 'D'
    DAD = 'DAD'
    DEF13E3 = 'DEF13E3'
    DEF13E3AD = 'DEF13E3AD'
    DEF14A = 'DEF14A'
    DEF14C = 'DEF14C'
    DEFA14A = 'DEFA14A'
    DEFA14C = 'DEFA14C'
    DEFC14A = 'DEFC14A'
    DEFC14C = 'DEFC14C'
    DEFM14A = 'DEFM14A'
    DEFM14C = 'DEFM14C'
    DEFN14A = 'DEFN14A'
    DEFR14A = 'DEFR14A'
    DEFR14C = 'DEFR14C'
    DEFS14A = 'DEFS14A'
    DEFS14C = 'DEFS14C'
    DELAM = 'DELAM'
    DFAN14A = 'DFAN14A'
    DFRN14A = 'DFRN14A'
    DOS = 'DOS'
    DOSA = 'DOSA'
    DOSLTR = 'DOSLTR'
    DRS = 'DRS'
    DRSAD = 'DRSAD'
    DRSLTR = 'DRSLTR'
    DSTRBRPT = 'DSTRBRPT'
    DSTRBRPTAD = 'DSTRBRPTAD'
    EFFECT = 'EFFECT'
    ETR = 'ETR'
    F1 = 'F1'
    F1AD = 'F1AD'
    F10 = 'F10'
    F10AD = 'F10AD'
    F10EF = 'F10EF'
    F10MEF = 'F10MEF'
    F10POS = 'F10POS'
    F1MEF = 'F1MEF'
    F2 = 'F2'
    F2AD = 'F2AD'
    F2D = 'F2D'
    F2DPOS = 'F2DPOS'
    F2MEF = 'F2MEF'
    F3 = 'F3'
    F3AD = 'F3AD'
    F3ASR = 'F3ASR'
    F3D = 'F3D'
    F3DPOS = 'F3DPOS'
    F3MEF = 'F3MEF'
    F4 = 'F4'
    F4AD = 'F4AD'
    F4EF = 'F4EF'
    F4EFAD = 'F4EFAD'
    F4MEF = 'F4MEF'
    F4POS = 'F4POS'
    F6 = 'F6'
    F6AD = 'F6AD'
    F6EF = 'F6EF'
    F6POS = 'F6POS'
    F7 = 'F7'
    F7AD = 'F7AD'
    F7POS = 'F7POS'
    F8 = 'F8'
    F8AD = 'F8AD'
    F80 = 'F80'
    F80AD = 'F80AD'
    F80POS = 'F80POS'
    F8POS = 'F8POS'
    F9 = 'F9'
    F9AD = 'F9AD'
    F9EF = 'F9EF'
    F9MEF = 'F9MEF'
    F9POS = 'F9POS'
    FN = 'FN'
    FNAD = 'FNAD'
    FWP = 'FWP'
    FX = 'FX'
    FXAD = 'FXAD'
    IRANNOTICE = 'IRANNOTICE'
    MA = 'MA'
    MAAD = 'MAAD'
    MAA = 'MAA'
    MAI = 'MAI'
    MAIAD = 'MAIAD'
    MANR = 'MANR'
    MAW = 'MAW'
    N1 = 'N1'
    N1AD = 'N1AD'
    N14 = 'N14'
    N14AD = 'N14AD'
    N148C = 'N148C'
    N148CAD = 'N148CAD'
    N14AE = 'N14AE'
    N14AEAD = 'N14AEAD'
    N14AE24 = 'N14AE24'
    N14AE24AD = 'N14AE24AD'
    N14EL24 = 'N14EL24'
    N14EL24AD = 'N14EL24AD'
    N14MEF = 'N14MEF'
    N18F1 = 'N18F1'
    N18F1AD = 'N18F1AD'
    N1A = 'N1A'
    N1AAD = 'N1AAD'
    N1AEL = 'N1AEL'
    N1AELAD = 'N1AELAD'
    N2 = 'N2'
    N2AD = 'N2AD'
    N23C1 = 'N23C1'
    N23C1AD = 'N23C1AD'
    N23C2 = 'N23C2'
    N23C2AD = 'N23C2AD'
    N23C3A = 'N23C3A'
    N23C3AAD = 'N23C3AAD'
    N23C3B = 'N23C3B'
    N23C3BAD = 'N23C3BAD'
    N23C3C = 'N23C3C'
    N23C3CAD = 'N23C3CAD'
    N27D1 = 'N27D1'
    N27D1AD = 'N27D1AD'
    N2MEF = 'N2MEF'
    N3 = 'N3'
    N3AD = 'N3AD'
    N30B2 = 'N30B2'
    N30D = 'N30D'
    N30DAD = 'N30DAD'
    N3EL = 'N3EL'
    N3ELAD = 'N3ELAD'
    N4 = 'N4'
    N4AD = 'N4AD'
    N4EL = 'N4EL'
    N4ELAD = 'N4ELAD'
    N5 = 'N5'
    N5AD = 'N5AD'
    N54A = 'N54A'
    N54AAD = 'N54AAD'
    N54C = 'N54C'
    N54CAD = 'N54CAD'
    N6 = 'N6'
    N6AD = 'N6AD'
    N6C9 = 'N6C9'
    N6C9AD = 'N6C9AD'
    N6F = 'N6F'
    N6FAD = 'N6FAD'
    N8A = 'N8A'
    N8AAD = 'N8AAD'
    N8B2 = 'N8B2'
    N8B2AD = 'N8B2AD'
    N8B3 = 'N8B3'
    N8B3AD = 'N8B3AD'
    N8B4 = 'N8B4'
    N8B4AD = 'N8B4AD'
    N8F = 'N8F'
    N8FAD = 'N8FAD'
    N8FNTC = 'N8FNTC'
    N8FORDR = 'N8FORDR'
    NCEN = 'NCEN'
    NCENDA = 'NCENDA'
    NCR = 'NCR'
    NCRAD = 'NCRAD'
    NCSR = 'NCSR'
    NCSRAD = 'NCSRAD'
    NCSRS = 'NCSRS'
    NCSRSAD = 'NCSRSAD'
    NMFP = 'NMFP'
    NMFPAD = 'NMFPAD'
    NMFP1 = 'NMFP1'
    NMFP1AD = 'NMFP1AD'
    NMFP2 = 'NMFP2'
    NMFP2AD = 'NMFP2AD'
    NPX = 'NPX'
    NPXAD = 'NPXAD'
    NQ = 'NQ'
    NQAD = 'NQAD'
    NRSROCE = 'NRSROCE'
    NRSROCEAD = 'NRSROCEAD'
    NRSROUPD = 'NRSROUPD'
    NRSROUPDAD = 'NRSROUPDAD'
    NSARA = 'NSARA'
    NSARAAD = 'NSARAAD'
    NSARAT = 'NSARAT'
    NSARATAD = 'NSARATAD'
    NSARB = 'NSARB'
    NSARBAD = 'NSARBAD'
    NSARBT = 'NSARBT'
    NSARBTAD = 'NSARBTAD'
    NSARU = 'NSARU'
    NSARUAD = 'NSARUAD'
    NT10D = 'NT10D'
    NT10DAD = 'NT10DAD'
    NT10K = 'NT10K'
    NT10KAD = 'NT10KAD'
    NT10Q = 'NT10Q'
    NT10QAD = 'NT10QAD'
    NT11K = 'NT11K'
    NT11KAD = 'NT11KAD'
    NT15D2 = 'NT15D2'
    NT15D2AD = 'NT15D2AD'
    NT20F = 'NT20F'
    NT20FAD = 'NT20FAD'
    NTFNCEN = 'NTFNCEN'
    NTFNCSR = 'NTFNCSR'
    NTFNSAR = 'NTFNSAR'
    NTN10D = 'NTN10D'
    NTN10K = 'NTN10K'
    NTN10Q = 'NTN10Q'
    NTN15D2 = 'NTN15D2'
    NTN20F = 'NTN20F'
    NTNCEN = 'NTNCEN'
    NTNCENX = 'NTNCENX'
    NTNCENXDA = 'NTNCENXDA'
    NTNCSR = 'NTNCSR'
    NTNCSRAD = 'NTNCSRAD'
    NTNMFP = 'NTNMFP'
    NTNMFPAD = 'NTNMFPAD'
    NTNMFP1 = 'NTNMFP1'
    NTNMFP1AD = 'NTNMFP1AD'
    NTNMFP2 = 'NTNMFP2'
    NTNMFP2AD = 'NTNMFP2AD'
    NTNSAR = 'NTNSAR'
    NTNSARAD = 'NTNSARAD'
    OIPNTC = 'OIPNTC'
    OIPORDR = 'OIPORDR'
    POS462B = 'POS462B'
    POS462C = 'POS462C'
    POS8C = 'POS8C'
    POSAM = 'POSAM'
    POSAMC = 'POSAMC'
    POSAMI = 'POSAMI'
    POSASR = 'POSASR'
    POSEX = 'POSEX'
    PRE14A = 'PRE14A'
    PRE14C = 'PRE14C'
    PREC14A = 'PREC14A'
    PREC14C = 'PREC14C'
    PREM14A = 'PREM14A'
    PREM14C = 'PREM14C'
    PREN14A = 'PREN14A'
    PRER14A = 'PRER14A'
    PRER14C = 'PRER14C'
    PRES14A = 'PRES14A'
    PRES14C = 'PRES14C'
    PRRN14A = 'PRRN14A'
    PX14A6G = 'PX14A6G'
    PX14A6N = 'PX14A6N'
    QRTLYRPT = 'QRTLYRPT'
    QRTLYRPTAD = 'QRTLYRPTAD'
    QUALIF = 'QUALIF'
    RW = 'RW'
    RWWD = 'RWWD'
    S1 = 'S1'
    S1AD = 'S1AD'
    S11 = 'S11'
    S11AD = 'S11AD'
    S11MEF = 'S11MEF'
    S1MEF = 'S1MEF'
    S2 = 'S2'
    S2AD = 'S2AD'
    S20 = 'S20'
    S20AD = 'S20AD'
    S2MEF = 'S2MEF'
    S3 = 'S3'
    S3AD = 'S3AD'
    S3ASR = 'S3ASR'
    S3D = 'S3D'
    S3DPOS = 'S3DPOS'
    S3MEF = 'S3MEF'
    S4 = 'S4'
    S4AD = 'S4AD'
    S4EF = 'S4EF'
    S4EFAD = 'S4EFAD'
    S4MEF = 'S4MEF'
    S4POS = 'S4POS'
    S6 = 'S6'
    S6AD = 'S6AD'
    S6EL24 = 'S6EL24'
    S6EL24AD = 'S6EL24AD'
    S8 = 'S8'
    S8POS = 'S8POS'
    SB = 'SB'
    SBAD = 'SBAD'
    SB1 = 'SB1'
    SB1AD = 'SB1AD'
    SB1MEF = 'SB1MEF'
    SB2 = 'SB2'
    SB2AD = 'SB2AD'
    SB2MEF = 'SB2MEF'
    SBMEF = 'SBMEF'
    SBSE = 'SBSE'
    SBSEA = 'SBSEA'
    SBSEBD = 'SBSEBD'
    SBSEC = 'SBSEC'
    SBSEW = 'SBSEW'
    SC13D = 'SC13D'
    SC13DAD = 'SC13DAD'
    SC13E1 = 'SC13E1'
    SC13E1AD = 'SC13E1AD'
    SC13E3 = 'SC13E3'
    SC13E3AD = 'SC13E3AD'
    SC13E4 = 'SC13E4'
    SC13E4AD = 'SC13E4AD'
    SC13E4F = 'SC13E4F'
    SC13E4FAD = 'SC13E4FAD'
    SC13G = 'SC13G'
    SC13GAD = 'SC13GAD'
    SC14D1 = 'SC14D1'
    SC14D1AD = 'SC14D1AD'
    SC14D1F = 'SC14D1F'
    SC14D1FAD = 'SC14D1FAD'
    SC14D9 = 'SC14D9'
    SC14D9AD = 'SC14D9AD'
    SC14D9C = 'SC14D9C'
    SC14D9F = 'SC14D9F'
    SC14D9FAD = 'SC14D9FAD'
    SC14F1 = 'SC14F1'
    SC14F1AD = 'SC14F1AD'
    SC14N = 'SC14N'
    SC14NAD = 'SC14NAD'
    SC14NS = 'SC14NS'
    SC14NSAD = 'SC14NSAD'
    SCTOC = 'SCTOC'
    SCTOI = 'SCTOI'
    SCTOIAD = 'SCTOIAD'
    SCTOT = 'SCTOT'
    SCTOTAD = 'SCTOTAD'
    SD = 'SD'
    SDAD = 'SDAD'
    SDR = 'SDR'
    SDRAD = 'SDRAD'
    SDRA = 'SDRA'
    SDRW = 'SDRW'
    SF1 = 'SF1'
    SF1AD = 'SF1AD'
    SF3 = 'SF3'
    SF3AD = 'SF3AD'
    SF3ME = 'SF3ME'
    SP15D2 = 'SP15D2'
    SP15D2AD = 'SP15D2AD'
    SUPPL = 'SUPPL'
    T3 = 'T3'
    T3AD = 'T3AD'
    T6 = 'T6'
    T6AD = 'T6AD'
    TA1 = 'TA1'
    TA1AD = 'TA1AD'
    TA2 = 'TA2'
    TA2AD = 'TA2AD'
    TAW = 'TAW'
    U1 = 'U1'
    U1AD = 'U1AD'
    U12IA = 'U12IA'
    U12IAAD = 'U12IAAD'
    U12IB = 'U12IB'
    U12IBAD = 'U12IBAD'
    U131 = 'U131'
    U131AD = 'U131AD'
    U1360 = 'U1360'
    U1360AD = 'U1360AD'
    U13E1 = 'U13E1'
    U13E1AD = 'U13E1AD'
    U13El = 'U13El'
    U13ElAD = 'U13ElAD'
    U33S = 'U33S'
    U33SAD = 'U33SAD'
    U3A2 = 'U3A2'
    U3A2AD = 'U3A2AD'
    U3A31 = 'U3A31'
    U3A31AD = 'U3A31AD'
    U57 = 'U57'
    U57AD = 'U57AD'
    U5A = 'U5A'
    U5AAD = 'U5AAD'
    U5B = 'U5B'
    U5BAD = 'U5BAD'
    U5S = 'U5S'
    U5SAD = 'U5SAD'
    U6B2 = 'U6B2'
    U6B2AD = 'U6B2AD'
    U7D = 'U7D'
    U7DAD = 'U7DAD'
    U9C3 = 'U9C3'
    U9C3AD = 'U9C3AD'
    UNDER = 'UNDER'
    UNDERAD = 'UNDERAD'
    UPLOAD = 'UPLOAD'
    UR1 = 'UR1'
    UR1AD = 'UR1AD'
    X17A5 = 'X17A5'
    X17A5AD = 'X17A5AD'
