from shortcuts.actions.base import BaseAction, ChoiceField, FloatField, GroupIDField, IntegerField


class NothingAction(BaseAction):
    '''Nothing'''
    itype = 'is.workflow.actions.nothing'
    keyword = 'nothing'


class SetItemNameAction(BaseAction):
    '''Set item name'''
    # todo: advanced
    # <dict>
    #   <key>WFWorkflowActionIdentifier</key>
    #   <string>is.workflow.actions.setitemname</string>
    #   <key>WFWorkflowActionParameters</key>
    #   <dict>
    #       <key>Advanced</key>
    #       <true/>
    #       <key>WFDontIncludeFileExtension</key>
    #       <true/>
    #   </dict>
    # </dict>

    itype = 'is.workflow.actions.setitemname'
    keyword = 'set_item_name'


class ViewContentGraphAction(BaseAction):
    '''View content graph'''
    itype = 'is.workflow.actions.viewresult'
    keyword = 'view_content_graph'


class ContinueInShortcutAppAction(BaseAction):
    '''Continue in shortcut app'''
    itype = 'is.workflow.actions.handoff'
    keyword = 'continue_in_shortcut_app'


class DelayAction(BaseAction):
    '''Delay'''
    itype = 'is.workflow.actions.delay'
    keyword = 'delay'

    time = FloatField('WFDelayTime')


class WaitToReturnAction(BaseAction):
    '''Wait to return'''
    itype = 'is.workflow.actions.waittoreturn'
    keyword = 'wait_to_return'


class RepeatStartAction(BaseAction):
    '''Repeat'''
    itype = 'is.workflow.actions.repeat.count'
    keyword = 'repeat_start'

    _additional_identifier_field = 'WFControlFlowMode'

    group_id = GroupIDField('GroupingIdentifier')
    count = IntegerField('WFRepeatCount')

    default_fields = {
        'WFControlFlowMode': 0,
    }


class RepeatEndAction(BaseAction):
    '''Repeat'''
    itype = 'is.workflow.actions.repeat.count'
    keyword = 'repeat_end'

    _additional_identifier_field = 'WFControlFlowMode'

    group_id = GroupIDField('GroupingIdentifier')

    default_fields = {
        'WFControlFlowMode': 2,
    }


class RepeatEachStartAction(BaseAction):
    '''Repeat with each start'''
    itype = 'is.workflow.actions.repeat.each'
    keyword = 'repeat_with_each_start'

    _additional_identifier_field = 'WFControlFlowMode'

    group_id = GroupIDField('GroupingIdentifier')

    default_fields = {
        'WFControlFlowMode': 0,
    }


class RepeatEachEndAction(BaseAction):
    '''Repeat with each end'''
    itype = 'is.workflow.actions.repeat.each'
    keyword = 'repeat_with_each_end'

    _additional_identifier_field = 'WFControlFlowMode'

    group_id = GroupIDField('GroupingIdentifier')

    default_fields = {
        'WFControlFlowMode': 2,
    }


HASH_CHOICES = (
    'MD5',
    'SHA1',
    'SHA256',
    'SHA512',
)


class HashAction(BaseAction):
    '''Hash action'''
    itype = 'is.workflow.actions.hash'
    keyword = 'hash'

    hash_type = ChoiceField('WFHashType', choices=HASH_CHOICES, default=HASH_CHOICES[0])
