from sure import expect

from social.tests.models import User
from social.tests.actions.actions import BaseActionTest


class LoginActionTest(BaseActionTest):
    def test_login(self):
        self.do_login()

    def test_login_with_partial_pipeline(self):
        self.do_login_with_partial_pipeline()

    def test_fields_stored_in_session(self):
        self.strategy.set_settings({
            'SOCIAL_AUTH_FIELDS_STORED_IN_SESSION': ['foo', 'bar']
        })
        self.strategy.set_request_data({'foo': '1', 'bar': '2'})
        self.do_login()
        expect(self.strategy.session_get('foo')).to.equal('1')
        expect(self.strategy.session_get('bar')).to.equal('2')

    def test_redirect_value(self):
        self.strategy.set_request_data({'next': '/after-login'})
        redirect = self.do_login(after_complete_checks=False)
        expect(redirect.url).to.equal('/after-login')

    def test_login_with_invalid_partial_pipeline(self):
        def before_complete():
            partial = self.strategy.session_get('partial_pipeline')
            partial['backend'] = 'foobar'
            self.strategy.session_set('partial_pipeline', partial)
        self.do_login_with_partial_pipeline(before_complete)

    def test_new_user(self):
        self.strategy.set_settings({
            'SOCIAL_AUTH_NEW_USER_REDIRECT_URL': '/new-user'
        })
        redirect = self.do_login(after_complete_checks=False)
        expect(redirect.url).to.equal('/new-user')

    def test_inactive_user(self):
        self.strategy.set_settings({
            'SOCIAL_AUTH_INACTIVE_USER_URL': '/inactive'
        })
        User.set_active(False)
        redirect = self.do_login(after_complete_checks=False)
        expect(redirect.url).to.equal('/inactive')

    def test_invalid_user(self):
        self.strategy.set_settings({
            'SOCIAL_AUTH_LOGIN_ERROR_URL': '/error',
            'SOCIAL_AUTH_PIPELINE': (
                'social.pipeline.social_auth.social_details',
                'social.pipeline.social_auth.social_uid',
                'social.pipeline.social_auth.auth_allowed',
                'social.pipeline.social_auth.social_user',
                'social.pipeline.user.get_username',
                'social.pipeline.user.create_user',
                'social.pipeline.social_auth.associate_user',
                'social.pipeline.social_auth.load_extra_data',
                'social.pipeline.user.user_details',
                'social.tests.pipeline.remove_user'
            )
        })
        redirect = self.do_login(after_complete_checks=False)
        expect(redirect.url).to.equal('/error')
