import sys

from .middleware import Middleware
from .base_manager import BaseManager
from .pubsub_manager import PubSubManager
from .kombu_manager import KombuManager
from .redis_manager import RedisManager
from .zmq_manager import ZmqManager
from .server import Server
from .namespace import Namespace
if sys.version_info >= (3, 5):  # pragma: no cover
    from .asyncio_server import AsyncServer
    from .asyncio_manager import AsyncManager
    from .asyncio_namespace import AsyncNamespace
    from .asyncio_redis_manager import AsyncRedisManager
else:  # pragma: no cover
    AsyncServer = None
    AsyncManager = None
    AsyncNamespace = None
    AsyncRedisManager = None

__version__ = '1.7.3'

__all__ = ['__version__', 'Middleware', 'Server', 'BaseManager',
           'PubSubManager', 'KombuManager', 'RedisManager', 'ZmqManager',
           'Namespace']
if AsyncServer is not None:  # pragma: no cover
    __all__ += ['AsyncServer', 'AsyncNamespace', 'AsyncManager',
                'AsyncRedisManager']
