# Memory Table

> This is based on the [STS3215_Memory_Table_EN.xlsx](documents/STS3215_Memory_Table_EN.xlsx) spreadsheet.

| 0x | Dec | Hex  | Parameter                                           | Size | Default | Type   | Access              | Min    | Max   | Unit         | Description                                                                                         |
|----|-----|------|-----------------------------------------------------|------|---------|--------|---------------------|--------|-------|--------------|-----------------------------------------------------------------------------------------------------|
| 0  | 0   | 0x00 | Firmware major version number                       | 1    | 1       | EEPROM | Read-only           | --     | --    | --           | --                                                                                                  |
| 1  | 1   | 0x01 | Firmware minor version number                       | 1    | 1       | EEPROM | Read-only           | --     | --    | --           | --                                                                                                  |
| 2  | 2   | 0x02 | END                                                 | 1    | 0       | EEPROM | Read-only           | --     | --    | --           | --                                                                                                  |
| 3  | 3   | 0x03 | Servo main version number                           | 1    |         | EEPROM | Read-only           | --     | --    | --           | --                                                                                                  |
| 4  | 4   | 0x04 | Servo version number                                | 1    |         | EEPROM | Read-only           | --     | --    | --           | --                                                                                                  |
| 5  | 5   | 0x05 | ID                                                  | 1    | 1       | EEPROM | Reading and writing | 0      | 253   | Number       | Unique identifier on the bus; duplicate IDs are not allowed. 254 (0xFE) is broadcast ID.            |
| 6  | 6   | 0x06 | Baud rate                                           | 1    | 0       | EEPROM | Reading and writing | 0      | 7     | none         | 0: 1,000,000; 1: 500,000; 2: 250,000; 3: 128,000; 4: 115,200; 5: 76,800; 6: 57,600; 7: 38,400 baud. |
| 7  | 7   | 0x07 | Return delay                                        | 1    | 250     | EEPROM | Reading and writing | 0      | 254   | 2µs          | Minimum unit is 2µs; max configurable 254*2 = 508µs.                                                |
| 8  | 8   | 0x08 | Phase 2 (Response Status Level)                     | 1    | 1       | EEPROM | Reading and writing | 0      | 1     | none         | 0: No response for commands other than read/PING. 1: Response returned for all commands.            |
| 9  | 9   | 0x09 | Minimum angle limit                                 | 2    | 0       | EEPROM | Reading and writing | 0      | 4094  | step         | Sets minimum motion travel limit; must be < max angle limit.                                        |
| 11 | 11  | 0x0B | Maximum angle limit                                 | 2    | 4095    | EEPROM | Reading and writing | 1      | 4095  | step         | Sets maximum motion travel limit; must be > min angle limit.                                        |
| 13 | 13  | 0x0D | Maximum temperature limit                           | 1    | 70      | EEPROM | Reading and writing | 0      | 100   | °C           | Maximum operating temperature limit; setting accuracy 1°C.                                          |
| 14 | 14  | 0x0E | Maximum input voltage                               | 1    |         | EEPROM | Reading and writing | 0      | 254   | 0.1V         | Maximum voltage = value*0.1V.                                                                       |
| 15 | 15  | 0x0F | Minimum input voltage                               | 1    |         | EEPROM | Reading and writing | 0      | 254   | 0.1V         | Minimum voltage = value*0.1V.                                                                       |
| 16 | 16  | 0x10 | Maximum torque                                      | 2    | 1000    | EEPROM | Reading and writing | 0      | 1000  | 0.1%         | Maximum output torque limit, assigned on power-up.                                                  |
| 18 | 18  | 0x12 | Phase                                               | 1    |         | EEPROM | Reading and writing | 0      | 254   | none         | Special function bytes cannot be modified unless required.                                          |
| 19 | 19  | 0x13 | Uninstallation conditions                           | 1    | 44      | EEPROM | Reading and writing | 0      | 254   | none         | Bit 1 enables/disables corresponding protection.                                                    |
| 20 | 20  | 0x14 | LED alarm conditions                                | 1    | 47      | EEPROM | Reading and writing | 0      | 254   | none         | Bit 1 enables/disables flashing alarm.                                                              |
| 21 | 21  | 0x15 | Position ring P proportional coefficient            | 1    |         | EEPROM | Reading and writing | 0      | 254   | none         | Proportional coefficient for motor control.                                                         |
| 22 | 22  | 0x16 | Differential coefficients of position loop D        | 1    |         | EEPROM | Reading and writing | 0      | 254   | none         | Differential coefficient of motor control.                                                          |
| 23 | 23  | 0x17 | Integral coefficients of position loop I            | 1    |         | EEPROM | Reading and writing | 0      | 254   | none         | Integral coefficient of motor control.                                                              |
| 24 | 24  | 0x18 | Minimum starting force                              | 1    |         | EEPROM | Reading and writing | 0      | 254   | 0.1%         | Minimum output starting torque; 10 = 1% stall torque.                                               |
| 25 | 25  | 0x19 | Points limit                                        | 1    |         | EEPROM | Reading and writing | 0      | 254   | none         | Max score = score limit * 4. 0 disables limit.                                                      |
| 26 | 26  | 0x1A | Clockwise insensitive area                          | 1    | 1       | EEPROM | Reading and writing | 0      | 32    | step         | Smallest unit is minimum resolution angle.                                                          |
| 27 | 27  | 0x1B | Counterclockwise insensitive area                   | 1    | 1       | EEPROM | Reading and writing | 0      | 32    | step         | Smallest unit is minimum resolution angle.                                                          |
| 28 | 28  | 0x1C | Protective current                                  | 2    |         | EEPROM | Reading and writing | 0      | 511   | 6.5mA        | Max settable current = 500*6.5mA = 3250mA.                                                          |
| 30 | 30  | 0x1E | Angular resolution                                  | 1    | 1       | EEPROM | Reading and writing | 1      | 3     | none         | Modifies magnification factor for sensor min resolution angle.                                      |
| 31 | 31  | 0x1F | Position correction                                 | 2    | 0       | EEPROM | Reading and writing | -2047  | 2047  | step         | BIT11 = direction; other bits = 0-2047 steps.                                                       |
| 33 | 33  | 0x21 | Operating mode                                      | 1    | 0       | EEPROM | Reading and writing | 0      | 3     | none         | 0: Position mode; 1: Constant speed; 2: PWM open-loop; 3: Stepper servo mode.                       |
| 34 | 34  | 0x22 | Protective torque                                   | 1    | 20      | EEPROM | Reading and writing | 0      | 100   | 1.0%         | Output torque after overload protection.                                                            |
| 35 | 35  | 0x23 | Protection time                                     | 1    | 200     | EEPROM | Reading and writing | 0      | 254   | 10ms         | Duration exceeding overload torque before reset.                                                    |
| 36 | 36  | 0x24 | Overload torque                                     | 1    | 80      | EEPROM | Reading and writing | 0      | 100   | 1.0%         | Max torque threshold for overload protection.                                                       |
| 37 | 37  | 0x25 | Speed closed-loop P proportional coefficient        | 1    |         | EEPROM | Reading and writing | 0      | 254   | none         | Speed loop proportional coefficient in constant speed mode.                                         |
| 38 | 38  | 0x26 | Overcurrent protection time                         | 1    | 200     | EEPROM | Reading and writing | 0      | 254   | 10ms         | Max configurable = 254*10ms = 2540ms.                                                               |
| 39 | 39  | 0x27 | Integral coefficient of closed-loop velocity system | 1    |         | EEPROM | Reading and writing | 0      | 254   | 1/10         | Integral coefficient of speed loop, reduced by factor 10 vs version 3.6.                            |
| 40 | 40  | 0x28 | Torque switch                                       | 1    | 0       | SRAM   | Reading and writing | 0      | 128   | none         | 0: Off torque; 1: On torque; 128: Correct current position to 2048.                                 |
| 41 | 41  | 0x29 | Acceleration                                        | 1    | 0       | SRAM   | Reading and writing | 0      | 254   | 100 steps/s² | 10 → 1000 steps/s² acceleration/deceleration.                                                       |
| 42 | 42  | 0x2A | Target location                                     | 2    | 0       | SRAM   | Reading and writing | -32766 | 32766 | step         | Absolute position control; each step = min resolvable angle.                                        |
| 44 | 44  | 0x2C | Runtime                                             | 2    | 0       | SRAM   | Reading and writing | 0      | 1000  | 0.10%        | PWM open-loop speed control, BIT10 = direction.                                                     |
| 46 | 46  | 0x2E | Running speed                                       | 2    | 0       | SRAM   | Reading and writing | -32766 | 32766 | Steps/s      | Number of steps per second; 50 steps/s ≈ 0.732 RPM.                                                 |
| 48 | 48  | 0x30 | Torque Limit                                        | 2    | 1000    | SRAM   | Reading and writing | 0      | 1000  | 1.0%         | Initial power-on value assigned by maximum torque (0x10).                                           |
| 49 | 49  | 0x31 | Undefined                                           | 1    |         | SRAM   | none                | --     | --    | --           | --                                                                                                  |
| 50 | 50  | 0x32 | Undefined                                           | 1    |         | SRAM   | none                | --     | --    | --           | --                                                                                                  |
| 51 | 51  | 0x33 | Undefined                                           | 1    |         | SRAM   | none                | --     | --    | --           | --                                                                                                  |
| 52 | 52  | 0x34 | Undefined                                           | 1    |         | SRAM   | none                | --     | --    | --           | --                                                                                                  |
| 53 | 53  | 0x35 | Undefined                                           | 1    |         | SRAM   | none                | --     | --    | --           | --                                                                                                  |
| 54 | 54  | 0x36 | Undefined                                           | 1    |         | SRAM   | none                | --     | --    | --           | --                                                                                                  |
| 55 | 55  | 0x37 | Lock symbol                                         | 1    | 0       | SRAM   | Reading and writing | 0      | 1     | none         | 0: disable write lock; 1: enable write lock; affects EEPROM saving.                                 |
| 56 | 56  | 0x38 | Current location                                    | 2    | 0       | SRAM   | Read-only           | --     | --    | step         | Feedback on current position step count; absolute control.                                          |
| 58 | 58  | 0x3A | Current speed                                       | 2    | 0       | SRAM   | Read-only           | --     | --    | Steps/s      | Feedback on motor speed in steps per second.                                                        |
| 60 | 60  | 0x3C | Current load                                        | 2    | 0       | SRAM   | Read-only           | --     | --    | 0.1%         | Motor output drive duty cycle.                                                                      |
| 62 | 62  | 0x3E | Current voltage                                     | 1    | 0       | SRAM   | Read-only           | --     | --    | 0.1V         | Current operating voltage.                                                                          |
| 63 | 63  | 0x3F | Current temperature                                 | 1    | 0       | SRAM   | Read-only           | --     | --    | °C           | Internal operating temperature.                                                                     |
| 64 | 64  | 0x40 | Asynchronous write flag                             | 1    | 0       | SRAM   | Read-only           | --     | --    | none         | Flag for asynchronous write instructions.                                                           |
| 65 | 65  | 0x41 | Servo status                                        | 1    | 0       | SRAM   | Read-only           | --     | --    | none         | Bit = 1 indicates error; 0 = no error.                                                              |
| 66 | 66  | 0x42 | Mobile sign                                         | 1    | 0       | SRAM   | Read-only           | --     | --    | none         | 1: servo in motion; 0: stationary.                                                                  |
| 67 | 67  | 0x43 | Undefined                                           | 2    | 0       | SRAM   | Read-only           | --     | --    | --           | --                                                                                                  |
| 69 | 69  | 0x45 | Current current                                     | 2    | 0       | SRAM   | Read-only           | --     | --    | 6.5mA        | Max measurable current = 500*6.5mA = 3250mA.                                                        |