# StateMachine 0.9.0

*2022-12-21*

## Python compatibility 0.9.0

StateMachine 0.9 supports Python 2.7, 3.5, 3.6, 3.7, 3.8.

## What's new in 0.9

### Args and kwargs now are passed to bounded transitions

Parameters sent with the event trigger will now be propagated to the transition handlers.

```py
>>> from statemachine import StateMachine, State

>>> class CampaignMachine(StateMachine):
...     draft = State("Draft", initial=True)
...     producing = State("Being produced")
...
...     produce = draft.to(producing) | producing.to(producing)
...
...     def on_enter_producing(self, approver=None):
...         print(f"Approved by: {approver}")

>>> sm = CampaignMachine()

>>> sm.produce(approver="Aragorn")  # imperative
Approved by: Aragorn

```


### State machine declarations now with final states


Now you can declare `final` states and the machine will make sure they have no transitions.

```py
>>> from statemachine import StateMachine, State

>>> class ApprovalMachine(StateMachine):
...     """A workflow machine"""
...     requested = State("Requested", initial=True)
...     accepted = State("Accepted")
...     rejected = State("Rejected")
...     completed = State("Completed", final=True)
...
...     validate = requested.to(accepted, cond="is_ok") | requested.to(rejected)
...     release = accepted.to(completed)
...     reopen = completed.to(requested)
Traceback (most recent call last):
...
InvalidDefinition: Cannot declare transitions from final state. Invalid state(s): ['completed']

```

See {ref}`final-state` for more details.

## Minor features and bug fixes

- Doctesting all documentation including README (with issues on examples fixed).
- Fix state value misjudged when state value is an "boolean False value" (tks @the5fire)
- Fix returning dict as result of transitions callback.
