# StateMachine 2.1.0

*June 11, 2023*

## What's new in 2.1.0

### Added support for declaring states using Enum

Given an ``Enum`` type that declares our expected states:

```py
>>> from enum import Enum

>>> class Status(Enum):
...     pending = 1
...     completed = 2

```

A {ref}`StateMachine` can be declared as follows:

```py
>>> from statemachine import StateMachine
>>> from statemachine.states import States

>>> class ApprovalMachine(StateMachine):
...
...     _ = States.from_enum(Status, initial=Status.pending, final=Status.completed)
...
...     finish = _.pending.to(_.completed)
...
...     def on_enter_completed(self):
...         print("Completed!")

```

See {ref}`States from Enum types`.

## Bugfixes in 2.1.0

- Fixes [#369](https://github.com/fgmacedo/python-statemachine/issues/369) adding support to wrap
  methods used as {ref}`Actions` decorated with `functools.partial`.
- Fixes [#384](https://github.com/fgmacedo/python-statemachine/issues/384) so multiple observers can watch the same callback.
